<?php

declare(strict_types=1);

namespace App\Xielei\Admin\Http\Home;

use Ebcms\Config;
use Ebcms\Router;
use Psr\Http\Message\ResponseInterface;
use Xielei\Session;
use Xielei\Template;

class Login extends Common
{

    public function get(
        Router $router,
        Template $template
    ): ResponseInterface {
        $html = $template->renderFromFile('login', [
            'router' => $router,
        ]);
        return $this->html($html);
    }

    public function post(
        Router $router,
        Config $config,
        Session $session
    ): ResponseInterface {
        $captcha = $_POST['captcha'];
        if (!$captcha || $captcha != $session->get('admin_captcha')) {
            return $this->failure('验证码无效！');
        }
        $session->delete('admin_captcha');

        if (!$managers = $config->get('managers@xielei/admin')) {
            return $this->failure('未配置后台账户！');
        }

        $account = $_POST['account'];
        $password = $_POST['password'];

        if (!$account || !isset($managers[$account])) {
            return $this->failure('账户或密码无效！');
        }
        if (!$password || $password != $managers[$account]['password']) {
            return $this->failure('账户或密码无效！');
        }

        $session->set('admin', $account);

        if ($login_redirect = $session->get('login_redirect')) {
            $session->delete('login_redirect');
        } else {
            $login_redirect = $router->buildUrl('/xielei/admin/index');
        }

        return $this->redirect($login_redirect);
    }
}
