<!DOCTYPE html>
<html lang="zh-CN">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>控制台</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.0/dist/css/bootstrap.min.css" integrity="sha256-aAr2Zpq8MZ+YA/D6JtRD3xtrwpEz2IqOS+pWD/7XKIw=" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.min.js" integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.0/dist/js/bootstrap.js" integrity="sha256-i/Jq6Tc8SbPMBrnvq/sOTfH81hW5emVa4OzZPqhcwtI=" crossorigin="anonymous"></script>
</head>

<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark border-bottom shadow-sm" style="z-index:2;">
        <a class="navbar-brand wb" href="http://www.ebcms.com/" target="_blank">EBCMS</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <ul class="navbar-nav mr-auto d-block d-lg-none">
                {foreach $menu as $group => $urls}
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown_{:md5($group)}" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        {$group}
                    </a>
                    <div class="dropdown-menu" aria-labelledby="navbarDropdown_{:md5($group)}">
                        {foreach clone $urls as $v}
                        <a class="dropdown-item" href="{$v.url}" target="main">{$v.title}</a>
                        {/foreach}
                    </div>
                </li>
                {/foreach}
            </ul>
            <span class="navbar-text d-none d-lg-block">
                好用的管理系统
            </span>
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="https://packagist.org/?type=ebcms-app" target="_blank">应用商店</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#" id="changepwd">修改密码</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{:$router->buildUrl('/xielei/admin/admin/logout')}">退出</a>
                </li>
            </ul>
        </div>
    </nav>
    <script>
        $(function() {
            $("#changepwd").bind('click', function() {
                var oldpwd = prompt('请输入旧密码：');
                if (oldpwd) {
                    var newpwd = prompt('请输入新密码：');
                    if (newpwd) {
                        $.ajax({
                            type: "POST",
                            url: "{:$router->buildUrl('/xielei/admin/admin/password')}",
                            data: {
                                oldpwd: oldpwd,
                                newpwd: newpwd,
                            },
                            dataType: "JSON",
                            success: function(response) {
                                alert(response.message);
                            }
                        });
                    }
                }
            });
            $(".navbar-nav li a").on("click", function() {
                if (!$(this).hasClass('dropdown-toggle')) {
                    $('.navbar-toggler').trigger('click');
                }
            });
        });
    </script>
    <style>
        html,
        body {
            width: 100%;
            height: 100%;
            overflow: hidden;
        }

        .main {
            overflow: hidden;
            position: absolute;
            left: 0;
            right: 0;
            bottom: 0;
            top: 57px;
        }

        .main .left {
            float: left;
            width: 250px;
            height: 100%;
            overflow: auto;
            border-right: 1px solid #eee;
        }

        .main .right {
            height: 100%;
            overflow: auto;
        }

        /*clear float.*/
        .main:after {
            content: "";
            height: 0;
            line-height: 0;
            display: block;
            visibility: hidden;
            clear: both;
        }
    </style>
    <div class="main">
        <div class="left d-none d-lg-block bg-light">
            <div id="accordionExample" class="">
                {foreach $menu as $group => $urls}
                <div>
                    <div class="py-2 px-3 border-bottom font-weight-bolder text-truncate" style="cursor: pointer;margin-top:0px;border-top:1px solid #fff;background:#f3f3f3;" id="heading_{:md5($group)}" data-toggle="collapse" data-target="#collapse_{:md5($group)}" aria-expanded="false" aria-controls="collapse_{:md5($group)}">
                        {$group}
                    </div>
                    <div id="collapse_{:md5($group)}" class="collapse border-bottom bg-white" aria-labelledby="heading_{:md5($group)}" data-parent="#accordionExample">
                        <ul class="nav flex-column">
                            {foreach clone $urls as $v}
                            <li class="nav-item">
                                <a class="nav-link text-truncate" href="{$v.url}" target="{$v['target']??'main'}">{$v.title}</a>
                            </li>
                            {/foreach}
                        </ul>
                    </div>
                </div>
                {/foreach}
            </div>
        </div>
        <div class="right">
            <iframe src="" name="main" style="width:100%;height:100%;overflow:auto;display:block;" frameborder="0"></iframe>
        </div>
    </div>

</body>

</html>