<?php

declare(strict_types=1);

namespace App\Xielei\ArticleWeb\Http\Admin;

use App\Xielei\Admin\Http\Admin\Common;
use App\Xielei\Admin\Model\Config as ModelConfig;
use Ebcms\Config as EbcmsConfig;
use Xielei\FormBuilder\Builder;
use Xielei\FormBuilder\Col;
use Xielei\FormBuilder\Field\Text;
use Xielei\FormBuilder\Field\Textarea;
use Xielei\FormBuilder\Row;
use Xielei\RequestFilter;

class Config extends Common
{
    public function get(
        EbcmsConfig $config
    ) {
        $form = new Builder('系统设置');
        $form->addRow(
            (new Row())->addCol(
                (new Col('col-md-9'))->addItem(
                    (new Text('网站名称', 'xielei[article-web][site][name]', $config->get('site.name@xielei.article-web')))->set('help', '网站标题的后缀，一般不宜过长，例如:EBCMS'),
                    (new Text('网站标题', 'xielei[article-web][site][title]', $config->get('site.title@xielei.article-web')))->set('help', '首页标题，例如：好用的网站管理系统'),
                    (new Text('网站关键词', 'xielei[article-web][site][keywords]', $config->get('site.keywords@xielei.article-web')))->set('help', '例如：cms ebcms 内容管理系统'),
                    (new Textarea('网站简介', 'xielei[article-web][site][description]', $config->get('site.description@xielei.article-web')))->set('help', '例如：ebcms是好用的内容管理系统'),
                    (new Text('前台模板路径', 'xielei[article-web][home][template_root]', $config->get('home.template_root@xielei.article-web')))->set('help', '相对于网站index.php文件的路径，也可以写绝对路径')
                ),
                (new Col('col-md-3'))->addItem()
            )
        );
        return $form->__toString();
    }

    public function post(
        RequestFilter $input,
        ModelConfig $configModel
    ) {
        $configModel->save($input->post());
        return $this->success('更新成功！');
    }
}
