<?php

declare(strict_types=1);

namespace App\Xielei\ArticleWeb\Http\Home;

use App\Xielei\Admin\Http\Home\Common;
use App\Xielei\Article\Model\Article as ModelArticle;
use App\Xielei\Article\Model\Category;
use App\Xielei\Article\Model\Tag;
use Ebcms\Config;
use Xielei\RequestFilter;
use Xielei\Template;

class Article extends Common
{

    public function get(
        ModelArticle $modelArticle,
        Category $modelCategory,
        Tag $tagModel,
        Config $config,
        RequestFilter $input,
        Template $template
    ) {
        if (!$article = $modelArticle->get('*', [
            'state' => 1,
            'OR' => [
                'id' => $input->get('id'),
                'alias' => $input->get('id'),
            ],
        ])) {
            return $this->failure('页面不存在！');
        }

        if (!$category = $modelCategory->get('*', [
            'state' => 1,
            'id' => $article['category_id'],
        ])) {
            return $this->failure('页面不存在！');
        }

        $modelArticle->update([
            'click[+]' => 1,
        ], [
            'id' => $article['id'],
        ]);

        $relations = [];
        if ($tags = array_unique(array_filter(explode(',', $article['tags'])))) {
            if ($article_ids = $tagModel->select('article_id', [
                'tag' => $tags,
                'article_id[!]' => $article['id'],
                'LIMIT' => 10,
            ])) {
                $relations = $modelArticle->select('*', [
                    'state' => 1,
                    'id' => $article_ids,
                ]);
            }
        }

        return $this->html($template->renderFromFile($category['tpl_article'] ?: '/article', [
            'category' => $category,
            'article' => $article,
            'relations' => $relations,
            'meta' => [
                'title' => $article['title'] . ' - ' . $config->get('site.name@xielei.article-web'),
                'keywords' => $article['keywords'],
                'description' => $article['description'] ?: mb_substr(str_replace(["\r", "\n", "\t"], '', trim(strip_tags($article['body']))), 0, 250),
            ],
        ]));
    }
}
