<?php

declare(strict_types=1);

namespace App\Xielei\ArticleWeb\Http\Home;

use App\Xielei\Admin\Http\Home\Common;
use App\Xielei\Article\Model\Article;
use App\Xielei\Article\Model\Category as ModelCategory;
use Ebcms\Config;
use Xielei\Pagination;
use Xielei\RequestFilter;
use Xielei\Template;

class Category extends Common
{

    public function get(
        ModelCategory $modelCategory,
        Article $modelArticle,
        RequestFilter $input,
        Pagination $pagination,
        Template $template,
        Config $config
    ) {
        if (!$category = $modelCategory->get('*', [
            'state' => 1,
            'OR' => [
                'id' => $input->get('id'),
                'alias' => $input->get('id'),
            ],
        ])) {
            return $this->failure('页面不存在！');
        }

        if ($category['redirect_uri']) {
            return $this->redirect($category['redirect_uri']);
        }

        $where = [
            'category_id' => $category['id'],
            'state' => 1,
            'ORDER' => [
                'id' => 'DESC',
            ],
        ];
        if ($input->get('type')) {
            $where['type'] = $input->get('type');
        }

        $total = $modelArticle->count($where);

        $page = $input->get('page', 1, ['intval']) ?: 1;
        $page_num = $category['page_num'];
        $where['LIMIT'] = [($page - 1) * $page_num, $page_num];

        $articles = $modelArticle->select('*', $where);

        return $this->html($template->renderFromFile($category['tpl_category'] ?: '/category', [
            'category' => $category,
            'articles' => $articles,
            'pagination' => $pagination->render($page, $total, $page_num),
            'meta' => [
                'title' => ($input->has('get.type') ? $input->get('type') . ' - ' : '') . $category['title'] . ' - ' . $config->get('site.name@xielei.article-web'),
                'keywords' => $category['keywords'],
                'description' => $category['description'],
            ],
        ]));
    }
}
