<?php

declare(strict_types=1);

namespace App\Xielei\ArticleWeb\Http\Home;

use App\Xielei\Admin\Http\Home\Common;
use Ebcms\Config;
use Xielei\Template;

class Index extends Common
{

    public function get(
        Config $config,
        Template $template
    ) {
        $html = $template->renderFromFile('/index', [
            'meta' => [
                'title' => $config->get('site.name@xielei.article-web') . ' - ' . $config->get('site.title@xielei.article-web'),
                'keywords' => $config->get('site.keywords@xielei.article-web'),
                'description' => $config->get('site.description@xielei.article-web'),
            ],
        ]);
        return $this->html($html);
    }
}
