<?php

declare(strict_types=1);

namespace App\Xielei\ArticleWeb\Http\Home;

use App\Xielei\Admin\Http\Home\Common;
use App\Xielei\Article\Model\Article;
use Ebcms\Config;
use Xielei\Database\Db;
use Xielei\Pagination;
use Xielei\RequestFilter;
use Xielei\Template;

class Search extends Common
{

    public function get(
        Config $config,
        RequestFilter $input,
        Pagination $pagination,
        Article $modelArticle,
        Template $template
    ) {
        $where = 'WHERE MATCH (title,keywords,description,tags,body) AGAINST (:q IN NATURAL LANGUAGE MODE)';

        $total = $modelArticle->count(Db::raw($where, [
            ':q' => $input->get('q'),
        ]));

        $page = $input->get('page', 1, ['intval']) ?: 1;
        $page_num = 30;
        $where .= ' LIMIT ' . ($page - 1) * $page_num . ',' . $page_num;
        $articles = $modelArticle->select('*',  Db::raw($where, [
            ':q' => $input->get('q'),
        ]));

        $html = $template->renderFromFile('/search', [
            'articles' => $articles,
            'pagination' => $pagination->render($page, $total, $page_num),
            'meta' => [
                'title' => '搜索 - ' . $config->get('site.name@xielei.article-web'),
                'keywords' => $input->get('q'),
                'description' => $input->get('q'),
            ],
        ]);
        return $this->html($html);
    }
}
