<!DOCTYPE html>
<html lang="zh-CN">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{$meta['title']??''}</title>
    <meta name="keywords" content="{$meta['keywords']??''}" />
    <meta name="description" content="{$meta['description']??''}" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css" integrity="sha256-L/W5Wfqfa0sdBNIKN9cG6QA5F2qx4qICmU2VgLruv9Y=" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.4.1/dist/jquery.min.js" integrity="sha256-CSXorXvZcTkaix6Yvo6HppcZGetbYMGWSFlBw8HfCJo=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/js/bootstrap.bundle.min.js" integrity="sha256-OUFW7hFO0/r5aEGTQOz9F/aXQOt+TwqI1Z4fbVvww04=" crossorigin="anonymous"></script>
</head>

<body>
    <div class="container-lg">
        <div class="my-4 d-inline-block display-4 font-weight-bold text-secondary text-monospace">{:$config->get('site.name@xielei.article-web')}</div>
        <ul class="nav bg-primary">
            <li class="nav-item">
                <a class="nav-link text-light active" href="{:$router->buildUrl('/xielei/article-web/home/index')}">主页</a>
            </li>
            <?php
            $categorys = \Ebcms\App::getInstance()->execute(function (\App\Xielei\Article\Model\Category $category) {
                return $category->select('*', [
                    'state' => 1,
                    'nav' => 1,
                    'ORDER' => [
                        'rank' => 'DESC',
                        'id' => 'ASC'
                    ],
                ]);
            });
            ?>
            {foreach $categorys as $vo}
            {if $vo['nav']}
            <li class="nav-item">
                <a class="nav-link text-light" href="{:$router->buildUrl('/xielei/article-web/home/category', ['id'=>$vo['alias']?:$vo['id']])}">{$vo.title}</a>
            </li>
            {/if}
            {/foreach}
            <li class="nav-item float-right">
                <a class="nav-link text-light" href="{:$router->buildUrl('/xielei/article-web/home/search')}">搜索</a>
            </li>
        </ul>