<?php

declare(strict_types=1);

namespace App\Xielei\Article\Http\Admin\Article;

use App\Xielei\Admin\Http\Admin\Common;
use App\Xielei\Article\Model\Article;
use App\Xielei\Article\Model\Category;
use App\Xielei\Article\Model\Tag;
use Ebcms\Router;
use Xielei\FormBuilder\Builder;
use Xielei\FormBuilder\Col;
use Xielei\FormBuilder\Field\Radio;
use Xielei\FormBuilder\Field\Select;
use Xielei\FormBuilder\Field\Text;
use Xielei\FormBuilder\Field\Textarea;
use Xielei\FormBuilder\Other\Cover;
use Xielei\FormBuilder\Other\Summernote;
use Xielei\FormBuilder\Row;
use Xielei\FormBuilder\Summary;
use Xielei\RequestFilter;

class Create extends Common
{
    public function get(
        Category $categoryModel,
        Router $router
    ) {
        $radio_option = [
            [
                'label' => '是',
                'value' => 1,
            ], [
                'label' => '否',
                'value' => 2,
            ],
        ];
        $category_option = (function () use ($categoryModel) {
            $res = [];
            foreach ($categoryModel->select('*', [
                'ORDER' => [
                    'rank' => 'DESC',
                    'id' => 'ASC',
                ],
            ]) as $vo) {
                $sub = [];
                foreach (explode(' ', $vo['types']) as $type) {
                    $sub[] = [
                        'label' => $vo['title'] . '-' . $type,
                        'value' => $vo['id'] . '_' . $type,
                    ];
                }
                $res[] = [
                    'label' => $vo['title'],
                    'group' => $sub,
                ];
            }
            return $res;
        })();
        $form = new Builder('创建文章');
        $form->addRow(
            (new Row())->addCol(
                (new Col('col-md-9'))->addItem(
                    (new Text('标题', 'title'))->set('help', '一般不超过80个字符')->set('required', 1),
                    (new Summernote('内容详情', 'body', '', $router->buildUrl('/xielei/admin/admin/upload'))),
                    (new Radio('是否发布', 'state', '1'))->set('options', $radio_option)->set('inline', true)
                ),
                (new Col('col-md-3'))->addItem(
                    (new Select('发布到', 'category'))->set('options', $category_option),
                    (new Cover('封面图', 'cover', '', $router->buildUrl('/xielei/admin/admin/upload'))),
                    (new Radio('是否置顶', 'sticky', '2'))->set('options', $radio_option)->set('inline', true),
                    (new Text('文章标签', 'tags'))->set('help', '多个标签用空格分割'),
                    (new Summary('元数据设置'))->addItem(
                        new Text('关键词', 'keywords'),
                        new Textarea('简介', 'description')
                    ),
                    (new Summary('其他参数设置'))->addItem(
                        new Text('模板', 'tpl'),
                        new Text('别名', 'alias'),
                        new Text('重定向地址', 'redirect_uri')
                    )
                )
            )
        );
        return $form->__toString();
    }

    public function post(
        RequestFilter $input,
        Article $articleModel,
        Tag $tagModel
    ) {
        $category = explode('_', $input->post('category'));
        $data = [
            'category_id' => $category[0],
            'type' => $category[1],
            'title' => $input->post('title'),
            'cover' => $input->post('cover'),
            'body' => $input->post('body', '', []),
            'state' => $input->post('state', 0, ['intval']),
            'sticky' => $input->post('sticky', 0, ['intval']),
            'keywords' => $input->post('keywords'),
            'description' => $input->post('description'),
            'tpl' => $input->post('tpl'),
            'alias' => $input->post('alias'),
            'tags' => $input->post('tags'),
            'publish_time' => time(),
            'update_time' => time(),
        ];
        $article_id = $articleModel->insert($data);

        if ($data['state'] && $data['tags']) {
            $tmp = array_unique(array_filter(explode(',', $data['tags'])));
            $tags = [];
            foreach ($tmp as $tag) {
                $tags[] = [
                    'article_id' => $article_id,
                    'tag' => $tag,
                ];
            }
            $tagModel->insert($tags);
        }
        return $this->success('操作成功！', 'javascript:history.go(-2)');
    }
}
