<?php

declare(strict_types=1);

namespace App\Xielei\Article\Http\Admin\Article;

use App\Xielei\Admin\Http\Admin\Common;
use App\Xielei\Article\Model\Article;
use App\Xielei\Article\Model\Tag;
use Xielei\RequestFilter;

class Delete extends Common
{
    public function get(
        RequestFilter $input,
        Article $articleModel,
        Tag $tagModel
    ) {
        $articleModel->delete([
            'id' => $input->get('id', 0, ['intval']),
        ]);
        $tagModel->delete([
            'article_id' => $input->get('id', 0, ['intval']),
        ]);
        return $this->success('操作成功！');
    }
}
