<?php

declare(strict_types=1);

namespace App\Xielei\Article\Http\Admin\Article;

use App\Xielei\Admin\Http\Admin\Common;
use App\Xielei\Article\Model\Article;
use App\Xielei\Article\Model\Category;
use Xielei\Pagination;
use Xielei\RequestFilter;
use Xielei\Template;

class Index extends Common
{

    public function get(
        RequestFilter $input,
        Template $template,
        Category $categoryModel,
        Article $articleModel,
        Pagination $pagination
    ) {
        $options = [
            'ORDER' => [
                'id' => 'DESC',
            ],
        ];
        if ($input->get('category')) {
            $tmp = explode('_', $input->get('category'));
            $options['category_id'] = $tmp[0];
            if (isset($tmp[1]) && ($tmp[1] != '')) {
                $options['type'] = $tmp[1];
            }
        }
        if ($input->get('state')) {
            $options['state'] = $input->get('state');
        }
        if ($input->get('sticky')) {
            $options['sticky'] = $input->get('sticky');
        }
        if ($q = $input->get('q')) {
            $options['OR'] = [
                'id' => $q,
                'title[~]' => '%' . $q . '%',
                'body[~]' => '%' . $q . '%',
            ];
        }
        $total = $articleModel->count($options);

        $page = $input->get('page', 1, ['intval']) ?: 1;
        $page_num = min(100, $input->get('page_num', 20, ['intval']) ?: 20);
        $options['LIMIT'] = [($page - 1) * $page_num, $page_num];

        $data = $articleModel->select('*', $options);

        return $this->html($template->renderFromFile('/article/index', [
            'data' => $data,
            'total' => $total,
            'categorys' => $categoryModel->select('*', [
                'ORDER' => [
                    'rank' => 'DESC',
                    'id' => 'ASC',
                ],
            ]),
            'pagination' => $pagination->render($page, $total, $page_num),
        ]));
    }
}
