<?php

declare(strict_types=1);

namespace App\Xielei\Article\Http\Admin\Article;

use App\Xielei\Admin\Http\Admin\Common;
use App\Xielei\Article\Model\Article;
use App\Xielei\Article\Model\Category;
use App\Xielei\Article\Model\Tag;
use Ebcms\Router;
use Xielei\FormBuilder\Builder;
use Xielei\FormBuilder\Col;
use Xielei\FormBuilder\Field\Hidden;
use Xielei\FormBuilder\Field\Radio;
use Xielei\FormBuilder\Field\Select;
use Xielei\FormBuilder\Field\Text;
use Xielei\FormBuilder\Field\Textarea;
use Xielei\FormBuilder\Other\Cover;
use Xielei\FormBuilder\Other\Summernote;
use Xielei\FormBuilder\Row;
use Xielei\FormBuilder\Summary;
use Xielei\RequestFilter;
use Xielei\Xss;

class Update extends Common
{
    public function get(
        Category $categoryModel,
        Article $articleModel,
        Router $router,
        RequestFilter $input
    ) {
        $data = $articleModel->get('*', [
            'id' => $input->get('id', 0, ['intval']),
        ]);

        $radio_option = [
            [
                'label' => '是',
                'value' => 1,
            ], [
                'label' => '否',
                'value' => 2,
            ],
        ];
        $category_option = (function () use ($categoryModel) {
            $res = [];
            foreach ($categoryModel->select('*', [
                'ORDER' => [
                    'rank' => 'DESC',
                    'id' => 'ASC',
                ],
            ]) as $vo) {
                $sub = [];
                foreach (explode(' ', $vo['types']) as $type) {
                    $sub[] = [
                        'label' => $vo['title'] . '-' . $type,
                        'value' => $vo['id'] . '_' . $type,
                    ];
                }
                $res[] = [
                    'label' => $vo['title'],
                    'group' => $sub,
                ];
            }
            return $res;
        })();
        $form = new Builder('编辑文章');
        $form->addRow(
            (new Row())->addCol(
                (new Col('col-md-9'))->addItem(
                    (new Hidden('id', $data['id'])),
                    (new Text('标题', 'title', $data['title']))->set('help', '一般不超过80个字符')->set('required', 1),
                    (new Summernote('内容详情', 'body', $data['body'], $router->buildUrl('/xielei/admin/admin/upload'))),
                    (new Radio('是否发布', 'state', $data['state']))
                        ->set('options', $radio_option)
                        ->set('inline', true)
                ),
                (new Col('col-md-3'))->addItem(
                    (new Select('发布到', 'category', $data['category_id'] . '_' . $data['type']))
                        ->set('options', $category_option),
                    (new Cover('封面图', 'cover', $data['cover'], $router->buildUrl('/xielei/admin/admin/upload'))),
                    (new Radio('是否置顶', 'sticky', $data['sticky']))
                        ->set('options', $radio_option)
                        ->set('inline', true),
                    (new Text('文章标签', 'tags', $data['tags']))->set('help', '多个标签用空格分割'),
                    (new Summary('元数据设置'))->addItem(
                        new Text('关键词', 'keywords', $data['keywords']),
                        new Textarea('简介', 'description', $data['description'])
                    ),
                    (new Summary('其他参数设置'))->addItem(
                        new Text('模板', 'tpl', $data['tpl']),
                        new Text('别名', 'alias', $data['alias']),
                        new Text('重定向地址', 'redirect_uri', $data['redirect_uri'])
                    )
                )
            )
        );
        return $this->html($form->__toString());
    }
    public function post(
        RequestFilter $input,
        Article $articleModel,
        Tag $tagModel,
        Xss $xss
    ) {
        $update = array_intersect_key($input->post(), [
            'title' => '',
            'state' => '',
            'cover' => '',
            'sticky' => '',
            'tags' => '',
            'keywords' => '',
            'description' => '',
            'tpl' => '',
            'alias' => '',
            'redirect_uri' => '',
        ]);
        if ($input->has('post.body')) {
            $update['body'] = $input->post('body', '', [[$xss, 'clear']]);
        }
        if ($input->post('category')) {
            $category = explode('_', $input->post('category'));
            $update['category_id'] = $category[0];
            $update['type'] = $category[1];
        }
        $update['update_time'] = time();

        $articleModel->update($update, [
            'id' => $input->post('id', 0, ['intval']),
        ]);

        $tagModel->delete([
            'article_id' => $input->post('id', 0, ['intval']),
        ]);

        if ($update['state'] && $update['tags']) {
            $tmp = array_unique(array_filter(explode(',', $update['tags'])));
            $tags = [];
            foreach ($tmp as $tag) {
                $tags[] = [
                    'article_id' => $input->post('id', 0, ['intval']),
                    'tag' => $tag,
                ];
            }
            $tagModel->insert($tags);
        }

        return $this->success('操作成功！', 'javascript:history.go(-2)');
    }
}
