<?php

declare(strict_types=1);

namespace App\Xielei\Article\Http\Admin\Category;

use App\Xielei\Admin\Http\Admin\Common;
use App\Xielei\Article\Model\Category;
use Ebcms\Router;
use Xielei\FormBuilder\Builder;
use Xielei\FormBuilder\Col;
use Xielei\FormBuilder\Field\Number;
use Xielei\FormBuilder\Field\Radio;
use Xielei\FormBuilder\Field\Range;
use Xielei\FormBuilder\Field\Text;
use Xielei\FormBuilder\Field\Textarea;
use Xielei\FormBuilder\Field\Url;
use Xielei\FormBuilder\Other\Summernote;
use Xielei\FormBuilder\Row;
use Xielei\FormBuilder\Summary;
use Xielei\RequestFilter;

class Create extends Common
{
    public function get(
        Router $router
    ) {
        $radio_option = [
            [
                'label' => '是',
                'value' => 1,
            ], [
                'label' => '否',
                'value' => 2,
            ],
        ];
        $form = new Builder('创建栏目');
        $form->addRow(
            (new Row())->addCol(
                (new Col('col-md-9'))->addItem(
                    (new Text('栏目标题', 'title'))->set('help', '一般不超过20个字符')->set('required', 1),
                    (new Text('类型', 'types'))->set('help', '用空格分割'),
                    (new Summernote('栏目介绍', 'body', '', $router->buildUrl('/xielei/admin/admin/upload'))),
                    (new Radio('是否发布', 'state', 1))->set('options', $radio_option)->set('inline', true),
                    (new Radio('是否在导航上显示', 'nav', 1))->set('options', $radio_option)->set('inline', true)
                ),
                (new Col('col-md-3'))->addItem(
                    (new Range('排序', 'rank', '50', 1, 100))->set('help', '越大越靠前'),
                    (new Url('重定向地址', 'redirect_uri')),
                    (new Summary('元数据设置'))->addItem(
                        new Text('关键词', 'keywords'),
                        new Textarea('简介', 'description')
                    ),
                    (new Summary('其他参数设置'))->addItem(
                        new Text('栏目默认模板', 'tpl_category'),
                        new Text('内容默认模板', 'tpl_article'),
                        new Text('别名', 'alias'),
                        new Number('分页大小', 'page_num', '20', 1, 500)
                    )
                )
            )
        );
        return $form->__toString();
    }

    public function post(
        RequestFilter $input,
        Category $categoryModel
    ) {
        $categoryModel->insert([
            'title' => $input->post('title'),
            'types' => $input->post('types'),
            'body' => $input->post('body', '', []),
            'state' => $input->post('state'),
            'nav' => $input->post('nav'),
            'rank' => $input->post('rank'),
            'redirect_uri' => $input->post('redirect_uri'),
            'keywords' => $input->post('keywords'),
            'description' => $input->post('description'),
            'tpl_category' => $input->post('tpl_category'),
            'tpl_article' => $input->post('tpl_article'),
            'alias' => $input->post('alias'),
            'page_num' => $input->post('page_num'),
        ]);
        return $this->success('操作成功！', 'javascript:history.go(-2)');
    }
}
