<?php

declare(strict_types=1);

namespace App\Xielei\Article\Http\Admin\Category;

use App\Xielei\Admin\Http\Admin\Common;
use App\Xielei\Article\Model\Article;
use App\Xielei\Article\Model\Category;
use App\Xielei\Article\Model\Tag;
use Xielei\RequestFilter;

class Delete extends Common
{
    public function get(
        RequestFilter $input,
        Article $articleModel,
        Tag $tagModel,
        Category $categoryModel
    ) {
        if ($article_ids = $articleModel->get('id', [
            'category_id' => $input->get('id', 0, ['intval']),
        ])) {
            $tagModel->delete([
                'article_id' => $article_ids,
            ]);
        }
        $articleModel->delete([
            'category_id' => $input->get('id', 0, ['intval']),
        ]);
        $categoryModel->delete([
            'id' => $input->get('id', 0, ['intval']),
        ]);
        return $this->success('操作成功！');
    }
}
