<?php

declare(strict_types=1);

namespace App\Xielei\Article\Http\Admin\Category;

use App\Xielei\Admin\Http\Admin\Common;
use App\Xielei\Article\Model\Category;
use Xielei\Template;

class Index extends Common
{

    public function get(
        Category $categoryModel,
        Template $template
    ) {
        return $this->html($template->renderFromFile('/category/index', [
            'categorys' => $categoryModel->select('*', [
                'ORDER' => [
                    'rank' => 'DESC',
                    'id' => 'ASC',
                ],
            ]),
        ]));
    }
}
