<?php

declare(strict_types=1);

namespace App\Xielei\Article\Http\Admin\Category;

use App\Xielei\Admin\Http\Admin\Common;
use App\Xielei\Article\Model\Category;
use Ebcms\Router;
use Xielei\FormBuilder\Builder;
use Xielei\FormBuilder\Col;
use Xielei\FormBuilder\Field\Hidden;
use Xielei\FormBuilder\Field\Number;
use Xielei\FormBuilder\Field\Radio;
use Xielei\FormBuilder\Field\Range;
use Xielei\FormBuilder\Field\Text;
use Xielei\FormBuilder\Field\Textarea;
use Xielei\FormBuilder\Field\Url;
use Xielei\FormBuilder\Other\Summernote;
use Xielei\FormBuilder\Row;
use Xielei\FormBuilder\Summary;
use Xielei\RequestFilter;
use Xielei\Xss;

class Update extends Common
{
    public function get(
        Router $router,
        Category $categoryModel,
        RequestFilter $input
    ) {
        $data = $categoryModel->get('*', [
            'id' => $input->get('id', 0, ['intval']),
        ]);

        $radio_option = [
            [
                'label' => '是',
                'value' => 1,
            ], [
                'label' => '否',
                'value' => 2,
            ],
        ];
        $form = new Builder('更新栏目');
        $form->addRow(
            (new Row())->addCol(
                (new Col('col-md-9'))->addItem(
                    (new Hidden('id', $data['id'])),
                    (new Text('标题', 'title', $data['title']))->set('help', '一般不超过20个字符')->set('required', 1),
                    (new Text('类型', 'types', $data['types']))->set('help', '用空格分割'),
                    (new Summernote('栏目介绍', 'body', $data['body'], $router->buildUrl('/xielei/admin/admin/upload'))),
                    (new Radio('是否发布', 'state', $data['state']))->set('options', $radio_option)->set('inline', true),
                    (new Radio('是否在导航上显示', 'nav', $data['nav']))->set('options', $radio_option)->set('inline', true)
                ),
                (new Col('col-md-3'))->addItem(
                    (new Range('排序', 'rank', $data['rank'], 1, 100))->set('help', '越大越靠前'),
                    (new Url('重定向地址', 'redirect_uri', $data['redirect_uri'])),
                    (new Summary('元数据设置'))->addItem(
                        new Text('关键词', 'keywords', $data['keywords']),
                        new Textarea('简介', 'description', $data['description'])
                    ),
                    (new Summary('其他参数设置'))->addItem(
                        new Text('栏目默认模板', 'tpl_category', $data['tpl_category']),
                        new Text('内容默认模板', 'tpl_article', $data['tpl_article']),
                        new Text('别名', 'alias', $data['alias']),
                        new Number('分页大小', 'page_num', $data['page_num'], 1, 500)
                    )
                )
            )
        );
        return $this->html($form->__toString());
    }
    public function post(
        RequestFilter $input,
        Category $categoryModel,
        Xss $xss
    ) {
        $update = array_intersect_key($input->post(), [
            'title' => '',
            'types' => '',
            'state' => '',
            'nav' => '',
            'rank' => '',
            'redirect_uri' => '',
            'keywords' => '',
            'description' => '',
            'tpl_category' => '',
            'tpl_article' => '',
            'alias' => '',
            'page_num' => '',
        ]);
        if ($input->has('post.body')) {
            $update['body'] = $input->post('body', '', [[$xss, 'clear']]);
        }

        $categoryModel->update($update, [
            'id' => $input->post('id', 0, ['intval']),
        ]);

        return $this->success('操作成功！', 'javascript:history.go(-2)');
    }
}
