<?php

declare(strict_types=1);

namespace App\Xielei\Article\Model;

use Xielei\Database\Model;

class Article extends Model
{
    public function getTable(): string
    {
        return 'xielei_article_article';
    }

    public function getById(int $id)
    {
        return $this->db->get($this->table, '*', [
            'id' => $id,
        ]);
    }

    public function insertWithTag(array $data)
    {
        $this->db->insert($this->table, $data);
        $article_id = $this->db->id();
        if ($data['state'] && $data['tags']) {
            $tmp = array_unique(array_filter(explode(',', $data['tags'])));
            $tags = [];
            foreach ($tmp as $tag) {
                $tags[] = [
                    'article_id' => $article_id,
                    'tag' => $tag,
                ];
            }
            $this->tag->insert($tags);
        }
    }

    public function updateWithTag(int $id, array $update)
    {
        $this->db->update($this->table, $update, [
            'id' => $id,
        ]);

        $this->tag->deleteByArticleId($id);

        if ($update['state'] && $update['tags']) {
            $tmp = array_unique(array_filter(explode(',', $update['tags'])));
            $tags = [];
            foreach ($tmp as $tag) {
                $tags[] = [
                    'article_id' => $id,
                    'tag' => $tag,
                ];
            }
            $this->tag->insert($tags);
        }
    }
}
