{include /common/header}
<div class="my-4 display-4">文章列表</div>
<hr>
<div class="my-3">
    <a href="{:$router->buildUrl('/xielei/article/admin/article/create')}" class="btn btn-primary">创建文章</a>
</div>
<div class="my-3">
    <form id="form_2" class="form-inline" action="{:$router->buildUrl('/xielei/article/admin/article/index')}" method="GET">

        <label class="mr-2">栏目</label>
        <select class="custom-select mr-sm-2" name="category" onchange="document.getElementById('form_2').submit();">
            <option {if !$input->get('category_id')}selected{/if} value="">不限</option>
            {foreach $categorys as $vo}
            <optgroup label="{$vo.title}">
                <option value="{$vo.id}_" <?php if ($input->get('category') == $vo['id'] . '_') { ?>selected<?php } ?>>{$vo.title}</option>
                {foreach explode(' ', $vo['types']) as $type}
                <option value="{$vo.id}_{$type}" <?php if ($input->get('category') == $vo['id'] . '_' . $type) { ?>selected<?php } ?>>{$vo.title}-{$type}</option>
                {/foreach}
            </optgroup>
            {/foreach}
        </select>

        <label class="mr-2">发布状态</label>
        <select class="custom-select mr-sm-2" name="state" onchange="document.getElementById('form_2').submit();">
            <option {if $input->get('state')=='' }selected{/if} value="">不限</option>
            <option {if $input->get('state')=='2' }selected{/if} value="2">未发布</option>
            <option {if $input->get('state')=='1' }selected{/if} value="1">已发布</option>
        </select>

        <label class="mr-2">置顶状态</label>
        <select class="custom-select mr-sm-2" name="sticky" onchange="document.getElementById('form_2').submit();">
            <option {if $input->get('sticky')=='' }selected{/if} value="">不限</option>
            <option {if $input->get('sticky')=='2' }selected{/if} value="2">未置顶</option>
            <option {if $input->get('sticky')=='1' }selected{/if} value="1">已置顶</option>
        </select>

        <label class="mr-2">分页大小</label>
        <select class="custom-select mr-sm-2" name="page_num" onchange="document.getElementById('form_2').submit();">
            <option {if $input->get('page_num')=='20' }selected{/if} value="20">20</option>
            <option {if $input->get('page_num')=='50' }selected{/if} value="50">50</option>
            <option {if $input->get('page_num')=='100' }selected{/if} value="100">100</option>
            <option {if $input->get('page_num')=='500' }selected{/if} value="500">500</option>
        </select>

        <label class="mr-2">搜索</label>
        <input type="search" class="form-control" name="q" value="{:$input->get('q')}" onchange="document.getElementById('form_2').submit();">
        <input type="hidden" name="page" value="1">
    </form>
</div>
<div class="table-responsive">
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>标题</th>
                <th>点击量</th>
                <th>发布状态</th>
                <th>固定</th>
                <th>管理</th>
            </tr>
        </thead>
        <tbody>
            {foreach $data as $vo}
            <tr>
                <th>{$vo.id}</th>
                <td>{$vo.title}</td>
                <td>{$vo.click}</td>
                <td>
                    {if $vo['state']==1}
                    发布
                    {else}
                    未发布
                    {/if}
                </td>
                <td>
                    {if $vo['sticky']==1}
                    置顶
                    {else}
                    未置顶
                    {/if}
                </td>
                <td class="text-nowrap">
                    <a href="{:$router->buildUrl('/xielei/article/admin/article/update', ['id'=>$vo['id']])}">编辑</a>
                    <a href="{:$router->buildUrl('/xielei/article/admin/article/delete', ['id'=>$vo['id']])}" onclick="return confirm('确定删除吗？删除后不可恢复！');">删除</a>
                </td>
            </tr>
            {/foreach}
        </tbody>
    </table>
</div>
<nav class="my-3">
    <ul class="pagination">
        {foreach $pagination as $v}
        {if $v=='...'}
        <li class="page-item disabled"><a class="page-link" href="javascript:void(0);">{$v}</a></li>
        {elseif isset($v['current'])}
        <li class="page-item active"><a class="page-link" href="javascript:void(0);">{$v.page}</a></li>
        {else}
        <li class="page-item"><a class="page-link" href="{:$router->buildUrl('/xielei/article/admin/article/index', array_merge($_GET, ['page'=>$v['page']]))}">{$v.page}</a></li>
        {/if}
        {/foreach}
    </ul>
</nav>
{include /common/footer}