<?php

declare(strict_types=1);

namespace Xielei\Database;

use Ebcms\Config;
use Medoo\Medoo;

class Db extends Medoo
{

    public function __construct(
        array $options = [],
        Config $config
    ) {
        parent::__construct(array_merge([
            'database_type' => 'mysql',
            'database_name' => 'test',
            'server' => '127.0.0.1',
            'username' => 'root',
            'password' => 'root',
            'charset' => 'utf8mb4',
            'prefix' => 'prefix_',
            'option' => [
                \PDO::ATTR_CASE => \PDO::CASE_NATURAL,
                \PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION,
                \PDO::ATTR_STRINGIFY_FETCHES => false,
                \PDO::ATTR_EMULATE_PREPARES => false,
            ],
            'command' => ['SET SQL_MODE=ANSI_QUOTES'],
        ], (array) $config->get('database@xielei.database', []), $options));
    }
}
