<?php

declare(strict_types=1);

namespace App\Xielei\Installer\Http;

use App\Xielei\Admin\Traits\ResponseTrait;
use App\Xielei\Admin\Traits\RestfulTrait;
use App\Xielei\Installer\Middleware\Lock;
use Ebcms\Config;
use Ebcms\RequestHandler;
use Ebcms\Router;
use Xielei\RequestFilter;
use Xielei\Template;

abstract class Common
{
    use RestfulTrait;
    use ResponseTrait;

    public function __construct(
        Config $config,
        Router $router,
        RequestFilter $input,
        RequestHandler $requestHandler,
        Template $template
    ) {
        $requestHandler->lazyMiddleware(Lock::class);
        $template->assign([
            'input' => $input,
            'config' => $config,
            'router' => $router,
        ]);
        $template->setRoot(
            $config->get('home.template_root@xielei.installer') ?: (__DIR__ . '/../../template')
        );
    }
}
