<?php

declare(strict_types=1);

namespace App\Xielei\Installer\Middleware;

use Ebcms\App;
use Ebcms\Config;
use Psr\Http\Message\ResponseFactoryInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;

class JumpInstaller implements MiddlewareInterface
{
    public function process(
        ServerRequestInterface $request,
        RequestHandlerInterface $handler
    ): ResponseInterface {
        return App::getInstance()->execute(function (
            App $app,
            Config $config,
            ResponseFactoryInterface $responseFactory
        ) use ($request, $handler): ResponseInterface {
            if (!$config->get('lock@xielei.installer')) {
                if (!$app->getRequestTargetClass() || strpos($app->getRequestTargetClass(), 'App\\Xielei\\Installer\\Http\\Index') !== 0) {
                    $response = $responseFactory->createResponse(302);
                    if (
                        (!empty($_SERVER['REQUEST_SCHEME']) && $_SERVER['REQUEST_SCHEME'] == 'https')
                        || (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on')
                        || (!empty($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == '443')
                    ) {
                        $schema = 'https';
                    } else {
                        $schema = 'http';
                    }
                    $root = $schema . '://' . $_SERVER['HTTP_HOST'] . '/' . implode('/', array_filter(explode('/', $_SERVER['SCRIPT_NAME'])));
                    return $response->withHeader('Location', $root . '/xielei/installer/index');
                }
            }
            return $handler->handle($request);
        });
    }
}
