<?php

namespace Xielei;

class Session
{

    public $prefix = 'xielei_';

    function __construct(string $prefix = 'xielei_')
    {
        $this->prefix = $prefix;
        if (session_status() !== PHP_SESSION_ACTIVE) {
            session_start();
        }
    }

    /**
     * Undocumented function
     *
     * @param string $id
     * @param mixed $value
     * @return self
     */
    public function set(string $id, $value): self
    {
        $_SESSION[$this->prefix . $id] = $value;
        return $this;
    }

    public function get(string $id = null)
    {
        if ($id == null) {
            return $_SESSION;
        } else {
            return isset($_SESSION[$this->prefix . $id]) ? $_SESSION[$this->prefix . $id] : null;
        }
    }

    public function delete(string $id): self
    {
        if (isset($_SESSION[$this->prefix . $id])) {
            unset($_SESSION[$this->prefix . $id]);
        }
        return $this;
    }

    public function destroy(): self
    {
        session_destroy();
        return $this;
    }
}
