# template

php template engine

## Installation

``` php
composer require xielei/template
```

## Usage

``` php
$template = new \Xielei\Template;
```

### methods

| Item | Instruction |
| - | - |
| setDebug(bool $debug) | |
| setRoot(string $root) | |
| setCache(\Psr\SimpleCache\CacheInterface $cache) | |
| assign(mix $name, [$value]) | set value..|
| renderFromString($string [, $data]) | render from string |
| renderFromFile($file [, $data]) | render from file, must set tpl_path |
| extend(pattern, callback) | extend the tag.|

## Example

``` php
$template = new \Xielei\Template;
$template -> renderFromString('hello {$name}!', ['name'=>'world']);
// hello world!
```

### assign

``` php
$template = new \Xielei\Template();
$template -> assign('name', 'world') -> renderFromString('hello {$name}!');
// hello world!
```

### render

``` php
$template = new \Xielei\Template;
$template->setRoot('/path/to');
// /path/to/index.html => hello {$name}!
$template -> renderFromFile('index', ['name'=>'world']);
// hello world!
```

### tags

``` php
{php}
    $a=1;
    echo 13;
{/php}
{$var} => <?php echo $var;?>
{$var.sub} => <?php echo $var['sub'];?>
{$a?1:0} => <?php echo (isset($a) && $a)?1:0;?>
{:script...} => <?php echo script...;?>
{include header}
{if $a==$b && $c>1}
{else}
{/if}
{foreach $data as $key=>$value}
{$key}:{$value}
{/foreach}
{for $i=0; $i < 10; $i++}
{$i}
{/for}
{function test($a, $b)}
<p>{$a} + {$b} = {:$a+$b}</p>
{/function}
{:test(3,6)}
{var $a=3}
{$a}
{switch $a}
    {case 1}
        <p>eq 1</p>
    {/case}
    {case 2}
        <p>eq 2</p>
    {/case}
    {default}
        <p>xxx</p>
{/switch}
```

## Extend

``` php
$template->extend('/\{dump\s+(.*)\s*\}/Ui', function($matchs){
    return '<?php var_dump(' . $matchs[1] . '); ?>';
});
$template->renderFromString('{dump $a}', ['a'=>123]);
// <?php var_dump($a); ?>
```
