<?php
// +----------------------------------------------------------------------
// | RXThinkCMF框架 [ RXThinkCMF ]
// +----------------------------------------------------------------------
// | 版权所有 2017~2020 南京RXThinkCMF研发中心
// +----------------------------------------------------------------------
// | 官方网站: http://www.rxthink.cn
// +----------------------------------------------------------------------
// | Author: 牧羊人 <1175401194@qq.com>
// +----------------------------------------------------------------------

namespace app\admin\controller;


use app\admin\service\AdService;
use app\common\controller\Backend;
use think\facade\View;

/**
 * 广告-控制器
 * @author 牧羊人
 * @since 2020/7/2
 * Class Ad
 * @package app\admin\controller
 */
class Ad extends Backend
{
    /**
     * 初始化
     * @author 牧羊人
     * @since 2020/7/2
     */
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->model = new \app\admin\model\Ad();
        $this->service = new AdService();
    }

    /**
     * 添加或编辑
     * @return mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     * @author 牧羊人
     * @since 2020/7/2
     */
    public function edit()
    {
        // 广告位列表
        $adSortMod = new \app\admin\model\AdSort();
        $sortList = $adSortMod->where("mark", 1)->order("id desc")->select()->toArray();
        View::assign("sortList", $sortList);
        // 广告类型
        View::assign("typeList", config("admin.ad_type"));
        return parent::edit(); // TODO: Change the autogenerated stub
    }
}