<?php
// +----------------------------------------------------------------------
// | RXThinkCMF框架 [ RXThinkCMF ]
// +----------------------------------------------------------------------
// | 版权所有 2017~2020 南京RXThinkCMF研发中心
// +----------------------------------------------------------------------
// | 官方网站: http://www.rxthink.cn
// +----------------------------------------------------------------------
// | Author: 牧羊人 <1175401194@qq.com>
// +----------------------------------------------------------------------

namespace app\admin\controller;


use app\admin\service\AdminService;
use app\common\controller\Backend;
use think\facade\View;

/**
 * 人员-控制器
 * @author 牧羊人
 * @since 2020/7/3
 * Class Admin
 * @package app\admin\controller
 */
class Admin extends Backend
{
    /**
     * 初始化
     * @author 牧羊人
     * @since 2020/7/3
     */
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->model = new \app\admin\model\Admin();
        $this->service = new AdminService();
    }

    /**
     * 添加或编辑
     * @return mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     * @author 牧羊人
     * @since 2020/7/3
     */
    public function edit()
    {
        // 性别
        View::assign("genderList", config("admin.gender_list"));

        // 角色列表
        $roleMod = new \app\admin\model\Role();
        $roleList = $roleMod->where("mark", 1)->order("sort asc")->select()->toArray();
        View::assign("roleList", $roleList);

        // 职级
        $levelMod = new \app\admin\model\Level();
        $levelList = $levelMod->where("status", 1)->where("mark", 1)->order("sort asc")->select()->toArray();
        View::assign("levelList", $levelList);

        // 岗位
        $positionMod = new \app\admin\model\Position();
        $positionList = $positionMod->where("status", 1)->where("mark", 1)->order("sort asc")->select()->toArray();
        View::assign("positionList", $positionList);

        // 获取上级部门
        $deptMod = new \app\admin\model\Dep();
        $result = $deptMod->getChilds(0, true);
        if ($result) {
            $deptList = array();
            foreach ($result as $val) {
                $key = (int)$val['id'];
                $deptList[$key] = $val;
                $vlist = isset($val['children']) ? $val['children'] : [];
                if ($vlist) {
                    foreach ($vlist as &$v) {
                        $k = (int)$v['id'];
                        $v['name'] = "|--" . $v['name'];
                        $deptList[$k] = $v;
                        $clist = isset($v['children']) ? $v['children'] : [];
                        if ($clist) {
                            foreach ($clist as &$vt) {
                                $kt = (int)$vt['id'];
                                $vt['name'] = "|--|--" . $vt['name'];
                                $deptList[$kt] = $vt;
                            }
                        }
                    }
                }
            }
        }
        // 绑定数据
        View::assign("deptList", $deptList);
        return parent::edit(); // TODO: Change the autogenerated stub
    }

    /**
     * 重置密码
     * @return mixed
     * @since 2020/7/3
     * @author 牧羊人
     */
    public function resetPwd()
    {
        if (IS_POST) {
            $result = $this->service->resetPwd();
            return $result;
        }
    }
}