<?php
// +----------------------------------------------------------------------
// | RXThinkCMF框架 [ RXThinkCMF ]
// +----------------------------------------------------------------------
// | 版权所有 2017~2020 南京RXThinkCMF研发中心
// +----------------------------------------------------------------------
// | 官方网站: http://www.rxthink.cn
// +----------------------------------------------------------------------
// | Author: 牧羊人 <1175401194@qq.com>
// +----------------------------------------------------------------------

namespace app\admin\controller;


use app\admin\service\CityService;
use app\common\controller\Backend;
use think\facade\View;

/**
 * 城市-控制器
 * @author 牧羊人
 * @since 2020/7/3
 * Class City
 * @package app\admin\controller
 */
class City extends Backend
{
    /**
     * 初始化
     * @author 牧羊人
     * @since 2020/7/3
     */
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->model = new \app\admin\model\City();
        $this->service = new CityService();
    }

    /**
     * 添加或编辑
     * @return mixed
     * @since 2020/7/3
     * @author 牧羊人
     */
    public function edit()
    {
        // 城市级别
        View::assign("levelList", config("admin.city_level"));
        return parent::edit(); // TODO: Change the autogenerated stub
    }

    /**
     * 获取子级城市
     * @return array
     * @since 2020/7/3
     * @author 牧羊人
     */
    public function getChilds()
    {
        if (IS_POST) {
            $id = input("post.id", 0);
            $list = $this->model->getChilds($id);
            return message('操作成功', true, $list);
        }
    }
}