<?php
// +----------------------------------------------------------------------
// | RXThinkCMF框架 [ RXThinkCMF ]
// +----------------------------------------------------------------------
// | 版权所有 2017~2020 南京RXThinkCMF研发中心
// +----------------------------------------------------------------------
// | 官方网站: http://www.rxthink.cn
// +----------------------------------------------------------------------
// | Author: 牧羊人 <1175401194@qq.com>
// +----------------------------------------------------------------------

namespace app\admin\controller;


use app\admin\service\LayoutDescService;
use app\common\controller\Backend;
use think\facade\View;

/**
 * 布局描述-控制器
 * @author 牧羊人
 * @since 2020/7/2
 * Class Layoutdesc
 * @package app\admin\controller
 */
class Layoutdesc extends Backend
{
    /**
     * 初始化
     * @author 牧羊人
     * @since 2020/7/2
     */
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->model = new \app\admin\model\LayoutDesc();
        $this->service = new LayoutDescService();
    }

    /**
     * 添加或编辑
     * @return mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     * @author 牧羊人
     * @since 2020/7/2
     */
    public function edit()
    {
        // 站点列表
        $itemMod = new \app\admin\model\Item();
        $itemList = $itemMod->where("status", 1)->where("mark", 1)->order("sort asc")->select()->toArray();
        View::assign("itemList", $itemList);
        return parent::edit(); // TODO: Change the autogenerated stub
    }

    /**
     * 根据站点ID获取描述列表
     * @return array
     * @since 2020/7/2
     * @author 牧羊人
     */
    public function getLayoutDescList()
    {
        // 站点ID
        $itemId = request()->param("item_id", 0);
        $list = $this->model->where(['item_id' => $itemId, 'mark' => 1])->order("sort asc")->select();
        return message("操作成功", true, $list);
    }
}