<?php
// +----------------------------------------------------------------------
// | RXThinkCMF框架 [ RXThinkCMF ]
// +----------------------------------------------------------------------
// | 版权所有 2017~2020 南京RXThinkCMF研发中心
// +----------------------------------------------------------------------
// | 官方网站: http://www.rxthink.cn
// +----------------------------------------------------------------------
// | Author: 牧羊人 <1175401194@qq.com>
// +----------------------------------------------------------------------

namespace app\admin\controller;


use app\admin\service\LinkService;
use app\common\controller\Backend;
use think\facade\View;

/**
 * 友链管理-控制器
 * @author 牧羊人
 * @since 2020/7/2
 * Class Link
 * @package app\admin\controller
 */
class Link extends Backend
{
    /**
     * 初始化
     * @author 牧羊人
     * @since 2020/7/2
     */
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->model = new \app\admin\model\Link();
        $this->service = new LinkService();
    }

    /**
     * 数据列表页
     * @return mixed
     * @since 2020/7/2
     * @author 牧羊人
     */
    public function index()
    {
        return parent::index([
            'typeList' => config("admin.link_type"),
            'platformList' => config("admin.link_platform"),
        ]); // TODO: Change the autogenerated stub
    }

    /**
     * 添加或编辑
     * @return mixed
     * @since 2020/7/2
     * @author 牧羊人
     */
    public function edit()
    {
        // 友链类型
        View::assign("typeList", config("admin.link_type"));
        // 友链形式
        View::assign("formList", config("admin.link_form"));
        // 友链平台
        View::assign("platformList", config("admin.link_platform"));
        return parent::edit(); // TODO: Change the autogenerated stub
    }
}