<?php
// +----------------------------------------------------------------------
// | RXThinkCMF框架 [ RXThinkCMF ]
// +----------------------------------------------------------------------
// | 版权所有 2017~2020 南京RXThinkCMF研发中心
// +----------------------------------------------------------------------
// | 官方网站: http://www.rxthink.cn
// +----------------------------------------------------------------------
// | Author: 牧羊人 <1175401194@qq.com>
// +----------------------------------------------------------------------

namespace app\admin\model;


use app\common\model\BaseModel;

/**
 * 人员权限模型
 * @author 牧羊人
 * @since: 2020/6/30
 * Class AdminRom
 * @package app\admin\model
 */
class AdminRom extends BaseModel
{
    // 设置数据表名
    protected $name = "admin_rom";

    /**
     * 获取缓存信息
     * @param int $id
     * @return \app\common\model\数据信息|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @author 牧羊人
     * @since: 2020/6/30
     */
    public function getInfo($id)
    {
        return parent::getInfo($id); // TODO: Change the autogenerated stub
    }

    /**
     * 获取权限菜单
     * @param $roleIds 角色ID
     * @param $adminId 用户ID
     * @param $type 类型
     * @param $pid 上级ID
     * @return mixed
     * @since 2020/8/19
     * @author 牧羊人
     */
    public function getPermissionMenu($roleIds, $adminId, $type, $pid)
    {
        $map = [];
        if ($roleIds) {
            $map1 = [
                ['r.type', '=', 1],
                ['r.type_id', 'in', $roleIds],
            ];
            $map[] = $map1;
        }
        $map2 = [
            ['r.type', '=', 2],
            ['r.type_id', '=', $adminId],
        ];
        $map[] = $map2;
        $menuMod = new Menu();
        $menuList = $menuMod->alias('m')
            ->join(DB_PREFIX . 'admin_rom r', 'r.menu_id=m.id')
            ->distinct(true)
            ->where(function ($query) use ($map) {
                $query->whereOr($map);
            })
            ->where('m.type', '=', $type)
            ->where('m.pid', '=', $pid)
            ->where('m.status', '=', 1)
            ->where('m.mark', '=', 1)
            ->order('m.pid ASC,m.sort ASC')
            ->field('m.*')
            ->select()->toArray();
        if (!empty($menuList)) {
            $type += 1;
            if ($type <= 4) {
                foreach ($menuList as &$val) {
                    $childList = $this->getPermissionMenu($roleIds, $adminId, $type, $val['id']);
                    if (is_array($childList) && !empty($childList)) {
                        $val['children'] = $childList;
                    }
                }
            }
        }
        return $menuList;
    }

    /**
     * 获取权限节点列表
     * @param $roleIds 角色ID
     * @param $adminId 人员ID
     * @return mixed
     * @author 牧羊人
     * @since 2020/8/21
     */
    public function getPermissionFuncList($roleIds, $adminId)
    {
        $map = [];
        if ($roleIds) {
            $map1 = [
                ['r.type', '=', 1],
                ['r.type_id', 'in', $roleIds],
            ];
            $map[] = $map1;
        }
        $map2 = [
            ['r.type', '=', 2],
            ['r.type_id', '=', $adminId],
        ];
        $map[] = $map2;
        $menuMod = new Menu();
        $funcList = $menuMod->alias('m')
            ->join(DB_PREFIX . 'admin_rom r', 'r.menu_id=m.id')
            ->distinct(true)
            ->where(function ($query) use ($map) {
                $query->whereOr($map);
            })
            ->where('m.type', '=', 4)
            ->where('m.status', '=', 1)
            ->where('m.mark', '=', 1)
            ->order('m.pid ASC,m.sort ASC')
            ->column('m.permission');
        return $funcList;
    }
}