<?php
// +----------------------------------------------------------------------
// | RXThinkCMF框架 [ RXThinkCMF ]
// +----------------------------------------------------------------------
// | 版权所有 2017~2020 南京RXThinkCMF研发中心
// +----------------------------------------------------------------------
// | 官方网站: http://www.rxthink.cn
// +----------------------------------------------------------------------
// | Author: 牧羊人 <1175401194@qq.com>
// +----------------------------------------------------------------------

namespace app\admin\model;


use app\common\model\BaseModel;

/**
 * 定时任务-模型
 * @author 牧羊人
 * @since 2020/7/4
 * Class Crontab
 * @package app\admin\model
 */
class Crontab extends BaseModel
{
    // 设置数据表名
    protected $name = "crontab";

    /**
     * 获取缓存信息
     * @param int $id 记录ID
     * @return \app\common\model\数据信息|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @author 牧羊人
     * @since 2020/7/4
     */
    public function getInfo($id)
    {
        $info = parent::getInfo($id); // TODO: Change the autogenerated stub
        if ($info) {
            // 任务类型
            if ($info['type']) {
                $info['type_name'] = config('admin.crontab_type')[$info['type']];
            }
            // 开始时间
            if ($info['start_time']) {
                $info['format_start_time'] = datetime($info['start_time']);
            }
            // 结束时间
            if ($info['end_time']) {
                $info['format_end_time'] = datetime($info['end_time']);
            }
            // 执行时间
            if ($info['execute_time']) {
                $info['format_execute_time'] = datetime($info['execute_time']);
            }
        }
        return $info;
    }
}