<?php
// +----------------------------------------------------------------------
// | RXThinkCMF框架 [ RXThinkCMF ]
// +----------------------------------------------------------------------
// | 版权所有 2017~2020 南京RXThinkCMF研发中心
// +----------------------------------------------------------------------
// | 官方网站: http://www.rxthink.cn
// +----------------------------------------------------------------------
// | Author: 牧羊人 <1175401194@qq.com>
// +----------------------------------------------------------------------

namespace app\admin\service;


use app\admin\model\Admin;
use app\admin\model\City;
use app\common\service\BaseService;

/**
 * 人员管理-服务类
 * @author 牧羊人
 * @since 2020/7/3
 * Class AdminService
 * @package app\admin\service
 */
class AdminService extends BaseService
{
    /**
     * 构造函数
     * @author 牧羊人
     * @since 2020/7/3
     * AdminService constructor.
     */
    public function __construct()
    {
        $this->model = new Admin();
    }

    /**
     * 获取数据列表
     * @return array
     * @since 2020/7/11
     * @author 牧羊人
     */
    public function getList()
    {
        $param = request()->param();

        // 查询条件
        $map = [];

        // 真实姓名
        $realname = isset($param['realname']) ? $param['realname'] : '';
        if ($realname) {
            $map[] = ['realname', 'like', "%{$realname}%"];
        }

        return parent::getList($map); // TODO: Change the autogenerated stub
    }

    /**
     * 添加或编辑
     * @return array
     * @since 2020/7/3
     * @author 牧羊人
     */
    public function edit()
    {
        // 请求参数
        $data = request()->param();
        // 头像处理
        $avatar = isset($data['avatar']) ? trim($data['avatar']) : '';
        if (strpos($avatar, "temp")) {
            $data['avatar'] = save_image($avatar, 'admin');
        } else {
            $data['avatar'] = str_replace(IMG_URL, "", $data['avatar']);
        }
        // 密码加密处理
        $username = trim($data['username']);
        $password = trim($data['password']);
        if ($password) {
            $data['password'] = get_password($password . $username);
        } else {
            unset($data['password']);
        }
        $data['entry_date'] = isset($data['entry_date']) ? strtotime($data['entry_date']) : 0;
        // 保存城市区域
        if ($data['district_id']) {
            $cityMod = new City();
            $cityName = $cityMod->getCityName($data['district_id'], " ");
            $data['city_area'] = $cityName;
        }
        $result = $this->model->edit($data);
        if (!$result) {
            return message("操作失败", false);
        }
        // 删除用户整体缓存
        $this->model->cacheDAll();
        return message();
    }

    /**
     * 重置密码
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @since 2020/7/3
     * @author 牧羊人
     */
    public function resetPwd()
    {
        $data = request()->param();
        $adminId = (int)$data['id'];
        $info = $this->model->getInfo($adminId);
        if (!$info) {
            return message('当前用户信息不存在', false);
        }
        $data['password'] = get_password("123456" . $info['username']);
        return parent::edit($data);
    }
}