<?php
// +----------------------------------------------------------------------
// | RXThinkCMF框架 [ RXThinkCMF ]
// +----------------------------------------------------------------------
// | 版权所有 2017~2020 南京RXThinkCMF研发中心
// +----------------------------------------------------------------------
// | 官方网站: http://www.rxthink.cn
// +----------------------------------------------------------------------
// | Author: 牧羊人 <1175401194@qq.com>
// +----------------------------------------------------------------------

namespace app\admin\service;


use app\admin\model\ItemCate;
use app\common\service\BaseService;

/**
 * 栏目管理-服务类
 * @author 牧羊人
 * @since 2020/7/2
 * Class ItemCateService
 * @package app\admin\service
 */
class ItemCateService extends BaseService
{
    /**
     * 构造函数
     * @author 牧羊人
     * @since 2020/7/2
     * ItemCateService constructor.
     */
    public function __construct()
    {
        $this->model = new ItemCate();
    }

    /**
     * 获取数据列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @since 2021/1/24
     * @author 牧羊人
     */
    public function getList()
    {
        $param = request()->param();
        // 查询条件
        $map = [];
        // 栏目名称
        $name = getter($param, "name");
        if ($name) {
            $map[] = ['name', 'like', "%{$name}%"];
        }
        $list = $this->model->getList($map, "sort asc");
        return message("操作成功", true, $list);
    }

    /**
     * 添加或编辑
     * @return array
     * @since 2020/7/2
     * @author 牧羊人
     */
    public function edit()
    {
        // 参数
        $data = request()->param();
        // 是否有封面
        $is_cover = $data['is_cover'];
        // 封面地址
        $cover = trim($data['cover']);
        //封面验证
        if ($is_cover == 1 && !$data['id'] && !$cover) {
            return message('请上传栏目封面', false);
        }
        if ($is_cover == 1) {
            if (strpos($cover, "temp")) {
                $data['cover'] = save_image($cover, 'itemcate');
            } else {
                $data['cover'] = str_replace(IMG_URL, "", $data['cover']);
            }
        } elseif ($is_cover == 2) {
            $data['cover'] = '';
        }
        return parent::edit($data); // TODO: Change the autogenerated stub
    }
}