<?php

namespace AlibabaCloud\Sas\V20181203;

use AlibabaCloud\Client\Resolver\ApiResolver;

/**
 * @method CreateAntiBruteForceRule createAntiBruteForceRule(array $options = [])
 * @method CreateOrUpdateAssetGroup createOrUpdateAssetGroup(array $options = [])
 * @method CreateSimilarSecurityEventsQueryTask createSimilarSecurityEventsQueryTask(array $options = [])
 * @method DeleteGroup deleteGroup(array $options = [])
 * @method DeleteLoginBaseConfig deleteLoginBaseConfig(array $options = [])
 * @method DeleteTagWithUuid deleteTagWithUuid(array $options = [])
 * @method DescribeAlarmEventDetail describeAlarmEventDetail(array $options = [])
 * @method DescribeAlarmEventList describeAlarmEventList(array $options = [])
 * @method DescribeAllEntity describeAllEntity(array $options = [])
 * @method DescribeAllGroups describeAllGroups(array $options = [])
 * @method DescribeAllRegionsStatistics describeAllRegionsStatistics(array $options = [])
 * @method DescribeAssetDetailByUuid describeAssetDetailByUuid(array $options = [])
 * @method DescribeAssetDetailByUuids describeAssetDetailByUuids(array $options = [])
 * @method DescribeAutoDelConfig describeAutoDelConfig(array $options = [])
 * @method DescribeCheckWarningDetail describeCheckWarningDetail(array $options = [])
 * @method DescribeCheckWarnings describeCheckWarnings(array $options = [])
 * @method DescribeCheckWarningSummary describeCheckWarningSummary(array $options = [])
 * @method DescribeCloudCenterInstances describeCloudCenterInstances(array $options = [])
 * @method DescribeCloudProductFieldStatistics describeCloudProductFieldStatistics(array $options = [])
 * @method DescribeConcernNecessity describeConcernNecessity(array $options = [])
 * @method DescribeCriteria describeCriteria(array $options = [])
 * @method DescribeDialogMessages describeDialogMessages(array $options = [])
 * @method DescribeDingTalk describeDingTalk(array $options = [])
 * @method DescribeDomainCount describeDomainCount(array $options = [])
 * @method DescribeDomainDetail describeDomainDetail(array $options = [])
 * @method DescribeDomainList describeDomainList(array $options = [])
 * @method DescribeEmgVulGroup describeEmgVulGroup(array $options = [])
 * @method DescribeExportInfo describeExportInfo(array $options = [])
 * @method DescribeFieldStatistics describeFieldStatistics(array $options = [])
 * @method DescribeGraph4InvestigationOnline describeGraph4InvestigationOnline(array $options = [])
 * @method DescribeGroupedTags describeGroupedTags(array $options = [])
 * @method DescribeGroupedVul describeGroupedVul(array $options = [])
 * @method DescribeInstanceStatistics describeInstanceStatistics(array $options = [])
 * @method DescribeIpInfo describeIpInfo(array $options = [])
 * @method DescribeModuleConfig describeModuleConfig(array $options = [])
 * @method DescribeNoticeConfig describeNoticeConfig(array $options = [])
 * @method DescribePropertyCount describePropertyCount(array $options = [])
 * @method DescribePropertyPortDetail describePropertyPortDetail(array $options = [])
 * @method DescribePropertyPortItem describePropertyPortItem(array $options = [])
 * @method DescribePropertyProcDetail describePropertyProcDetail(array $options = [])
 * @method DescribePropertyProcItem describePropertyProcItem(array $options = [])
 * @method DescribePropertySoftwareDetail describePropertySoftwareDetail(array $options = [])
 * @method DescribePropertySoftwareItem describePropertySoftwareItem(array $options = [])
 * @method DescribePropertyUsageNewest describePropertyUsageNewest(array $options = [])
 * @method DescribePropertyUserDetail describePropertyUserDetail(array $options = [])
 * @method DescribePropertyUserItem describePropertyUserItem(array $options = [])
 * @method DescribeRiskCheckItemResult describeRiskCheckItemResult(array $options = [])
 * @method DescribeRiskCheckResult describeRiskCheckResult(array $options = [])
 * @method DescribeRiskCheckSummary describeRiskCheckSummary(array $options = [])
 * @method DescribeRiskItemType describeRiskItemType(array $options = [])
 * @method DescribeSasAssetStatisticsColumn describeSasAssetStatisticsColumn(array $options = [])
 * @method DescribeSearchCondition describeSearchCondition(array $options = [])
 * @method DescribeSecureSuggestion describeSecureSuggestion(array $options = [])
 * @method DescribeSecurityCheckScheduleConfig describeSecurityCheckScheduleConfig(array $options = [])
 * @method DescribeSecurityEventOperations describeSecurityEventOperations(array $options = [])
 * @method DescribeSecurityStatInfo describeSecurityStatInfo(array $options = [])
 * @method DescribeSimilarSecurityEvents describeSimilarSecurityEvents(array $options = [])
 * @method DescribeStrategyExecDetail describeStrategyExecDetail(array $options = [])
 * @method DescribeStratety describeStratety(array $options = [])
 * @method DescribeSummaryInfo describeSummaryInfo(array $options = [])
 * @method DescribeSuspEventDetail describeSuspEventDetail(array $options = [])
 * @method DescribeSuspEvents describeSuspEvents(array $options = [])
 * @method DescribeUserBaselineAuthorization describeUserBaselineAuthorization(array $options = [])
 * @method DescribeUserLayoutAuthorization describeUserLayoutAuthorization(array $options = [])
 * @method DescribeVolDingdingMessage describeVolDingdingMessage(array $options = [])
 * @method DescribeVpcList describeVpcList(array $options = [])
 * @method DescribeVulDetails describeVulDetails(array $options = [])
 * @method DescribeVulList describeVulList(array $options = [])
 * @method DescribeVulWhitelist describeVulWhitelist(array $options = [])
 * @method DescribeWarningMachines describeWarningMachines(array $options = [])
 * @method ExportRecord exportRecord(array $options = [])
 * @method FixCheckWarnings fixCheckWarnings(array $options = [])
 * @method GetIncIOCs getIncIOCs(array $options = [])
 * @method GetIOCs getIOCs(array $options = [])
 * @method HandleSimilarSecurityEvents handleSimilarSecurityEvents(array $options = [])
 * @method ModifyAntiBruteForceRule modifyAntiBruteForceRule(array $options = [])
 * @method ModifyCreateVulWhitelist modifyCreateVulWhitelist(array $options = [])
 * @method ModifyEmgVulSubmit modifyEmgVulSubmit(array $options = [])
 * @method ModifyGroupProperty modifyGroupProperty(array $options = [])
 * @method ModifyLoginBaseConfig modifyLoginBaseConfig(array $options = [])
 * @method ModifyLoginSwitchConfig modifyLoginSwitchConfig(array $options = [])
 * @method ModifyNoticeConfig modifyNoticeConfig(array $options = [])
 * @method ModifyOperateVul modifyOperateVul(array $options = [])
 * @method ModifyPushAllTask modifyPushAllTask(array $options = [])
 * @method ModifyRiskCheckStatus modifyRiskCheckStatus(array $options = [])
 * @method ModifyRiskSingleResultStatus modifyRiskSingleResultStatus(array $options = [])
 * @method ModifySecurityCheckScheduleConfig modifySecurityCheckScheduleConfig(array $options = [])
 * @method ModifyStartVulScan modifyStartVulScan(array $options = [])
 * @method ModifyTagWithUuid modifyTagWithUuid(array $options = [])
 * @method ModifyVulTargetConfig modifyVulTargetConfig(array $options = [])
 * @method OperateSuspiciousTargetConfig operateSuspiciousTargetConfig(array $options = [])
 * @method OperationSuspEvents operationSuspEvents(array $options = [])
 * @method PauseClient pauseClient(array $options = [])
 * @method SasInstallCode sasInstallCode(array $options = [])
 * @method StartBaselineSecurityCheck startBaselineSecurityCheck(array $options = [])
 * @method ValidateHcWarnings validateHcWarnings(array $options = [])
 */
class SasApiResolver extends ApiResolver
{
}

class Rpc extends \AlibabaCloud\Client\Resolver\Rpc
{
    /** @var string */
    public $product = 'Sas';

    /** @var string */
    public $version = '2018-12-03';

    /** @var string */
    public $method = 'POST';

    /** @var string */
    public $serviceCode = 'sas';
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getForbiddenTime()
 * @method $this withForbiddenTime($value)
 * @method string getFailCount()
 * @method $this withFailCount($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getEnableSmartRule()
 * @method $this withEnableSmartRule($value)
 * @method array getUuidList()
 * @method string getName()
 * @method $this withName($value)
 * @method string getSpan()
 * @method $this withSpan($value)
 * @method string getDefaultRule()
 * @method $this withDefaultRule($value)
 */
class CreateAntiBruteForceRule extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getGroupName()
 * @method $this withGroupName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class CreateOrUpdateAssetGroup extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getSecurityEventId()
 * @method $this withSecurityEventId($value)
 * @method string getSimilarEventScenarioCode()
 * @method $this withSimilarEventScenarioCode($value)
 */
class CreateSimilarSecurityEventsQueryTask extends Rpc
{
}

/**
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DeleteGroup extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class DeleteLoginBaseConfig extends Rpc
{
}

/**
 * @method string getTagName()
 * @method $this withTagName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuidList()
 * @method $this withUuidList($value)
 */
class DeleteTagWithUuid extends Rpc
{
}

/**
 * @method string getAlarmUniqueInfo()
 * @method $this withAlarmUniqueInfo($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeAlarmEventDetail extends Rpc
{
}

/**
 * @method string getAlarmEventType()
 * @method $this withAlarmEventType($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getAlarmEventName()
 * @method $this withAlarmEventName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method array getOperateErrorCodeList()
 * @method string getLevels()
 * @method $this withLevels($value)
 */
class DescribeAlarmEventList extends Rpc
{

    /**
     * @param array $operateErrorCodeList
     *
     * @return $this
     */
	public function withOperateErrorCodeList(array $operateErrorCodeList)
	{
	    $this->data['OperateErrorCodeList'] = $operateErrorCodeList;
		foreach ($operateErrorCodeList as $i => $iValue) {
			$this->options['query']['OperateErrorCodeList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeAllEntity extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeAllGroups extends Rpc
{
}

/**
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getAllRegion()
 * @method $this withAllRegion($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getWebGroupId()
 * @method $this withWebGroupId($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getTag()
 * @method $this withTag($value)
 * @method string getFlow()
 * @method $this withFlow($value)
 * @method string getSaleId()
 * @method $this withSaleId($value)
 * @method string getRuleType()
 * @method $this withRuleType($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSecureToken()
 * @method $this withSecureToken($value)
 * @method string getAction1()
 * @method $this withAction1($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeAllRegionsStatistics extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeAssetDetailByUuid extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeAssetDetailByUuids extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeAutoDelConfig extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCheckWarningId()
 * @method $this withCheckWarningId($value)
 */
class DescribeCheckWarningDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeCheckWarnings extends Rpc
{
}

/**
 * @method string getRiskName()
 * @method $this withRiskName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskStatus()
 * @method $this withRiskStatus($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 * @method string getTypeName()
 * @method $this withTypeName($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeCheckWarningSummary extends Rpc
{
}

/**
 * @method string getCriteria()
 * @method $this withCriteria($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getNoPage()
 * @method $this withNoPage($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLogicalExp()
 * @method $this withLogicalExp($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 */
class DescribeCloudCenterInstances extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeCloudProductFieldStatistics extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeConcernNecessity extends Rpc
{
}

/**
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getValue()
 * @method $this withValue($value)
 */
class DescribeCriteria extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeDialogMessages extends Rpc
{
}

/**
 * @method string getRuleActionName()
 * @method $this withRuleActionName($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeDingTalk extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeDomainCount extends Rpc
{
}

/**
 * @method string getDomainName()
 * @method $this withDomainName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeDomainDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getFuzzyDomain()
 * @method $this withFuzzyDomain($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDomainType()
 * @method $this withDomainType($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeDomainList extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeEmgVulGroup extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getExportId()
 * @method $this withExportId($value)
 */
class DescribeExportInfo extends Rpc
{
}

/**
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeFieldStatistics extends Rpc
{
}

/**
 * @method string getVertexId()
 * @method $this withVertexId($value)
 * @method string getAnomalyId()
 * @method $this withAnomalyId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAnomalyUuid()
 * @method $this withAnomalyUuid($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getDirection()
 * @method $this withDirection($value)
 * @method string getPathLength()
 * @method $this withPathLength($value)
 * @method string getNamespace()
 * @method $this withNamespace($value)
 */
class DescribeGraph4InvestigationOnline extends Rpc
{
}

/**
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeGroupedTags extends Rpc
{
}

/**
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeGroupedVul extends Rpc
{
}

/**
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeInstanceStatistics extends Rpc
{
}

/**
 * @method string getIp()
 * @method $this withIp($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getField()
 * @method $this withField($value)
 */
class DescribeIpInfo extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeModuleConfig extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeNoticeConfig extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuidList()
 * @method $this withUuidList($value)
 */
class DescribePropertyCount extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getPort()
 * @method $this withPort($value)
 * @method string getProcName()
 * @method $this withProcName($value)
 */
class DescribePropertyPortDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPort()
 * @method $this withPort($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertyPortItem extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getCmdline()
 * @method $this withCmdline($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getUser()
 * @method $this withUser($value)
 */
class DescribePropertyProcDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertyProcItem extends Rpc
{
}

/**
 * @method string getSoftwareVersion()
 * @method $this withSoftwareVersion($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getPath()
 * @method $this withPath($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getName()
 * @method $this withName($value)
 */
class DescribePropertySoftwareDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertySoftwareItem extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribePropertyUsageNewest extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getIsRoot()
 * @method $this withIsRoot($value)
 * @method string getUser()
 * @method $this withUser($value)
 */
class DescribePropertyUserDetail extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getUser()
 * @method $this withUser($value)
 * @method string getForceFlush()
 * @method $this withForceFlush($value)
 */
class DescribePropertyUserItem extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getItemId()
 * @method $this withItemId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 */
class DescribeRiskCheckItemResult extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getAssetType()
 * @method $this withAssetType($value)
 * @method string getGroupId()
 * @method $this withGroupId($value)
 * @method array getItemIds()
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskLevel()
 * @method $this withRiskLevel($value)
 * @method string getInstanceId()
 * @method $this withInstanceId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class DescribeRiskCheckResult extends Rpc
{

    /**
     * @param array $itemIds
     *
     * @return $this
     */
	public function withItemIds(array $itemIds)
	{
	    $this->data['ItemIds'] = $itemIds;
		foreach ($itemIds as $i => $iValue) {
			$this->options['query']['ItemIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeRiskCheckSummary extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeRiskItemType extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeSasAssetStatisticsColumn extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSearchCondition extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSecureSuggestion extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSecurityCheckScheduleConfig extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getSecurityEventId()
 * @method $this withSecurityEventId($value)
 */
class DescribeSecurityEventOperations extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeSecurityStatInfo extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 */
class DescribeSimilarSecurityEvents extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 */
class DescribeStrategyExecDetail extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStrategyIds()
 * @method $this withStrategyIds($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeStratety extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getResourceDirectoryAccountId()
 * @method $this withResourceDirectoryAccountId($value)
 */
class DescribeSummaryInfo extends Rpc
{
}

/**
 * @method string getSuspiciousEventId()
 * @method $this withSuspiciousEventId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeSuspEventDetail extends Rpc
{
}

/**
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getAlarmUniqueInfo()
 * @method $this withAlarmUniqueInfo($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getLevels()
 * @method $this withLevels($value)
 * @method string getParentEventTypes()
 * @method $this withParentEventTypes($value)
 */
class DescribeSuspEvents extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeUserBaselineAuthorization extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeUserLayoutAuthorization extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeVolDingdingMessage extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class DescribeVpcList extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class DescribeVulDetails extends Rpc
{
}

/**
 * @method string getStatusList()
 * @method $this withStatusList($value)
 * @method string getRemark()
 * @method $this withRemark($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getDealed()
 * @method $this withDealed($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getAliasName()
 * @method $this withAliasName($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getIds()
 * @method $this withIds($value)
 * @method string getNecessity()
 * @method $this withNecessity($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeVulList extends Rpc
{
}

/**
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 */
class DescribeVulWhitelist extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getPageSize()
 * @method $this withPageSize($value)
 * @method string getMachineName()
 * @method $this withMachineName($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getCurrentPage()
 * @method $this withCurrentPage($value)
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getStrategyId()
 * @method $this withStrategyId($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class DescribeWarningMachines extends Rpc
{
}

/**
 * @method string getExportType()
 * @method $this withExportType($value)
 * @method string getParams()
 * @method $this withParams($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ExportRecord extends Rpc
{
}

/**
 * @method string getRiskId()
 * @method $this withRiskId($value)
 * @method string getCheckParams()
 * @method $this withCheckParams($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class FixCheckWarnings extends Rpc
{
}

/**
 * @method string getDate()
 * @method $this withDate($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetIncIOCs extends Rpc
{
}

/**
 * @method string getDate()
 * @method $this withDate($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class GetIOCs extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperationCode()
 * @method $this withOperationCode($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getOperationParams()
 * @method $this withOperationParams($value)
 */
class HandleSimilarSecurityEvents extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getForbiddenTime()
 * @method $this withForbiddenTime($value)
 * @method string getFailCount()
 * @method $this withFailCount($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getEnableSmartRule()
 * @method $this withEnableSmartRule($value)
 * @method array getUuidList()
 * @method string getId()
 * @method $this withId($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getSpan()
 * @method $this withSpan($value)
 * @method string getDefaultRule()
 * @method $this withDefaultRule($value)
 */
class ModifyAntiBruteForceRule extends Rpc
{

    /**
     * @param array $uuidList
     *
     * @return $this
     */
	public function withUuidList(array $uuidList)
	{
	    $this->data['UuidList'] = $uuidList;
		foreach ($uuidList as $i => $iValue) {
			$this->options['query']['UuidList.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method string getWhitelist()
 * @method $this withWhitelist($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ModifyCreateVulWhitelist extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getName()
 * @method $this withName($value)
 * @method string getUserAgreement()
 * @method $this withUserAgreement($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ModifyEmgVulSubmit extends Rpc
{
}

/**
 * @method string getData()
 * @method $this withData($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ModifyGroupProperty extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getTarget()
 * @method $this withTarget($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class ModifyLoginBaseConfig extends Rpc
{
}

/**
 * @method string getItem()
 * @method $this withItem($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyLoginSwitchConfig extends Rpc
{
}

/**
 * @method string getProject()
 * @method $this withProject($value)
 * @method string getTimeLimit()
 * @method $this withTimeLimit($value)
 * @method string getRoute()
 * @method $this withRoute($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class ModifyNoticeConfig extends Rpc
{
}

/**
 * @method string getReason()
 * @method $this withReason($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getOperateType()
 * @method $this withOperateType($value)
 * @method string getInfo()
 * @method $this withInfo($value)
 */
class ModifyOperateVul extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getTasks()
 * @method $this withTasks($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ModifyPushAllTask extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getItemId()
 * @method $this withItemId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyRiskCheckStatus extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method array getIds()
 * @method string getLang()
 * @method $this withLang($value)
 * @method string getTaskId()
 * @method $this withTaskId($value)
 * @method string getStatus()
 * @method $this withStatus($value)
 */
class ModifyRiskSingleResultStatus extends Rpc
{

    /**
     * @param array $ids
     *
     * @return $this
     */
	public function withIds(array $ids)
	{
	    $this->data['Ids'] = $ids;
		foreach ($ids as $i => $iValue) {
			$this->options['query']['Ids.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method string getEndTime()
 * @method $this withEndTime($value)
 * @method string getStartTime()
 * @method $this withStartTime($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getDaysOfWeek()
 * @method $this withDaysOfWeek($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class ModifySecurityCheckScheduleConfig extends Rpc
{
}

/**
 * @method string getTypes()
 * @method $this withTypes($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ModifyStartVulScan extends Rpc
{
}

/**
 * @method string getTagId()
 * @method $this withTagId($value)
 * @method string getMachineTypes()
 * @method $this withMachineTypes($value)
 * @method string getTagList()
 * @method $this withTagList($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuidList()
 * @method $this withUuidList($value)
 */
class ModifyTagWithUuid extends Rpc
{
}

/**
 * @method string getType()
 * @method $this withType($value)
 * @method string getUuid()
 * @method $this withUuid($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getConfig()
 * @method $this withConfig($value)
 */
class ModifyVulTargetConfig extends Rpc
{
}

/**
 * @method string getTargetType()
 * @method $this withTargetType($value)
 * @method string getType()
 * @method $this withType($value)
 * @method string getTargetOperations()
 * @method $this withTargetOperations($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class OperateSuspiciousTargetConfig extends Rpc
{
}

/**
 * @method string getSuspiciousEventIds()
 * @method $this withSuspiciousEventIds($value)
 * @method string getSubOperation()
 * @method $this withSubOperation($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getWarnType()
 * @method $this withWarnType($value)
 * @method string getFrom()
 * @method $this withFrom($value)
 * @method string getOperation()
 * @method $this withOperation($value)
 */
class OperationSuspEvents extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getAppName()
 * @method $this withAppName($value)
 * @method string getValue()
 * @method $this withValue($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class PauseClient extends Rpc
{
}

/**
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 */
class SasInstallCode extends Rpc
{
}

/**
 * @method string getResourceOwnerId()
 * @method $this withResourceOwnerId($value)
 * @method array getItemIds()
 * @method string getType()
 * @method $this withType($value)
 * @method array getAssets()
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getLang()
 * @method $this withLang($value)
 */
class StartBaselineSecurityCheck extends Rpc
{

    /**
     * @param array $itemIds
     *
     * @return $this
     */
	public function withItemIds(array $itemIds)
	{
	    $this->data['ItemIds'] = $itemIds;
		foreach ($itemIds as $i => $iValue) {
			$this->options['query']['ItemIds.' . ($i + 1)] = $iValue;
		}

		return $this;
    }

    /**
     * @param array $assets
     *
     * @return $this
     */
	public function withAssets(array $assets)
	{
	    $this->data['Assets'] = $assets;
		foreach ($assets as $i => $iValue) {
			$this->options['query']['Assets.' . ($i + 1)] = $iValue;
		}

		return $this;
    }
}

/**
 * @method string getRiskIds()
 * @method $this withRiskIds($value)
 * @method string getSourceIp()
 * @method $this withSourceIp($value)
 * @method string getUuids()
 * @method $this withUuids($value)
 */
class ValidateHcWarnings extends Rpc
{
}
