
--
-- 表的结构 `eb_article`
--

CREATE TABLE `eb_article` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '文章管理ID',
  `cid` varchar(255) DEFAULT '1' COMMENT '分类id',
  `title` varchar(255) DEFAULT NULL COMMENT '文章标题',
  `author` varchar(255) DEFAULT NULL COMMENT '文章作者',
  `image_input` varchar(255) DEFAULT NULL COMMENT '文章图片',
  `synopsis` varchar(255) DEFAULT NULL COMMENT '文章简介',
  `label` varchar(2000) NOT NULL DEFAULT '' COMMENT '标签',
  `share_title` varchar(255) DEFAULT NULL COMMENT '文章分享标题',
  `share_synopsis` varchar(255) DEFAULT NULL COMMENT '文章分享简介',
  `visit` varchar(255) DEFAULT NULL COMMENT '浏览次数',
  `sort` int(10) UNSIGNED DEFAULT '0' COMMENT '排序',
  `url` varchar(255) DEFAULT NULL COMMENT '原文链接',
  `status` tinyint(1) UNSIGNED DEFAULT NULL COMMENT '状态',
  `add_time` varchar(255) DEFAULT NULL COMMENT '添加时间',
  `hide` tinyint(1) UNSIGNED DEFAULT '0' COMMENT '是否隐藏',
  `admin_id` int(10) UNSIGNED DEFAULT '0' COMMENT '管理员id',
  `mer_id` int(10) UNSIGNED DEFAULT '0' COMMENT '商户id',
  `is_hot` tinyint(1) UNSIGNED DEFAULT '0' COMMENT '是否热门(小程序)',
  `is_banner` tinyint(1) UNSIGNED DEFAULT '0' COMMENT '是否轮播图(小程序)',
  `consult_image` varchar(255) DEFAULT NULL COMMENT '活动咨询图片',
  `consult_type` tinyint(1) UNSIGNED DEFAULT '0' COMMENT '活动咨询类型 1 图片 2视屏',
  `is_consult` tinyint(1) UNSIGNED DEFAULT '0' COMMENT '是否活动咨询',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='文章管理表';

--
-- 转存表中的数据 `eb_article`
--

INSERT INTO `eb_article` (`id`, `cid`, `title`, `author`, `image_input`, `synopsis`, `label`, `share_title`, `share_synopsis`, `visit`, `sort`, `url`, `status`, `add_time`, `hide`, `admin_id`, `mer_id`, `is_hot`, `is_banner`, `consult_image`, `consult_type`, `is_consult`, `is_show`) VALUES
(13, '0', '新闻测试01', NULL, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/10f3d202002111757429313.jpg', '新闻测试01', '[\"\\u56fe\\u6587\",\"\\u6d4b\\u8bd5\"]', NULL, NULL, NULL, 0, NULL, NULL, '1581921949', 0, 0, 0, 0, 0, NULL, 0, 0, 1),
(14, '1', '转扩！抗击疫情，这些税收优惠政策请查收', 'demo', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', '转扩！抗击疫情，这些税收优惠政策请查收', '', NULL, NULL, NULL, 0, NULL, 1, '1582346935', 0, 0, 0, 0, 0, NULL, 0, 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `eb_article_category`
--

CREATE TABLE `eb_article_category` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '文章分类id',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '父级ID',
  `title` varchar(255) NOT NULL COMMENT '文章分类标题',
  `intr` varchar(255) DEFAULT NULL COMMENT '文章分类简介',
  `image` varchar(255) NOT NULL COMMENT '文章分类图片',
  `status` tinyint(1) UNSIGNED NOT NULL COMMENT '状态',
  `sort` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '排序',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '1删除0未删除',
  `add_time` varchar(255) NOT NULL COMMENT '添加时间',
  `hidden` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否隐藏'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='文章分类表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_article_content`
--

CREATE TABLE `eb_article_content` (
  `nid` int(10) UNSIGNED NOT NULL COMMENT '文章id',
  `content` text NOT NULL COMMENT '文章内容'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='文章内容表';

--
-- 转存表中的数据 `eb_article_content`
--

INSERT INTO `eb_article_content` (`nid`, `content`) VALUES
(13, '&lt;p&gt;&lt;img src=&quot;http://testcrmeb.oss-cn-beijing.aliyuncs.com/7809f202002111801111378.jpg&quot;/&gt;&lt;/p&gt;'),
(14, '<p>地魔</p>');

-- --------------------------------------------------------

--
-- 表的结构 `eb_cache`
--

CREATE TABLE `eb_cache` (
  `key` varchar(32) NOT NULL,
  `result` text COMMENT '缓存数据',
  `add_time` int(10) DEFAULT NULL COMMENT '缓存时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='记录缓存';

-- --------------------------------------------------------

--
-- 表的结构 `eb_express`
--

CREATE TABLE `eb_express` (
  `id` mediumint(11) UNSIGNED NOT NULL COMMENT '快递公司id',
  `code` varchar(50) NOT NULL COMMENT '快递公司简称',
  `name` varchar(50) NOT NULL COMMENT '快递公司全称',
  `sort` int(11) NOT NULL COMMENT '排序',
  `is_show` tinyint(1) NOT NULL COMMENT '是否显示'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='快递公司表';

--
-- 转存表中的数据 `eb_express`
--

INSERT INTO `eb_express` (`id`, `code`, `name`, `sort`, `is_show`) VALUES
(1, 'LIMINWL', '利民物流', 1, 1),
(2, 'XINTIAN', '鑫天顺物流', 1, 1),
(3, 'henglu', '恒路物流', 1, 1),
(4, 'klwl', '康力物流', 1, 1),
(5, 'meiguo', '美国快递', 1, 1),
(6, 'a2u', 'A2U速递', 1, 1),
(7, 'benteng', '奔腾物流', 1, 1),
(8, 'ahdf', '德方物流', 1, 1),
(9, 'timedg', '万家通', 1, 1),
(10, 'ztong', '智通物流', 1, 1),
(11, 'xindan', '新蛋物流', 1, 1),
(12, 'bgpyghx', '挂号信', 1, 1),
(13, 'XFHONG', '鑫飞鸿物流快递', 1, 1),
(14, 'ALP', '阿里物流', 1, 1),
(15, 'BFWL', '滨发物流', 1, 1),
(16, 'SJWL', '宋军物流', 1, 1),
(17, 'SHUNFAWL', '顺发物流', 1, 1),
(18, 'TIANHEWL', '天河物流', 1, 1),
(19, 'YBWL', '邮联物流', 1, 1),
(20, 'SWHY', '盛旺货运', 1, 1),
(21, 'TSWL', '汤氏物流', 1, 1),
(22, 'YUANYUANWL', '圆圆物流', 1, 1),
(23, 'BALIANGWL', '八梁物流', 1, 1),
(24, 'ZGWL', '振刚物流', 1, 1),
(25, 'JIAYU', '佳宇物流', 1, 1),
(26, 'SHHX', '昊昕物流', 1, 1),
(27, 'ande', '安得物流', 1, 1),
(28, 'ppbyb', '贝邮宝', 1, 1),
(29, 'dida', '递达快递', 1, 1),
(30, 'jppost', '日本邮政', 1, 1),
(31, 'intmail', '中国邮政', 96, 1),
(32, 'HENGCHENGWL', '恒诚物流', 1, 1),
(33, 'HENGFENGWL', '恒丰物流', 1, 1),
(34, 'gdems', '广东ems快递', 1, 1),
(35, 'xlyt', '祥龙运通', 1, 1),
(36, 'gjbg', '国际包裹', 1, 1),
(37, 'uex', 'UEX', 1, 1),
(38, 'singpost', '新加坡邮政', 1, 1),
(39, 'guangdongyouzhengwuliu', '广东邮政', 1, 1),
(40, 'bht', 'BHT', 1, 1),
(41, 'cces', 'CCES快递', 1, 1),
(42, 'cloudexpress', 'CE易欧通国际速递', 1, 1),
(43, 'dasu', '达速物流', 1, 1),
(44, 'pfcexpress', '皇家物流', 1, 1),
(45, 'hjs', '猴急送', 1, 1),
(46, 'huilian', '辉联物流', 1, 1),
(47, 'huanqiu', '环球速运', 1, 1),
(48, 'huada', '华达快运', 1, 1),
(49, 'htwd', '华通务达物流', 1, 1),
(50, 'hipito', '海派通', 1, 1),
(51, 'hqtd', '环球通达', 1, 1),
(52, 'airgtc', '航空快递', 1, 1),
(53, 'haoyoukuai', '好又快物流', 1, 1),
(54, 'hanrun', '韩润物流', 1, 1),
(55, 'ccd', '河南次晨达', 1, 1),
(56, 'hfwuxi', '和丰同城', 1, 1),
(57, 'Sky', '荷兰', 1, 1),
(58, 'hongxun', '鸿讯物流', 1, 1),
(59, 'hongjie', '宏捷国际物流', 1, 1),
(60, 'httx56', '汇通天下物流', 1, 1),
(61, 'lqht', '恒通快递', 1, 1),
(62, 'jinguangsudikuaijian', '京广速递快件', 1, 1),
(63, 'junfengguoji', '骏丰国际速递', 1, 1),
(64, 'jiajiatong56', '佳家通', 1, 1),
(65, 'jrypex', '吉日优派', 1, 1),
(66, 'jinchengwuliu', '锦程国际物流', 1, 1),
(67, 'jgwl', '景光物流', 1, 1),
(68, 'pzhjst', '急顺通', 1, 1),
(69, 'ruexp', '捷网俄全通', 1, 1),
(70, 'jmjss', '金马甲', 1, 1),
(71, 'lanhu', '蓝弧快递', 1, 1),
(72, 'ltexp', '乐天速递', 1, 1),
(73, 'lutong', '鲁通快运', 1, 1),
(74, 'ledii', '乐递供应链', 1, 1),
(75, 'lundao', '论道国际物流', 1, 1),
(76, 'mailikuaidi', '麦力快递', 1, 1),
(77, 'mchy', '木春货运', 1, 1),
(78, 'meiquick', '美快国际物流', 1, 1),
(79, 'valueway', '美通快递', 1, 1),
(80, 'nuoyaao', '偌亚奥国际', 1, 1),
(81, 'euasia', '欧亚专线', 1, 1),
(82, 'pca', '澳大利亚PCA快递', 1, 1),
(83, 'pingandatengfei', '平安达腾飞', 1, 1),
(84, 'pjbest', '品骏快递', 1, 1),
(85, 'qbexpress', '秦邦快运', 1, 1),
(86, 'quanxintong', '全信通快递', 1, 1),
(87, 'quansutong', '全速通国际快递', 1, 1),
(88, 'qinyuan', '秦远物流', 1, 1),
(89, 'qichen', '启辰国际物流', 1, 1),
(90, 'quansu', '全速快运', 1, 1),
(91, 'qzx56', '全之鑫物流', 1, 1),
(92, 'qskdyxgs', '千顺快递', 1, 1),
(93, 'runhengfeng', '全时速运', 1, 1),
(94, 'rytsd', '日益通速递', 1, 1),
(95, 'ruidaex', '瑞达国际速递', 1, 1),
(96, 'shiyun', '世运快递', 1, 1),
(97, 'sfift', '十方通物流', 1, 1),
(98, 'stkd', '顺通快递', 1, 1),
(99, 'bgn', '布谷鸟快递', 1, 1),
(100, 'jiahuier', '佳惠尔快递', 1, 1),
(101, 'pingyou', '小包', 1, 1),
(102, 'yumeijie', '誉美捷快递', 1, 1),
(103, 'meilong', '美龙快递', 1, 1),
(104, 'guangtong', '广通速递', 1, 1),
(105, 'STARS', '星晨急便', 1, 1),
(106, 'NANHANG', '中国南方航空股份有限公司', 1, 1),
(107, 'lanbiao', '蓝镖快递', 1, 1),
(109, 'baotongda', '宝通达物流', 1, 1),
(110, 'dashun', '大顺物流', 1, 1),
(111, 'dada', '大达物流', 1, 1),
(112, 'fangfangda', '方方达物流', 1, 1),
(113, 'hebeijianhua', '河北建华物流', 1, 1),
(114, 'haolaiyun', '好来运快递', 1, 1),
(115, 'jinyue', '晋越快递', 1, 1),
(116, 'kuaitao', '快淘快递', 1, 1),
(117, 'peixing', '陪行物流', 1, 1),
(118, 'hkpost', '香港邮政', 1, 1),
(119, 'ytfh', '一统飞鸿快递', 1, 1),
(120, 'zhongxinda', '中信达快递', 1, 1),
(121, 'zhongtian', '中天快运', 1, 1),
(122, 'zuochuan', '佐川急便', 1, 1),
(123, 'chengguang', '程光快递', 1, 1),
(124, 'cszx', '城市之星', 1, 1),
(125, 'chuanzhi', '传志快递', 1, 1),
(126, 'feibao', '飞豹快递', 1, 1),
(127, 'huiqiang', '汇强快递', 1, 1),
(128, 'lejiedi', '乐捷递', 1, 1),
(129, 'lijisong', '成都立即送快递', 1, 1),
(130, 'minbang', '民邦速递', 1, 1),
(131, 'ocs', 'OCS国际快递', 1, 1),
(132, 'santai', '三态速递', 1, 1),
(133, 'saiaodi', '赛澳递', 1, 1),
(134, 'jingdong', '京东快递', 1, 1),
(135, 'zengyi', '增益快递', 1, 1),
(136, 'fanyu', '凡宇速递', 1, 1),
(137, 'fengda', '丰达快递', 1, 1),
(138, 'coe', '东方快递', 1, 1),
(139, 'ees', '百福东方快递', 1, 1),
(140, 'disifang', '递四方速递', 1, 1),
(141, 'rufeng', '如风达快递', 1, 1),
(142, 'changtong', '长通物流', 1, 1),
(143, 'chengshi100', '城市100快递', 1, 1),
(144, 'feibang', '飞邦物流', 1, 1),
(145, 'haosheng', '昊盛物流', 1, 1),
(146, 'yinsu', '音速速运', 1, 1),
(147, 'kuanrong', '宽容物流', 1, 1),
(148, 'tongcheng', '通成物流', 1, 1),
(149, 'tonghe', '通和天下物流', 1, 1),
(150, 'zhima', '芝麻开门', 1, 1),
(151, 'ririshun', '日日顺物流', 1, 1),
(152, 'anxun', '安迅物流', 1, 1),
(153, 'baiqian', '百千诚国际物流', 1, 1),
(154, 'chukouyi', '出口易', 1, 1),
(155, 'diantong', '店通快递', 1, 1),
(156, 'dajin', '大金物流', 1, 1),
(157, 'feite', '飞特物流', 1, 1),
(159, 'gnxb', '国内小包', 1, 1),
(160, 'huacheng', '华诚物流', 1, 1),
(161, 'huahan', '华翰物流', 1, 1),
(162, 'hengyu', '恒宇运通', 1, 1),
(163, 'huahang', '华航快递', 1, 1),
(164, 'jiuyi', '久易快递', 1, 1),
(165, 'jiete', '捷特快递', 1, 1),
(166, 'jingshi', '京世物流', 1, 1),
(167, 'kuayue', '跨越快递', 1, 1),
(168, 'mengsu', '蒙速快递', 1, 1),
(169, 'nanbei', '南北快递', 1, 1),
(171, 'pinganda', '平安达快递', 1, 1),
(172, 'ruifeng', '瑞丰速递', 1, 1),
(173, 'rongqing', '荣庆物流', 1, 1),
(174, 'suijia', '穗佳物流', 1, 1),
(175, 'simai', '思迈快递', 1, 1),
(176, 'suteng', '速腾快递', 1, 1),
(177, 'shengbang', '晟邦物流', 1, 1),
(178, 'suchengzhaipei', '速呈宅配', 1, 1),
(179, 'wuhuan', '五环速递', 1, 1),
(180, 'xingchengzhaipei', '星程宅配', 1, 1),
(181, 'yinjie', '顺捷丰达', 1, 1),
(183, 'yanwen', '燕文物流', 1, 1),
(184, 'zongxing', '纵行物流', 1, 1),
(185, 'aae', 'AAE快递', 1, 1),
(186, 'dhl', 'DHL快递', 1, 1),
(187, 'feihu', '飞狐快递', 1, 1),
(188, 'shunfeng', '顺丰速运', 92, 1),
(189, 'spring', '春风物流', 1, 1),
(190, 'yidatong', '易达通快递', 1, 1),
(191, 'PEWKEE', '彪记快递', 1, 1),
(192, 'PHOENIXEXP', '凤凰快递', 1, 1),
(193, 'CNGLS', 'GLS快递', 1, 1),
(194, 'BHTEXP', '华慧快递', 1, 1),
(195, 'B2B', '卡行天下', 1, 1),
(196, 'PEISI', '配思货运', 1, 1),
(197, 'SUNDAPOST', '上大物流', 1, 1),
(198, 'SUYUE', '苏粤货运', 1, 1),
(199, 'F5XM', '伍圆速递', 1, 1),
(200, 'GZWENJIE', '文捷航空速递', 1, 1),
(201, 'yuancheng', '远成物流', 1, 1),
(202, 'dpex', 'DPEX快递', 1, 1),
(203, 'anjie', '安捷快递', 1, 1),
(204, 'jldt', '嘉里大通', 1, 1),
(205, 'yousu', '优速快递', 1, 1),
(206, 'wanbo', '万博快递', 1, 1),
(207, 'sure', '速尔物流', 1, 1),
(208, 'sutong', '速通物流', 1, 1),
(209, 'JUNCHUANWL', '骏川物流', 1, 1),
(210, 'guada', '冠达快递', 1, 1),
(211, 'dsu', 'D速快递', 1, 1),
(212, 'LONGSHENWL', '龙胜物流', 1, 1),
(213, 'abc', '爱彼西快递', 1, 1),
(214, 'eyoubao', 'E邮宝', 1, 1),
(215, 'aol', 'AOL快递', 1, 1),
(216, 'jixianda', '急先达物流', 1, 1),
(217, 'haihong', '山东海红快递', 1, 1),
(218, 'feiyang', '飞洋快递', 1, 1),
(219, 'rpx', 'RPX保时达', 1, 1),
(220, 'zhaijisong', '宅急送', 1, 1),
(221, 'tiantian', '天天快递', 99, 1),
(222, 'yunwuliu', '云物流', 1, 1),
(223, 'jiuye', '九曳供应链', 1, 1),
(224, 'bsky', '百世快运', 1, 1),
(225, 'higo', '黑狗物流', 1, 1),
(226, 'arke', '方舟速递', 1, 1),
(227, 'zwsy', '中外速运', 1, 1),
(228, 'jxy', '吉祥邮', 1, 1),
(229, 'aramex', 'Aramex', 1, 1),
(230, 'guotong', '国通快递', 1, 1),
(231, 'jiayi', '佳怡物流', 1, 1),
(232, 'longbang', '龙邦快运', 1, 1),
(233, 'minhang', '民航快递', 1, 1),
(234, 'quanyi', '全一快递', 1, 1),
(235, 'quanchen', '全晨快递', 1, 1),
(236, 'usps', 'USPS快递', 1, 1),
(237, 'xinbang', '新邦物流', 1, 1),
(238, 'yuanzhi', '元智捷诚快递', 1, 1),
(239, 'zhongyou', '中邮物流', 1, 1),
(240, 'yuxin', '宇鑫物流', 1, 1),
(241, 'cnpex', '中环快递', 1, 1),
(242, 'shengfeng', '盛丰物流', 1, 1),
(243, 'yuantong', '圆通速递', 97, 1),
(244, 'jiayunmei', '加运美物流', 1, 1),
(245, 'ywfex', '源伟丰快递', 1, 1),
(246, 'xinfeng', '信丰物流', 1, 1),
(247, 'wanxiang', '万象物流', 1, 1),
(248, 'menduimen', '门对门', 1, 1),
(249, 'mingliang', '明亮物流', 1, 1),
(250, 'fengxingtianxia', '风行天下', 1, 1),
(251, 'gongsuda', '共速达物流', 1, 1),
(252, 'zhongtong', '中通快递', 100, 1),
(253, 'quanritong', '全日通快递', 1, 1),
(254, 'ems', 'EMS', 1, 1),
(255, 'wanjia', '万家物流', 1, 1),
(256, 'yuntong', '运通快递', 1, 1),
(257, 'feikuaida', '飞快达物流', 1, 1),
(258, 'haimeng', '海盟速递', 1, 1),
(259, 'zhongsukuaidi', '中速快件', 1, 1),
(260, 'yuefeng', '越丰快递', 1, 1),
(261, 'shenghui', '盛辉物流', 1, 1),
(262, 'datian', '大田物流', 1, 1),
(263, 'quanjitong', '全际通快递', 1, 1),
(264, 'longlangkuaidi', '隆浪快递', 1, 1),
(265, 'neweggozzo', '新蛋奥硕物流', 1, 1),
(266, 'shentong', '申通快递', 95, 1),
(267, 'haiwaihuanqiu', '海外环球', 1, 1),
(268, 'yad', '源安达快递', 1, 1),
(269, 'jindawuliu', '金大物流', 1, 1),
(270, 'sevendays', '七天连锁', 1, 1),
(271, 'tnt', 'TNT快递', 1, 1),
(272, 'huayu', '天地华宇物流', 1, 1),
(273, 'lianhaotong', '联昊通快递', 1, 1),
(274, 'nengda', '港中能达快递', 1, 1),
(275, 'LBWL', '联邦物流', 1, 1),
(276, 'ontrac', 'onTrac', 1, 1),
(277, 'feihang', '原飞航快递', 1, 1),
(278, 'bangsongwuliu', '邦送物流', 1, 1),
(279, 'huaxialong', '华夏龙物流', 1, 1),
(280, 'ztwy', '中天万运快递', 1, 1),
(281, 'fkd', '飞康达物流', 1, 1),
(282, 'anxinda', '安信达快递', 1, 1),
(283, 'quanfeng', '全峰快递', 1, 1),
(284, 'shengan', '圣安物流', 1, 1),
(285, 'jiaji', '佳吉物流', 1, 1),
(286, 'yunda', '韵达快运', 94, 1),
(287, 'ups', 'UPS快递', 1, 1),
(288, 'debang', '德邦物流', 1, 1),
(289, 'yafeng', '亚风速递', 1, 1),
(290, 'kuaijie', '快捷速递', 98, 1),
(291, 'huitong', '百世快递', 93, 1),
(293, 'aolau', 'AOL澳通速递', 1, 1),
(294, 'anneng', '安能物流', 1, 1),
(295, 'auexpress', '澳邮中国快运', 1, 1),
(296, 'exfresh', '安鲜达', 1, 1),
(297, 'bcwelt', 'BCWELT', 1, 1),
(298, 'youzhengguonei', '挂号信', 1, 1),
(299, 'xiaohongmao', '北青小红帽', 1, 1),
(300, 'lbbk', '宝凯物流', 1, 1),
(301, 'byht', '博源恒通', 1, 1),
(302, 'idada', '百成大达物流', 1, 1),
(303, 'baitengwuliu', '百腾物流', 1, 1),
(304, 'birdex', '笨鸟海淘', 1, 1),
(305, 'bsht', '百事亨通', 1, 1),
(306, 'dayang', '大洋物流快递', 1, 1),
(307, 'dechuangwuliu', '德创物流', 1, 1),
(308, 'donghanwl', '东瀚物流', 1, 1),
(309, 'dfpost', '达方物流', 1, 1),
(310, 'dongjun', '东骏快捷物流', 1, 1),
(311, 'dindon', '叮咚澳洲转运', 1, 1),
(312, 'dazhong', '大众佐川急便', 1, 1),
(313, 'decnlh', '德中快递', 1, 1),
(314, 'dekuncn', '德坤供应链', 1, 1),
(315, 'eshunda', '俄顺达', 1, 1),
(316, 'ewe', 'EWE全球快递', 1, 1),
(317, 'fedexuk', 'FedEx英国', 1, 1),
(318, 'fox', 'FOX国际速递', 1, 1),
(319, 'rufengda', '凡客如风达', 1, 1),
(320, 'fandaguoji', '颿达国际快递', 1, 1),
(321, 'hnfy', '飞鹰物流', 1, 1),
(322, 'flysman', '飞力士物流', 1, 1),
(323, 'sccod', '丰程物流', 1, 1),
(324, 'farlogistis', '泛远国际物流', 1, 1),
(325, 'gsm', 'GSM', 1, 1),
(326, 'gaticn', 'GATI快递', 1, 1),
(327, 'gts', 'GTS快递', 1, 1),
(328, 'gangkuai', '港快速递', 1, 1),
(329, 'gtsd', '高铁速递', 1, 1),
(330, 'tiandihuayu', '华宇物流', 1, 1),
(331, 'huangmajia', '黄马甲快递', 1, 1),
(332, 'ucs', '合众速递', 1, 1),
(333, 'huoban', '伙伴物流', 1, 1),
(334, 'nedahm', '红马速递', 1, 1),
(335, 'huiwen', '汇文配送', 1, 1),
(336, 'nmhuahe', '华赫物流', 1, 1),
(337, 'hangyu', '航宇快递', 1, 1),
(338, 'minsheng', '闽盛物流', 1, 1),
(339, 'riyu', '日昱物流', 1, 1),
(340, 'sxhongmajia', '山西红马甲', 1, 1),
(341, 'syjiahuier', '沈阳佳惠尔', 1, 1),
(342, 'shlindao', '上海林道货运', 1, 1),
(343, 'shunjiefengda', '顺捷丰达', 1, 1),
(344, 'subida', '速必达物流', 1, 1),
(345, 'bphchina', '速方国际物流', 1, 1),
(346, 'sendtochina', '速递中国', 1, 1),
(347, 'suning', '苏宁快递', 1, 1),
(348, 'sihaiet', '四海快递', 1, 1),
(349, 'tianzong', '天纵物流', 1, 1),
(350, 'chinatzx', '同舟行物流', 1, 1),
(351, 'nntengda', '腾达速递', 1, 1),
(352, 'sd138', '泰国138', 1, 1),
(353, 'tongdaxing', '通达兴物流', 1, 1),
(354, 'tlky', '天联快运', 1, 1),
(355, 'youshuwuliu', 'UC优速快递', 1, 1),
(356, 'ueq', 'UEQ快递', 1, 1),
(357, 'weitepai', '微特派快递', 1, 1),
(358, 'wtdchina', '威时沛运', 1, 1),
(359, 'wzhaunyun', '微转运', 1, 1),
(360, 'gswtkd', '万通快递', 1, 1),
(361, 'wotu', '渥途国际速运', 1, 1),
(362, 'xiyoute', '希优特快递', 1, 1),
(363, 'xilaikd', '喜来快递', 1, 1),
(364, 'xsrd', '鑫世锐达', 1, 1),
(365, 'xtb', '鑫通宝物流', 1, 1),
(366, 'xintianjie', '信天捷快递', 1, 1),
(367, 'xaetc', '西安胜峰', 1, 1),
(368, 'xianfeng', '先锋快递', 1, 1),
(369, 'sunspeedy', '新速航', 1, 1),
(370, 'xipost', '西邮寄', 1, 1),
(371, 'sinatone', '信联通', 1, 1),
(372, 'sunjex', '新杰物流', 1, 1),
(373, 'yundaexus', '韵达美国件', 1, 1),
(374, 'yxwl', '宇鑫物流', 1, 1),
(375, 'yitongda', '易通达', 1, 1),
(376, 'yiqiguojiwuliu', '一柒物流', 1, 1),
(377, 'yilingsuyun', '亿领速运', 1, 1),
(378, 'yujiawuliu', '煜嘉物流', 1, 1),
(379, 'gml', '英脉物流', 1, 1),
(380, 'leopard', '云豹国际货运', 1, 1),
(381, 'czwlyn', '云南中诚', 1, 1),
(382, 'sdyoupei', '优配速运', 1, 1),
(383, 'yongchang', '永昌物流', 1, 1),
(384, 'yufeng', '御风速运', 1, 1),
(385, 'yamaxunwuliu', '亚马逊物流', 1, 1),
(386, 'yousutongda', '优速通达', 1, 1),
(387, 'yishunhang', '亿顺航', 1, 1),
(388, 'yongwangda', '永旺达快递', 1, 1),
(389, 'ecmscn', '易满客', 1, 1),
(390, 'yingchao', '英超物流', 1, 1),
(391, 'edlogistics', '益递物流', 1, 1),
(392, 'yyexpress', '远洋国际', 1, 1),
(393, 'onehcang', '一号仓', 1, 1),
(394, 'ycgky', '远成快运', 1, 1),
(395, 'lineone', '一号线', 1, 1),
(396, 'ypsd', '壹品速递', 1, 1),
(397, 'vipexpress', '鹰运国际速递', 1, 1),
(398, 'el56', '易联通达物流', 1, 1),
(399, 'yyqc56', '一运全成物流', 1, 1),
(400, 'zhongtie', '中铁快运', 1, 1),
(401, 'ZTKY', '中铁物流', 1, 1),
(402, 'zzjh', '郑州建华快递', 1, 1),
(403, 'zhongruisudi', '中睿速递', 1, 1),
(404, 'zhongwaiyun', '中外运速递', 1, 1),
(405, 'zengyisudi', '增益速递', 1, 1),
(406, 'sujievip', '郑州速捷', 1, 1),
(407, 'zhichengtongda', '至诚通达快递', 1, 1),
(408, 'zhdwl', '众辉达物流', 1, 1),
(409, 'kuachangwuliu', '直邮易', 1, 1),
(410, 'topspeedex', '中运全速', 1, 1),
(411, 'otobv', '中欧快运', 1, 1),
(412, 'zsky123', '准实快运', 1, 1),
(413, 'donghong', '东红物流', 1, 1),
(414, 'kuaiyouda', '快优达速递', 1, 1),
(415, 'balunzhi', '巴伦支快递', 1, 1),
(416, 'hutongwuliu', '户通物流', 1, 1),
(417, 'xianchenglian', '西安城联速递', 1, 1),
(418, 'youbijia', '邮必佳', 1, 1),
(419, 'feiyuan', '飞远物流', 1, 1),
(420, 'chengji', '城际速递', 1, 1),
(421, 'huaqi', '华企快运', 1, 1),
(422, 'yibang', '一邦快递', 1, 1),
(423, 'citylink', 'CityLink快递', 1, 1),
(424, 'meixi', '美西快递', 1, 1),
(425, 'acs', 'ACS', 1, 1);

-- --------------------------------------------------------

--
-- 表的结构 `eb_grade`
--

CREATE TABLE `eb_grade` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL COMMENT '年级名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='年级列表';

--
-- 转存表中的数据 `eb_grade`
--

INSERT INTO `eb_grade` (`id`, `name`, `sort`, `add_time`) VALUES
(1, '少儿编程', 5, 1547625712),
(2, '高中', 6, 1547625985),
(3, '初中', 7, 1547625992),
(4, '小学', 8, 1547626003),
(5, '绘画', 4, 1581414927),
(6, '公考', 3, 1581414950),
(7, '小语种', 2, 1581414960),
(8, '考研', 1, 1581414969);

-- --------------------------------------------------------

--
-- 表的结构 `eb_live_barrage`
--

CREATE TABLE `eb_live_barrage` (
  `id` int(11) NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `to_uid` int(11) NOT NULL COMMENT '给谁发送',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '消息类型，1=文本，2=图片，3=语音',
  `barrage` varchar(3000) NOT NULL DEFAULT '' COMMENT '评论内容',
  `live_id` int(11) NOT NULL DEFAULT '0' COMMENT '直播间id',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '发送评论时间',
  `is_show` int(11) NOT NULL DEFAULT '1' COMMENT '是否显示 1= 显示，0=隐藏'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='直播间弹幕';

--
-- 转存表中的数据 `eb_live_barrage`
--

INSERT INTO `eb_live_barrage` (`id`, `uid`, `to_uid`, `type`, `barrage`, `live_id`, `add_time`, `is_show`) VALUES
(1, 209, 0, 1, '你好', 10, 1582029381, 1),
(2, 198, 0, 1, '[qq_12][qq_12][qq_12][qq_12][qq_12]', 10, 1582073756, 1),
(3, 164, 0, 1, '嘿嘿', 10, 1582077353, 1),
(4, 164, 0, 1, '[qq_13]', 10, 1582077358, 1),
(5, 164, 0, 1, '[qq_12][qq_12]', 10, 1582077363, 1),
(6, 276, 0, 1, '[qq_11][qq_12][qq_12][qq_6][qq_6]', 10, 1582093402, 1),
(7, 276, 0, 1, '[qq_2][qq_3][qq_4][qq_4][qq_5]', 10, 1582093406, 1),
(8, 65, 0, 2, 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/95d75202002191944598419.png', 10, 1582112699, 1),
(9, 319, 0, 1, '[em_37]', 10, 1582127815, 1),
(10, 65, 0, 1, 'd', 11, 1582166793, 1),
(11, 65, 0, 1, 'asd', 11, 1582166828, 1),
(12, 66, 0, 1, '你是', 11, 1582166839, 1),
(13, 66, 0, 1, '你是', 11, 1582166854, 1),
(14, 65, 0, 1, 'asd', 11, 1582166858, 1),
(15, 65, 0, 1, '咱是', 11, 1582166867, 1),
(16, 65, 0, 1, '实打实打算啊是大', 11, 1582166921, 1),
(17, 65, 0, 1, '打发士大夫二', 11, 1582166930, 1),
(18, 341, 0, 1, '323419323419', 10, 1582205387, 1),
(19, 326, 0, 1, '[em_25]', 10, 1582284966, 1),
(20, 503, 0, 1, '回放呢', 10, 1582285233, 1),
(21, 503, 0, 1, '123', 10, 1582285242, 1),
(22, 524, 0, 1, '？', 10, 1582285336, 1),
(23, 574, 0, 1, '[qq_1]', 10, 1582285636, 1),
(24, 592, 0, 1, '[qq_1]', 10, 1582285835, 1),
(25, 506, 0, 1, '看不到呀', 10, 1582285963, 1),
(26, 608, 0, 1, '好棒', 10, 1582286466, 1),
(27, 680, 0, 1, '直播', 10, 1582287711, 1),
(28, 680, 0, 1, '[qq_1]', 10, 1582287733, 1),
(29, 680, 0, 1, '[qq_2]', 10, 1582287742, 1),
(30, 715, 0, 1, '大家好', 10, 1582289243, 1),
(31, 759, 0, 1, '63+', 10, 1582290626, 1),
(32, 759, 0, 1, '错过就感觉到个低功耗', 10, 1582290630, 1),
(33, 776, 0, 1, '测试', 10, 1582291516, 1),
(34, 807, 0, 1, '[qq_13]', 10, 1582293831, 1),
(35, 832, 0, 1, '那么状况', 10, 1582296232, 1),
(36, 832, 0, 2, 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/3efd39040238907d69ae.jpg', 10, 1582296253, 1),
(37, 842, 0, 1, '123', 10, 1582297198, 1),
(38, 842, 0, 1, '好', 10, 1582297226, 1),
(39, 842, 0, 2, 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/417be91ff00706d68f62.jpg', 10, 1582297288, 1),
(40, 864, 0, 1, '[qq_12]', 10, 1582299228, 1),
(41, 864, 0, 1, '[qq_5]', 10, 1582299232, 1),
(42, 864, 0, 1, '[em_3][em_3]', 10, 1582299237, 1),
(43, 620, 0, 1, '人生的奔跑，不在于瞬间的爆发，而取决于途中的坚持。', 10, 1582306748, 1),
(44, 918, 0, 1, '测试', 10, 1582329784, 1),
(45, 182, 0, 1, '测试', 10, 1582330164, 1),
(46, 835, 0, 1, '？？？？', 10, 1582337896, 1),
(47, 262, 0, 1, '哈哈', 10, 1582344568, 1),
(48, 969, 0, 1, '?', 10, 1582349253, 1),
(49, 969, 0, 2, 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/edf24f679abab08d7ee1.jpg', 10, 1582349281, 1),
(50, 972, 0, 1, '[qq_1]', 10, 1582350217, 1),
(51, 972, 0, 1, '111', 10, 1582350254, 1),
(52, 848, 0, 1, '开下', 13, 1582350596, 1),
(53, 952, 0, 1, '[qq_6]', 10, 1582360627, 1),
(54, 1060, 0, 1, '111', 12, 1582389437, 1),
(55, 1060, 0, 1, '2222', 12, 1582389439, 1),
(56, 1060, 0, 1, '3333', 12, 1582389441, 1),
(57, 1060, 0, 1, '5555555', 12, 1582389443, 1),
(58, 1060, 0, 1, '11111111111', 12, 1582389448, 1),
(59, 1060, 0, 1, '[qq_11]', 12, 1582389476, 1),
(60, 1060, 0, 1, '[qq_12][qq_12][qq_12][qq_12][qq_12]', 12, 1582389479, 1),
(61, 1060, 0, 1, '[qq_20][qq_20]', 12, 1582389496, 1),
(62, 1060, 0, 1, '111', 12, 1582389514, 1),
(63, 1060, 0, 1, '33333333333', 12, 1582389524, 1),
(64, 1060, 0, 1, '11111111', 12, 1582389575, 1),
(65, 65, 0, 1, 'wer', 10, 1582433799, 1),
(66, 65, 0, 1, '1', 10, 1582434761, 1);

-- --------------------------------------------------------

--
-- 表的结构 `eb_live_honoured_guest`
--

CREATE TABLE `eb_live_honoured_guest` (
  `id` int(11) NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '嘉宾用户id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '嘉宾类型 0=助教，1=讲师',
  `wechat_name` varchar(64) DEFAULT NULL COMMENT '微信昵称',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT '嘉宾别昵称',
  `live_id` int(11) NOT NULL DEFAULT '0' COMMENT '直播间id',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加事件'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='直播间嘉宾';

-- --------------------------------------------------------

--
-- 表的结构 `eb_live_studio`
--

CREATE TABLE `eb_live_studio` (
  `id` int(11) NOT NULL,
  `stream_name` varchar(32) NOT NULL DEFAULT '' COMMENT '直播间号',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `live_title` varchar(255) NOT NULL DEFAULT '' COMMENT '直播间标题',
  `live_image` varchar(255) NOT NULL DEFAULT '' COMMENT '直播间封面',
  `start_play_time` varchar(30) NOT NULL DEFAULT '0' COMMENT '每日开播时间',
  `stop_play_time` varchar(30) NOT NULL DEFAULT '0' COMMENT '每日停播时间',
  `live_introduction` varchar(3000) NOT NULL DEFAULT '' COMMENT '直播间简介',
  `special_id` int(11) NOT NULL DEFAULT '0' COMMENT '关联专题id',
  `online_user_num` int(11) NOT NULL DEFAULT '0' COMMENT '在线人数',
  `online_num` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟在线人数',
  `studio_pwd` varchar(32) NOT NULL DEFAULT '' COMMENT '直播间密码',
  `is_remind` tinyint(1) NOT NULL DEFAULT '0' COMMENT '开播提醒',
  `remind_time` int(5) UNSIGNED NOT NULL DEFAULT '0' COMMENT '开播前提醒时间（分钟）',
  `auto_phrase` varchar(255) NOT NULL DEFAULT '' COMMENT '进入直播间自动回复',
  `add_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '添加时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_recording` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否录制直播间',
  `is_play` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否正在开播',
  `recording` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否录制进行中',
  `record_time` int(11) NOT NULL DEFAULT '0' COMMENT '录制开始时间',
  `is_playback` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否回放',
  `playback_record_id` varchar(1000) NOT NULL DEFAULT '' COMMENT '回放RecordId',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='直播间';

--
-- 转存表中的数据 `eb_live_studio`
--

INSERT INTO `eb_live_studio`(`id`, `stream_name`, `uid`, `live_title`, `live_image`, `start_play_time`, `stop_play_time`, `live_introduction`, `special_id`, `online_user_num`, `online_num`, `studio_pwd`, `is_remind`, `remind_time`, `auto_phrase`, `add_time`, `is_del`, `is_recording`, `is_play`, `recording`, `record_time`, `is_playback`, `playback_record_id`, `sort`) VALUES
(14, '66396889', 0, '直播国学大讲堂', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/ce99d202002201232432554.jpg', '2020-04-28 11:22:57', '2020-04-28 12:22:57', '直播国学大讲堂', 1, 0, 0, '', 0, 0, '国学大讲堂', 1588044359, 0, 0, 0, 0, 0, 0, '', 0);


-- --------------------------------------------------------

--
-- 表的结构 `eb_live_user`
--

CREATE TABLE `eb_live_user` (
  `id` int(11) NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `live_id` int(11) NOT NULL DEFAULT '0' COMMENT '直播间id',
  `add_ip` varchar(16) NOT NULL DEFAULT '' COMMENT '首次浏览ip',
  `last_ip` varchar(16) NOT NULL DEFAULT '' COMMENT '历史访问id',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '首次访问时间',
  `last_time` int(11) NOT NULL DEFAULT '0' COMMENT '历史访问时间',
  `visit_num` int(11) NOT NULL DEFAULT '0' COMMENT '访问次数',
  `is_online` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否在线 1=在线，0=下线',
  `is_ban` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否禁言，1=禁言，0=自由',
  `is_open_ben` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否禁止进入直播间 1=禁止，0=自由',
  `ban_time` int(11) NOT NULL DEFAULT '0' COMMENT '禁言时间',
  `open_ben_time` int(11) NOT NULL DEFAULT '0' COMMENT '禁止进入直播间时间',
  `is_follow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否关注'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='直播间用户管理';

--
-- 转存表中的数据 `eb_live_user`
--

INSERT INTO `eb_live_user` (`id`, `uid`, `live_id`, `add_ip`, `last_ip`, `add_time`, `last_time`, `visit_num`, `is_online`, `is_ban`, `is_open_ben`, `ban_time`, `open_ben_time`, `is_follow`) VALUES
(40, 65, 10, '111.19.87.149', '111.18.84.139', 1582023837, 1582433791, 1, 1, 0, 0, 0, 0, 0),
(41, 201, 10, '223.104.45.108', '223.104.45.108', 1582025661, 1582025661, 1, 0, 0, 0, 0, 0, 0),
(42, 209, 10, '113.123.202.152', '113.123.202.152', 1582029362, 1582029723, 1, 0, 0, 0, 0, 0, 0),
(43, 213, 10, '117.136.86.224', '117.136.86.224', 1582030057, 1582030241, 1, 0, 0, 0, 0, 0, 0),
(44, 198, 10, '59.57.130.234', '59.57.130.234', 1582073737, 1582073737, 1, 0, 0, 0, 0, 0, 0),
(45, 164, 10, '36.157.214.78', '36.157.214.78', 1582077335, 1582077335, 1, 0, 0, 0, 0, 0, 0),
(46, 228, 10, '140.243.38.122', '140.243.38.122', 1582081735, 1582105964, 1, 0, 0, 0, 0, 0, 0),
(47, 262, 10, '117.153.27.81', '117.153.27.171', 1582087551, 1582344552, 1, 0, 0, 0, 0, 0, 0),
(48, 276, 10, '36.157.92.59', '36.157.92.59', 1582093369, 1582093397, 1, 0, 0, 0, 0, 0, 0),
(49, 283, 10, '113.127.66.233', '113.127.66.233', 1582098323, 1582098373, 1, 0, 0, 0, 0, 0, 0),
(50, 284, 10, '119.126.105.212', '119.126.105.212', 1582099793, 1582099793, 1, 0, 0, 0, 0, 0, 0),
(51, 319, 10, '117.136.69.236', '117.136.69.236', 1582127786, 1582128728, 1, 0, 0, 0, 0, 0, 0),
(52, 321, 10, '117.136.69.236', '117.136.69.236', 1582128773, 1582128773, 1, 0, 0, 0, 0, 0, 0),
(53, 323, 10, '106.40.160.204', '106.40.160.204', 1582129542, 1582129874, 1, 0, 0, 0, 0, 0, 0),
(54, 65, 11, '111.19.87.163', '111.19.87.163', 1582165755, 1582166780, 1, 1, 0, 0, 0, 0, 0),
(55, 66, 11, '123.139.135.202', '123.139.135.202', 1582166404, 1582180825, 1, 0, 0, 0, 0, 0, 0),
(56, 346, 10, '113.77.146.236', '113.77.146.236', 1582168226, 1582168226, 1, 0, 0, 0, 0, 0, 0),
(57, 369, 10, '49.78.177.5', '49.78.177.5', 1582179768, 1582179768, 1, 0, 0, 0, 0, 0, 0),
(58, 66, 10, '123.139.135.202', '123.139.135.202', 1582180513, 1582180814, 1, 0, 0, 0, 0, 0, 0),
(59, 67, 10, '124.23.134.216', '124.23.134.216', 1582180593, 1582180675, 1, 0, 0, 0, 0, 0, 0),
(60, 66, 12, '123.139.135.202', '123.139.135.202', 1582180969, 1582181163, 1, 0, 0, 0, 0, 0, 0),
(61, 67, 12, '124.23.133.90', '124.23.133.90', 1582181263, 1582181263, 1, 0, 0, 0, 0, 0, 0),
(62, 341, 10, '115.171.20.34', '115.171.20.34', 1582205360, 1582273504, 1, 0, 0, 0, 0, 0, 0),
(63, 401, 10, '111.197.247.122', '111.197.247.122', 1582205396, 1582205396, 1, 0, 0, 0, 0, 0, 0),
(64, 400, 10, '106.114.94.72', '106.114.94.72', 1582250005, 1582250005, 1, 0, 0, 0, 0, 0, 0),
(65, 425, 10, '112.36.197.185', '112.36.197.185', 1582251387, 1582251387, 1, 0, 0, 0, 0, 0, 0),
(66, 77, 10, '36.44.174.116', '36.44.174.116', 1582280392, 1582280392, 1, 0, 0, 0, 0, 0, 0),
(67, 456, 10, '120.36.253.190', '120.36.253.190', 1582283169, 1582283169, 1, 0, 0, 0, 0, 0, 0),
(68, 457, 10, '183.253.144.99', '183.253.144.99', 1582284485, 1582284485, 1, 0, 0, 0, 0, 0, 0),
(69, 462, 10, '222.214.83.185', '222.214.83.185', 1582284953, 1582284975, 1, 0, 0, 0, 0, 0, 0),
(70, 326, 10, '121.207.41.182', '121.207.41.182', 1582284954, 1582284969, 1, 0, 0, 0, 0, 0, 0),
(71, 199, 10, '60.181.138.90', '60.181.138.90', 1582285088, 1582285088, 1, 0, 0, 0, 0, 0, 0),
(72, 503, 10, '112.224.5.113', '112.224.5.113', 1582285219, 1582285269, 1, 0, 0, 0, 0, 0, 0),
(73, 520, 10, '222.134.85.122', '222.134.85.122', 1582285287, 1582285287, 1, 0, 0, 0, 0, 0, 0),
(74, 524, 10, '112.3.107.163', '112.3.107.163', 1582285330, 1582288107, 1, 0, 0, 0, 0, 0, 0),
(75, 528, 10, '1.193.82.7', '1.193.82.7', 1582285345, 1582285345, 1, 0, 0, 0, 0, 0, 0),
(76, 543, 10, '60.9.190.56', '60.9.190.56', 1582285453, 1582285453, 1, 0, 0, 0, 0, 0, 0),
(77, 549, 10, '112.96.163.2', '112.96.163.2', 1582285461, 1582285461, 1, 0, 0, 0, 0, 0, 0),
(78, 567, 10, '103.63.154.252', '103.63.154.252', 1582285523, 1582285523, 1, 0, 0, 0, 0, 0, 0),
(79, 558, 10, '42.90.26.191', '42.90.26.191', 1582285552, 1582287103, 1, 0, 0, 0, 0, 0, 0),
(80, 574, 10, '122.96.46.147', '122.96.46.147', 1582285622, 1582285669, 1, 0, 0, 0, 0, 0, 0),
(81, 560, 10, '112.226.135.133', '112.226.135.133', 1582285720, 1582286768, 1, 0, 0, 0, 0, 0, 0),
(82, 542, 10, '1.80.58.108', '1.80.58.108', 1582285801, 1582285832, 1, 0, 0, 0, 0, 0, 0),
(83, 592, 10, '59.57.229.210', '59.57.229.210', 1582285821, 1582285821, 1, 0, 0, 0, 0, 0, 0),
(84, 506, 10, '218.18.144.107', '218.18.144.107', 1582285936, 1582286040, 1, 0, 0, 0, 0, 0, 0),
(85, 606, 10, '183.35.218.121', '183.35.218.121', 1582285941, 1582285941, 1, 0, 0, 0, 0, 0, 0),
(86, 587, 10, '183.253.34.52', '183.253.34.52', 1582286028, 1582286105, 1, 0, 0, 0, 0, 0, 0),
(87, 622, 10, '171.114.112.175', '171.114.112.175', 1582286287, 1582286287, 1, 0, 0, 0, 0, 0, 0),
(88, 608, 10, '113.117.175.92', '113.117.175.92', 1582286431, 1582288442, 1, 0, 0, 0, 0, 0, 0),
(89, 624, 10, '140.243.180.31', '140.243.180.31', 1582286441, 1582286518, 1, 0, 0, 0, 0, 0, 0),
(90, 633, 10, '183.39.180.81', '61.141.73.68', 1582286463, 1582303207, 1, 0, 0, 0, 0, 0, 0),
(91, 625, 10, '220.202.152.75', '220.202.152.75', 1582286513, 1582286539, 1, 0, 0, 0, 0, 0, 0),
(92, 680, 10, '39.144.23.63', '39.144.23.63', 1582287687, 1582287687, 1, 0, 0, 0, 0, 0, 0),
(93, 695, 10, '106.7.164.22', '106.7.164.22', 1582287984, 1582287984, 1, 0, 0, 0, 0, 0, 0),
(94, 706, 10, '183.167.26.13', '183.167.26.13', 1582288237, 1582288237, 1, 0, 0, 0, 0, 0, 0),
(95, 717, 10, '183.199.164.181', '183.199.164.181', 1582288586, 1582288621, 1, 0, 0, 0, 0, 0, 0),
(96, 722, 10, '111.50.70.22', '111.50.70.22', 1582288770, 1582288770, 1, 0, 0, 0, 0, 0, 0),
(97, 725, 10, '116.162.2.191', '116.162.2.191', 1582288886, 1582288886, 1, 0, 0, 0, 0, 0, 0),
(98, 729, 10, '183.0.13.234', '183.0.13.234', 1582289044, 1582289044, 1, 0, 0, 0, 0, 0, 0),
(99, 525, 10, '182.240.79.8', '182.240.79.8', 1582289103, 1582304714, 1, 0, 0, 0, 0, 0, 0),
(100, 715, 10, '116.162.2.19', '116.162.2.19', 1582289229, 1582289229, 1, 0, 0, 0, 0, 0, 0),
(101, 116, 10, '27.151.93.8', '27.151.93.8', 1582289411, 1582289411, 1, 0, 0, 0, 0, 0, 0),
(102, 741, 10, '117.139.134.228', '117.139.134.228', 1582289659, 1582289659, 1, 0, 0, 0, 0, 0, 0),
(103, 739, 10, '36.148.106.0', '36.148.106.0', 1582289710, 1582289710, 1, 0, 0, 0, 0, 0, 0),
(104, 749, 10, '123.152.233.20', '123.152.233.20', 1582289939, 1582292115, 1, 0, 0, 0, 0, 0, 0),
(105, 751, 10, '125.105.43.253', '125.105.43.253', 1582290037, 1582290037, 1, 0, 0, 0, 0, 0, 0),
(106, 759, 10, '222.169.179.65', '222.169.179.65', 1582290613, 1582290613, 1, 0, 0, 0, 0, 0, 0),
(107, 569, 10, '112.0.8.190', '112.0.8.190', 1582290759, 1582290759, 1, 0, 0, 0, 0, 0, 0),
(108, 774, 10, '122.238.179.170', '122.238.179.170', 1582291401, 1582291401, 1, 0, 0, 0, 0, 0, 0),
(109, 776, 10, '120.231.105.182', '120.231.105.182', 1582291491, 1582291555, 1, 0, 0, 0, 0, 0, 0),
(110, 510, 10, '120.204.189.155', '120.204.189.155', 1582292852, 1582292852, 1, 0, 0, 0, 0, 0, 0),
(111, 791, 10, '106.87.137.234', '106.87.141.189', 1582292983, 1582322085, 1, 0, 0, 0, 0, 0, 0),
(112, 637, 10, '123.123.8.237', '123.123.8.237', 1582293209, 1582341005, 1, 0, 0, 0, 0, 0, 0),
(113, 803, 10, '162.208.214.66', '162.208.214.66', 1582293649, 1582293649, 1, 0, 0, 0, 0, 0, 0),
(114, 804, 10, '183.250.29.147', '183.250.29.147', 1582293751, 1582293819, 1, 0, 0, 0, 0, 0, 0),
(115, 807, 10, '117.183.117.205', '117.183.117.205', 1582293824, 1582293824, 1, 0, 0, 0, 0, 0, 0),
(116, 808, 10, '1.180.14.227', '111.127.128.58', 1582293883, 1582350592, 1, 0, 0, 0, 0, 0, 0),
(117, 343, 10, '112.11.74.28', '112.11.74.28', 1582294018, 1582294018, 1, 0, 0, 0, 0, 0, 0),
(118, 820, 10, '223.104.247.34', '223.104.247.34', 1582295133, 1582295133, 1, 0, 0, 0, 0, 0, 0),
(119, 821, 10, '101.83.32.112', '101.83.32.112', 1582295199, 1582343242, 1, 0, 0, 0, 0, 0, 0),
(120, 829, 10, '58.44.14.79', '58.44.14.79', 1582295896, 1582295896, 1, 0, 0, 0, 0, 0, 0),
(121, 832, 10, '118.80.40.227', '118.80.40.227', 1582296221, 1582297274, 1, 0, 0, 0, 0, 0, 0),
(122, 836, 10, '120.239.32.190', '120.239.32.190', 1582296829, 1582296829, 1, 0, 0, 0, 0, 0, 0),
(123, 842, 10, '223.72.36.181', '223.72.36.181', 1582297163, 1582297163, 1, 0, 0, 0, 0, 0, 0),
(124, 845, 10, '111.60.244.209', '111.60.244.209', 1582297598, 1582297598, 1, 0, 0, 0, 0, 0, 0),
(125, 853, 10, '223.104.23.192', '223.104.23.192', 1582298310, 1582298310, 1, 0, 0, 0, 0, 0, 0),
(126, 188, 10, '117.136.74.144', '117.136.74.144', 1582298739, 1582298739, 1, 0, 0, 0, 0, 0, 0),
(127, 864, 10, '123.174.81.102', '123.174.81.102', 1582299214, 1582299214, 1, 0, 0, 0, 0, 0, 0),
(128, 867, 10, '116.1.81.52', '116.1.81.52', 1582299614, 1582299614, 1, 0, 0, 0, 0, 0, 0),
(129, 869, 10, '59.57.192.52', '59.57.192.52', 1582300037, 1582300037, 1, 0, 0, 0, 0, 0, 0),
(130, 880, 10, '61.172.7.150', '61.172.7.150', 1582302085, 1582302185, 1, 0, 0, 0, 0, 0, 0),
(131, 892, 10, '175.8.178.111', '175.8.178.111', 1582306504, 1582306545, 1, 0, 0, 0, 0, 0, 0),
(132, 620, 10, '180.120.157.119', '180.120.157.119', 1582306716, 1582306716, 1, 0, 0, 0, 0, 0, 0),
(133, 893, 10, '111.33.237.152', '111.33.237.152', 1582307006, 1582307006, 1, 0, 0, 0, 0, 0, 0),
(134, 895, 10, '111.122.10.2', '111.122.10.2', 1582308391, 1582308391, 1, 0, 0, 0, 0, 0, 0),
(135, 899, 10, '183.29.49.243', '183.29.49.243', 1582309523, 1582309523, 1, 0, 0, 0, 0, 0, 0),
(136, 576, 10, '171.115.149.61', '171.115.149.61', 1582310843, 1582310879, 1, 0, 0, 0, 0, 0, 0),
(137, 88, 10, '223.104.177.91', '223.104.177.91', 1582314967, 1582315006, 1, 0, 0, 0, 0, 0, 0),
(138, 906, 10, '113.70.137.185', '113.70.137.185', 1582324364, 1582324364, 1, 0, 0, 0, 0, 0, 0),
(139, 909, 10, '223.88.66.187', '223.88.66.187', 1582326240, 1582326320, 1, 0, 0, 0, 0, 0, 0),
(140, 910, 10, '119.185.202.101', '119.185.202.101', 1582327497, 1582327497, 1, 0, 0, 0, 0, 0, 0),
(141, 915, 10, '113.134.232.253', '113.134.232.253', 1582328984, 1582329039, 1, 0, 0, 0, 0, 0, 0),
(142, 918, 10, '223.150.189.101', '223.150.189.101', 1582329774, 1582329774, 1, 0, 0, 0, 0, 0, 0),
(143, 182, 10, '60.180.172.104', '60.180.172.104', 1582330003, 1582330122, 1, 0, 0, 0, 0, 0, 0),
(144, 924, 10, '106.117.15.209', '106.117.15.209', 1582332799, 1582332940, 1, 0, 0, 0, 0, 0, 0),
(145, 928, 10, '119.100.60.180', '119.100.60.180', 1582333963, 1582333990, 1, 0, 0, 0, 0, 0, 0),
(146, 887, 10, '219.142.144.211', '219.142.144.211', 1582337625, 1582337665, 1, 0, 0, 0, 0, 0, 0),
(147, 835, 10, '180.120.161.80', '122.96.44.188', 1582337878, 1582340797, 1, 0, 0, 0, 0, 0, 0),
(148, 942, 10, '223.104.190.90', '223.104.190.90', 1582338201, 1582338201, 1, 0, 0, 0, 0, 0, 0),
(149, 714, 10, '113.57.182.233', '113.57.182.233', 1582340417, 1582340417, 1, 0, 0, 0, 0, 0, 0),
(150, 708, 10, '1.204.6.234', '1.204.6.234', 1582341143, 1582341143, 1, 0, 0, 0, 0, 0, 0),
(151, 473, 10, '120.230.79.99', '120.230.79.99', 1582343475, 1582343555, 1, 0, 0, 0, 0, 0, 0),
(152, 724, 10, '117.188.8.79', '117.188.8.79', 1582345484, 1582345484, 1, 0, 0, 0, 0, 0, 0),
(153, 967, 10, '183.200.12.246', '183.200.12.246', 1582347340, 1582347385, 1, 0, 0, 0, 0, 0, 0),
(154, 969, 10, '120.229.10.99', '120.229.10.99', 1582349190, 1582349241, 1, 0, 0, 0, 0, 0, 0),
(155, 565, 13, '113.101.54.247', '113.101.54.247', 1582350027, 1582351035, 1, 0, 0, 0, 0, 0, 0),
(156, 972, 10, '115.63.92.161', '115.63.92.161', 1582350202, 1582351512, 1, 0, 0, 0, 0, 0, 0),
(157, 972, 12, '115.63.92.161', '115.63.92.161', 1582350411, 1582351499, 1, 0, 0, 0, 0, 0, 0),
(158, 848, 13, '223.104.64.58', '223.104.64.58', 1582350572, 1582351558, 1, 0, 0, 0, 0, 0, 0),
(159, 978, 10, '106.6.172.242', '106.6.172.242', 1582351558, 1582351558, 1, 0, 0, 0, 0, 0, 0),
(160, 973, 10, '182.51.86.116', '182.51.86.116', 1582352410, 1582353499, 1, 0, 0, 0, 0, 0, 0),
(161, 983, 10, '121.16.180.179', '121.16.180.179', 1582352746, 1582352746, 1, 0, 0, 0, 0, 0, 0),
(162, 952, 10, '183.142.70.219', '183.142.95.146', 1582353309, 1582360534, 1, 0, 0, 0, 0, 0, 0),
(163, 992, 10, '106.110.38.11', '106.110.38.11', 1582357064, 1582357065, 1, 0, 0, 0, 0, 0, 0),
(164, 209, 13, '113.123.202.152', '113.123.202.152', 1582372891, 1582372891, 1, 0, 0, 0, 0, 0, 0),
(165, 1060, 12, '14.20.185.169', '14.20.185.169', 1582389432, 1582389432, 1, 0, 0, 0, 0, 0, 0),
(166, 1015, 10, '106.42.94.19', '106.42.94.19', 1582420612, 1582420612, 1, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `eb_phone_user`
--

CREATE TABLE `eb_phone_user` (
  `id` int(10) UNSIGNED NOT NULL,
  `phone` varchar(11) NOT NULL DEFAULT '' COMMENT '手机号码',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '用户头像',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT '用户昵称',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'user用户id,不关联为0',
  `grade_id` int(11) NOT NULL DEFAULT '0' COMMENT '年级id',
  `new_money` decimal(9,2) NOT NULL DEFAULT '0.00' COMMENT '用户余额',
  `level` tinyint(1) NOT NULL DEFAULT '0' COMMENT '用户等级',
  `add_ip` varchar(16) NOT NULL DEFAULT '' COMMENT '添加ip',
  `pwd` varchar(32) NOT NULL DEFAULT '' COMMENT '登录密码',
  `spread_uid` int(11) NOT NULL DEFAULT '0' COMMENT '推广员id',
  `is_promoter` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为推广员',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `last_time` int(11) NOT NULL DEFAULT '0' COMMENT '登录时间',
  `last_ip` varchar(16) NOT NULL DEFAULT '' COMMENT '登录id',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否禁止,0=禁止,1=开启'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='手机号码注册用户表';


--
-- 表的结构 `eb_recommend`
--

CREATE TABLE `eb_recommend` (
  `id` int(11) NOT NULL,
  `typesetting` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1=大图,2=宫图,3=小图,4=纯图',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `link` varchar(255) NOT NULL DEFAULT '' COMMENT '自定义跳转路径',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '类型0=专题,1=新闻,2=直播,3=自定义跳转',
  `number` int(11) NOT NULL DEFAULT '0' COMMENT '数量',
  `relation_ids` varchar(1000) NOT NULL DEFAULT '' COMMENT '关联id',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `icon` varchar(255) NOT NULL DEFAULT '' COMMENT '图标',
  `image` varchar(255) NOT NULL DEFAULT '' COMMENT '封面图',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `is_fixed` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为固定排版',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否上架',
  `grade_id` int(11) NOT NULL DEFAULT '0' COMMENT '年级id',
  `show_count` int(11) NOT NULL DEFAULT '0' COMMENT '展示多少个'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='首页推荐';

--
-- 转存表中的数据 `eb_recommend`
--

INSERT INTO `eb_recommend` (`id`, `typesetting`, `title`, `link`, `type`, `number`, `relation_ids`, `add_time`, `icon`, `image`, `sort`, `is_fixed`, `is_show`, `grade_id`, `show_count`) VALUES
(16, 2, '语文', '', 0, 0, '', 1581401726, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/dff8b202002111344407490.png', '', 0, 1, 0, 1, 0),
(17, 1, '测试推荐', '', 0, 0, '', 1581402048, '', '', 0, 0, 1, 1, 10),
(18, 0, '小学', '', 0, 0, '', 1581415908, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/a3248202002111757415453.png', '', 10, 1, 1, 4, 0),
(19, 1, '初中', '', 0, 0, '', 1581415944, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/12017202002111757416996.png', '', 9, 1, 1, 3, 0),
(20, 4, '高中', '', 0, 0, '', 1581416083, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/55bd0202002111757421468.png', '', 8, 1, 1, 2, 0),
(21, 2, '少儿编程', '', 0, 0, '', 1581416143, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/022b1202002111757413298.png', '', 7, 1, 1, 1, 0),
(22, 3, '绘画', '', 0, 0, '', 1581416164, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/09bd3202002111757426798.png', '', 6, 1, 1, 5, 0),
(23, 1, '公考', '', 0, 0, '', 1581416198, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/fb05a202002111757415258.png', '', 5, 1, 1, 6, 0),
(24, 3, '小语种', '', 0, 0, '', 1581416219, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/e20b0202002111757424191.png', '', 4, 1, 1, 7, 0),
(25, 3, '考研', '', 0, 0, '', 1581416246, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/8cf7c202002111757418051.png', '', 3, 1, 1, 8, 0),
(26, 2, '精品课程排行', '', 0, 0, '', 1581417034, '', '', 0, 0, 1, 4, 100),
(27, 0, '我的课程', 'http://zhishifufei.crmeb.net/wap/special/grade_list.html', 3, 0, '', 1581502207, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/abbe8202002111757429842.png', '', 2, 1, 1, 0, 0),
(28, 0, '我的收藏', 'http://zhishifufei.crmeb.net/wap/special/grade_list/type/1.html', 3, 0, '', 1581502283, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/37e3a202002111757417776.png', '', 1, 1, 1, 0, 0),
(30, 2, '测试', '', 1, 0, '', 1581921700, '', '', 0, 0, 1, 4, 10),
(31, 3, '在线直播', '', 0, 0, '', 1582180461, '', '', 0, 0, 1, 4, 10);

-- --------------------------------------------------------

--
-- 表的结构 `eb_recommend_banner`
--

CREATE TABLE `eb_recommend_banner` (
  `id` int(11) NOT NULL,
  `recommend_id` int(11) NOT NULL DEFAULT '0' COMMENT '推荐id',
  `pic` varchar(300) NOT NULL DEFAULT '' COMMENT '图片链接',
  `url` varchar(300) NOT NULL DEFAULT '' COMMENT '跳转地址',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='首页推荐banner';

--
-- 转存表中的数据 `eb_recommend_banner`
--

INSERT INTO `eb_recommend_banner` (`id`, `recommend_id`, `pic`, `url`, `sort`, `is_show`, `add_time`) VALUES
(6, 26, 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/10f3d202002111757429313.jpg', '#', 0, 1, 1581924394);

-- --------------------------------------------------------

--
-- 表的结构 `eb_recommend_relation`
--

CREATE TABLE `eb_recommend_relation` (
  `id` int(11) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '类型,0=专题,1=新闻，2=直播',
  `recommend_id` int(11) NOT NULL COMMENT '推荐id',
  `link_id` int(11) NOT NULL DEFAULT '0' COMMENT '关联id',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='主页推荐关联表';

--
-- 转存表中的数据 `eb_recommend_relation`
--

INSERT INTO `eb_recommend_relation` (`id`, `type`, `recommend_id`, `link_id`, `sort`, `add_time`) VALUES
(111, 0, 31, 1, 0, 1588047108),
(112, 0, 26, 2, 0, 1588047166),
(113, 0, 17, 3, 0, 1588047184),
(114, 0, 26, 3, 0, 1588047194),
(115, 0, 17, 4, 0, 1588047207),
(116, 0, 26, 5, 0, 1588047333),
(117, 0, 17, 5, 0, 1588047341);

-- --------------------------------------------------------

--
-- 表的结构 `eb_routine_access_token`
--

CREATE TABLE `eb_routine_access_token` (
  `id` int(11) UNSIGNED NOT NULL COMMENT '小程序access_token表ID',
  `access_token` varchar(256) NOT NULL COMMENT 'openid',
  `stop_time` int(11) UNSIGNED NOT NULL COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='小程序access_token表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_routine_form_id`
--

CREATE TABLE `eb_routine_form_id` (
  `id` int(11) UNSIGNED NOT NULL COMMENT '表单ID表ID',
  `uid` int(11) DEFAULT '0' COMMENT '用户uid',
  `form_id` varchar(32) NOT NULL COMMENT '表单ID',
  `stop_time` int(11) UNSIGNED DEFAULT NULL COMMENT '表单ID失效时间',
  `status` tinyint(1) UNSIGNED DEFAULT '0' COMMENT '状态1 未使用 2不能使用'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='表单id表记录表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_routine_template`
--

CREATE TABLE `eb_routine_template` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '模板id',
  `tempkey` char(50) NOT NULL COMMENT '模板编号',
  `name` char(100) NOT NULL COMMENT '模板名',
  `content` varchar(1000) NOT NULL COMMENT '回复内容',
  `tempid` char(100) DEFAULT NULL COMMENT '模板ID',
  `add_time` varchar(15) NOT NULL COMMENT '添加时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='微信模板';

--
-- 转存表中的数据 `eb_routine_template`
--

INSERT INTO `eb_routine_template` (`id`, `tempkey`, `name`, `content`, `tempid`, `add_time`, `status`) VALUES
(12, 'AT0177', '订单配送通知', '订单编号{{keyword1.DATA}}\n配送员{{keyword2.DATA}}\n联系电话{{keyword3.DATA}}\n配送时间{{keyword4.DATA}}\n备注{{keyword5.DATA}}', 'PPDexF5trJG2H9XuEcfrcV6V0Nk1X9S0mWDva_bEjF8', '1534469109', 1),
(13, 'AT0007', '订单发货提醒', '订单号{{keyword1.DATA}}\n快递公司{{keyword2.DATA}}\n快递单号{{keyword3.DATA}}\n发货时间{{keyword4.DATA}}\n备注{{keyword5.DATA}}', 'rgb_ATfivS_vx7u6AnYXpQH-BxIABq8yJpMnGwhAzaE', '1534469928', 0),
(14, 'AT0787', '退款成功通知', '订单号{{keyword1.DATA}}\n退款时间{{keyword2.DATA}}\n退款金额{{keyword3.DATA}}\n退款方式{{keyword4.DATA}}\n备注{{keyword5.DATA}}', 'g3Fu-ljOUwtNHo7ISRNovemB5LIDsPfgiYUukwadymA', '1534469993', 1),
(15, 'AT0009', '订单支付成功通知', '单号{{keyword1.DATA}}\n下单时间{{keyword2.DATA}}\n订单状态{{keyword3.DATA}}\n支付金额{{keyword4.DATA}}\n支付方式{{keyword5.DATA}}', '6HxCNpsDXqhzGd_7QioQgWCJlIgzmLbcoE2d8uluEaQ', '1534470043', 1),
(16, 'AT1173', '砍价成功通知', '商品名称{{keyword1.DATA}}\n砍价金额{{keyword2.DATA}}\n底价{{keyword3.DATA}}\n砍掉价格{{keyword4.DATA}}\n支付金额{{keyword5.DATA}}\n备注{{keyword6.DATA}}', 'DCt_nV9uo2bJdGMg19zr6ao_x8MGo3lRX6BqsVFY2zw', '1534470085', 0),
(17, 'AT0036', '退款通知', '订单编号{{keyword1.DATA}}\n退款原因{{keyword2.DATA}}\n退款时间{{keyword3.DATA}}\n退款金额{{keyword4.DATA}}\n退款方式{{keyword5.DATA}}', 'kJ5jTVzV4ecNUDucKUATjBOIKJVzrPAm9peXYD13BxY', '1534470134', 1),
(18, 'AT0035', '收益到账通知', '订单号{{keyword1.DATA}}\n商品名称{{keyword2.DATA}}\n金额{{keyword3.DATA}}\n收益来源{{keyword4.DATA}}', 'OaCSnkkFi7GFomOCTCDe5w9qaNAWS2REAVZ3epWlxA0', '1541814979', 1),
(19, 'AT0146', '审核结果通知', '审核结果{{keyword1.DATA}}\r\n审核人员{{keyword2.DATA}}\r\n联系电话{{keyword3.DATA}}\r\n审核时间{{keyword4.DATA}}\r\n备注{{keyword5.DATA}}\r\n申请用户{{keyword6.DATA}}\r\n未通过原因{{keyword7.DATA}}', 'wzc5lXn4llgOgX7zH7l90rh4szlPZdjYPRTRo5OnzTs', '1543545827', 1);

-- --------------------------------------------------------

--
-- 表的结构 `eb_search`
--

CREATE TABLE `eb_search` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '关键词名',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='关键词搜索设置';

--
-- 转存表中的数据 `eb_search`
--

INSERT INTO `eb_search` (`id`, `name`, `add_time`) VALUES
(29, '语文', 1581476333),
(30, '数学', 1581476338),
(31, '英语', 1581476343);

-- --------------------------------------------------------

--
-- 表的结构 `eb_sms_code`
--

CREATE TABLE `eb_sms_code` (
  `id` int(5) NOT NULL COMMENT 'id',
  `tel` varchar(20) NOT NULL COMMENT '电话号码',
  `uid` int(10) UNSIGNED NOT NULL COMMENT '谁发送的',
  `code` int(8) UNSIGNED NOT NULL COMMENT '验证码',
  `last_time` int(11) UNSIGNED NOT NULL COMMENT '过期时间',
  `is_use` int(2) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否已使用'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `eb_sms_code`
--

INSERT INTO `eb_sms_code` (`id`, `tel`, `uid`, `code`, `last_time`, `is_use`) VALUES
(255, '18941056335', 0, 915273, 1582434662, 1);

-- --------------------------------------------------------

--
-- 表的结构 `eb_special`
--

CREATE TABLE `eb_special` (
  `id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `subject_id` int(11) NOT NULL DEFAULT '0' COMMENT '科目id',
  `admin_id` int(11) NOT NULL DEFAULT '0' COMMENT '所属管理者id',
   `type` tinyint(2) NOT NULL DEFAULT '6' COMMENT '专题类型1：图文专题；2：音频专题；3：视频专题；4：直播专题；5：专栏；6：其他专题',
  `abstract` varchar(1000) NOT NULL DEFAULT '' COMMENT '简介',
  `phrase` varchar(2000) NOT NULL DEFAULT '' COMMENT '短语',
  `image` varchar(255) NOT NULL DEFAULT '' COMMENT '封面图',
  `label` varchar(1000) NOT NULL DEFAULT '' COMMENT '标签',
  `banner` varchar(2000) NOT NULL DEFAULT '' COMMENT 'banner图',
  `poster_image` varchar(255) NOT NULL DEFAULT '' COMMENT '海报',
  `service_code` varchar(255) NOT NULL DEFAULT '' COMMENT '客服二维码',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_live` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否为直播',
  `money` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '金额',
  `pink_money` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '拼团价格',
  `is_pink` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否开启拼团',
  `pink_number` int(11) NOT NULL DEFAULT '0' COMMENT '拼团人数',
  `pink_strar_time` int(11) NOT NULL DEFAULT '0' COMMENT '拼团开始时间',
  `pink_end_time` int(11) NOT NULL DEFAULT '0' COMMENT '拼团结束时间',
  `pink_time` int(11) NOT NULL DEFAULT '0' COMMENT '拼团时间',
  `is_fake_pink` tinyint(1) NOT NULL DEFAULT '0' COMMENT '虚拟拼团是否开启',
  `fake_pink_number` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟拼团人数',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `sales` int(11) NOT NULL DEFAULT '0' COMMENT '实际销量',
  `fake_sales` int(11) NOT NULL DEFAULT '0' COMMENT '虚拟销量',
  `browse_count` int(11) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `pay_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '支付类型',
  `member_pay_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '会员支付类型0：免费，1付费',
  `member_money` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '会员价格',
  `link` varchar(512) NOT NULL DEFAULT '' COMMENT '音频视频专题链接'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='专题';

--
-- 转存表中的数据 `eb_special`
--
INSERT INTO `eb_special`(`id`, `title`, `subject_id`, `admin_id`, `type`, `abstract`, `phrase`, `image`, `label`, `banner`, `poster_image`, `service_code`, `is_show`, `is_del`, `is_live`, `money`, `pink_money`, `is_pink`, `pink_number`, `pink_strar_time`, `pink_end_time`, `pink_time`, `is_fake_pink`, `fake_pink_number`, `sort`, `sales`, `fake_sales`, `browse_count`, `add_time`, `pay_type`, `member_pay_type`, `member_money`, `link`) VALUES
(1, '直播国学大讲堂', 21, 0, 4, '直播国学大讲堂', '直播国学大讲堂', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/ce99d202002201232432554.jpg', '[\"\\u56fd\\u5b66\\u8bb2\\u5802\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/ce99d202002201232432554.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/ce99d202002201232432554.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 1, 0, 0, 0.00, 0.00, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1588044359, 0, 0, 0.00, ''),
(2, '图文专题', 21, 0, 1, '图文专题简介', '图文专题短语', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/f4313202002201232435004.jpg', '[\"\\u56fe\\u6587\\u4e13\\u9898\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/f4313202002201232435004.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/f4313202002201232435004.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 1, 0, 0, 0.50, 0.00, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 13, 1588045424, 1, 1, 0.20, ''),
(3, '音频专题', 22, 0, 2, '音频专题简介', '音频专题', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/8ab46202002201232152644.jpg', '[\"\\u97f3\\u9891\\u4e13\\u9898\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/8ab46202002201232152644.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/8ab46202002201232152644.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 1, 0, 0, 0.20, 0.00, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1588046472, 1, 0, 0.00, ''),
(4, '视频专题', 23, 0, 3, '视频专题', '视频专题', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/9ec16202002121807113099.png', '[\"\\u89c6\\u9891\\u4e13\\u9898\"]', '[\"http:\\/\\/testcrmeb.oss-cn-beijing.aliyuncs.com\\/9ec16202002121807113099.png\"]', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/9ec16202002121807113099.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/9ec16202002121807113099.png', 1, 0, 0, 0.00, 0.00, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 1, 1588046648, 0, 0, 0.00, ''),
(5, '我是专栏', 21, 0, 5, '我是专栏（我里面包含专题）', '我是专栏', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/32379202002201232449232.jpg', '[\"\\u4e13\\u680f\\u4e13\\u9898\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/32379202002201232449232.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/32379202002201232449232.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/32379202002201232449232.jpg', 1, 0, 0, 1.00, 0.30, 1, 2, 1588003200, 1588176000, 100, 1, 50, 0, 0, 0, 2, 1588046788, 1, 1, 0.50, '');

/*INSERT INTO `eb_special` (`id`, `title`, `subject_id`, `abstract`, `phrase`, `image`, `label`, `banner`, `poster_image`, `service_code`, `is_show`, `is_del`, `is_live`, `money`, `pink_money`, `is_pink`, `pink_number`, `pink_strar_time`, `pink_end_time`, `pink_time`, `is_fake_pink`, `fake_pink_number`, `sort`, `sales`, `fake_sales`, `browse_count`, `add_time`, `pay_type`) VALUES
(45, '测试专题', 21, '测试专题11', '测试专题111', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/267f3202002201232144167.jpg', '[\"\\u6d4b\\u8bd5\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/f4313202002201232435004.jpg\",\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/ce99d202002201232432554.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 1, 0, 0, '150.00', '100.00', 1, 6, 1581418810, 1582905600, 30, 1, 50, 3, 0, 21, 520, 1581401647, 1),
(46, '测试语文', 21, '测试语文', '测试语文', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/1b0cb202002201232145135.jpg', '[\"\\u8bed\\u6587\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/0620e202002201232446695.jpg\",\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/3ec76202002201232442683.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 1, 0, 0, '0.01', '0.00', 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 246, 1581404545, 1),
(47, '公考大变革', 21, '公考大变革', '公考大变革', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/9f41f202002201232146791.jpg', '[\"\\u516c\\u8003\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/744f3202002201232457195.jpg\",\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/e56f5202002201232449146.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 1, 0, 0, '0.01', '0.00', 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 249, 1581405126, 1),
(48, '数学的逻辑', 22, '数学的逻辑数学的逻辑数学的逻辑数学的逻辑', '数学的逻辑', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/44910202002201232149124.jpg', '[\"\\u6570\\u5b66\",\"32\\u8282\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/3ec76202002201232442683.jpg\",\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/32379202002201232449232.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 1, 0, 0, '300.00', '0.00', 0, 0, 0, 0, 0, 1, 0, 0, 0, 30, 450, 1581415485, 1),
(49, '英语的口语技巧', 23, '英语的口语技巧', '英语的口语技巧', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/3e9f4202002201232159295.jpg', '[\"\\u82f1\\u8bed\",\"36\\u8282\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/e56f5202002201232449146.jpg\",\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/d41c7202002201232431520.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 1, 0, 0, '200.00', '100.00', 1, 4, 1581415648, 1582905600, 16, 1, 50, 0, 0, 100, 195, 1581415680, 1),
(50, '雅思英语000', 23, '雅思英语', '雅思英语', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/8ab46202002201232152644.jpg', '[\"\\u96c5\\u601d\",\"166\\u8282\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/78cdd20200220123244525.jpg\",\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/32379202002201232449232.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 1, 0, 0, '0.01', '10.00', 1, 8, 1581417706, 1582819200, 20, 1, 50, 0, 0, 0, 175, 1581417733, 1),
(51, '功能测试', 30, '功能测试', '功能测试', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/9d76920200212180711743.png', '[\"\\u6d4b\\u8bd5\",\"24\\u8282\"]', '[\"http:\\/\\/testcrmeb.oss-cn-beijing.aliyuncs.com\\/9d76920200212180711743.png\"]', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/7809f202002111801111378.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/bd2ef202002111519022660.jpg', 1, 1, 0, '200.00', '0.00', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1581674470, 1),
(52, '测试直播123', 21, '测试直播123', '测试直播123', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/887d9202002201232157812.jpg', '[\"\\u6d4b\\u8bd5\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/32379202002201232449232.jpg\",\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/78cdd20200220123244525.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 1, 0, 1, '0.00', '0.00', 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1015, 1582023314, 0),
(53, '直播测试666', 22, '直播测试666', '直播测试666', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/44910202002201232149124.jpg', '[\"\\u70ed\\u95e8\",\"\\u65b0\\u54c1\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/3ec76202002201232442683.jpg\",\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/ce99d202002201232432554.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/bd2ef202002111519022660.jpg', 1, 0, 1, '300.00', '100.00', 1, 2, 1582118006, 1582560000, 2, 1, 50, 0, 0, 0, 144, 1582118064, 1),
(54, '语文学习技巧', 21, '语文学习技巧', '语文学习技巧', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/9547920200220123215506.jpg', '[\"\\u8bed\\u6587\",\"\\u76f4\\u64ad\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/d41c7202002201232431520.jpg\",\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/ce99d202002201232432554.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 1, 0, 1, '100.00', '0.00', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 169, 1582180941, 1),
(55, 'xxx', 21, 'xxx', 'xxx', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/e56f5202002201232449146.jpg', '[\"xxx\"]', '[\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/744f3202002201232457195.jpg\"]', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/9a0d1202002201232324402.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/8ab46202002201232152644.jpg', 1, 0, 1, '11.00', '0.00', 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 128, 1582220245, 0);*/

-- --------------------------------------------------------

--
-- 表的结构 `eb_special_barrage`
--

CREATE TABLE `eb_special_barrage` (
  `id` int(11) NOT NULL,
  `special_id` int(11) NOT NULL DEFAULT '0' COMMENT '专题id 0=全部可用',
  `nickname` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '用户昵称',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '用户图像',
  `action` tinyint(1) NOT NULL DEFAULT '0' COMMENT '动作类型 1=开团，2=参团',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示，默认显示',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='专题弹幕';

--
-- 转存表中的数据 `eb_special_barrage`
--

INSERT INTO `eb_special_barrage` (`id`, `special_id`, `nickname`, `avatar`, `action`, `sort`, `is_show`, `add_time`) VALUES
(24, 0, '666', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/6b85d202002111757421971.jpg', 1, 0, 1, 1582011509),
(25, 0, '666', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/6b85d202002111757421971.jpg', 1, 0, 1, 1582011520),
(26, 0, 'yy', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/7f0bd202002111757435432.jpg', 1, 0, 1, 1582018672);

-- --------------------------------------------------------

--
-- 表的结构 `eb_special_buy`
--

CREATE TABLE `eb_special_buy` (
  `id` int(11) NOT NULL,
  `order_id` varchar(32) NOT NULL DEFAULT '' COMMENT '订单id',
  `special_id` int(11) NOT NULL COMMENT '专题id',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '获得方式:0=支付获得,1=拼团获得,2=领取礼物获得,3=赠送'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='专题获得记录';

--
-- 转存表中的数据 `eb_special_buy`
--

INSERT INTO `eb_special_buy` (`id`, `order_id`, `special_id`, `uid`, `add_time`, `is_del`, `type`) VALUES
(29, 'wx2020021115031210001', 46, 1, 1581404592, 0, 0),
(30, 'wx2020021117425910009', 47, 65, 1581414186, 0, 0),
(31, 'wx2020021119123910010', 48, 65, 1581419559, 0, 0),
(32, 'wx2020021209385010001', 47, 70, 1581471530, 0, 0),
(33, 'wx2020021209405610003', 47, 69, 1581471667, 0, 0),
(34, 'wx2020021209460410005', 50, 69, 1581471964, 0, 0),
(35, 'wx2020021209540210010', 48, 66, 1581472442, 0, 0),
(36, 'wx2020021210064710014', 48, 77, 1581473207, 0, 0),
(37, 'wx2020021210071510015', 48, 74, 1581473235, 0, 0),
(38, 'wx2020021210181210021', 46, 66, 1581473892, 0, 2),
(39, 'wx2020021209561810012', 49, 65, 1581474127, 0, 1),
(40, 'wx2020021209591910013', 49, 66, 1581474127, 0, 1),
(41, 'wx2020021210185910022', 49, 71, 1581474127, 0, 1),
(42, 'wx2020021210220710023', 49, 77, 1581474127, 0, 1),
(43, 'wx2020021210223610024', 50, 71, 1581474156, 0, 0),
(44, 'wx2020021210390910028', 46, 78, 1581475149, 0, 0),
(45, 'wx2020021211092910029', 50, 66, 1581476969, 0, 0),
(46, 'wx2020021211313810031', 48, 71, 1581478298, 0, 2),
(47, 'wx2020021309244410001', 50, 67, 1581557084, 0, 0),
(48, 'wx2020021309272710002', 48, 67, 1581557247, 0, 0),
(49, 'wx2020021415075310002', 45, 66, 1581664073, 0, 0),
(50, 'wx2020021418471310003', 49, 68, 1581924384, 0, 1),
(51, 'wx2020021418594610004', 49, 67, 1581924384, 0, 1),
(52, 'wx2020021419110410005', 49, 69, 1581924384, 0, 1),
(53, 'wx2020021717461610005', 47, 68, 1581932776, 0, 0),
(54, 'wx2020021717464510006', 47, 67, 1581932805, 0, 0),
(55, 'wx2020021719172610011', 50, 65, 1581938246, 0, 0),
(56, 'wx2020021800404810002', 47, 120, 1581957653, 0, 0),
(57, 'wx2020021811550510003', 46, 65, 1581998123, 0, 0),
(58, 'wx2020021813553710007', 47, 156, 1582005405, 0, 0),
(59, 'wx2020021816250510009', 48, 169, 1582014305, 0, 0),
(60, 'wx2020021717180710003', 47, 67, 1582019265, 0, 0),
(61, 'wx2020021717425910004', 47, 68, 1582020749, 0, 0),
(62, 'wx2020021718260810007', 50, 65, 1582023308, 0, 0),
(63, 'wx2020021718321610008', 50, 65, 1582023666, 0, 0),
(64, 'wx2020021819244310011', 52, 198, 1582025083, 0, 0),
(65, 'wx2020021819244710012', 52, 198, 1582025087, 0, 0),
(66, 'wx2020021719141710009', 50, 65, 1582026222, 0, 0),
(67, 'wx2020021719163210010', 50, 65, 1582026306, 0, 0),
(68, 'wx2020021719175910012', 46, 65, 1582026468, 0, 0),
(69, 'wx2020021719202310013', 46, 65, 1582026588, 0, 0),
(70, 'wx2020021719221110014', 46, 65, 1582026698, 0, 0),
(71, 'wx2020021719252510015', 46, 65, 1582026880, 0, 0),
(72, 'wx2020021719271310016', 46, 65, 1582026972, 0, 0),
(73, 'wx2020021719283210017', 46, 65, 1582027029, 0, 0),
(74, 'wx2020021820261110013', 49, 169, 1582028771, 0, 0),
(75, 'wx2020021820440210015', 47, 209, 1582029842, 0, 0),
(76, 'wx2020021820460110016', 48, 209, 1582029961, 0, 0),
(77, 'wx2020021820493410017', 50, 169, 1582030174, 0, 0),
(78, 'wx2020021909572210002', 50, 164, 1582077449, 0, 0),
(79, 'wx2020021909592110003', 46, 164, 1582077567, 0, 0),
(80, 'wx2020021914243210005', 47, 276, 1582093480, 0, 0),
(81, 'wx2020021917473110006', 47, 297, 1582105651, 0, 0),
(82, 'wx2020021923561910008', 52, 319, 1582127779, 0, 0),
(83, 'wx2020022000253510001', 52, 323, 1582129535, 0, 0),
(84, 'wx2020022008570510002', 46, 209, 1582160225, 0, 0),
(85, 'wx2020022008572210003', 45, 209, 1582160242, 0, 0),
(86, 'wx2020022010292910005', 53, 65, 1582165769, 0, 0),
(87, 'wx2020022010400110006', 53, 66, 1582166401, 0, 0),
(88, '', 45, 351, 1582172388, 0, 3),
(89, 'wx2020022014223710007', 52, 369, 1582179757, 0, 0),
(90, 'wx2020022014224310008', 52, 369, 1582179763, 0, 0),
(91, 'wx2020022014232810009', 47, 369, 1582179814, 0, 0),
(92, 'wx2020022014240610011', 46, 369, 1582179857, 0, 0),
(93, 'wx2020022014345510012', 45, 65, 1582180495, 0, 0),
(94, 'wx2020022014424510013', 54, 66, 1582180965, 0, 0),
(96, 'wx2020022016202210015', 45, 380, 1582186822, 0, 0),
(97, 'wx2020022119363210002', 46, 462, 1582284998, 0, 0),
(98, 'wx2020022119404410006', 47, 496, 1582285249, 0, 0),
(99, 'wx2020022119414410007', 46, 511, 1582285314, 0, 0),
(100, 'wx2020022119460810012', 47, 565, 1582285573, 0, 0),
(101, 'wx2020022119474010014', 46, 565, 1582285666, 0, 0),
(102, 'wx2020022119505610015', 47, 542, 1582285863, 0, 0),
(103, 'wx2020022119520610018', 50, 587, 1582285934, 0, 0),
(104, 'wx2020022120260010022', 52, 695, 1582287961, 0, 0),
(105, 'wx2020022120260610023', 52, 695, 1582287966, 0, 0),
(106, 'wx2020022120372810026', 46, 717, 1582288656, 0, 0),
(107, 'wx2020022120412010027', 46, 724, 1582288887, 0, 0),
(108, 'wx2020022120461010031', 47, 525, 1582289176, 0, 0),
(109, 'wx2020022120480610033', 50, 715, 1582289291, 0, 0),
(110, 'wx2020022120552110038', 46, 741, 1582289730, 0, 0),
(111, 'wx2020022120561810040', 46, 744, 1582289786, 0, 0),
(112, 'wx2020022121062210045', 47, 750, 1582290392, 0, 0),
(113, 'wx2020022121071710046', 46, 761, 1582290446, 0, 0),
(114, 'wx2020022121072510048', 46, 753, 1582290459, 0, 0),
(115, 'wx2020022121080510049', 46, 750, 1582290491, 0, 0),
(117, 'wx2020022121332010053', 46, 749, 1582292006, 0, 0),
(118, 'wx2020022121490610056', 47, 791, 1582292954, 0, 0),
(119, 'wx2020022121504710057', 46, 791, 1582293053, 0, 0),
(120, 'wx2020022121540710059', 46, 637, 1582293257, 0, 0),
(121, 'wx2020022122433110062', 52, 832, 1582296211, 0, 0),
(122, 'wx2020022122433710063', 52, 832, 1582296217, 0, 0),
(123, 'wx2020022122433910064', 52, 832, 1582296219, 0, 0),
(124, 'wx2020022123063010070', 52, 845, 1582297590, 0, 0),
(125, 'wx2020022123063310071', 52, 845, 1582297593, 0, 0),
(126, 'wx2020022123470810072', 52, 869, 1582300028, 0, 0),
(127, 'wx2020022123471310073', 52, 869, 1582300033, 0, 0),
(128, 'wx2020022201363010003', 46, 892, 1582306595, 0, 0),
(129, 'wx2020022202062210006', 52, 895, 1582308382, 0, 0),
(130, 'wx2020022202104510007', 50, 637, 1582308654, 0, 0),
(131, 'wx2020022202240810008', 52, 899, 1582309448, 0, 0),
(132, 'wx2020022202241610009', 52, 899, 1582309456, 0, 0),
(133, 'wx2020022206192410010', 52, 904, 1582323564, 0, 0),
(134, 'wx2020022206322610011', 52, 906, 1582324346, 0, 0),
(135, 'wx2020022206323210012', 52, 906, 1582324352, 0, 0),
(136, 'wx2020022206323410013', 52, 906, 1582324354, 0, 0),
(137, 'wx2020022207083110021', 50, 909, 1582326518, 0, 0),
(139, 'wx2020022210150210025', 50, 887, 1582337706, 0, 0),
(140, '', 54, 928, 1582346738, 0, 3),
(141, 'wx2020022213294610028', 46, 969, 1582349394, 0, 0),
(142, 'wx2020022213402310029', 55, 565, 1582350023, 0, 0),
(143, '', 54, 972, 1582350389, 0, 3),
(144, 'wx2020022215053810030', 46, 987, 1582355146, 0, 0),
(145, 'wx2020022215145710032', 47, 985, 1582355708, 0, 0),
(146, 'wx2020022216571410036', 47, 978, 1582361842, 0, 0),
(147, 'wx2020022217060410038', 46, 714, 1582362373, 0, 0),
(148, 'wx2020022219170610040', 52, 1014, 1582370226, 0, 0),
(149, 'wx2020022219171210041', 52, 1014, 1582370232, 0, 0),
(150, 'wx2020022220012710045', 55, 209, 1582372887, 0, 0),
(151, 'wx2020022220025310047', 46, 1021, 1582372973, 0, 2),
(152, 'wx2020022220261410049', 47, 1020, 1582374404, 0, 0),
(153, 'wx2020022300221710001', 47, 1059, 1582388543, 0, 0),
(154, 'wx2020022300353310003', 45, 1060, 1582389333, 0, 0),
(155, 'wx2020022300370610005', 54, 1060, 1582389426, 0, 0),
(156, 'wx2020022300405010006', 47, 1060, 1582389650, 0, 0),
(157, 'wx2020022300420110007', 46, 1060, 1582389721, 0, 0),
(158, 'wx2020022300441810008', 50, 1060, 1582389858, 0, 0),
(159, '', 45, 416, 1582390065, 0, 3),
(160, 'wx2020022312101310010', 52, 1098, 1582431013, 0, 0),
(161, 'wx2020022312101710011', 52, 1098, 1582431017, 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `eb_special_content`
--

CREATE TABLE `eb_special_content` (
  `id` int(11) NOT NULL,
  `special_id` int(11) NOT NULL DEFAULT '0' COMMENT '专栏id',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `content` text NOT NULL COMMENT '内容'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='专栏内容关联表';

--
-- 转存表中的数据 `eb_special_content`
--

INSERT INTO `eb_special_content` (`id`, `special_id`, `add_time`, `content`) VALUES
(1, 1, 1588044359, '&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;div&gt;&lt;video style=&quot;width: 100%&quot; src=&quot;http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4&quot; class=&quot;video-ue&quot; controls=&quot;controls&quot;&gt;&lt;/video&gt;&lt;/div&gt;&lt;p&gt;直播简介&lt;br/&gt;&lt;/p&gt;'),
(2, 2, 1588045424, '&lt;p&gt;专题内容&lt;/p&gt;&lt;div&gt;&lt;video style=&quot;width: 100%&quot; src=&quot;http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4&quot; class=&quot;video-ue&quot; controls=&quot;controls&quot;&gt;&lt;/video&gt;&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;'),
(3, 3, 1588046472, '&lt;p&gt;内容&lt;/p&gt;&lt;div&gt;&lt;video style=&quot;width: 100%&quot; src=&quot;http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4&quot; class=&quot;video-ue&quot; controls=&quot;controls&quot;&gt;&lt;/video&gt;&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;'),
(4, 4, 1588046648, '&lt;p&gt;内容&lt;/p&gt;&lt;div&gt;&lt;video style=&quot;width: 100%&quot; src=&quot;http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4&quot; class=&quot;video-ue&quot; controls=&quot;controls&quot;&gt;&lt;/video&gt;&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;'),
(5, 5, 1588046788, '&lt;p&gt;专栏内容&lt;/p&gt;&lt;div&gt;&lt;video style=&quot;width: 100%&quot; src=&quot;http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4&quot; class=&quot;video-ue&quot; controls=&quot;controls&quot;&gt;&lt;/video&gt;&lt;/div&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');


-- --------------------------------------------------------

--
-- 表的结构 `eb_special_course`
--

CREATE TABLE `eb_special_course` (
  `id` int(11) NOT NULL,
  `special_id` int(11) NOT NULL DEFAULT '0' COMMENT '专题id',
  `course_name` varchar(100) NOT NULL DEFAULT '' COMMENT '课程名称',
  `is_show` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否上架',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `number` int(11) NOT NULL DEFAULT '0' COMMENT '数量',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='课程(1.1版本后废弃)';

-- --------------------------------------------------------
--
-- 表的结构 `eb_special_source`
--

CREATE TABLE `eb_special_source` (
    `id` int(11) NOT NULL,
    `special_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '专题id',
    `source_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '素材id(task表id)',
    `pay_status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '0:免费，1：付费',
    `play_count` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '课程光看次数',
    `add_time` int(11) NOT NULL DEFAULT 0 COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='素材专题关联表';

-- --------------------------------------------------------
--
-- 表的结构 `eb_special_record`
--

CREATE TABLE `eb_special_record` (
  `id` int(11) NOT NULL,
  `special_id` int(11) NOT NULL DEFAULT '0' COMMENT '专题id',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `number` int(11) NOT NULL DEFAULT '0' COMMENT '浏览次数',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '再次访问时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='学习记录';
-- --------------------------------------------------------
--
-- 表的结构 `eb_member_card_batch`
--
CREATE TABLE `eb_member_card_batch` (
  `id` int(10) NOT NULL,
  `title` varchar(100) NOT NULL COMMENT '批次名称',
  `total_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '生成卡数量',
  `use_day` int(11) unsigned NOT NULL DEFAULT '7' COMMENT '体验天数',
  `use_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '使用',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否生效,控制此批次所有卡0：不生效；1：生效',
  `qrcode` varchar(255) NOT NULL COMMENT '二维码图路径',
  `remark` varchar(502) CHARACTER SET utf8mb4 NOT NULL COMMENT '备注',
  `create_time` int(11) NOT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='会员卡批次表';
-- --------------------------------------------------------
--
-- 表的结构 `eb_member_card`
--
CREATE TABLE `eb_member_card` (
  `id` int(11) NOT NULL,
  `card_batch_id` int(11) unsigned NOT NULL COMMENT '卡批次id',
  `card_number` varchar(200) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '卡号',
  `card_password` char(12) CHARACTER SET utf8mb4 NOT NULL COMMENT '密码',
  `use_uid` int(11) NOT NULL COMMENT '使用用户',
  `use_time` int(11) NOT NULL COMMENT '使用时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '卡状态：0：冻结；1：激活',
  `create_time` int(11) NOT NULL,
  `update_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`,`card_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='会员卡表';

-- 转存表中的数据 `eb_special_record`
--

INSERT INTO `eb_special_record` (`id`, `special_id`, `uid`, `number`, `add_time`, `update_time`) VALUES
(1, 46, 1, 1, 1581404604, 1581404604),
(2, 47, 1, 1, 1581405142, 1581405142),
(3, 47, 65, 21, 1581405987, 1582180547),
(4, 46, 67, 6, 1581409559, 1581557233),
(5, 47, 66, 21, 1581409643, 1582173615),
(6, 46, 66, 27, 1581409667, 1582352993),
(7, 45, 66, 32, 1581409800, 1582353363),
(8, 47, 67, 4, 1581409928, 1581932811),
(9, 45, 65, 5, 1581414587, 1582180484),
(10, 46, 68, 2, 1581415033, 1581564901),
(11, 45, 68, 1, 1581415054, 1581415054),
(12, 48, 66, 152, 1581416769, 1582254103),
(13, 47, 68, 9, 1581417031, 1581932772),
(14, 48, 65, 22, 1581418520, 1581998725),
(15, 50, 66, 18, 1581419775, 1582173866),
(16, 50, 65, 14, 1581419849, 1582180867),
(17, 49, 66, 27, 1581421646, 1582175610),
(18, 49, 68, 9, 1581440241, 1581932861),
(19, 50, 71, 10, 1581470593, 1581478088),
(20, 45, 72, 3, 1581470648, 1581503726),
(21, 50, 67, 2, 1581470819, 1581557033),
(22, 47, 69, 5, 1581470922, 1581471691),
(23, 45, 70, 4, 1581471406, 1581473657),
(24, 47, 70, 4, 1581471446, 1581472739),
(25, 48, 74, 6, 1581471577, 1581473256),
(26, 50, 70, 7, 1581471578, 1581473646),
(27, 46, 74, 1, 1581471592, 1581471592),
(28, 46, 75, 1, 1581471699, 1581471699),
(29, 48, 70, 3, 1581471830, 1581472501),
(30, 49, 74, 1, 1581471847, 1581471847),
(31, 50, 69, 1, 1581471952, 1581471952),
(32, 47, 74, 1, 1581472397, 1581472397),
(33, 48, 77, 7, 1581472462, 1582280421),
(34, 49, 70, 3, 1581472507, 1581473639),
(35, 49, 65, 7, 1581472573, 1581998743),
(36, 45, 77, 4, 1581472595, 1582280404),
(37, 46, 65, 12, 1581473571, 1582089787),
(38, 47, 77, 1, 1581473608, 1581473608),
(39, 46, 77, 2, 1581473614, 1581473726),
(40, 46, 70, 3, 1581473626, 1581473828),
(41, 49, 71, 5, 1581473922, 1581478159),
(42, 49, 77, 11, 1581474109, 1581503174),
(43, 49, 79, 1, 1581474356, 1581474356),
(44, 45, 71, 3, 1581474861, 1581477488),
(45, 46, 78, 4, 1581474979, 1581476341),
(46, 48, 78, 1, 1581476257, 1581476257),
(47, 48, 67, 5, 1581476485, 1581933477),
(48, 50, 77, 1, 1581477556, 1581477556),
(49, 48, 71, 3, 1581478184, 1581478793),
(50, 48, 68, 1, 1581480931, 1581480931),
(51, 45, 80, 1, 1581513556, 1581513556),
(52, 45, 67, 2, 1581515467, 1581931046),
(53, 49, 67, 5, 1581515475, 1581933810),
(54, 50, 68, 2, 1581564916, 1581576596),
(55, 47, 81, 2, 1581580903, 1581583481),
(56, 48, 81, 2, 1581580924, 1581581953),
(57, 45, 81, 1, 1581581905, 1581581905),
(58, 49, 81, 2, 1581584697, 1581584707),
(59, 49, 69, 3, 1581678650, 1581678781),
(60, 48, 82, 9, 1581929611, 1581929614),
(61, 45, 83, 1, 1581929916, 1581929916),
(62, 45, 84, 1, 1581930836, 1581930836),
(63, 49, 85, 4, 1581930916, 1581931054),
(64, 48, 87, 1, 1581931510, 1581931510),
(65, 45, 89, 2, 1581931898, 1582353334),
(66, 46, 92, 1, 1581933187, 1581933187),
(67, 48, 92, 3, 1581933241, 1581933287),
(68, 45, 92, 1, 1581933299, 1581933299),
(69, 46, 91, 1, 1581933627, 1581933627),
(70, 50, 92, 2, 1581933794, 1581933809),
(71, 48, 91, 1, 1581933939, 1581933939),
(72, 45, 96, 1, 1581934719, 1581934719),
(73, 48, 88, 1, 1581936050, 1581936050),
(74, 45, 99, 1, 1581937569, 1581937569),
(75, 47, 99, 1, 1581938015, 1581938015),
(76, 45, 101, 1, 1581938911, 1581938911),
(77, 48, 101, 1, 1581938979, 1581938979),
(78, 46, 101, 1, 1581939151, 1581939151),
(79, 49, 106, 1, 1581943007, 1581943007),
(80, 45, 112, 1, 1581949299, 1581949299),
(81, 46, 116, 1, 1581951587, 1581951587),
(82, 47, 120, 1, 1581957602, 1581957602),
(83, 45, 120, 1, 1581957697, 1581957697),
(84, 45, 122, 1, 1581971193, 1581971193),
(85, 48, 122, 1, 1581971217, 1581971217),
(86, 45, 123, 1, 1581977197, 1581977197),
(87, 50, 124, 1, 1581980147, 1581980147),
(88, 46, 126, 2, 1581981857, 1581981861),
(89, 45, 129, 2, 1581983286, 1581983299),
(90, 47, 133, 1, 1581991574, 1581991574),
(91, 48, 143, 1, 1581997729, 1581997729),
(92, 47, 145, 1, 1581998598, 1581998598),
(93, 45, 146, 1, 1581998961, 1581998961),
(94, 45, 148, 1, 1581999217, 1581999217),
(95, 45, 150, 1, 1582000548, 1582000548),
(96, 45, 153, 1, 1582002133, 1582002133),
(97, 47, 153, 1, 1582002152, 1582002152),
(98, 46, 154, 2, 1582002158, 1582302551),
(99, 48, 154, 4, 1582002184, 1582002278),
(100, 45, 155, 1, 1582004104, 1582004104),
(101, 45, 156, 2, 1582005161, 1582005320),
(102, 49, 156, 1, 1582005203, 1582005203),
(103, 47, 156, 1, 1582005323, 1582005323),
(104, 48, 157, 2, 1582006128, 1582006526),
(105, 45, 157, 2, 1582006215, 1582006592),
(106, 46, 157, 3, 1582006460, 1582006657),
(107, 50, 158, 1, 1582006575, 1582006575),
(108, 49, 157, 1, 1582006576, 1582006576),
(109, 45, 158, 1, 1582006610, 1582006610),
(110, 47, 158, 1, 1582006620, 1582006620),
(111, 47, 160, 1, 1582007145, 1582007145),
(112, 50, 160, 2, 1582007162, 1582007189),
(113, 45, 161, 1, 1582007659, 1582007659),
(114, 47, 161, 1, 1582007691, 1582007691),
(115, 47, 164, 2, 1582009149, 1582077550),
(116, 48, 167, 1, 1582009911, 1582009911),
(117, 45, 168, 1, 1582010065, 1582010065),
(118, 48, 169, 8, 1582011155, 1582028245),
(119, 45, 169, 7, 1582011312, 1582029816),
(120, 49, 169, 5, 1582011555, 1582029849),
(121, 45, 172, 2, 1582013387, 1582013396),
(122, 47, 172, 1, 1582013406, 1582013406),
(123, 45, 173, 1, 1582013424, 1582013424),
(124, 50, 174, 1, 1582013602, 1582013602),
(125, 47, 169, 2, 1582014152, 1582028709),
(126, 46, 175, 1, 1582014332, 1582014332),
(127, 45, 175, 2, 1582014349, 1582014400),
(128, 48, 175, 1, 1582014414, 1582014414),
(129, 48, 178, 1, 1582015300, 1582015300),
(130, 48, 179, 2, 1582015534, 1582015552),
(131, 45, 182, 2, 1582016689, 1582328715),
(132, 49, 183, 1, 1582017248, 1582017248),
(133, 45, 189, 2, 1582020780, 1582020819),
(134, 50, 88, 2, 1582021397, 1582021418),
(135, 46, 190, 2, 1582021416, 1582021437),
(136, 45, 191, 1, 1582021429, 1582021429),
(137, 48, 190, 1, 1582021460, 1582021460),
(138, 45, 193, 1, 1582022111, 1582022111),
(139, 46, 195, 1, 1582022293, 1582022293),
(140, 45, 196, 1, 1582023167, 1582023167),
(141, 49, 197, 1, 1582023763, 1582023763),
(142, 52, 198, 4, 1582025048, 1582073785),
(143, 48, 199, 2, 1582025095, 1582285174),
(144, 49, 200, 2, 1582025356, 1582026032),
(145, 45, 201, 2, 1582025379, 1582025428),
(146, 52, 200, 7, 1582025476, 1582086574),
(147, 52, 201, 2, 1582025625, 1582025663),
(148, 48, 200, 2, 1582026071, 1582026112),
(149, 46, 205, 2, 1582026109, 1582028579),
(150, 47, 205, 1, 1582026143, 1582026143),
(151, 45, 205, 3, 1582026179, 1582028570),
(152, 52, 65, 23, 1582028456, 1582432314),
(153, 52, 205, 6, 1582028493, 1582197507),
(154, 48, 205, 1, 1582028599, 1582028599),
(155, 52, 169, 1, 1582028713, 1582028713),
(156, 48, 208, 1, 1582028894, 1582028894),
(157, 48, 209, 8, 1582029270, 1582372944),
(158, 52, 209, 13, 1582029326, 1582372932),
(159, 49, 209, 5, 1582029411, 1582372957),
(160, 47, 209, 8, 1582029499, 1582161716),
(161, 46, 169, 1, 1582029805, 1582029805),
(162, 52, 212, 1, 1582029876, 1582029876),
(163, 45, 212, 1, 1582029889, 1582029889),
(164, 45, 209, 7, 1582029929, 1582161767),
(165, 50, 169, 5, 1582030165, 1582342234),
(166, 50, 209, 3, 1582030360, 1582372976),
(167, 48, 214, 1, 1582030361, 1582030361),
(168, 47, 214, 1, 1582030388, 1582030388),
(169, 45, 214, 1, 1582030408, 1582030408),
(170, 52, 215, 1, 1582031072, 1582031072),
(171, 49, 215, 1, 1582031101, 1582031101),
(172, 45, 216, 1, 1582031362, 1582031362),
(173, 47, 216, 1, 1582031374, 1582031374),
(174, 46, 216, 1, 1582031377, 1582031377),
(175, 52, 216, 1, 1582031380, 1582031380),
(176, 45, 217, 1, 1582031650, 1582031650),
(177, 48, 218, 1, 1582032015, 1582032015),
(178, 45, 221, 1, 1582036615, 1582036615),
(179, 47, 200, 1, 1582036748, 1582036748),
(180, 48, 223, 1, 1582036925, 1582036925),
(181, 47, 223, 3, 1582036957, 1582037047),
(182, 49, 223, 1, 1582036974, 1582036974),
(183, 52, 223, 1, 1582037003, 1582037003),
(184, 50, 224, 1, 1582037083, 1582037083),
(185, 52, 224, 1, 1582037093, 1582037093),
(186, 47, 224, 1, 1582037440, 1582037440),
(187, 48, 227, 2, 1582037818, 1582037902),
(188, 49, 227, 3, 1582037829, 1582037896),
(189, 52, 227, 1, 1582037847, 1582037847),
(190, 47, 227, 1, 1582037887, 1582037887),
(191, 45, 227, 1, 1582037955, 1582037955),
(192, 49, 199, 1, 1582042998, 1582042998),
(193, 50, 199, 1, 1582043065, 1582043065),
(194, 48, 228, 3, 1582043675, 1582081781),
(195, 52, 228, 8, 1582043697, 1582105975),
(196, 45, 229, 1, 1582043769, 1582043769),
(197, 46, 228, 1, 1582043777, 1582043777),
(198, 49, 230, 1, 1582044560, 1582044560),
(199, 47, 231, 1, 1582046747, 1582046747),
(200, 45, 232, 2, 1582048275, 1582048288),
(201, 48, 233, 1, 1582059645, 1582059645),
(202, 47, 234, 1, 1582060483, 1582060483),
(203, 46, 234, 2, 1582060493, 1582060500),
(204, 45, 235, 5, 1582067544, 1582292435),
(205, 52, 235, 6, 1582067643, 1582292398),
(206, 52, 236, 1, 1582068931, 1582068931),
(207, 49, 239, 1, 1582070856, 1582070856),
(208, 48, 239, 1, 1582070903, 1582070903),
(209, 45, 240, 1, 1582073001, 1582073001),
(210, 48, 240, 2, 1582073040, 1582073085),
(211, 46, 198, 3, 1582073651, 1582073681),
(212, 47, 198, 2, 1582073725, 1582073817),
(213, 49, 198, 1, 1582073827, 1582073827),
(214, 52, 241, 1, 1582074086, 1582074086),
(215, 47, 243, 1, 1582075210, 1582075210),
(216, 50, 243, 1, 1582075233, 1582075233),
(217, 49, 244, 1, 1582076631, 1582076631),
(218, 52, 244, 1, 1582076661, 1582076661),
(219, 45, 164, 3, 1582077279, 1582077544),
(220, 52, 164, 1, 1582077287, 1582077287),
(221, 48, 164, 2, 1582077398, 1582077587),
(222, 50, 164, 1, 1582077432, 1582077432),
(223, 46, 164, 1, 1582077553, 1582077553),
(224, 48, 245, 3, 1582078834, 1582079056),
(225, 52, 66, 9, 1582078965, 1582358407),
(226, 48, 246, 1, 1582079491, 1582079491),
(227, 47, 246, 1, 1582079509, 1582079509),
(228, 46, 246, 1, 1582079545, 1582079545),
(229, 45, 247, 1, 1582079826, 1582079826),
(230, 48, 251, 2, 1582081191, 1582285702),
(231, 45, 228, 1, 1582081674, 1582081674),
(232, 45, 253, 1, 1582082157, 1582082157),
(233, 52, 253, 1, 1582082161, 1582082161),
(234, 48, 255, 1, 1582082437, 1582082437),
(235, 45, 256, 1, 1582082900, 1582082900),
(236, 46, 258, 1, 1582084684, 1582084684),
(237, 45, 258, 1, 1582084738, 1582084738),
(238, 47, 258, 1, 1582084778, 1582084778),
(239, 45, 259, 1, 1582086202, 1582086202),
(240, 52, 259, 1, 1582086229, 1582086229),
(241, 45, 260, 1, 1582086321, 1582086321),
(242, 46, 200, 1, 1582086625, 1582086625),
(243, 47, 262, 1, 1582087199, 1582087199),
(244, 45, 262, 2, 1582087223, 1582286090),
(245, 52, 262, 11, 1582087229, 1582344575),
(246, 45, 263, 2, 1582087313, 1582087335),
(247, 45, 265, 1, 1582087752, 1582087752),
(248, 45, 264, 2, 1582088078, 1582190482),
(249, 48, 266, 2, 1582088754, 1582088861),
(250, 52, 266, 1, 1582088849, 1582088849),
(251, 48, 267, 1, 1582088926, 1582088926),
(252, 50, 267, 1, 1582088981, 1582088981),
(253, 45, 275, 2, 1582092913, 1582286760),
(254, 48, 275, 1, 1582092931, 1582092931),
(255, 52, 276, 4, 1582093293, 1582093426),
(256, 45, 276, 1, 1582093436, 1582093436),
(257, 47, 276, 2, 1582093448, 1582093518),
(258, 50, 276, 1, 1582093502, 1582093502),
(259, 45, 282, 1, 1582097811, 1582097811),
(260, 48, 283, 1, 1582098223, 1582098223),
(261, 52, 283, 3, 1582098288, 1582098380),
(262, 47, 283, 1, 1582098393, 1582098393),
(263, 52, 284, 2, 1582099759, 1582099808),
(264, 52, 287, 1, 1582101122, 1582101122),
(265, 48, 288, 1, 1582101277, 1582101277),
(266, 50, 288, 1, 1582101288, 1582101288),
(267, 52, 289, 1, 1582101399, 1582101399),
(268, 48, 290, 1, 1582102644, 1582102644),
(269, 47, 292, 1, 1582103705, 1582103705),
(270, 52, 295, 4, 1582104808, 1582286015),
(271, 46, 295, 1, 1582104821, 1582104821),
(272, 48, 295, 2, 1582104841, 1582105211),
(273, 45, 295, 3, 1582104872, 1582105294),
(274, 48, 296, 1, 1582104983, 1582104983),
(275, 47, 296, 1, 1582105002, 1582105002),
(276, 50, 295, 1, 1582105160, 1582105160),
(277, 47, 295, 1, 1582105233, 1582105233),
(278, 48, 297, 3, 1582105296, 1582105714),
(279, 52, 297, 3, 1582105310, 1582105765),
(280, 45, 297, 1, 1582105502, 1582105502),
(281, 49, 297, 1, 1582105567, 1582105567),
(282, 46, 297, 1, 1582105576, 1582105576),
(283, 47, 297, 1, 1582105646, 1582105646),
(284, 48, 298, 1, 1582107749, 1582107749),
(285, 49, 299, 1, 1582109575, 1582109575),
(286, 48, 301, 3, 1582111048, 1582125038),
(287, 45, 302, 1, 1582112728, 1582112728),
(288, 45, 303, 1, 1582113386, 1582113386),
(289, 52, 304, 1, 1582115798, 1582115798),
(290, 48, 304, 1, 1582115808, 1582115808),
(291, 47, 306, 3, 1582117086, 1582117128),
(292, 48, 306, 1, 1582117230, 1582117230),
(293, 45, 304, 2, 1582117549, 1582117561),
(294, 49, 309, 1, 1582121309, 1582121309),
(295, 47, 311, 1, 1582122218, 1582122218),
(296, 48, 313, 1, 1582122973, 1582122973),
(297, 47, 313, 2, 1582123000, 1582177966),
(298, 45, 313, 3, 1582123032, 1582177785),
(299, 47, 235, 5, 1582124046, 1582292449),
(300, 48, 316, 2, 1582124436, 1582124482),
(301, 48, 317, 1, 1582125142, 1582125142),
(302, 45, 199, 1, 1582126117, 1582126117),
(303, 52, 318, 1, 1582126637, 1582126637),
(304, 52, 319, 3, 1582127736, 1582128719),
(305, 45, 319, 1, 1582127831, 1582127831),
(306, 48, 320, 2, 1582128704, 1582129520),
(307, 47, 322, 2, 1582129271, 1582129514),
(308, 48, 322, 1, 1582129297, 1582129297),
(309, 46, 322, 1, 1582129488, 1582129488),
(310, 52, 323, 4, 1582129491, 1582129884),
(311, 45, 320, 1, 1582129536, 1582129536),
(312, 49, 323, 2, 1582129623, 1582129841),
(313, 48, 324, 1, 1582129756, 1582129756),
(314, 52, 326, 4, 1582130967, 1582284984),
(315, 52, 325, 3, 1582130987, 1582391323),
(316, 48, 329, 1, 1582135261, 1582135261),
(317, 49, 329, 1, 1582135324, 1582135324),
(318, 45, 331, 1, 1582157761, 1582157761),
(319, 45, 332, 1, 1582157867, 1582157867),
(320, 52, 331, 1, 1582157891, 1582157891),
(321, 48, 333, 1, 1582157980, 1582157980),
(322, 45, 325, 6, 1582159866, 1582391279),
(323, 46, 209, 4, 1582160219, 1582372832),
(324, 48, 334, 1, 1582160391, 1582160391),
(325, 48, 335, 2, 1582160673, 1582160683),
(326, 48, 336, 1, 1582161365, 1582161365),
(327, 52, 301, 1, 1582161864, 1582161864),
(328, 49, 338, 1, 1582164540, 1582164540),
(329, 48, 338, 1, 1582164567, 1582164567),
(330, 50, 338, 1, 1582164723, 1582164723),
(331, 45, 338, 1, 1582164736, 1582164736),
(332, 45, 340, 1, 1582164889, 1582164889),
(333, 52, 341, 13, 1582165132, 1582273572),
(334, 45, 341, 7, 1582165147, 1582367027),
(335, 46, 341, 1, 1582165158, 1582165158),
(336, 53, 65, 1, 1582165758, 1582165758),
(337, 47, 342, 2, 1582165987, 1582166382),
(338, 52, 342, 1, 1582166010, 1582166010),
(339, 45, 342, 3, 1582166092, 1582167737),
(340, 47, 343, 1, 1582166338, 1582166338),
(341, 48, 342, 1, 1582166363, 1582166363),
(342, 53, 66, 5, 1582166394, 1582254106),
(343, 49, 342, 2, 1582166437, 1582166621),
(344, 52, 346, 1, 1582168176, 1582168176),
(345, 50, 346, 1, 1582168260, 1582168260),
(346, 45, 347, 1, 1582168573, 1582168573),
(347, 46, 349, 1, 1582168749, 1582168749),
(348, 46, 350, 1, 1582169420, 1582169420),
(349, 45, 350, 1, 1582169449, 1582169449),
(350, 45, 351, 1, 1582170067, 1582170067),
(351, 46, 353, 1, 1582171515, 1582171515),
(352, 45, 354, 1, 1582172543, 1582172543),
(353, 47, 355, 2, 1582172945, 1582285222),
(354, 45, 357, 2, 1582174014, 1582174036),
(355, 49, 358, 1, 1582174182, 1582174182),
(356, 48, 359, 2, 1582174378, 1582174394),
(357, 48, 361, 1, 1582175959, 1582175959),
(358, 52, 362, 1, 1582177006, 1582177006),
(359, 46, 363, 1, 1582177033, 1582177033),
(360, 52, 363, 1, 1582177060, 1582177060),
(361, 45, 364, 2, 1582177268, 1582177292),
(362, 48, 364, 1, 1582177305, 1582177305),
(363, 47, 365, 1, 1582177583, 1582177583),
(364, 46, 365, 1, 1582177604, 1582177604),
(365, 48, 366, 1, 1582177604, 1582177604),
(366, 49, 313, 1, 1582177817, 1582177817),
(367, 53, 313, 1, 1582177904, 1582177904),
(368, 48, 367, 1, 1582178667, 1582178667),
(369, 45, 367, 1, 1582178705, 1582178705),
(370, 52, 369, 3, 1582179718, 1582179788),
(371, 48, 370, 1, 1582179785, 1582179785),
(372, 47, 369, 1, 1582179797, 1582179797),
(373, 46, 369, 2, 1582179839, 1582179879),
(374, 47, 371, 2, 1582180135, 1582180256),
(375, 48, 371, 1, 1582180208, 1582180208),
(376, 52, 67, 3, 1582180587, 1582181129),
(377, 53, 67, 2, 1582180680, 1582181124),
(378, 54, 66, 2, 1582180962, 1582181161),
(379, 54, 67, 6, 1582181037, 1582181233),
(380, 52, 373, 1, 1582182046, 1582182046),
(381, 48, 374, 1, 1582182433, 1582182433),
(382, 50, 374, 1, 1582182472, 1582182472),
(383, 49, 376, 1, 1582183943, 1582183943),
(384, 45, 381, 1, 1582186657, 1582186657),
(385, 45, 380, 2, 1582186671, 1582186790),
(386, 52, 381, 1, 1582186828, 1582186828),
(387, 46, 382, 1, 1582187926, 1582187926),
(388, 45, 385, 1, 1582189119, 1582189119),
(389, 46, 385, 1, 1582189172, 1582189172),
(390, 54, 386, 1, 1582190082, 1582190082),
(391, 46, 386, 1, 1582190089, 1582190089),
(392, 45, 388, 1, 1582191051, 1582191051),
(393, 52, 390, 1, 1582192475, 1582192475),
(394, 52, 242, 1, 1582193170, 1582193170),
(395, 49, 242, 1, 1582193206, 1582193206),
(396, 54, 242, 2, 1582193217, 1582366690),
(397, 52, 391, 1, 1582194704, 1582194704),
(398, 45, 394, 2, 1582195807, 1582213093),
(399, 52, 392, 4, 1582197637, 1582197714),
(400, 48, 392, 1, 1582197878, 1582197878),
(401, 54, 397, 3, 1582200072, 1582204804),
(402, 52, 398, 1, 1582201867, 1582201867),
(403, 45, 398, 1, 1582201900, 1582201900),
(404, 52, 399, 1, 1582204304, 1582204304),
(405, 52, 397, 1, 1582204778, 1582204778),
(406, 45, 397, 1, 1582204807, 1582204807),
(407, 45, 401, 1, 1582205221, 1582205221),
(408, 50, 341, 3, 1582205240, 1582273061),
(409, 47, 401, 1, 1582205257, 1582205257),
(410, 52, 401, 2, 1582205270, 1582205299),
(411, 47, 341, 1, 1582205317, 1582205317),
(412, 52, 404, 1, 1582207810, 1582207810),
(413, 45, 405, 1, 1582208379, 1582208379),
(414, 45, 407, 1, 1582209822, 1582209822),
(415, 52, 409, 1, 1582210060, 1582210060),
(416, 52, 410, 1, 1582210092, 1582210092),
(417, 49, 409, 1, 1582210107, 1582210107),
(418, 54, 394, 1, 1582213101, 1582213101),
(419, 45, 400, 3, 1582215361, 1582249949),
(420, 52, 400, 3, 1582215399, 1582250010),
(421, 52, 414, 1, 1582218113, 1582218113),
(422, 45, 415, 1, 1582218208, 1582218208),
(423, 46, 415, 1, 1582218224, 1582218224),
(424, 48, 415, 1, 1582218254, 1582218254),
(425, 52, 415, 2, 1582218262, 1582218276),
(426, 52, 416, 4, 1582219559, 1582228609),
(427, 49, 416, 1, 1582219595, 1582219595),
(428, 48, 416, 2, 1582219688, 1582221163),
(429, 45, 416, 1, 1582219738, 1582219738),
(430, 53, 416, 3, 1582219748, 1582292602),
(431, 46, 416, 3, 1582219753, 1582221148),
(432, 50, 416, 1, 1582221153, 1582221153),
(433, 54, 416, 1, 1582221301, 1582221301),
(434, 54, 417, 1, 1582222582, 1582222582),
(435, 48, 418, 1, 1582227957, 1582227957),
(436, 45, 420, 1, 1582246036, 1582246036),
(437, 52, 422, 1, 1582248985, 1582248985),
(438, 54, 272, 1, 1582250363, 1582250363),
(439, 53, 423, 1, 1582250648, 1582250648),
(440, 52, 425, 1, 1582251351, 1582251351),
(441, 49, 425, 1, 1582251418, 1582251418),
(442, 52, 426, 1, 1582251517, 1582251517),
(443, 52, 430, 1, 1582256794, 1582256794),
(444, 52, 431, 1, 1582257317, 1582257317),
(445, 45, 431, 1, 1582257341, 1582257341),
(446, 55, 431, 1, 1582257364, 1582257364),
(447, 45, 434, 1, 1582260232, 1582260232),
(448, 45, 435, 1, 1582260904, 1582260904),
(449, 47, 443, 1, 1582269477, 1582269477),
(450, 45, 443, 2, 1582269503, 1582285309),
(451, 48, 443, 1, 1582269518, 1582269518),
(452, 55, 443, 1, 1582269523, 1582269523),
(453, 48, 444, 2, 1582270452, 1582270470),
(454, 52, 429, 1, 1582270938, 1582270938),
(455, 52, 445, 2, 1582272356, 1582272373),
(456, 49, 341, 1, 1582273141, 1582273141),
(457, 48, 341, 4, 1582273472, 1582366985),
(458, 55, 341, 1, 1582273602, 1582273602),
(459, 45, 241, 1, 1582273882, 1582273882),
(460, 52, 446, 2, 1582275223, 1582275250),
(461, 45, 446, 1, 1582275265, 1582275265),
(462, 45, 447, 2, 1582276328, 1582276356),
(463, 48, 369, 1, 1582277009, 1582277009),
(464, 45, 448, 1, 1582277051, 1582277051),
(465, 52, 77, 1, 1582280384, 1582280384),
(466, 52, 453, 1, 1582282460, 1582282460),
(467, 52, 456, 3, 1582283059, 1582283162),
(468, 53, 456, 1, 1582283143, 1582283143),
(469, 46, 456, 1, 1582283150, 1582283150),
(470, 47, 456, 1, 1582283234, 1582283234),
(471, 52, 457, 1, 1582284446, 1582284446),
(472, 54, 457, 1, 1582284500, 1582284500),
(473, 52, 459, 1, 1582284899, 1582284899),
(474, 45, 458, 1, 1582284903, 1582284903),
(475, 52, 462, 5, 1582284916, 1582284977),
(476, 55, 462, 1, 1582284923, 1582284923),
(477, 53, 465, 1, 1582284935, 1582284935),
(478, 45, 466, 1, 1582284944, 1582284944),
(479, 54, 464, 1, 1582284944, 1582284944),
(480, 55, 465, 1, 1582284946, 1582284946),
(481, 54, 470, 1, 1582284955, 1582284955),
(482, 52, 467, 1, 1582284956, 1582284956),
(483, 48, 466, 1, 1582284964, 1582284964),
(484, 52, 470, 2, 1582284969, 1582340268),
(485, 54, 468, 1, 1582284974, 1582284974),
(486, 45, 471, 1, 1582284981, 1582284981),
(487, 46, 462, 1, 1582284982, 1582284982),
(488, 52, 475, 1, 1582284985, 1582284985),
(489, 55, 471, 1, 1582284989, 1582284989),
(490, 52, 478, 2, 1582284990, 1582285026),
(491, 45, 474, 1, 1582284991, 1582284991),
(492, 52, 476, 1, 1582284992, 1582284992),
(493, 53, 468, 1, 1582284997, 1582284997),
(494, 52, 480, 1, 1582285002, 1582285002),
(495, 52, 471, 1, 1582285002, 1582285002),
(496, 45, 479, 1, 1582285005, 1582285005),
(497, 52, 483, 1, 1582285008, 1582285008),
(498, 52, 468, 1, 1582285009, 1582285009),
(499, 53, 482, 1, 1582285010, 1582285010),
(500, 52, 199, 5, 1582285011, 1582285146),
(501, 50, 478, 2, 1582285011, 1582285055),
(502, 45, 482, 1, 1582285020, 1582285020),
(503, 45, 480, 1, 1582285021, 1582285021),
(504, 45, 484, 1, 1582285026, 1582285026),
(505, 52, 466, 1, 1582285028, 1582285028),
(506, 48, 486, 1, 1582285031, 1582285031),
(507, 53, 481, 1, 1582285034, 1582285034),
(508, 52, 487, 1, 1582285045, 1582285045),
(509, 52, 488, 1, 1582285047, 1582285047),
(510, 53, 478, 1, 1582285048, 1582285048),
(511, 45, 481, 1, 1582285050, 1582285050),
(512, 45, 485, 1, 1582285059, 1582285059),
(513, 54, 488, 1, 1582285060, 1582285060),
(514, 54, 480, 1, 1582285063, 1582285063),
(515, 52, 492, 2, 1582285076, 1582285084),
(516, 52, 485, 2, 1582285076, 1582285168),
(517, 45, 493, 1, 1582285081, 1582285081),
(518, 55, 487, 1, 1582285088, 1582285088),
(519, 53, 480, 2, 1582285093, 1582285117),
(520, 52, 493, 1, 1582285099, 1582285099),
(521, 49, 480, 1, 1582285104, 1582285104),
(522, 52, 496, 2, 1582285123, 1582285147),
(523, 45, 495, 1, 1582285124, 1582285124),
(524, 55, 497, 1, 1582285128, 1582285128),
(525, 52, 498, 1, 1582285132, 1582285132),
(526, 52, 500, 2, 1582285132, 1582295781),
(527, 52, 497, 1, 1582285139, 1582285139),
(528, 52, 443, 1, 1582285141, 1582285141),
(529, 53, 501, 1, 1582285146, 1582285146),
(530, 46, 496, 1, 1582285152, 1582285152),
(531, 47, 499, 1, 1582285153, 1582285153),
(532, 52, 501, 3, 1582285155, 1582285191),
(533, 54, 501, 1, 1582285168, 1582285168),
(534, 54, 503, 1, 1582285168, 1582285168),
(535, 52, 502, 1, 1582285174, 1582285174),
(536, 45, 501, 1, 1582285178, 1582285178),
(537, 52, 505, 4, 1582285183, 1582383364),
(538, 45, 506, 5, 1582285183, 1582286024),
(539, 52, 503, 4, 1582285191, 1582285272),
(540, 52, 508, 1, 1582285193, 1582285193),
(541, 45, 509, 1, 1582285196, 1582285196),
(542, 52, 506, 5, 1582285197, 1582286034),
(543, 46, 199, 1, 1582285198, 1582285198),
(544, 47, 496, 1, 1582285201, 1582285201),
(545, 50, 354, 1, 1582285207, 1582285207),
(546, 45, 507, 1, 1582285210, 1582285210),
(547, 52, 512, 2, 1582285212, 1582285671),
(548, 52, 511, 2, 1582285214, 1582285397),
(549, 52, 513, 2, 1582285216, 1582285292),
(550, 52, 509, 1, 1582285221, 1582285221),
(551, 45, 505, 1, 1582285225, 1582285225),
(552, 45, 514, 1, 1582285229, 1582285229),
(553, 46, 509, 1, 1582285230, 1582285230),
(554, 47, 505, 3, 1582285233, 1582285243),
(555, 52, 516, 1, 1582285239, 1582285239),
(556, 46, 511, 3, 1582285239, 1582285348),
(557, 48, 506, 1, 1582285239, 1582285239),
(558, 52, 515, 2, 1582285242, 1582285259),
(559, 52, 519, 1, 1582285245, 1582285245),
(560, 55, 517, 1, 1582285247, 1582285247),
(561, 54, 443, 2, 1582285247, 1582285367),
(562, 55, 514, 1, 1582285248, 1582285248),
(563, 52, 520, 2, 1582285250, 1582285291),
(564, 52, 494, 1, 1582285252, 1582285252),
(565, 52, 521, 1, 1582285254, 1582285254),
(566, 49, 524, 1, 1582285258, 1582285258),
(567, 54, 516, 1, 1582285259, 1582285259),
(568, 50, 496, 1, 1582285266, 1582285266),
(569, 55, 523, 1, 1582285272, 1582285272),
(570, 55, 526, 2, 1582285273, 1582285277),
(571, 52, 529, 1, 1582285273, 1582285273),
(572, 52, 524, 6, 1582285275, 1582288134),
(573, 45, 525, 1, 1582285281, 1582285281),
(574, 45, 510, 3, 1582285283, 1582292873),
(575, 52, 534, 1, 1582285285, 1582285285),
(576, 45, 529, 1, 1582285285, 1582285285),
(577, 45, 530, 1, 1582285286, 1582285286),
(578, 52, 528, 5, 1582285287, 1582285377),
(579, 45, 535, 1, 1582285290, 1582285290),
(580, 47, 526, 1, 1582285291, 1582285291),
(581, 54, 533, 1, 1582285291, 1582285291),
(582, 48, 503, 1, 1582285293, 1582285293),
(583, 54, 535, 1, 1582285300, 1582285300),
(584, 53, 520, 1, 1582285300, 1582285300),
(585, 54, 520, 3, 1582285308, 1582285394),
(586, 45, 537, 1, 1582285309, 1582285309),
(587, 52, 510, 3, 1582285313, 1582292793),
(588, 52, 538, 3, 1582285316, 1582285339),
(589, 54, 537, 2, 1582285319, 1582285334),
(590, 53, 457, 1, 1582285337, 1582285337),
(591, 45, 543, 2, 1582285349, 1582285501),
(592, 47, 542, 2, 1582285354, 1582285851),
(593, 55, 539, 1, 1582285355, 1582285355),
(594, 52, 525, 4, 1582285357, 1582304712),
(595, 52, 533, 1, 1582285362, 1582285362),
(596, 48, 545, 1, 1582285363, 1582285363),
(597, 52, 541, 1, 1582285363, 1582285363),
(598, 52, 544, 1, 1582285365, 1582285365),
(599, 47, 546, 2, 1582285366, 1582285387),
(600, 55, 543, 1, 1582285368, 1582285368),
(601, 45, 542, 1, 1582285368, 1582285368),
(602, 47, 511, 1, 1582285369, 1582285369),
(603, 48, 547, 1, 1582285372, 1582285372),
(604, 45, 548, 1, 1582285376, 1582285376),
(605, 54, 544, 1, 1582285379, 1582285379),
(606, 45, 520, 1, 1582285380, 1582285380),
(607, 47, 549, 2, 1582285382, 1582285431),
(608, 54, 543, 1, 1582285382, 1582285382),
(609, 52, 542, 6, 1582285386, 1582285847),
(610, 55, 546, 1, 1582285399, 1582285399),
(611, 45, 550, 1, 1582285400, 1582285400),
(612, 52, 543, 1, 1582285405, 1582285405),
(613, 52, 553, 1, 1582285407, 1582285407),
(614, 52, 556, 1, 1582285410, 1582285410),
(615, 52, 539, 2, 1582285417, 1582285424),
(616, 50, 505, 1, 1582285420, 1582285420),
(617, 48, 526, 1, 1582285422, 1582285422),
(618, 52, 557, 1, 1582285426, 1582285426),
(619, 55, 560, 1, 1582285435, 1582285435),
(620, 45, 551, 1, 1582285440, 1582285440),
(621, 48, 557, 1, 1582285440, 1582285440),
(622, 45, 553, 1, 1582285441, 1582285441),
(623, 48, 542, 4, 1582285442, 1582285961),
(624, 45, 559, 1, 1582285445, 1582285445),
(625, 49, 549, 1, 1582285445, 1582285445),
(626, 53, 561, 1, 1582285446, 1582285446),
(627, 45, 557, 1, 1582285452, 1582285452),
(628, 52, 549, 2, 1582285452, 1582285483),
(629, 54, 563, 1, 1582285457, 1582285457),
(630, 47, 562, 2, 1582285458, 1582285492),
(631, 52, 565, 4, 1582285462, 1582285723),
(632, 52, 566, 1, 1582285472, 1582285472),
(633, 55, 558, 1, 1582285475, 1582285475),
(634, 52, 568, 1, 1582285476, 1582285476),
(635, 52, 567, 2, 1582285482, 1582285528),
(636, 45, 565, 3, 1582285482, 1582285646),
(637, 47, 555, 1, 1582285489, 1582285489),
(638, 49, 565, 2, 1582285489, 1582349924),
(639, 53, 558, 1, 1582285492, 1582285492),
(640, 49, 527, 2, 1582285500, 1582285525),
(641, 52, 569, 2, 1582285503, 1582290733),
(642, 52, 559, 1, 1582285506, 1582285506),
(643, 52, 558, 3, 1582285507, 1582287112),
(644, 46, 535, 1, 1582285509, 1582285509),
(645, 49, 560, 1, 1582285511, 1582285511),
(646, 45, 572, 2, 1582285516, 1582285535),
(647, 46, 559, 1, 1582285525, 1582285525),
(648, 52, 527, 3, 1582285540, 1582286799),
(649, 52, 573, 1, 1582285541, 1582285541),
(650, 52, 570, 1, 1582285542, 1582285542),
(651, 48, 567, 1, 1582285544, 1582285544),
(652, 52, 572, 1, 1582285554, 1582285554),
(653, 45, 569, 1, 1582285555, 1582285555),
(654, 47, 565, 2, 1582285558, 1582285713),
(655, 54, 505, 1, 1582285567, 1582285567),
(656, 52, 574, 5, 1582285570, 1582285672),
(657, 46, 573, 1, 1582285572, 1582285572),
(658, 52, 576, 5, 1582285575, 1582310874),
(659, 52, 575, 1, 1582285580, 1582285580),
(660, 45, 575, 1, 1582285601, 1582285601),
(661, 50, 542, 1, 1582285605, 1582285605),
(662, 52, 555, 1, 1582285606, 1582285606),
(663, 48, 578, 1, 1582285607, 1582285607),
(664, 48, 512, 2, 1582285609, 1582285627),
(665, 52, 579, 1, 1582285610, 1582285610),
(666, 53, 175, 1, 1582285612, 1582285612),
(667, 54, 576, 1, 1582285617, 1582285617),
(668, 52, 580, 1, 1582285622, 1582285622),
(669, 53, 565, 2, 1582285624, 1582285633),
(670, 48, 581, 1, 1582285632, 1582285632),
(671, 54, 579, 1, 1582285632, 1582285632),
(672, 46, 527, 1, 1582285633, 1582285633),
(673, 52, 584, 3, 1582285634, 1582285654),
(674, 49, 512, 1, 1582285636, 1582285636),
(675, 52, 583, 1, 1582285639, 1582285639),
(676, 54, 565, 1, 1582285639, 1582285639),
(677, 49, 555, 1, 1582285645, 1582285645),
(678, 45, 579, 1, 1582285650, 1582285650),
(679, 46, 583, 1, 1582285652, 1582285652),
(680, 46, 565, 3, 1582285653, 1582285716),
(681, 52, 587, 9, 1582285662, 1582385417),
(682, 48, 575, 1, 1582285670, 1582285670),
(683, 54, 588, 1, 1582285671, 1582285671),
(684, 48, 585, 3, 1582285678, 1582285712),
(685, 52, 251, 2, 1582285680, 1582285734),
(686, 54, 586, 1, 1582285682, 1582285682),
(687, 47, 579, 1, 1582285684, 1582285684),
(688, 52, 588, 2, 1582285686, 1582343346),
(689, 45, 590, 1, 1582285686, 1582285686),
(690, 52, 560, 5, 1582285687, 1582286989),
(691, 45, 591, 1, 1582285692, 1582285692),
(692, 53, 589, 1, 1582285694, 1582285694),
(693, 55, 587, 2, 1582285702, 1582385427),
(694, 45, 580, 1, 1582285702, 1582285702),
(695, 52, 592, 2, 1582285715, 1582285788),
(696, 45, 585, 1, 1582285719, 1582285719),
(697, 54, 580, 1, 1582285721, 1582285721),
(698, 54, 251, 1, 1582285722, 1582285722),
(699, 52, 595, 2, 1582285733, 1582334586),
(700, 52, 585, 1, 1582285738, 1582285738),
(701, 45, 251, 1, 1582285738, 1582285738),
(702, 55, 565, 6, 1582285741, 1582350557),
(703, 54, 542, 2, 1582285741, 1582285762),
(704, 45, 588, 1, 1582285744, 1582285744),
(705, 52, 598, 1, 1582285746, 1582285746),
(706, 49, 592, 1, 1582285752, 1582285752),
(707, 45, 594, 1, 1582285754, 1582285754),
(708, 52, 590, 2, 1582285760, 1582285833),
(709, 52, 596, 1, 1582285761, 1582285761),
(710, 45, 597, 1, 1582285772, 1582285772),
(711, 52, 599, 3, 1582285783, 1582302126),
(712, 52, 603, 1, 1582285784, 1582285784),
(713, 49, 587, 5, 1582285799, 1582385451),
(714, 52, 604, 1, 1582285809, 1582285809),
(715, 45, 593, 2, 1582285847, 1582341893),
(716, 45, 606, 2, 1582285851, 1582285872),
(717, 55, 564, 1, 1582285851, 1582285851),
(718, 47, 564, 1, 1582285860, 1582285860),
(719, 47, 593, 1, 1582285861, 1582285861),
(720, 50, 587, 1, 1582285875, 1582285875),
(721, 54, 590, 1, 1582285879, 1582285879),
(722, 55, 606, 1, 1582285891, 1582285891),
(723, 53, 506, 1, 1582285895, 1582285895),
(724, 46, 542, 3, 1582285898, 1582286245),
(725, 54, 606, 1, 1582285900, 1582285900),
(726, 52, 606, 2, 1582285913, 1582285998),
(727, 55, 607, 1, 1582285965, 1582285965),
(728, 53, 609, 1, 1582285974, 1582285974),
(729, 45, 607, 1, 1582285979, 1582285979),
(730, 47, 607, 1, 1582285994, 1582285994),
(731, 45, 609, 1, 1582285996, 1582285996),
(732, 52, 609, 1, 1582286006, 1582286006),
(733, 54, 611, 1, 1582286025, 1582286025),
(734, 52, 611, 2, 1582286058, 1582286150),
(735, 46, 587, 1, 1582286075, 1582286075),
(736, 45, 612, 1, 1582286078, 1582286078),
(737, 55, 614, 1, 1582286084, 1582286084),
(738, 52, 616, 1, 1582286097, 1582286097),
(739, 52, 610, 1, 1582286106, 1582286106),
(740, 45, 608, 1, 1582286115, 1582286115),
(741, 45, 614, 1, 1582286116, 1582286116),
(742, 55, 262, 2, 1582286119, 1582344583),
(743, 52, 614, 1, 1582286131, 1582286131),
(744, 45, 617, 1, 1582286135, 1582286135),
(745, 45, 618, 1, 1582286138, 1582286138),
(746, 53, 167, 2, 1582286149, 1582286181),
(747, 45, 621, 1, 1582286150, 1582286150),
(748, 55, 620, 1, 1582286151, 1582286151),
(749, 52, 622, 5, 1582286153, 1582286306),
(750, 52, 621, 1, 1582286178, 1582286178),
(751, 47, 618, 2, 1582286194, 1582286217),
(752, 45, 619, 1, 1582286199, 1582286199),
(753, 47, 608, 3, 1582286204, 1582288434),
(754, 52, 620, 6, 1582286209, 1582306754),
(755, 45, 623, 2, 1582286212, 1582286265),
(756, 55, 619, 1, 1582286216, 1582286216),
(757, 45, 622, 1, 1582286219, 1582286219),
(758, 52, 608, 6, 1582286237, 1582288670),
(759, 53, 622, 1, 1582286255, 1582286255),
(760, 47, 623, 1, 1582286257, 1582286257),
(761, 45, 625, 1, 1582286260, 1582286260),
(762, 49, 622, 1, 1582286262, 1582286262),
(763, 48, 622, 1, 1582286274, 1582286274),
(764, 54, 528, 1, 1582286275, 1582286275),
(765, 54, 167, 1, 1582286282, 1582286282),
(766, 45, 628, 1, 1582286283, 1582286283),
(767, 54, 629, 1, 1582286310, 1582286310),
(768, 55, 167, 1, 1582286321, 1582286321),
(769, 52, 629, 1, 1582286322, 1582286322),
(770, 47, 622, 1, 1582286324, 1582286324),
(771, 47, 629, 1, 1582286340, 1582286340),
(772, 54, 622, 1, 1582286355, 1582286355),
(773, 55, 625, 1, 1582286359, 1582286359),
(774, 45, 631, 2, 1582286365, 1582286374),
(775, 52, 624, 5, 1582286366, 1582286534),
(776, 52, 630, 1, 1582286367, 1582286367),
(777, 46, 167, 1, 1582286373, 1582286373),
(778, 53, 624, 1, 1582286378, 1582286378),
(779, 45, 632, 1, 1582286381, 1582286381),
(780, 52, 633, 8, 1582286409, 1582370945),
(781, 52, 625, 4, 1582286412, 1582286559),
(782, 52, 635, 1, 1582286440, 1582286440),
(783, 45, 587, 1, 1582286440, 1582286440),
(784, 52, 636, 1, 1582286447, 1582286447),
(785, 52, 638, 1, 1582286464, 1582286464),
(786, 48, 637, 3, 1582286464, 1582367666),
(787, 45, 636, 1, 1582286474, 1582286474),
(788, 53, 638, 1, 1582286480, 1582286480),
(789, 52, 640, 1, 1582286489, 1582286489),
(790, 53, 633, 2, 1582286511, 1582303154),
(791, 55, 561, 1, 1582286512, 1582286512),
(792, 48, 633, 2, 1582286523, 1582286558),
(793, 45, 644, 1, 1582286548, 1582286548),
(794, 45, 643, 1, 1582286550, 1582286550),
(795, 45, 646, 2, 1582286592, 1582289046),
(796, 47, 648, 1, 1582286603, 1582286603),
(797, 49, 625, 1, 1582286621, 1582286621),
(798, 45, 649, 1, 1582286638, 1582286638),
(799, 52, 131, 1, 1582286645, 1582286645),
(800, 53, 652, 1, 1582286647, 1582286647),
(801, 52, 651, 2, 1582286649, 1582286717),
(802, 48, 642, 2, 1582286669, 1582286691),
(803, 54, 131, 1, 1582286677, 1582286677),
(804, 55, 653, 1, 1582286677, 1582286677),
(805, 54, 649, 1, 1582286677, 1582286677),
(806, 52, 654, 1, 1582286684, 1582286684),
(807, 54, 651, 1, 1582286700, 1582286700),
(808, 48, 653, 1, 1582286700, 1582286700),
(809, 46, 625, 1, 1582286711, 1582286711),
(810, 52, 275, 1, 1582286714, 1582286714),
(811, 45, 651, 1, 1582286733, 1582286733),
(812, 54, 653, 1, 1582286734, 1582286734),
(813, 52, 655, 4, 1582286737, 1582287069),
(814, 52, 642, 1, 1582286740, 1582286740),
(815, 52, 653, 1, 1582286752, 1582286752),
(816, 45, 650, 1, 1582286811, 1582286811),
(817, 54, 650, 2, 1582286824, 1582286836),
(818, 52, 650, 1, 1582286842, 1582286842),
(819, 48, 560, 3, 1582286852, 1582286923),
(820, 48, 655, 1, 1582286891, 1582286891),
(821, 54, 560, 1, 1582286901, 1582286901),
(822, 48, 656, 1, 1582286906, 1582286906),
(823, 54, 657, 1, 1582286908, 1582286908),
(824, 45, 658, 2, 1582286908, 1582286955),
(825, 52, 646, 4, 1582286913, 1582429123),
(826, 52, 657, 1, 1582286923, 1582286923),
(827, 47, 656, 1, 1582286925, 1582286925),
(828, 52, 658, 1, 1582286928, 1582286928),
(829, 52, 660, 2, 1582286934, 1582286973),
(830, 47, 560, 1, 1582286940, 1582286940),
(831, 55, 661, 2, 1582286957, 1582286982),
(832, 54, 661, 1, 1582286969, 1582286969),
(833, 53, 661, 1, 1582286986, 1582286986),
(834, 48, 661, 1, 1582287009, 1582287009),
(835, 50, 660, 1, 1582287014, 1582287014),
(836, 45, 661, 1, 1582287019, 1582287019),
(837, 46, 661, 1, 1582287026, 1582287026),
(838, 45, 660, 1, 1582287029, 1582287029),
(839, 45, 637, 13, 1582287041, 1582369073),
(840, 55, 660, 1, 1582287055, 1582287055),
(841, 52, 637, 10, 1582287064, 1582344872),
(842, 50, 663, 2, 1582287064, 1582287130),
(843, 48, 558, 2, 1582287071, 1582287089),
(844, 48, 665, 1, 1582287128, 1582287128),
(845, 46, 663, 1, 1582287172, 1582287172),
(846, 45, 667, 1, 1582287231, 1582287231),
(847, 55, 667, 2, 1582287248, 1582287271),
(848, 52, 670, 1, 1582287268, 1582287268),
(849, 53, 669, 1, 1582287272, 1582287272),
(850, 52, 671, 2, 1582287282, 1582287308),
(851, 54, 669, 1, 1582287283, 1582287283),
(852, 52, 672, 1, 1582287302, 1582287302),
(853, 52, 673, 1, 1582287346, 1582287346),
(854, 47, 674, 1, 1582287366, 1582287366),
(855, 52, 659, 1, 1582287399, 1582287399),
(856, 45, 659, 1, 1582287428, 1582287428),
(857, 45, 676, 1, 1582287490, 1582287490),
(858, 46, 676, 1, 1582287516, 1582287516),
(859, 48, 676, 1, 1582287557, 1582287557),
(860, 53, 676, 1, 1582287569, 1582287569),
(861, 53, 678, 1, 1582287571, 1582287571),
(862, 53, 72, 1, 1582287593, 1582287593),
(863, 55, 72, 1, 1582287601, 1582287601),
(864, 46, 679, 1, 1582287602, 1582287602),
(865, 52, 72, 1, 1582287635, 1582287635),
(866, 54, 680, 2, 1582287646, 1582287804),
(867, 52, 680, 3, 1582287653, 1582287773),
(868, 53, 683, 1, 1582287700, 1582287700),
(869, 45, 685, 1, 1582287710, 1582287710),
(870, 52, 589, 1, 1582287721, 1582287721),
(871, 52, 685, 1, 1582287731, 1582287731),
(872, 50, 682, 1, 1582287749, 1582287749),
(873, 48, 608, 1, 1582287800, 1582287800),
(874, 47, 680, 1, 1582287814, 1582287814),
(875, 52, 689, 2, 1582287832, 1582287847),
(876, 52, 693, 3, 1582287848, 1582288049),
(877, 45, 694, 2, 1582287855, 1582287869),
(878, 45, 687, 1, 1582287866, 1582287866),
(879, 45, 692, 2, 1582287866, 1582287902),
(880, 47, 689, 1, 1582287880, 1582287880),
(881, 52, 695, 3, 1582287886, 1582288014),
(882, 54, 694, 1, 1582287887, 1582287887),
(883, 52, 696, 1, 1582287906, 1582287906),
(884, 48, 696, 1, 1582287918, 1582287918),
(885, 52, 552, 1, 1582287943, 1582287943),
(886, 53, 552, 1, 1582287956, 1582287956),
(887, 49, 699, 1, 1582287978, 1582287978),
(888, 53, 700, 1, 1582287984, 1582287984),
(889, 55, 700, 1, 1582287999, 1582287999),
(890, 52, 701, 1, 1582288005, 1582288005),
(891, 54, 693, 2, 1582288010, 1582288058),
(892, 49, 692, 1, 1582288022, 1582288022),
(893, 45, 700, 1, 1582288024, 1582288024),
(894, 47, 695, 1, 1582288034, 1582288034),
(895, 53, 608, 3, 1582288037, 1582288664),
(896, 45, 701, 1, 1582288037, 1582288037),
(897, 53, 702, 1, 1582288040, 1582288040),
(898, 48, 700, 1, 1582288042, 1582288042),
(899, 53, 217, 1, 1582288061, 1582288061),
(900, 50, 695, 1, 1582288070, 1582288070),
(901, 45, 704, 1, 1582288076, 1582288076),
(902, 54, 524, 1, 1582288091, 1582288091),
(903, 52, 704, 1, 1582288098, 1582288098),
(904, 53, 705, 1, 1582288142, 1582288142),
(905, 54, 705, 2, 1582288153, 1582288237),
(906, 50, 608, 1, 1582288157, 1582288157),
(907, 52, 706, 3, 1582288183, 1582288241),
(908, 46, 524, 1, 1582288199, 1582288199),
(909, 49, 669, 1, 1582288276, 1582288276),
(910, 55, 608, 1, 1582288278, 1582288278),
(911, 52, 290, 1, 1582288296, 1582288296),
(912, 54, 608, 1, 1582288311, 1582288311),
(913, 55, 711, 1, 1582288328, 1582288328),
(914, 54, 713, 1, 1582288341, 1582288341),
(915, 53, 713, 1, 1582288355, 1582288355),
(916, 48, 686, 1, 1582288455, 1582288455),
(917, 53, 686, 1, 1582288471, 1582288471),
(918, 45, 686, 1, 1582288494, 1582288494),
(919, 48, 716, 1, 1582288497, 1582288497),
(920, 53, 715, 1, 1582288498, 1582288498),
(921, 52, 715, 7, 1582288504, 1582289435),
(922, 47, 686, 3, 1582288504, 1582288542),
(923, 52, 717, 5, 1582288509, 1582288627),
(924, 55, 717, 1, 1582288520, 1582288520),
(925, 45, 716, 8, 1582288530, 1582289469),
(926, 53, 719, 1, 1582288532, 1582288532),
(927, 52, 718, 1, 1582288534, 1582288534),
(928, 54, 719, 2, 1582288543, 1582288569),
(929, 45, 717, 1, 1582288545, 1582288545),
(930, 55, 718, 1, 1582288561, 1582288561),
(931, 52, 716, 1, 1582288566, 1582288566),
(932, 52, 686, 3, 1582288568, 1582288619),
(933, 46, 717, 2, 1582288638, 1582288671),
(934, 48, 715, 1, 1582288644, 1582288644),
(935, 54, 708, 1, 1582288671, 1582288671),
(936, 55, 721, 1, 1582288675, 1582288675),
(937, 52, 722, 3, 1582288685, 1582288796),
(938, 46, 715, 1, 1582288695, 1582288695),
(939, 48, 682, 1, 1582288700, 1582288700),
(940, 48, 718, 1, 1582288707, 1582288707),
(941, 52, 682, 1, 1582288712, 1582288712),
(942, 52, 721, 2, 1582288719, 1582289056),
(943, 46, 723, 1, 1582288722, 1582288722),
(944, 52, 724, 5, 1582288724, 1582373320),
(945, 48, 721, 3, 1582288737, 1582289082),
(946, 55, 724, 1, 1582288738, 1582288738),
(947, 45, 718, 1, 1582288740, 1582288740),
(948, 46, 724, 3, 1582288780, 1582373328),
(949, 46, 608, 2, 1582288789, 1582288809),
(950, 54, 726, 1, 1582288815, 1582288815),
(951, 52, 725, 2, 1582288834, 1582288923),
(952, 53, 728, 1, 1582288840, 1582288840),
(953, 52, 728, 1, 1582288852, 1582288852),
(954, 55, 729, 1, 1582288874, 1582288874),
(955, 50, 723, 3, 1582288875, 1582288931),
(956, 48, 729, 2, 1582288883, 1582288916),
(957, 55, 730, 1, 1582288889, 1582288889),
(958, 52, 729, 3, 1582288925, 1582289050),
(959, 52, 730, 1, 1582288925, 1582288925),
(960, 53, 729, 1, 1582288946, 1582288946),
(961, 55, 723, 2, 1582288948, 1582288989),
(962, 46, 730, 1, 1582288959, 1582288959),
(963, 45, 724, 1, 1582288963, 1582288963),
(964, 52, 731, 1, 1582288977, 1582288977),
(965, 49, 721, 1, 1582289044, 1582289044),
(966, 52, 723, 1, 1582289097, 1582289097),
(967, 53, 525, 1, 1582289125, 1582289125),
(968, 52, 486, 1, 1582289138, 1582289138),
(969, 45, 732, 1, 1582289146, 1582289146),
(970, 49, 486, 1, 1582289150, 1582289150),
(971, 47, 525, 1, 1582289151, 1582289151),
(972, 54, 525, 1, 1582289216, 1582289216),
(973, 50, 715, 3, 1582289270, 1582289393),
(974, 54, 734, 1, 1582289296, 1582289296),
(975, 52, 116, 4, 1582289353, 1582289435),
(976, 45, 735, 5, 1582289359, 1582289549),
(977, 45, 733, 2, 1582289365, 1582289424),
(978, 47, 733, 1, 1582289391, 1582289391),
(979, 47, 715, 1, 1582289424, 1582289424),
(980, 52, 733, 3, 1582289445, 1582289494),
(981, 45, 738, 1, 1582289453, 1582289453),
(982, 54, 737, 1, 1582289474, 1582289474),
(983, 52, 737, 1, 1582289480, 1582289480),
(984, 52, 742, 1, 1582289513, 1582289513),
(985, 52, 735, 1, 1582289515, 1582289515),
(986, 46, 733, 1, 1582289515, 1582289515),
(987, 53, 741, 1, 1582289523, 1582289523),
(988, 52, 743, 1, 1582289527, 1582289527),
(989, 54, 743, 1, 1582289543, 1582289543),
(990, 52, 744, 3, 1582289552, 1582289736),
(991, 54, 742, 1, 1582289553, 1582289553),
(992, 52, 745, 1, 1582289565, 1582289565),
(993, 52, 739, 3, 1582289572, 1582289743),
(994, 45, 743, 1, 1582289580, 1582289580),
(995, 50, 745, 1, 1582289590, 1582289590),
(996, 52, 747, 1, 1582289602, 1582289602),
(997, 45, 746, 2, 1582289603, 1582289652),
(998, 52, 741, 2, 1582289617, 1582289680),
(999, 46, 747, 1, 1582289632, 1582289632),
(1000, 54, 739, 1, 1582289648, 1582289648),
(1001, 45, 744, 2, 1582289654, 1582289728),
(1002, 47, 746, 1, 1582289682, 1582289682),
(1003, 46, 741, 1, 1582289702, 1582289702),
(1004, 55, 748, 1, 1582289763, 1582289763),
(1005, 46, 744, 2, 1582289765, 1582292511),
(1006, 52, 748, 1, 1582289771, 1582289771),
(1007, 52, 750, 1, 1582289809, 1582289809),
(1008, 48, 749, 2, 1582289821, 1582290008),
(1009, 48, 750, 1, 1582289822, 1582289822),
(1010, 45, 750, 1, 1582289849, 1582289849),
(1011, 45, 749, 4, 1582289873, 1582291955),
(1012, 52, 749, 6, 1582289885, 1582292153),
(1013, 46, 750, 2, 1582289898, 1582290480),
(1014, 50, 729, 2, 1582289964, 1582290014),
(1015, 46, 749, 5, 1582289980, 1582292059),
(1016, 52, 751, 2, 1582289989, 1582290050),
(1017, 48, 457, 1, 1582289993, 1582289993),
(1018, 55, 751, 1, 1582290061, 1582290061),
(1019, 45, 752, 1, 1582290098, 1582290098),
(1020, 55, 755, 3, 1582290169, 1582290203),
(1021, 52, 756, 3, 1582290202, 1582290291),
(1022, 54, 749, 2, 1582290211, 1582290219),
(1023, 48, 756, 2, 1582290220, 1582290271),
(1024, 53, 753, 1, 1582290230, 1582290230),
(1025, 49, 753, 1, 1582290244, 1582290244),
(1026, 52, 753, 3, 1582290262, 1582290394),
(1027, 54, 750, 1, 1582290296, 1582290296),
(1028, 52, 218, 2, 1582290304, 1582290308),
(1029, 45, 759, 1, 1582290312, 1582290312),
(1030, 45, 756, 1, 1582290313, 1582290313),
(1031, 47, 750, 2, 1582290315, 1582290478),
(1032, 54, 758, 1, 1582290324, 1582290324),
(1033, 50, 759, 2, 1582290325, 1582290696),
(1034, 46, 756, 1, 1582290338, 1582290338),
(1035, 52, 759, 6, 1582290362, 1582290648),
(1036, 47, 759, 2, 1582290393, 1582290429),
(1037, 46, 761, 3, 1582290397, 1582329005),
(1038, 50, 753, 1, 1582290409, 1582290409),
(1039, 46, 753, 2, 1582290421, 1582290483),
(1040, 46, 759, 4, 1582290436, 1582290548),
(1041, 55, 750, 1, 1582290446, 1582290446),
(1042, 53, 749, 2, 1582290505, 1582290516),
(1043, 53, 763, 1, 1582290535, 1582290535),
(1044, 54, 763, 1, 1582290558, 1582290558),
(1045, 45, 761, 1, 1582290572, 1582290572),
(1046, 45, 708, 1, 1582290589, 1582290589),
(1047, 49, 764, 1, 1582290603, 1582290603),
(1048, 52, 708, 2, 1582290627, 1582341105),
(1049, 45, 764, 1, 1582290630, 1582290630),
(1050, 48, 759, 1, 1582290675, 1582290675),
(1051, 54, 765, 1, 1582290799, 1582290799),
(1052, 45, 766, 1, 1582290827, 1582290827),
(1053, 54, 766, 1, 1582290847, 1582290847),
(1054, 46, 766, 1, 1582290894, 1582290894),
(1055, 45, 767, 2, 1582291051, 1582291115),
(1056, 54, 768, 1, 1582291055, 1582291055),
(1057, 53, 767, 1, 1582291098, 1582291098),
(1058, 53, 768, 1, 1582291111, 1582291111),
(1059, 52, 768, 1, 1582291119, 1582291119),
(1060, 52, 769, 1, 1582291139, 1582291139),
(1061, 54, 769, 1, 1582291166, 1582291166),
(1062, 49, 771, 1, 1582291233, 1582291233),
(1063, 52, 668, 1, 1582291317, 1582291317),
(1064, 49, 774, 2, 1582291347, 1582291424),
(1065, 52, 774, 2, 1582291360, 1582291419),
(1066, 45, 773, 1, 1582291371, 1582291371),
(1067, 52, 775, 2, 1582291389, 1582291425),
(1068, 47, 775, 1, 1582291420, 1582291420),
(1069, 52, 776, 7, 1582291431, 1582291557),
(1070, 45, 774, 2, 1582291446, 1582291446),
(1071, 45, 777, 1, 1582291472, 1582291472),
(1072, 45, 778, 1, 1582291524, 1582291524),
(1073, 54, 778, 1, 1582291539, 1582291539),
(1074, 48, 779, 2, 1582291556, 1582291614),
(1075, 45, 776, 1, 1582291579, 1582291579),
(1076, 54, 779, 1, 1582291624, 1582291624),
(1077, 52, 781, 1, 1582291670, 1582291670),
(1078, 45, 783, 1, 1582291731, 1582291731),
(1079, 54, 782, 1, 1582291735, 1582291735),
(1080, 55, 783, 1, 1582291790, 1582291790),
(1081, 52, 784, 1, 1582291815, 1582291815),
(1082, 48, 784, 1, 1582291844, 1582291844),
(1083, 54, 786, 2, 1582291870, 1582291907),
(1084, 52, 787, 1, 1582291987, 1582291987),
(1085, 52, 788, 2, 1582291994, 1582292016),
(1086, 46, 788, 1, 1582292026, 1582292026),
(1087, 52, 789, 1, 1582292246, 1582292246),
(1088, 45, 789, 1, 1582292299, 1582292299),
(1089, 48, 235, 1, 1582292335, 1582292335),
(1090, 54, 235, 2, 1582292356, 1582292442),
(1091, 48, 790, 1, 1582292427, 1582292427),
(1092, 55, 235, 1, 1582292439, 1582292439),
(1093, 46, 235, 2, 1582292451, 1582292469),
(1094, 52, 791, 6, 1582292490, 1582322128),
(1095, 52, 792, 1, 1582292502, 1582292502),
(1096, 55, 791, 2, 1582292507, 1582322160),
(1097, 52, 793, 1, 1582292539, 1582292539),
(1098, 45, 794, 2, 1582292687, 1582292738),
(1099, 52, 794, 1, 1582292708, 1582292708),
(1100, 55, 795, 1, 1582292741, 1582292741),
(1101, 52, 795, 1, 1582292750, 1582292750),
(1102, 45, 791, 2, 1582292762, 1582292881),
(1103, 48, 791, 1, 1582292894, 1582292894),
(1104, 47, 791, 1, 1582292906, 1582292906),
(1105, 47, 796, 1, 1582292952, 1582292952),
(1106, 48, 510, 1, 1582292960, 1582292960),
(1107, 54, 791, 1, 1582293003, 1582293003),
(1108, 53, 796, 1, 1582293004, 1582293004),
(1109, 46, 791, 1, 1582293039, 1582293039),
(1110, 49, 637, 4, 1582293105, 1582384140),
(1111, 53, 637, 3, 1582293138, 1582384173),
(1112, 46, 637, 11, 1582293237, 1582373548),
(1113, 47, 637, 3, 1582293291, 1582369081),
(1114, 55, 637, 1, 1582293301, 1582293301),
(1115, 49, 803, 1, 1582293550, 1582293550),
(1116, 52, 803, 1, 1582293641, 1582293641),
(1117, 50, 804, 1, 1582293692, 1582293692),
(1118, 53, 805, 1, 1582293701, 1582293701),
(1119, 52, 805, 2, 1582293707, 1582293724),
(1120, 52, 804, 4, 1582293715, 1582293821),
(1121, 47, 806, 1, 1582293723, 1582293723),
(1122, 53, 807, 1, 1582293755, 1582293755),
(1123, 47, 805, 2, 1582293757, 1582293874),
(1124, 45, 343, 2, 1582293771, 1582293780),
(1125, 52, 807, 2, 1582293787, 1582293840),
(1126, 53, 808, 1, 1582293838, 1582293838),
(1127, 55, 804, 1, 1582293844, 1582293844),
(1128, 52, 808, 5, 1582293851, 1582350640),
(1129, 45, 809, 1, 1582293903, 1582293903),
(1130, 52, 810, 3, 1582293923, 1582294008),
(1131, 52, 809, 2, 1582293941, 1582293957),
(1132, 46, 805, 1, 1582293946, 1582293946),
(1133, 54, 810, 1, 1582293963, 1582293963),
(1134, 52, 343, 2, 1582293978, 1582294026),
(1135, 52, 811, 1, 1582294003, 1582294003),
(1136, 54, 811, 1, 1582294037, 1582294037),
(1137, 50, 343, 1, 1582294043, 1582294043),
(1138, 53, 813, 1, 1582294291, 1582294291),
(1139, 45, 813, 1, 1582294306, 1582294306),
(1140, 52, 817, 1, 1582294545, 1582294545),
(1141, 45, 818, 1, 1582294610, 1582294610),
(1142, 54, 819, 4, 1582294670, 1582298415),
(1143, 52, 820, 2, 1582295040, 1582295128),
(1144, 45, 820, 1, 1582295059, 1582295059),
(1145, 50, 820, 1, 1582295079, 1582295079),
(1146, 52, 822, 2, 1582295133, 1582295147),
(1147, 45, 821, 1, 1582295140, 1582295140),
(1148, 52, 821, 3, 1582295154, 1582343240),
(1149, 45, 823, 1, 1582295277, 1582295277),
(1150, 54, 824, 1, 1582295302, 1582295302),
(1151, 48, 823, 1, 1582295331, 1582295331),
(1152, 52, 823, 1, 1582295353, 1582295353),
(1153, 52, 825, 1, 1582295361, 1582295361),
(1154, 53, 827, 1, 1582295746, 1582295746),
(1155, 52, 827, 1, 1582295752, 1582295752),
(1156, 54, 828, 1, 1582295761, 1582295761),
(1157, 55, 827, 1, 1582295762, 1582295762),
(1158, 52, 829, 2, 1582295847, 1582295925),
(1159, 55, 829, 1, 1582295909, 1582295909),
(1160, 52, 816, 1, 1582295934, 1582295934),
(1161, 54, 816, 2, 1582295955, 1582296009),
(1162, 53, 816, 1, 1582296014, 1582296014),
(1163, 50, 829, 1, 1582296029, 1582296029),
(1164, 52, 832, 7, 1582296161, 1582297285),
(1165, 47, 833, 1, 1582296291, 1582296291),
(1166, 52, 207, 1, 1582296372, 1582296372),
(1167, 52, 834, 1, 1582296444, 1582296444),
(1168, 50, 834, 2, 1582296493, 1582296613),
(1169, 52, 835, 5, 1582296557, 1582340812),
(1170, 45, 835, 2, 1582296567, 1582296618),
(1171, 49, 832, 1, 1582296587, 1582296587),
(1172, 47, 832, 2, 1582296612, 1582296626),
(1173, 48, 835, 1, 1582296646, 1582296646),
(1174, 45, 673, 1, 1582296698, 1582296698),
(1175, 52, 836, 2, 1582296706, 1582296791),
(1176, 45, 836, 1, 1582296720, 1582296720),
(1177, 52, 837, 1, 1582296723, 1582296723),
(1178, 53, 673, 1, 1582296732, 1582296732),
(1179, 55, 836, 1, 1582296750, 1582296750),
(1180, 52, 838, 1, 1582296782, 1582296782),
(1181, 52, 839, 1, 1582296843, 1582296843),
(1182, 53, 836, 1, 1582296886, 1582296886),
(1183, 47, 836, 1, 1582296906, 1582296906),
(1184, 52, 840, 1, 1582296975, 1582296975),
(1185, 45, 841, 1, 1582297069, 1582297069),
(1186, 45, 842, 1, 1582297098, 1582297098),
(1187, 52, 842, 2, 1582297114, 1582297128),
(1188, 55, 832, 1, 1582297261, 1582297261),
(1189, 55, 843, 2, 1582297386, 1582297475),
(1190, 53, 843, 1, 1582297411, 1582297411),
(1191, 47, 843, 2, 1582297462, 1582297480),
(1192, 52, 845, 3, 1582297478, 1582297768),
(1193, 46, 843, 1, 1582297487, 1582297487),
(1194, 45, 845, 2, 1582297502, 1582297718),
(1195, 49, 845, 1, 1582297528, 1582297528),
(1196, 45, 847, 1, 1582297644, 1582297644),
(1197, 53, 847, 1, 1582297661, 1582297661),
(1198, 52, 850, 2, 1582297706, 1582297730),
(1199, 46, 845, 1, 1582297726, 1582297726),
(1200, 52, 853, 2, 1582298235, 1582298271),
(1201, 48, 853, 1, 1582298253, 1582298253),
(1202, 52, 854, 2, 1582298288, 1582298307),
(1203, 50, 853, 1, 1582298340, 1582298340),
(1204, 45, 855, 1, 1582298365, 1582298365),
(1205, 49, 854, 1, 1582298388, 1582298388),
(1206, 54, 854, 1, 1582298401, 1582298401),
(1207, 46, 855, 2, 1582298406, 1582298433),
(1208, 53, 819, 1, 1582298427, 1582298427),
(1209, 46, 819, 1, 1582298433, 1582298433),
(1210, 45, 819, 1, 1582298435, 1582298435),
(1211, 52, 856, 1, 1582298453, 1582298453),
(1212, 55, 855, 1, 1582298474, 1582298474),
(1213, 55, 856, 1, 1582298479, 1582298479),
(1214, 52, 855, 1, 1582298502, 1582298502),
(1215, 52, 188, 2, 1582298696, 1582398758),
(1216, 55, 858, 2, 1582298701, 1582298729);
INSERT INTO `eb_special_record` (`id`, `special_id`, `uid`, `number`, `add_time`, `update_time`) VALUES
(1217, 52, 858, 2, 1582298710, 1582298723),
(1218, 52, 859, 1, 1582298757, 1582298757),
(1219, 45, 860, 1, 1582298788, 1582298788),
(1220, 45, 861, 3, 1582298874, 1582299051),
(1221, 52, 862, 5, 1582298884, 1582303222),
(1222, 54, 861, 2, 1582298903, 1582299064),
(1223, 52, 861, 1, 1582298947, 1582298947),
(1224, 49, 861, 1, 1582299032, 1582299032),
(1225, 55, 861, 1, 1582299057, 1582299057),
(1226, 55, 863, 1, 1582299070, 1582299070),
(1227, 46, 861, 1, 1582299092, 1582299092),
(1228, 52, 864, 2, 1582299127, 1582299174),
(1229, 53, 864, 1, 1582299167, 1582299167),
(1230, 52, 866, 3, 1582299303, 1582305647),
(1231, 45, 866, 1, 1582299316, 1582299316),
(1232, 46, 866, 1, 1582299334, 1582299334),
(1233, 45, 867, 1, 1582299556, 1582299556),
(1234, 52, 867, 1, 1582299575, 1582299575),
(1235, 54, 867, 1, 1582299640, 1582299640),
(1236, 52, 868, 1, 1582299679, 1582299679),
(1237, 45, 869, 1, 1582299946, 1582299946),
(1238, 52, 869, 1, 1582299976, 1582299976),
(1239, 50, 870, 1, 1582300036, 1582300036),
(1240, 45, 871, 2, 1582300511, 1582300630),
(1241, 48, 872, 1, 1582300581, 1582300581),
(1242, 52, 873, 2, 1582300834, 1582300867),
(1243, 45, 874, 1, 1582300856, 1582300856),
(1244, 52, 874, 2, 1582300877, 1582300900),
(1245, 45, 154, 4, 1582300883, 1582302095),
(1246, 48, 874, 2, 1582300918, 1582300940),
(1247, 52, 875, 1, 1582300980, 1582300980),
(1248, 53, 874, 1, 1582301041, 1582301041),
(1249, 50, 874, 3, 1582301053, 1582301129),
(1250, 50, 154, 8, 1582301079, 1582302412),
(1251, 50, 876, 1, 1582301135, 1582301135),
(1252, 55, 154, 1, 1582301215, 1582301215),
(1253, 55, 877, 1, 1582301235, 1582301235),
(1254, 54, 154, 2, 1582301247, 1582302077),
(1255, 52, 877, 1, 1582301276, 1582301276),
(1256, 48, 877, 1, 1582301308, 1582301308),
(1257, 52, 879, 1, 1582301814, 1582301814),
(1258, 48, 879, 1, 1582301829, 1582301829),
(1259, 52, 154, 2, 1582301979, 1582302106),
(1260, 45, 880, 2, 1582302023, 1582302229),
(1261, 52, 880, 3, 1582302057, 1582302189),
(1262, 53, 154, 1, 1582302069, 1582302069),
(1263, 54, 599, 1, 1582302090, 1582302090),
(1264, 53, 599, 1, 1582302099, 1582302099),
(1265, 49, 633, 1, 1582302226, 1582302226),
(1266, 54, 882, 1, 1582302970, 1582302970),
(1267, 45, 862, 1, 1582302992, 1582302992),
(1268, 53, 862, 1, 1582303106, 1582303106),
(1269, 54, 862, 1, 1582303122, 1582303122),
(1270, 52, 848, 1, 1582303878, 1582303878),
(1271, 45, 883, 1, 1582304299, 1582304299),
(1272, 50, 886, 2, 1582304361, 1582304420),
(1273, 52, 886, 2, 1582304400, 1582304492),
(1274, 48, 883, 2, 1582304403, 1582304644),
(1275, 54, 883, 1, 1582304661, 1582304661),
(1276, 48, 525, 1, 1582304754, 1582304754),
(1277, 52, 889, 1, 1582305242, 1582305242),
(1278, 46, 888, 1, 1582305248, 1582305248),
(1279, 55, 889, 1, 1582305254, 1582305254),
(1280, 53, 890, 1, 1582305854, 1582305854),
(1281, 52, 891, 2, 1582305868, 1582305941),
(1282, 52, 890, 2, 1582305885, 1582306040),
(1283, 46, 891, 2, 1582305905, 1582305975),
(1284, 45, 891, 1, 1582305959, 1582305959),
(1285, 49, 890, 1, 1582306003, 1582306003),
(1286, 54, 890, 2, 1582306010, 1582306033),
(1287, 47, 890, 1, 1582306044, 1582306044),
(1288, 55, 892, 1, 1582306437, 1582306437),
(1289, 52, 892, 7, 1582306447, 1582306565),
(1290, 47, 892, 2, 1582306461, 1582306578),
(1291, 46, 892, 2, 1582306552, 1582306584),
(1292, 54, 620, 1, 1582306624, 1582306624),
(1293, 45, 620, 1, 1582306763, 1582306763),
(1294, 48, 620, 3, 1582306788, 1582307430),
(1295, 53, 620, 1, 1582306805, 1582306805),
(1296, 46, 620, 1, 1582306863, 1582306863),
(1297, 52, 893, 2, 1582306958, 1582307055),
(1298, 49, 620, 1, 1582307453, 1582307453),
(1299, 50, 620, 1, 1582307484, 1582307484),
(1300, 52, 894, 2, 1582308114, 1582308127),
(1301, 45, 895, 1, 1582308239, 1582308239),
(1302, 52, 895, 4, 1582308255, 1582308449),
(1303, 52, 896, 2, 1582308365, 1582361256),
(1304, 48, 895, 1, 1582308459, 1582308459),
(1305, 53, 895, 1, 1582308484, 1582308484),
(1306, 50, 637, 7, 1582308632, 1582372874),
(1307, 52, 897, 1, 1582309033, 1582309033),
(1308, 55, 898, 4, 1582309085, 1582309110),
(1309, 52, 899, 2, 1582309382, 1582309519),
(1310, 52, 88, 4, 1582314930, 1582315072),
(1311, 53, 88, 1, 1582315085, 1582315085),
(1312, 52, 901, 5, 1582318841, 1582387558),
(1313, 52, 902, 1, 1582322747, 1582322747),
(1314, 49, 903, 1, 1582322894, 1582322894),
(1315, 53, 903, 1, 1582322912, 1582322912),
(1316, 52, 903, 1, 1582322934, 1582322934),
(1317, 52, 904, 1, 1582323496, 1582323496),
(1318, 48, 904, 2, 1582323609, 1582323646),
(1319, 52, 905, 2, 1582323808, 1582323893),
(1320, 46, 905, 1, 1582323903, 1582323903),
(1321, 47, 905, 1, 1582323910, 1582323910),
(1322, 45, 906, 3, 1582324202, 1582324440),
(1323, 48, 906, 1, 1582324233, 1582324233),
(1324, 52, 906, 2, 1582324292, 1582324361),
(1325, 55, 907, 1, 1582325476, 1582325476),
(1326, 45, 908, 2, 1582326008, 1582326329),
(1327, 54, 908, 5, 1582326029, 1582326643),
(1328, 52, 908, 6, 1582326072, 1582326606),
(1329, 53, 908, 4, 1582326091, 1582326576),
(1330, 48, 908, 2, 1582326104, 1582326160),
(1331, 45, 909, 1, 1582326106, 1582326106),
(1332, 48, 909, 1, 1582326136, 1582326136),
(1333, 52, 909, 4, 1582326203, 1582326337),
(1334, 55, 908, 2, 1582326206, 1582326278),
(1335, 47, 908, 2, 1582326218, 1582326514),
(1336, 53, 909, 1, 1582326291, 1582326291),
(1337, 46, 909, 2, 1582326362, 1582326650),
(1338, 50, 909, 6, 1582326389, 1582326579),
(1339, 46, 908, 1, 1582326478, 1582326478),
(1340, 52, 910, 1, 1582327459, 1582327459),
(1341, 46, 910, 2, 1582327526, 1582327605),
(1342, 49, 911, 1, 1582327972, 1582327972),
(1343, 55, 911, 1, 1582328003, 1582328003),
(1344, 54, 911, 1, 1582328012, 1582328012),
(1345, 52, 911, 2, 1582328033, 1582328089),
(1346, 46, 911, 1, 1582328053, 1582328053),
(1347, 54, 913, 1, 1582328534, 1582328534),
(1348, 46, 913, 1, 1582328562, 1582328562),
(1349, 52, 182, 6, 1582328743, 1582330175),
(1350, 46, 182, 2, 1582328821, 1582330193),
(1351, 52, 915, 3, 1582328943, 1582329080),
(1352, 55, 761, 1, 1582329046, 1582329046),
(1353, 47, 761, 1, 1582329066, 1582329066),
(1354, 52, 916, 1, 1582329278, 1582329278),
(1355, 48, 916, 1, 1582329322, 1582329322),
(1356, 52, 918, 4, 1582329411, 1582330091),
(1357, 52, 917, 1, 1582329434, 1582329434),
(1358, 45, 917, 1, 1582329468, 1582329468),
(1359, 55, 918, 2, 1582329482, 1582330460),
(1360, 48, 918, 2, 1582329492, 1582330008),
(1361, 45, 918, 3, 1582329518, 1582333306),
(1362, 49, 918, 2, 1582329678, 1582330044),
(1363, 53, 182, 1, 1582330021, 1582330021),
(1364, 54, 182, 1, 1582330028, 1582330028),
(1365, 47, 918, 1, 1582330467, 1582330467),
(1366, 55, 921, 1, 1582332115, 1582332115),
(1367, 52, 922, 2, 1582332130, 1582332165),
(1368, 54, 922, 1, 1582332143, 1582332143),
(1369, 52, 921, 1, 1582332159, 1582332159),
(1370, 53, 923, 1, 1582332278, 1582332278),
(1371, 46, 923, 1, 1582332291, 1582332291),
(1372, 52, 924, 6, 1582332762, 1582332949),
(1373, 55, 927, 1, 1582333689, 1582333689),
(1374, 52, 928, 3, 1582333878, 1582333988),
(1375, 55, 928, 1, 1582333928, 1582333928),
(1376, 49, 929, 1, 1582333937, 1582333937),
(1377, 53, 928, 1, 1582333984, 1582333984),
(1378, 53, 931, 1, 1582334489, 1582334489),
(1379, 52, 934, 2, 1582334923, 1582334982),
(1380, 54, 934, 1, 1582334944, 1582334944),
(1381, 46, 934, 1, 1582334972, 1582334972),
(1382, 47, 249, 1, 1582335812, 1582335812),
(1383, 52, 936, 1, 1582335884, 1582335884),
(1384, 46, 510, 1, 1582336633, 1582336633),
(1385, 52, 938, 4, 1582336945, 1582356114),
(1386, 53, 887, 1, 1582337354, 1582337354),
(1387, 54, 887, 1, 1582337394, 1582337394),
(1388, 46, 887, 1, 1582337413, 1582337413),
(1389, 45, 887, 1, 1582337556, 1582337556),
(1390, 52, 887, 1, 1582337586, 1582337586),
(1391, 52, 939, 2, 1582337666, 1582337686),
(1392, 45, 940, 1, 1582337667, 1582337667),
(1393, 50, 887, 3, 1582337692, 1582338017),
(1394, 54, 723, 1, 1582338001, 1582338001),
(1395, 45, 942, 1, 1582338141, 1582338141),
(1396, 52, 942, 2, 1582338171, 1582338225),
(1397, 45, 945, 1, 1582338404, 1582338404),
(1398, 54, 945, 1, 1582338432, 1582338432),
(1399, 46, 945, 1, 1582338461, 1582338461),
(1400, 52, 709, 1, 1582338995, 1582338995),
(1401, 48, 945, 1, 1582339022, 1582339022),
(1402, 47, 946, 1, 1582339069, 1582339069),
(1403, 53, 946, 2, 1582339090, 1582339111),
(1404, 52, 946, 2, 1582339128, 1582339140),
(1405, 45, 938, 4, 1582339251, 1582356368),
(1406, 52, 947, 2, 1582339429, 1582339465),
(1407, 45, 950, 1, 1582339785, 1582339785),
(1408, 55, 938, 1, 1582339882, 1582339882),
(1409, 52, 690, 2, 1582340009, 1582340354),
(1410, 52, 714, 4, 1582340376, 1582362350),
(1411, 55, 952, 2, 1582340891, 1582353269),
(1412, 47, 938, 4, 1582342002, 1582356381),
(1413, 48, 690, 1, 1582342208, 1582342208),
(1414, 53, 957, 1, 1582342539, 1582342539),
(1415, 45, 690, 1, 1582342544, 1582342544),
(1416, 45, 951, 1, 1582342976, 1582342976),
(1417, 49, 821, 1, 1582343214, 1582343214),
(1418, 45, 959, 1, 1582343353, 1582343353),
(1419, 52, 473, 6, 1582343354, 1582343571),
(1420, 52, 960, 1, 1582343500, 1582343500),
(1421, 49, 473, 1, 1582343581, 1582343581),
(1422, 52, 961, 1, 1582344204, 1582344204),
(1423, 54, 961, 2, 1582344230, 1582344241),
(1424, 49, 262, 1, 1582344531, 1582344531),
(1425, 52, 962, 1, 1582344650, 1582344650),
(1426, 54, 962, 2, 1582344778, 1582344799),
(1427, 52, 963, 1, 1582344900, 1582344900),
(1428, 52, 89, 2, 1582345162, 1582353314),
(1429, 48, 724, 2, 1582345815, 1582373355),
(1430, 50, 967, 1, 1582347251, 1582347251),
(1431, 52, 967, 4, 1582347334, 1582347392),
(1432, 54, 968, 1, 1582347432, 1582347432),
(1433, 52, 968, 2, 1582348336, 1582348362),
(1434, 46, 602, 1, 1582349097, 1582349097),
(1435, 52, 969, 3, 1582349141, 1582349336),
(1436, 46, 969, 1, 1582349361, 1582349361),
(1437, 52, 970, 4, 1582349473, 1582349800),
(1438, 45, 970, 1, 1582349674, 1582349674),
(1439, 52, 972, 8, 1582350071, 1582351505),
(1440, 53, 972, 1, 1582350089, 1582350089),
(1441, 47, 972, 1, 1582350099, 1582350099),
(1442, 52, 976, 1, 1582350223, 1582350223),
(1443, 54, 972, 2, 1582350406, 1582351497),
(1444, 45, 808, 1, 1582350487, 1582350487),
(1445, 55, 808, 1, 1582350509, 1582350509),
(1446, 47, 808, 1, 1582350518, 1582350518),
(1447, 50, 808, 2, 1582350646, 1582350691),
(1448, 53, 977, 1, 1582351500, 1582351500),
(1449, 52, 978, 4, 1582351535, 1582361947),
(1450, 45, 973, 1, 1582352085, 1582352085),
(1451, 50, 973, 1, 1582352132, 1582352132),
(1452, 52, 973, 5, 1582352266, 1582352857),
(1453, 49, 982, 1, 1582352538, 1582352538),
(1454, 53, 973, 1, 1582352592, 1582352592),
(1455, 52, 983, 4, 1582352701, 1582352850),
(1456, 49, 973, 1, 1582352893, 1582352893),
(1457, 47, 973, 1, 1582352935, 1582352935),
(1458, 53, 952, 2, 1582353262, 1582358865),
(1459, 52, 952, 15, 1582353275, 1582362216),
(1460, 48, 89, 3, 1582353370, 1582353488),
(1461, 49, 938, 9, 1582353428, 1582356965),
(1462, 49, 89, 1, 1582353437, 1582353437),
(1463, 48, 973, 3, 1582353538, 1582353800),
(1464, 54, 973, 1, 1582353814, 1582353814),
(1465, 55, 66, 1, 1582353872, 1582353872),
(1466, 52, 985, 2, 1582354304, 1582355732),
(1467, 53, 986, 1, 1582354754, 1582354754),
(1468, 45, 986, 1, 1582354789, 1582354789),
(1469, 52, 986, 1, 1582354817, 1582354817),
(1470, 48, 986, 1, 1582354864, 1582354864),
(1471, 52, 987, 1, 1582354984, 1582354984),
(1472, 47, 987, 1, 1582355006, 1582355006),
(1473, 53, 987, 1, 1582355067, 1582355067),
(1474, 46, 987, 1, 1582355105, 1582355105),
(1475, 45, 989, 1, 1582355190, 1582355190),
(1476, 53, 985, 1, 1582355638, 1582355638),
(1477, 45, 985, 1, 1582355652, 1582355652),
(1478, 47, 985, 1, 1582355662, 1582355662),
(1479, 46, 938, 2, 1582355701, 1582356141),
(1480, 50, 938, 5, 1582355745, 1582356131),
(1481, 54, 985, 1, 1582355746, 1582355746),
(1482, 49, 985, 1, 1582355752, 1582355752),
(1483, 45, 990, 1, 1582356202, 1582356202),
(1484, 52, 990, 1, 1582356223, 1582356223),
(1485, 54, 938, 1, 1582356365, 1582356365),
(1486, 52, 991, 1, 1582356527, 1582356527),
(1487, 52, 992, 4, 1582356938, 1582357116),
(1488, 55, 992, 1, 1582357000, 1582357000),
(1489, 52, 171, 7, 1582358355, 1582385722),
(1490, 45, 171, 4, 1582359584, 1582421879),
(1491, 55, 171, 1, 1582359597, 1582359597),
(1492, 54, 171, 3, 1582359603, 1582421931),
(1493, 47, 171, 2, 1582359610, 1582421960),
(1494, 45, 952, 1, 1582359812, 1582359812),
(1495, 50, 952, 1, 1582359820, 1582359820),
(1496, 45, 995, 1, 1582360640, 1582360640),
(1497, 53, 996, 1, 1582361493, 1582361493),
(1498, 47, 997, 1, 1582361738, 1582361738),
(1499, 46, 997, 1, 1582361755, 1582361755),
(1500, 45, 978, 1, 1582361789, 1582361789),
(1501, 47, 978, 1, 1582361828, 1582361828),
(1502, 52, 167, 1, 1582362159, 1582362159),
(1503, 50, 714, 1, 1582362312, 1582362312),
(1504, 53, 714, 1, 1582362325, 1582362325),
(1505, 46, 714, 6, 1582362358, 1582362523),
(1506, 52, 999, 4, 1582362411, 1582362939),
(1507, 48, 999, 4, 1582362440, 1582363003),
(1508, 48, 743, 2, 1582362657, 1582362681),
(1509, 55, 999, 1, 1582362706, 1582362706),
(1510, 47, 999, 1, 1582362883, 1582362883),
(1511, 53, 999, 1, 1582362928, 1582362928),
(1512, 52, 1000, 2, 1582363681, 1582373176),
(1513, 52, 1001, 2, 1582363981, 1582364018),
(1514, 49, 1001, 1, 1582363991, 1582363991),
(1515, 52, 1003, 1, 1582365043, 1582365043),
(1516, 53, 1003, 2, 1582365181, 1582365187),
(1517, 52, 1004, 1, 1582365182, 1582365182),
(1518, 53, 171, 1, 1582366051, 1582366051),
(1519, 45, 1005, 1, 1582366076, 1582366076),
(1520, 53, 1005, 1, 1582366102, 1582366102),
(1521, 50, 171, 1, 1582366103, 1582366103),
(1522, 52, 1005, 2, 1582366123, 1582366130),
(1523, 54, 1005, 1, 1582366182, 1582366182),
(1524, 53, 1008, 1, 1582367956, 1582367956),
(1525, 55, 1008, 1, 1582367968, 1582367968),
(1526, 54, 1009, 1, 1582368557, 1582368557),
(1527, 52, 1009, 1, 1582368575, 1582368575),
(1528, 52, 1010, 2, 1582368617, 1582368690),
(1529, 45, 1010, 1, 1582368651, 1582368651),
(1530, 52, 1012, 1, 1582369648, 1582369648),
(1531, 55, 1013, 1, 1582369969, 1582369969),
(1532, 52, 1013, 1, 1582369985, 1582369985),
(1533, 52, 1014, 2, 1582370196, 1582370275),
(1534, 55, 1014, 1, 1582370255, 1582370255),
(1535, 52, 1015, 11, 1582370572, 1582420665),
(1536, 55, 1015, 2, 1582370605, 1582376779),
(1537, 45, 1015, 1, 1582370618, 1582370618),
(1538, 54, 633, 1, 1582370977, 1582370977),
(1539, 53, 1015, 3, 1582370991, 1582420584),
(1540, 45, 1017, 2, 1582371143, 1582371428),
(1541, 55, 1017, 1, 1582371469, 1582371469),
(1542, 48, 1017, 1, 1582371492, 1582371492),
(1543, 45, 1018, 3, 1582371651, 1582372094),
(1544, 54, 1015, 2, 1582371689, 1582371703),
(1545, 52, 1018, 3, 1582371702, 1582372171),
(1546, 52, 1019, 1, 1582372479, 1582372479),
(1547, 53, 209, 2, 1582372876, 1582372929),
(1548, 55, 209, 1, 1582372882, 1582372882),
(1549, 46, 1021, 3, 1582372933, 1582373058),
(1550, 53, 1020, 1, 1582373036, 1582373036),
(1551, 45, 924, 3, 1582373176, 1582373217),
(1552, 55, 924, 1, 1582373211, 1582373211),
(1553, 53, 724, 1, 1582373276, 1582373276),
(1554, 52, 1021, 1, 1582373335, 1582373335),
(1555, 45, 1021, 2, 1582373411, 1582373433),
(1556, 52, 1020, 4, 1582373938, 1582374582),
(1557, 47, 1020, 1, 1582374326, 1582374326),
(1558, 50, 1024, 1, 1582374354, 1582374354),
(1559, 52, 1024, 1, 1582374372, 1582374372),
(1560, 45, 1024, 1, 1582374386, 1582374386),
(1561, 48, 1028, 1, 1582375846, 1582375846),
(1562, 52, 1028, 1, 1582375873, 1582375873),
(1563, 50, 1015, 1, 1582376765, 1582376765),
(1564, 45, 1029, 1, 1582377358, 1582377358),
(1565, 54, 1031, 1, 1582378691, 1582378691),
(1566, 52, 1031, 1, 1582378708, 1582378708),
(1567, 50, 1033, 1, 1582379798, 1582379798),
(1568, 53, 1034, 1, 1582380055, 1582380055),
(1569, 52, 1035, 3, 1582380692, 1582380778),
(1570, 52, 1038, 1, 1582381993, 1582381993),
(1571, 52, 1039, 1, 1582383180, 1582383180),
(1572, 55, 505, 1, 1582383339, 1582383339),
(1573, 53, 505, 1, 1582383348, 1582383348),
(1574, 52, 1040, 1, 1582383462, 1582383462),
(1575, 49, 1040, 5, 1582383495, 1582385099),
(1576, 52, 1025, 2, 1582384283, 1582384336),
(1577, 45, 1044, 2, 1582384541, 1582384574),
(1578, 45, 1045, 1, 1582384594, 1582384594),
(1579, 52, 1045, 1, 1582384632, 1582384632),
(1580, 48, 587, 1, 1582385172, 1582385172),
(1581, 55, 1046, 1, 1582385311, 1582385311),
(1582, 52, 1046, 1, 1582385328, 1582385328),
(1583, 47, 587, 2, 1582385361, 1582385369),
(1584, 52, 1047, 1, 1582385426, 1582385426),
(1585, 54, 1047, 1, 1582385474, 1582385474),
(1586, 55, 1047, 1, 1582385521, 1582385521),
(1587, 45, 1048, 1, 1582385672, 1582385672),
(1588, 52, 1051, 1, 1582386083, 1582386083),
(1589, 52, 1049, 2, 1582386101, 1582386177),
(1590, 54, 1049, 1, 1582386164, 1582386164),
(1591, 53, 1049, 2, 1582386196, 1582386202),
(1592, 47, 1049, 1, 1582386216, 1582386216),
(1593, 52, 1052, 1, 1582386259, 1582386259),
(1594, 53, 1053, 2, 1582386356, 1582386366),
(1595, 52, 1054, 1, 1582386780, 1582386780),
(1596, 48, 647, 1, 1582387076, 1582387076),
(1597, 52, 647, 1, 1582387112, 1582387112),
(1598, 53, 901, 1, 1582387454, 1582387454),
(1599, 53, 1055, 1, 1582387611, 1582387611),
(1600, 55, 1055, 2, 1582387648, 1582387660),
(1601, 52, 1059, 2, 1582388481, 1582388573),
(1602, 53, 1059, 1, 1582388523, 1582388523),
(1603, 47, 1059, 1, 1582388531, 1582388531),
(1604, 45, 1060, 1, 1582389363, 1582389363),
(1605, 54, 1060, 2, 1582389419, 1582389589),
(1606, 47, 1060, 1, 1582389639, 1582389639),
(1607, 52, 1060, 1, 1582389671, 1582389671),
(1608, 46, 1060, 3, 1582389715, 1582389782),
(1609, 55, 1060, 1, 1582389798, 1582389798),
(1610, 50, 1060, 2, 1582389852, 1582389915),
(1611, 52, 1062, 1, 1582390891, 1582390891),
(1612, 46, 1063, 1, 1582390962, 1582390962),
(1613, 47, 325, 1, 1582391304, 1582391304),
(1614, 55, 1066, 1, 1582395310, 1582395310),
(1615, 52, 1068, 1, 1582396190, 1582396190),
(1616, 45, 665, 1, 1582409790, 1582409790),
(1617, 54, 665, 1, 1582409802, 1582409802),
(1618, 52, 665, 1, 1582409813, 1582409813),
(1619, 47, 665, 1, 1582409819, 1582409819),
(1620, 52, 1071, 2, 1582414578, 1582414611),
(1621, 54, 1072, 1, 1582418477, 1582418477),
(1622, 45, 464, 1, 1582420418, 1582420418),
(1623, 55, 1074, 1, 1582421521, 1582421521),
(1624, 55, 1076, 1, 1582423572, 1582423572),
(1625, 52, 1077, 1, 1582423630, 1582423630),
(1626, 53, 1077, 1, 1582423649, 1582423649),
(1627, 48, 1077, 1, 1582423684, 1582423684),
(1628, 49, 1077, 2, 1582423749, 1582423763),
(1629, 45, 1080, 1, 1582425596, 1582425596),
(1630, 52, 1081, 5, 1582426313, 1582426690),
(1631, 55, 1081, 1, 1582426326, 1582426326),
(1632, 45, 1082, 1, 1582426498, 1582426498),
(1633, 46, 1082, 2, 1582426534, 1582426581),
(1634, 45, 1081, 1, 1582426570, 1582426570),
(1635, 54, 1081, 1, 1582426584, 1582426584),
(1636, 49, 1081, 2, 1582426662, 1582426675),
(1637, 47, 1081, 1, 1582427247, 1582427247),
(1638, 52, 1083, 2, 1582427371, 1582427597),
(1639, 47, 1083, 1, 1582427547, 1582427547),
(1640, 45, 1084, 2, 1582427775, 1582427784),
(1641, 45, 1085, 1, 1582427842, 1582427842),
(1642, 45, 1092, 1, 1582429380, 1582429380),
(1643, 53, 1093, 1, 1582429384, 1582429384),
(1644, 52, 1093, 3, 1582429392, 1582429422),
(1645, 48, 1092, 1, 1582429415, 1582429415),
(1646, 55, 1093, 1, 1582429433, 1582429433),
(1647, 52, 1094, 1, 1582429537, 1582429537),
(1648, 54, 646, 1, 1582429541, 1582429541),
(1649, 53, 1091, 1, 1582429673, 1582429673),
(1650, 45, 1096, 1, 1582429853, 1582429853),
(1651, 52, 1097, 1, 1582429855, 1582429855),
(1652, 47, 1097, 1, 1582429886, 1582429886),
(1653, 47, 1095, 1, 1582430750, 1582430750),
(1654, 52, 1095, 1, 1582430765, 1582430765),
(1655, 52, 1098, 3, 1582430926, 1582431080),
(1656, 45, 695, 1, 1582431080, 1582431080),
(1657, 52, 1100, 1, 1582431538, 1582431538),
(1658, 45, 1101, 1, 1582432239, 1582432239),
(1659, 52, 1103, 5, 1582434346, 1582434635),
(1660, 52, 1104, 1, 1582434444, 1582434444),
(1661, 48, 1103, 2, 1582434481, 1582434504),
(1662, 54, 1103, 2, 1582434539, 1582434596),
(1663, 46, 1103, 1, 1582434624, 1582434624),
(1664, 52, 1105, 2, 1582436977, 1582437285),
(1665, 53, 1105, 1, 1582437149, 1582437149),
(1666, 54, 1105, 1, 1582437336, 1582437336),
(1667, 45, 1105, 1, 1582437642, 1582437642),
(1668, 52, 1106, 1, 1582437661, 1582437661),
(1669, 52, 1107, 2, 1582440027, 1582440084);

-- --------------------------------------------------------

--
-- 表的结构 `eb_special_relation`
--

CREATE TABLE `eb_special_relation` (
  `id` int(11) NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=专题,1=图文',
  `link_id` int(11) NOT NULL DEFAULT '0' COMMENT '关联id',
  `category` tinyint(1) NOT NULL DEFAULT '0' COMMENT '类型,1=收藏,2=点赞',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='图文专题点赞收藏';

--
-- 转存表中的数据 `eb_special_relation`
--

INSERT INTO `eb_special_relation` (`id`, `uid`, `type`, `link_id`, `category`, `add_time`) VALUES
(58, 68, 0, 47, 1, 1581417180),
(64, 156, 0, 47, 1, 1582006493),
(65, 200, 0, 52, 1, 1582025488),
(66, 200, 0, 49, 1, 1582026056),
(68, 341, 0, 52, 1, 1582165199),
(69, 371, 0, 47, 1, 1582180154),
(70, 446, 0, 52, 1, 1582275233),
(71, 542, 0, 48, 1, 1582285577),
(72, 565, 0, 47, 1, 1582285594),
(73, 506, 0, 52, 1, 1582285911),
(74, 506, 0, 45, 1, 1582286029),
(76, 661, 0, 53, 1, 1582286991),
(78, 759, 0, 52, 1, 1582290406),
(80, 791, 0, 52, 1, 1582293028),
(81, 673, 0, 53, 1, 1582296738),
(83, 637, 0, 49, 1, 1582384122);

-- --------------------------------------------------------

--
-- 表的结构 `eb_special_subject`
--

CREATE TABLE `eb_special_subject` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `pic` varchar(255) NOT NULL DEFAULT '' COMMENT '图标',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `is_show` int(11) NOT NULL DEFAULT '0' COMMENT '是否显示,1=显示,0=隐藏',
  `grade_id` int(11) NOT NULL DEFAULT '0' COMMENT '年级部id',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='科目列表';

--
-- 转存表中的数据 `eb_special_subject`
--

INSERT INTO `eb_special_subject` (`id`, `name`, `pic`, `sort`, `is_show`, `grade_id`, `add_time`) VALUES
(21, '语文', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/67c04202002111757584709.jpg', 10, 1, 4, 1581401495),
(22, '数学', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/8b0be202002111757582367.jpg', 9, 1, 4, 1581415097),
(23, '英语', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/5ae6f202002111757583267.jpg', 8, 1, 3, 1581415148),
(24, '音乐启蒙', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/67c04202002111757584709.jpg', 0, 1, 4, 1581476723),
(25, '体育训练', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/5ae6f202002111757583267.jpg', 0, 1, 4, 1581476740),
(26, '课外辅导', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/8b0be202002111757582367.jpg', 0, 1, 4, 1581476755),
(27, '野外拓展', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/67c04202002111757584709.jpg', 0, 1, 4, 1581476777),
(28, '精品提升', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/5ae6f202002111757583267.jpg', 0, 1, 4, 1581476806),
(30, '二级测试', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/ccb10202002111757423753.jpg', 0, 1, 10, 1581674369);

-- --------------------------------------------------------

--
-- 表的结构 `eb_special_task`
--

CREATE TABLE `eb_special_task` (
  `id` int(11) NOT NULL,
  `coures_id` int(11) NOT NULL DEFAULT '0' COMMENT '课程id（1.1版本后废弃）',
  `special_id` int(11) NOT NULL DEFAULT '0' COMMENT '专题id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '素材标题',
  `content` text NOT NULL COMMENT '内容',
  `detail` text NOT NULL COMMENT '简介',
  `type` tinyint(1) NOT NULL DEFAULT '6' COMMENT '素材类型',
  `is_pay` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否付费,0=免费,1=付费',
  `link` varchar(255) NOT NULL DEFAULT '' COMMENT '链接',
  `image` varchar(200) NOT NULL DEFAULT '0' COMMENT '封面图',
  `abstract` varchar(2000) NOT NULL DEFAULT '' COMMENT '摘要',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `play_count` int(11) NOT NULL DEFAULT '0' COMMENT '播放量',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=下架,1=上架',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `edit_time` int(11) NOT NULL DEFAULT '0' COMMENT '修改时间',
  `live_id` int(11) NOT NULL DEFAULT '0' COMMENT '直播ID，0=普通（1.1版本后废弃）'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='专题-素材';

--
-- 转存表中的数据 `eb_special_task`
--
INSERT INTO `eb_special_task`(`id`, `coures_id`, `special_id`, `title`, `content`, `detail`, `type`, `is_pay`, `link`, `image`, `abstract`, `sort`, `play_count`, `is_show`, `add_time`, `edit_time`, `live_id`) VALUES
(1, 0, 0, '图文素材1', '<p>我是图文素材1内容</p>', '<p>我是图文素材1简介</p>', 1, 0, '', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/32379202002201232449232.jpg', '', 1, 0, 1, 1588042168, 0, 0),
(2, 0, 0, '图文素材2', '<p>我是图文素材2内容</p>', '<p>我是图文素材2简介</p>', 1, 0, '', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/32379202002201232449232.jpg', '', 2, 0, 1, 1588042210, 0, 0),
(3, 0, 0, '音频素材一', '<p><br/></p><div><audio style=\"width: 100%\" src=\"http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4\" class=\"video-ue\" controls=\"controls\"></audio></div><p>音频</p>', '<p>我是音频素材1简介</p>', 2, 0, 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/0620e202002201232446695.jpg', '', 1, 0, 1, 1588043711, 0, 0),
(4, 0, 0, '音频素材二', '<p><br/></p><audio style=\"width: 100%\" src=\"http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4\" class=\"video-ue\" controls=\"controls\"></audio><p>我是音频素材内容</p>', '<p>我是音频素材二简介</p>', 2, 0, 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/e56f5202002201232449146.jpg', '', 2, 0, 1, 1588043762, 0, 0),
(5, 0, 0, '视频素材一', '<p><br/></p><div><video style=\"width: 100%\" src=\"http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4\" class=\"video-ue\" controls=\"controls\"></video></div><p>我是视频素材一内容</p>', '<p>我是视频素材一简介</p>', 3, 0, 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/3ec76202002201232442683.jpg', '', 1, 0, 1, 1588043857, 0, 0),
(6, 0, 0, '视频素材二', '<p><br/></p><div><video style=\"width: 100%\" src=\"http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4\" class=\"video-ue\" controls=\"controls\"></video></div><p>我是视频素材2内容</p>', '<p>我是视频素材2简介</p>', 3, 0, 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/W8rykksS4m6ZtYp27E.mp4', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/78cdd20200220123244525.jpg', '', 2, 0, 1, 1588043914, 0, 0);

--
-- 转存表中的数据 `eb_special_source`
--
INSERT INTO `eb_special_source` (`id`, `special_id`, `source_id`, `pay_status`, `play_count`, `add_time`) VALUES
(1, 2, 2, 1, 0, 1588045424),
(2, 2, 1, 0, 0, 1588045424),
(3, 3, 4, 0, 0, 1588046472),
(4, 3, 3, 0, 0, 1588046472),
(5, 4, 6, 1, 0, 1588046648),
(6, 4, 5, 0, 0, 1588046648),
(7, 5, 4, 0, 0, 1588046788),
(8, 5, 2, 0, 0, 1588046788),
(9, 5, 3, 0, 0, 1588046788);

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_bargain`
--

CREATE TABLE `eb_store_bargain` (
  `id` int(11) UNSIGNED NOT NULL COMMENT '砍价产品ID',
  `product_id` int(11) UNSIGNED NOT NULL COMMENT '关联产品ID',
  `title` varchar(255) NOT NULL COMMENT '砍价活动名称',
  `image` varchar(150) NOT NULL COMMENT '砍价活动图片',
  `unit_name` varchar(16) DEFAULT NULL COMMENT '单位名称',
  `stock` int(11) UNSIGNED DEFAULT NULL COMMENT '库存',
  `sales` int(11) UNSIGNED DEFAULT NULL COMMENT '销量',
  `images` varchar(1000) NOT NULL COMMENT '砍价产品轮播图',
  `start_time` int(11) UNSIGNED NOT NULL COMMENT '砍价开启时间',
  `stop_time` int(11) UNSIGNED NOT NULL COMMENT '砍价结束时间',
  `store_name` varchar(255) DEFAULT NULL COMMENT '砍价产品名称',
  `price` decimal(8,2) UNSIGNED DEFAULT NULL COMMENT '砍价金额',
  `min_price` decimal(8,2) UNSIGNED DEFAULT NULL COMMENT '砍价商品最低价',
  `num` int(11) UNSIGNED DEFAULT NULL COMMENT '每次购买的砍价产品数量',
  `bargain_max_price` decimal(8,2) UNSIGNED DEFAULT NULL COMMENT '用户每次砍价的最大金额',
  `bargain_min_price` decimal(8,2) UNSIGNED DEFAULT NULL COMMENT '用户每次砍价的最小金额',
  `bargain_num` int(11) UNSIGNED NOT NULL DEFAULT '1' COMMENT '用户每次砍价的次数',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '砍价状态 0(到砍价时间不自动开启)  1(到砍价时间自动开启时间)',
  `description` text COMMENT '砍价详情',
  `give_integral` decimal(10,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '反多少积分',
  `info` varchar(255) DEFAULT NULL COMMENT '砍价活动简介',
  `cost` decimal(8,2) UNSIGNED DEFAULT NULL COMMENT '成本价',
  `sort` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '排序',
  `is_hot` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否推荐0不推荐1推荐',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否删除 0未删除 1删除',
  `add_time` int(11) UNSIGNED NOT NULL COMMENT '添加时间',
  `is_postage` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '是否包邮 0不包邮 1包邮',
  `postage` decimal(10,2) UNSIGNED DEFAULT NULL COMMENT '邮费',
  `rule` text COMMENT '砍价规则',
  `look` int(11) UNSIGNED DEFAULT '0' COMMENT '砍价产品浏览量',
  `share` int(11) UNSIGNED DEFAULT '0' COMMENT '砍价产品分享量'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='砍价表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_bargain_user`
--

CREATE TABLE `eb_store_bargain_user` (
  `id` int(11) UNSIGNED NOT NULL COMMENT '用户参与砍价表ID',
  `uid` int(11) UNSIGNED DEFAULT NULL COMMENT '用户ID',
  `bargain_id` int(11) UNSIGNED DEFAULT NULL COMMENT '砍价产品id',
  `bargain_price_min` decimal(8,2) UNSIGNED DEFAULT NULL COMMENT '砍价的最低价',
  `bargain_price` decimal(8,2) DEFAULT NULL COMMENT '砍价金额',
  `price` decimal(8,2) UNSIGNED DEFAULT NULL COMMENT '砍掉的价格',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '状态 1参与中 2 活动结束参与失败 3活动结束参与成功',
  `add_time` int(11) UNSIGNED DEFAULT NULL COMMENT '参与时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户参与砍价表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_bargain_user_help`
--

CREATE TABLE `eb_store_bargain_user_help` (
  `id` int(11) UNSIGNED NOT NULL COMMENT '砍价用户帮助表ID',
  `uid` int(11) UNSIGNED DEFAULT NULL COMMENT '帮助的用户id',
  `bargain_id` int(11) UNSIGNED DEFAULT NULL COMMENT '砍价产品ID',
  `bargain_user_id` int(11) UNSIGNED DEFAULT NULL COMMENT '用户参与砍价表id',
  `price` decimal(8,2) UNSIGNED DEFAULT NULL COMMENT '帮助砍价多少金额',
  `add_time` int(11) UNSIGNED DEFAULT NULL COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='砍价用户帮助表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_cart`
--

CREATE TABLE `eb_store_cart` (
  `id` bigint(8) UNSIGNED NOT NULL COMMENT '购物车表ID',
  `uid` int(10) UNSIGNED NOT NULL COMMENT '用户ID',
  `type` varchar(32) NOT NULL COMMENT '类型',
  `product_id` int(10) UNSIGNED NOT NULL COMMENT '商品ID',
  `product_attr_unique` varchar(16) NOT NULL DEFAULT '' COMMENT '商品属性',
  `cart_num` smallint(5) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商品数量',
  `add_time` int(10) UNSIGNED NOT NULL COMMENT '添加时间',
  `is_pay` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0 = 未购买 1 = 已购买',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除',
  `is_new` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为立即购买',
  `combination_id` int(11) UNSIGNED NOT NULL COMMENT '拼团id',
  `seckill_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '秒杀产品ID',
  `bargain_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '砍价id',
  `integral_id` int(11) DEFAULT '0' COMMENT '积分id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='购物车表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_category`
--

CREATE TABLE `eb_store_category` (
  `id` mediumint(11) NOT NULL COMMENT '商品分类表ID',
  `mer_id` int(11) NOT NULL DEFAULT '0' COMMENT '商户id',
  `pid` mediumint(11) NOT NULL COMMENT '父id',
  `cate_name` varchar(100) NOT NULL COMMENT '分类名称',
  `sort` mediumint(11) NOT NULL COMMENT '排序',
  `pic` varchar(128) NOT NULL DEFAULT '' COMMENT '图标',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否推荐',
  `add_time` int(11) NOT NULL COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品分类表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_combination`
--

CREATE TABLE `eb_store_combination` (
  `id` int(10) UNSIGNED NOT NULL,
  `product_id` int(10) UNSIGNED NOT NULL COMMENT '商品id',
  `mer_id` int(10) UNSIGNED DEFAULT '0' COMMENT '商户id',
  `image` varchar(255) NOT NULL COMMENT '推荐图',
  `images` varchar(1000) NOT NULL COMMENT '轮播图',
  `title` varchar(255) NOT NULL COMMENT '活动标题',
  `attr` varchar(255) NOT NULL COMMENT '活动属性',
  `people` int(2) UNSIGNED NOT NULL COMMENT '参团人数',
  `info` varchar(255) NOT NULL COMMENT '简介',
  `price` decimal(10,2) UNSIGNED NOT NULL COMMENT '价格',
  `sort` int(10) UNSIGNED NOT NULL COMMENT '排序',
  `sales` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '销量',
  `stock` int(10) UNSIGNED NOT NULL COMMENT '库存',
  `add_time` varchar(128) NOT NULL COMMENT '添加时间',
  `is_host` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '推荐',
  `is_show` tinyint(1) UNSIGNED NOT NULL COMMENT '产品状态',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `combination` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `mer_use` tinyint(1) UNSIGNED NOT NULL COMMENT '商户是否可用1可用0不可用',
  `is_postage` tinyint(1) UNSIGNED NOT NULL COMMENT '是否包邮1是0否',
  `postage` decimal(10,2) UNSIGNED NOT NULL COMMENT '邮费',
  `description` text NOT NULL COMMENT '拼团内容',
  `start_time` int(11) UNSIGNED NOT NULL COMMENT '拼团开始时间',
  `stop_time` int(11) UNSIGNED NOT NULL COMMENT '拼团结束时间',
  `cost` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '拼图产品成本',
  `browse` int(11) DEFAULT '0' COMMENT '浏览量'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='拼团产品表' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_combination_attr`
--

CREATE TABLE `eb_store_combination_attr` (
  `product_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商品ID',
  `attr_name` varchar(32) NOT NULL COMMENT '属性名',
  `attr_values` varchar(256) NOT NULL COMMENT '属性值'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品属性表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_combination_attr_result`
--

CREATE TABLE `eb_store_combination_attr_result` (
  `product_id` int(10) UNSIGNED NOT NULL COMMENT '商品ID',
  `result` text NOT NULL COMMENT '商品属性参数',
  `change_time` int(10) UNSIGNED NOT NULL COMMENT '上次修改时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品属性详情表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_combination_attr_value`
--

CREATE TABLE `eb_store_combination_attr_value` (
  `product_id` int(10) UNSIGNED NOT NULL COMMENT '商品ID',
  `suk` varchar(128) NOT NULL COMMENT '商品属性索引值 (attr_value|attr_value[|....])',
  `stock` int(10) UNSIGNED NOT NULL COMMENT '属性对应的库存',
  `sales` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '销量',
  `price` decimal(8,2) UNSIGNED NOT NULL COMMENT '属性金额',
  `image` varchar(128) DEFAULT NULL COMMENT '图片',
  `unique` char(8) NOT NULL DEFAULT '' COMMENT '唯一值',
  `cost` decimal(8,2) UNSIGNED NOT NULL COMMENT '成本价'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品属性值表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_coupon`
--

CREATE TABLE `eb_store_coupon` (
  `id` int(11) UNSIGNED NOT NULL COMMENT '优惠券表ID',
  `title` varchar(64) NOT NULL COMMENT '优惠券名称',
  `integral` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '兑换消耗积分值',
  `coupon_price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '兑换的优惠券面值',
  `use_min_price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '最低消费多少金额可用优惠券',
  `coupon_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '优惠券有效期限（单位：天）',
  `sort` int(11) UNSIGNED NOT NULL DEFAULT '1' COMMENT '排序',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '状态（0：关闭，1：开启）',
  `add_time` int(11) UNSIGNED NOT NULL COMMENT '兑换项目添加时间',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否删除'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='优惠券表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_coupon_issue`
--

CREATE TABLE `eb_store_coupon_issue` (
  `id` int(10) UNSIGNED NOT NULL,
  `cid` int(10) DEFAULT NULL COMMENT '优惠券ID',
  `start_time` int(10) DEFAULT NULL COMMENT '优惠券领取开启时间',
  `end_time` int(10) DEFAULT NULL COMMENT '优惠券领取结束时间',
  `total_count` int(10) DEFAULT NULL COMMENT '优惠券领取数量',
  `remain_count` int(10) DEFAULT NULL COMMENT '优惠券剩余领取数量',
  `is_permanent` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否无限张数',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1 正常 0 未开启 -1 已无效',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `add_time` int(10) DEFAULT NULL COMMENT '优惠券添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='优惠券前台领取表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_coupon_issue_user`
--

CREATE TABLE `eb_store_coupon_issue_user` (
  `uid` int(10) DEFAULT NULL COMMENT '领取优惠券用户ID',
  `issue_coupon_id` int(10) DEFAULT NULL COMMENT '优惠券前台领取ID',
  `add_time` int(10) DEFAULT NULL COMMENT '领取时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='优惠券前台用户领取记录表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_coupon_user`
--

CREATE TABLE `eb_store_coupon_user` (
  `id` int(11) NOT NULL COMMENT '优惠券发放记录id',
  `cid` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '兑换的项目id',
  `uid` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '优惠券所属用户',
  `coupon_title` varchar(32) NOT NULL COMMENT '优惠券名称',
  `coupon_price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '优惠券的面值',
  `use_min_price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '最低消费多少金额可用优惠券',
  `add_time` int(11) UNSIGNED NOT NULL COMMENT '优惠券创建时间',
  `end_time` int(11) UNSIGNED NOT NULL COMMENT '优惠券结束时间',
  `use_time` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '使用时间',
  `type` varchar(32) NOT NULL DEFAULT 'send' COMMENT '获取方式',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态（0：未使用，1：已使用, 2:已过期）',
  `is_fail` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否有效'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='优惠券发放记录表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_order`
--

CREATE TABLE `eb_store_order` (
  `id` int(11) UNSIGNED NOT NULL COMMENT '订单ID',
  `trade_no` varchar(50) NOT NULL DEFAULT '' COMMENT '支付宝支付,支付宝交易订单号',
  `order_id` varchar(32) NOT NULL COMMENT '订单号',
  `uid` int(11) UNSIGNED NOT NULL COMMENT '用户id',
  `real_name` varchar(32) NOT NULL COMMENT '用户姓名',
  `user_phone` varchar(18) NOT NULL COMMENT '用户电话',
  `user_address` varchar(100) NOT NULL COMMENT '详细地址',
  `cart_id` varchar(256) NOT NULL DEFAULT '[]' COMMENT '购物车id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单类别 （0:课程订单 1:会员订单）',
  `member_id` int(11) NOT NULL DEFAULT '0' COMMENT '会员期限ID',
  `total_num` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '订单商品总数',
  `total_price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '订单总价',
  `total_postage` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '邮费',
  `pay_price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '实际支付金额',
  `deduction_price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '抵扣金额',
  `coupon_id` int(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '优惠券id',
  `coupon_price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '优惠券金额',
  `paid` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '支付状态',
  `pay_time` int(11) UNSIGNED DEFAULT '0' COMMENT '支付时间',
  `pay_type` varchar(32) NOT NULL COMMENT '支付方式',
  `add_time` int(11) UNSIGNED NOT NULL COMMENT '创建时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '订单状态（-1 : 申请退款 -2 : 退货成功 0：待取货；1：配送中；2：已收货；3：待评价；-1：已退款）',
  `refund_status` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0 未退款 1 申请中 2 已退款',
  `refund_reason_wap_img` varchar(255) DEFAULT NULL COMMENT '退款图片',
  `refund_reason_wap_explain` varchar(255) DEFAULT NULL COMMENT '退款用户说明',
  `refund_reason_time` int(11) UNSIGNED DEFAULT NULL COMMENT '退款时间',
  `refund_reason_wap` varchar(255) DEFAULT NULL COMMENT '前台退款原因',
  `refund_reason` varchar(255) DEFAULT NULL COMMENT '不退款的理由',
  `refund_price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '退款金额',
  `mark` varchar(512) NOT NULL COMMENT '备注',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否删除',
  `unique` char(32) NOT NULL COMMENT '唯一id(md5加密)类似id',
  `remark` varchar(512) DEFAULT NULL COMMENT '管理员备注',
  `mer_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商户ID',
  `cost` decimal(8,2) UNSIGNED NOT NULL COMMENT '成本价',
  `is_channel` tinyint(1) UNSIGNED DEFAULT '0' COMMENT '支付渠道(0微信公众号1微信小程序)',
  `pink_time` int(11) NOT NULL DEFAULT '0' COMMENT '拼团有效时间',
  `combination_id` int(11) UNSIGNED DEFAULT '0' COMMENT '拼团产品id',
  `pink_id` int(11) UNSIGNED DEFAULT '0' COMMENT '开团id',
  `seckill_id` int(11) UNSIGNED DEFAULT NULL COMMENT '秒杀产品id',
  `bargain_id` int(11) UNSIGNED DEFAULT NULL COMMENT '砍价产品id',
  `integral_id` int(11) UNSIGNED DEFAULT NULL,
  `pay_postage` decimal(8,2) DEFAULT '0.00' COMMENT '邮费',
  `delivery_name` varchar(255) DEFAULT NULL COMMENT '快递公司',
  `delivery_type` varchar(255) DEFAULT NULL COMMENT '物流类型',
  `delivery_id` varchar(64) DEFAULT '' COMMENT '快递单号',
  `gain_integral` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '消费赚取积分',
  `use_integral` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '使用积分',
  `back_integral` decimal(8,2) UNSIGNED DEFAULT NULL COMMENT '给用户退了多少积分',
  `is_gift` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为礼物订单',
  `gift_count` int(11) NOT NULL DEFAULT '0' COMMENT '领取次数',
  `is_receive_gift` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为领取的礼物订单',
  `gift_order_id` varchar(32) NOT NULL DEFAULT '' COMMENT '购买礼物order_id',
  `link_pay_uid` int(11) NOT NULL DEFAULT '0' COMMENT '通过连接购买所属用户',
  `spread_uid` int(11) NOT NULL DEFAULT '0' COMMENT '推广人uid'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='订单表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_order_cart_info`
--

CREATE TABLE `eb_store_order_cart_info` (
  `oid` int(11) UNSIGNED NOT NULL COMMENT '订单id',
  `cart_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '购物车id',
  `product_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商品ID',
  `cart_info` text NOT NULL COMMENT '购买东西的详细信息',
  `unique` char(32) NOT NULL COMMENT '唯一id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='订单购物详情表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_order_status`
--

CREATE TABLE `eb_store_order_status` (
  `oid` int(10) UNSIGNED NOT NULL COMMENT '订单id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=外面订单,1=跑腿订单',
  `change_type` varchar(32) NOT NULL COMMENT '操作类型',
  `change_message` varchar(256) NOT NULL COMMENT '操作备注',
  `change_time` int(10) UNSIGNED NOT NULL COMMENT '操作时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='订单操作记录表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_pink`
--

CREATE TABLE `eb_store_pink` (
  `id` int(10) UNSIGNED NOT NULL,
  `uid` int(10) UNSIGNED NOT NULL COMMENT '用户id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '拼团产品类型0=商品,1=专题',
  `order_id` varchar(32) NOT NULL COMMENT '订单id 生成',
  `order_id_key` int(10) UNSIGNED NOT NULL COMMENT '订单id  数据库',
  `total_num` int(10) UNSIGNED NOT NULL COMMENT '购买商品个数',
  `total_price` decimal(10,2) UNSIGNED NOT NULL COMMENT '购买总金额',
  `cid` int(10) UNSIGNED NOT NULL COMMENT '拼团产品id',
  `pid` int(10) UNSIGNED NOT NULL COMMENT '产品id',
  `people` int(10) UNSIGNED NOT NULL COMMENT '拼图总人数',
  `price` decimal(10,2) UNSIGNED NOT NULL COMMENT '拼团产品单价',
  `add_time` varchar(24) NOT NULL COMMENT '开始时间',
  `stop_time` varchar(24) NOT NULL,
  `k_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '团长id 0为团长',
  `is_tpl` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否发送模板消息0未发送1已发送',
  `is_refund` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否退款 0未退款 1已退款',
  `is_false` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为虚拟拼团',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '状态1进行中2已完成3未完成'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='拼团表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_pink_false`
--

CREATE TABLE `eb_store_pink_false` (
  `id` int(11) NOT NULL,
  `pink_id` int(11) NOT NULL DEFAULT '0' COMMENT '拼团id',
  `nickname` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `avatar` varchar(225) NOT NULL DEFAULT '' COMMENT '头像',
  `add_time` int(11) NOT NULL COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='虚拟参团人员';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_product`
--

CREATE TABLE `eb_store_product` (
  `id` mediumint(11) NOT NULL COMMENT '商品id',
  `mer_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商户Id(0为总后台管理员创建,不为0的时候是商户后台创建)',
  `image` varchar(128) NOT NULL COMMENT '商品图片',
  `slider_image` varchar(512) NOT NULL COMMENT '轮播图',
  `store_name` varchar(128) NOT NULL COMMENT '商品名称',
  `store_info` varchar(256) NOT NULL COMMENT '商品简介',
  `keyword` varchar(256) NOT NULL COMMENT '关键字',
  `cate_id` varchar(64) NOT NULL COMMENT '分类id',
  `price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '商品价格',
  `vip_price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '会员价格',
  `ot_price` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '市场价',
  `postage` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '邮费',
  `unit_name` varchar(32) NOT NULL COMMENT '单位名',
  `sort` smallint(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `sales` mediumint(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '销量',
  `stock` mediumint(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '库存',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态（0：未上架，1：上架）',
  `is_hot` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否热卖',
  `is_benefit` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否优惠',
  `is_best` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否精品',
  `is_new` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否新品',
  `description` text NOT NULL COMMENT '产品描述',
  `add_time` int(11) UNSIGNED NOT NULL COMMENT '添加时间',
  `is_postage` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否包邮',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否删除',
  `mer_use` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商户是否代理 0不可代理1可代理',
  `give_integral` decimal(8,2) UNSIGNED NOT NULL COMMENT '获得积分',
  `cost` decimal(8,2) UNSIGNED NOT NULL COMMENT '成本价',
  `is_seckill` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '秒杀状态 0 未开启 1已开启',
  `is_bargain` tinyint(1) UNSIGNED NOT NULL COMMENT '砍价状态 0未开启 1开启',
  `ficti` mediumint(11) DEFAULT '100' COMMENT '虚拟销量',
  `browse` int(11) DEFAULT '0' COMMENT '浏览量',
  `code_path` varchar(70) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_product_attr`
--

CREATE TABLE `eb_store_product_attr` (
  `product_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商品ID',
  `attr_name` varchar(32) NOT NULL COMMENT '属性名',
  `attr_values` varchar(256) NOT NULL COMMENT '属性值'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品属性表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_product_attr_result`
--

CREATE TABLE `eb_store_product_attr_result` (
  `product_id` int(10) UNSIGNED NOT NULL COMMENT '商品ID',
  `result` text NOT NULL COMMENT '商品属性参数',
  `change_time` int(10) UNSIGNED NOT NULL COMMENT '上次修改时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品属性详情表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_product_attr_value`
--

CREATE TABLE `eb_store_product_attr_value` (
  `product_id` int(10) UNSIGNED NOT NULL COMMENT '商品ID',
  `suk` varchar(128) NOT NULL COMMENT '商品属性索引值 (attr_value|attr_value[|....])',
  `stock` int(10) UNSIGNED NOT NULL COMMENT '属性对应的库存',
  `sales` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '销量',
  `price` decimal(8,2) UNSIGNED NOT NULL COMMENT '属性金额',
  `vip_price` decimal(9,2) NOT NULL DEFAULT '0.00' COMMENT '会员金额',
  `image` varchar(128) DEFAULT NULL COMMENT '图片',
  `unique` char(8) NOT NULL DEFAULT '' COMMENT '唯一值',
  `cost` decimal(8,2) UNSIGNED NOT NULL COMMENT '成本价'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品属性值表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_product_relation`
--

CREATE TABLE `eb_store_product_relation` (
  `uid` int(10) UNSIGNED NOT NULL COMMENT '用户ID',
  `product_id` int(10) UNSIGNED NOT NULL COMMENT '商品ID',
  `type` varchar(32) NOT NULL COMMENT '类型(收藏(collect）、点赞(like))',
  `category` varchar(32) NOT NULL COMMENT '某种类型的商品(普通商品、秒杀商品)',
  `add_time` int(10) UNSIGNED NOT NULL COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品点赞和收藏表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_product_reply`
--

CREATE TABLE `eb_store_product_reply` (
  `id` int(11) NOT NULL COMMENT '评论ID',
  `uid` int(11) NOT NULL COMMENT '用户ID',
  `oid` int(11) NOT NULL COMMENT '订单ID',
  `unique` char(32) NOT NULL COMMENT '唯一id',
  `product_id` int(11) NOT NULL COMMENT '产品id',
  `reply_type` varchar(32) NOT NULL DEFAULT 'product' COMMENT '某种商品类型(普通商品、秒杀商品）',
  `product_score` tinyint(1) NOT NULL COMMENT '商品分数',
  `service_score` tinyint(1) NOT NULL COMMENT '服务分数',
  `packing_score` tinyint(1) NOT NULL DEFAULT '0' COMMENT '包装分数',
  `mer_score` tinyint(1) NOT NULL DEFAULT '0' COMMENT '商家评价',
  `delivery_score` tinyint(1) NOT NULL DEFAULT '0' COMMENT '配送速度分数',
  `comment` varchar(512) NOT NULL COMMENT '评论内容',
  `pics` text NOT NULL COMMENT '评论图片',
  `add_time` int(11) NOT NULL COMMENT '评论时间',
  `merchant_reply_content` varchar(300) NOT NULL COMMENT '管理员回复内容',
  `merchant_reply_time` int(11) NOT NULL COMMENT '管理员回复时间',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0未删除1已删除',
  `is_reply` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未回复1已回复'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='评论表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_seckill`
--

CREATE TABLE `eb_store_seckill` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '商品秒杀产品表id',
  `product_id` int(10) UNSIGNED NOT NULL COMMENT '商品id',
  `image` varchar(255) NOT NULL COMMENT '推荐图',
  `images` varchar(1000) NOT NULL COMMENT '轮播图',
  `title` varchar(255) NOT NULL COMMENT '活动标题',
  `info` varchar(255) NOT NULL COMMENT '简介',
  `price` decimal(10,2) UNSIGNED NOT NULL COMMENT '价格',
  `cost` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '成本',
  `ot_price` decimal(10,2) UNSIGNED NOT NULL COMMENT '原价',
  `give_integral` decimal(10,2) UNSIGNED NOT NULL COMMENT '返多少积分',
  `sort` int(10) UNSIGNED NOT NULL COMMENT '排序',
  `stock` int(10) UNSIGNED NOT NULL COMMENT '库存',
  `sales` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '销量',
  `unit_name` varchar(16) NOT NULL COMMENT '单位名',
  `postage` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '邮费',
  `description` text NOT NULL COMMENT '内容',
  `start_time` varchar(128) NOT NULL COMMENT '开始时间',
  `stop_time` varchar(128) NOT NULL COMMENT '结束时间',
  `add_time` varchar(128) NOT NULL COMMENT '添加时间',
  `status` tinyint(1) UNSIGNED NOT NULL COMMENT '产品状态',
  `is_postage` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否包邮',
  `is_hot` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '热门推荐',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '删除 0未删除1已删除',
  `num` int(11) UNSIGNED NOT NULL COMMENT '最多秒杀几个',
  `is_show` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '显示'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商品秒杀产品表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_seckill_attr`
--

CREATE TABLE `eb_store_seckill_attr` (
  `product_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商品ID',
  `attr_name` varchar(32) NOT NULL COMMENT '属性名',
  `attr_values` varchar(256) NOT NULL COMMENT '属性值'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='秒杀商品属性表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_seckill_attr_result`
--

CREATE TABLE `eb_store_seckill_attr_result` (
  `product_id` int(10) UNSIGNED NOT NULL COMMENT '商品ID',
  `result` text NOT NULL COMMENT '商品属性参数',
  `change_time` int(10) UNSIGNED NOT NULL COMMENT '上次修改时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='秒杀商品属性详情表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_seckill_attr_value`
--

CREATE TABLE `eb_store_seckill_attr_value` (
  `product_id` int(10) UNSIGNED NOT NULL COMMENT '商品ID',
  `suk` varchar(128) NOT NULL COMMENT '商品属性索引值 (attr_value|attr_value[|....])',
  `stock` int(10) UNSIGNED NOT NULL COMMENT '属性对应的库存',
  `sales` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '销量',
  `price` decimal(8,2) UNSIGNED NOT NULL COMMENT '属性金额',
  `image` varchar(128) DEFAULT NULL COMMENT '图片',
  `unique` char(8) NOT NULL DEFAULT '' COMMENT '唯一值',
  `cost` decimal(8,2) UNSIGNED NOT NULL COMMENT '成本价'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='秒杀商品属性值表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_service`
--

CREATE TABLE `eb_store_service` (
  `id` int(11) NOT NULL COMMENT '客服id',
  `mer_id` int(11) NOT NULL DEFAULT '0' COMMENT '商户id',
  `uid` int(11) NOT NULL COMMENT '客服uid',
  `avatar` varchar(250) NOT NULL COMMENT '客服头像',
  `notify` int(11) NOT NULL DEFAULT '0',
  `nickname` varchar(50) NOT NULL COMMENT '代理名称',
  `add_time` int(11) NOT NULL COMMENT '添加时间',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '0隐藏1显示'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='客服表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_service_log`
--

CREATE TABLE `eb_store_service_log` (
  `id` int(11) NOT NULL COMMENT '客服用户对话记录表ID',
  `mer_id` int(11) NOT NULL DEFAULT '0' COMMENT '商户id',
  `msn` text NOT NULL COMMENT '消息内容',
  `uid` int(11) NOT NULL COMMENT '发送人uid',
  `to_uid` int(11) NOT NULL COMMENT '接收人uid',
  `add_time` int(11) NOT NULL COMMENT '发送时间',
  `type` tinyint(1) DEFAULT '0' COMMENT '是否已读（0：否；1：是；）',
  `remind` tinyint(1) DEFAULT '0' COMMENT '是否提醒过'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='客服用户对话记录表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_store_visit`
--

CREATE TABLE `eb_store_visit` (
  `id` int(10) NOT NULL,
  `product_id` int(11) DEFAULT NULL COMMENT '产品ID',
  `product_type` varchar(32) DEFAULT NULL COMMENT '产品类型',
  `cate_id` int(11) DEFAULT NULL COMMENT '产品分类ID',
  `type` char(50) DEFAULT NULL COMMENT '产品类型',
  `uid` int(11) DEFAULT NULL COMMENT '用户ID',
  `count` int(11) DEFAULT NULL COMMENT '访问次数',
  `content` varchar(255) DEFAULT NULL COMMENT '备注描述',
  `add_time` int(11) DEFAULT NULL COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='产品浏览分析表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_system_admin`
--

CREATE TABLE `eb_system_admin` (
  `id` smallint(5) UNSIGNED NOT NULL COMMENT '后台管理员表ID',
  `account` varchar(32) NOT NULL COMMENT '后台管理员账号',
  `pwd` char(32) NOT NULL COMMENT '后台管理员密码',
  `real_name` varchar(16) NOT NULL COMMENT '后台管理员姓名',
  `roles` varchar(128) NOT NULL COMMENT '后台管理员权限(menus_id)',
  `last_ip` varchar(16) DEFAULT NULL COMMENT '后台管理员最后一次登录ip',
  `last_time` int(10) UNSIGNED DEFAULT NULL COMMENT '后台管理员最后一次登录时间',
  `add_time` int(10) UNSIGNED NOT NULL COMMENT '后台管理员添加时间',
  `login_count` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '登录次数',
  `level` tinyint(3) UNSIGNED NOT NULL DEFAULT '1' COMMENT '后台管理员级别',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '后台管理员状态 1有效0无效',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='后台管理员表';

--
-- 转存表中的数据 `eb_system_admin`
--

INSERT INTO `eb_system_admin` (`id`, `account`, `pwd`, `real_name`, `roles`, `last_ip`, `last_time`, `add_time`, `login_count`, `level`, `status`, `is_del`) VALUES
(1, 'admin', '31f9abf61ad21a39fe44b0790e1a4f6d', 'admin', '1', '111.18.84.139', 1582432279, 1581341252, 0, 0, 1, 0),
(2, 'demo', 'fe01ce2a7fbac8fafaed7c982a04e229', 'demo', '23', '106.44.7.186', 1582437709, 1581585623, 0, 1, 1, 0);

-- --------------------------------------------------------

--
-- 表的结构 `eb_system_attachment`
--

CREATE TABLE `eb_system_attachment` (
  `att_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL COMMENT '附件名称',
  `att_dir` varchar(200) NOT NULL COMMENT '附件路径',
  `satt_dir` varchar(200) DEFAULT NULL COMMENT '压缩图片路径',
  `att_size` char(30) NOT NULL COMMENT '附件大小',
  `att_type` char(30) NOT NULL COMMENT '附件类型',
  `pid` int(10) NOT NULL COMMENT '分类id',
  `time` int(11) NOT NULL COMMENT '上传时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='附件管理表';

--
-- 转存表中的数据 `eb_system_attachment`
--

INSERT INTO `eb_system_attachment` (`att_id`, `name`, `att_dir`, `satt_dir`, `att_size`, `att_type`, `pid`, `time`) VALUES
(23, 'dff8b202002111344407490.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/dff8b202002111344407490.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/dff8b202002111344407490.png', '0', 'image/jpg', 4, 1581399880),
(24, '4e0a9202002111413415852.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/4e0a9202002111413415852.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/4e0a9202002111413415852.jpg', '0', 'image/jpg', 5, 1581401621),
(25, '5ab3f202002111454479193.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/5ab3f202002111454479193.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/5ab3f202002111454479193.jpg', '0', 'image/jpg', 0, 1581404087),
(26, 'bd2ef202002111519022660.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/bd2ef202002111519022660.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/bd2ef202002111519022660.jpg', '0', 'image/jpg', 6, 1581405542),
(27, '12017202002111757416996.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/12017202002111757416996.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/12017202002111757416996.png', '0', 'image/jpg', 0, 1581415061),
(28, 'fb05a202002111757415258.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/fb05a202002111757415258.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/fb05a202002111757415258.png', '0', 'image/jpg', 0, 1581415061),
(29, '022b1202002111757413298.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/022b1202002111757413298.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/022b1202002111757413298.png', '0', 'image/jpg', 0, 1581415061),
(30, '8cf7c202002111757418051.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/8cf7c202002111757418051.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/8cf7c202002111757418051.png', '0', 'image/jpg', 0, 1581415061),
(31, 'a3248202002111757415453.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/a3248202002111757415453.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/a3248202002111757415453.png', '0', 'image/jpg', 0, 1581415061),
(32, '37e3a202002111757417776.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/37e3a202002111757417776.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/37e3a202002111757417776.png', '0', 'image/jpg', 0, 1581415062),
(33, 'ccb10202002111757423753.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/ccb10202002111757423753.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/ccb10202002111757423753.jpg', '0', 'image/jpg', 0, 1581415062),
(34, 'abbe8202002111757429842.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/abbe8202002111757429842.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/abbe8202002111757429842.png', '0', 'image/jpg', 0, 1581415062),
(35, '10f3d202002111757429313.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/10f3d202002111757429313.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/10f3d202002111757429313.jpg', '0', 'image/jpg', 0, 1581415062),
(36, 'e20b0202002111757424191.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/e20b0202002111757424191.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/e20b0202002111757424191.png', '0', 'image/jpg', 0, 1581415062),
(37, '55bd0202002111757421468.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/55bd0202002111757421468.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/55bd0202002111757421468.png', '0', 'image/jpg', 0, 1581415062),
(38, '6b85d202002111757421971.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/6b85d202002111757421971.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/6b85d202002111757421971.jpg', '0', 'image/jpg', 0, 1581415062),
(39, '7d68920200211175742320.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/7d68920200211175742320.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/7d68920200211175742320.png', '0', 'image/jpg', 0, 1581415062),
(40, '09bd3202002111757426798.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/09bd3202002111757426798.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/09bd3202002111757426798.png', '0', 'image/jpg', 0, 1581415063),
(41, '7f0bd202002111757435432.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/7f0bd202002111757435432.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/7f0bd202002111757435432.jpg', '0', 'image/jpg', 0, 1581415063),
(42, '99cb7202002111757434673.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/99cb7202002111757434673.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/99cb7202002111757434673.jpg', '0', 'image/jpg', 0, 1581415063),
(43, '7c54d202002111757589056.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/7c54d202002111757589056.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/7c54d202002111757589056.png', '0', 'image/jpg', 0, 1581415078),
(44, '8b0be202002111757582367.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/8b0be202002111757582367.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/8b0be202002111757582367.jpg', '0', 'image/jpg', 0, 1581415078),
(45, '5ae6f202002111757583267.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/5ae6f202002111757583267.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/5ae6f202002111757583267.jpg', '0', 'image/jpg', 0, 1581415078),
(46, '67c04202002111757584709.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/67c04202002111757584709.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/67c04202002111757584709.jpg', '0', 'image/jpg', 0, 1581415079),
(47, '7809f202002111801111378.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/7809f202002111801111378.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/7809f202002111801111378.jpg', '0', 'image/jpg', 0, 1581415271),
(48, '32095202002111804187328.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/32095202002111804187328.jpg', '0', 'image/jpg', 0, 1581415458),
(49, '9ec16202002121807113099.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/9ec16202002121807113099.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/9ec16202002121807113099.png', '0', 'image/jpg', 0, 1581502031),
(50, '9d76920200212180711743.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/9d76920200212180711743.png', 'http://testcrmeb.oss-cn-beijing.aliyuncs.com/9d76920200212180711743.png', '0', 'image/jpg', 0, 1581502031),
(51, '34285202002171340371181.gif', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/34285202002171340371181.gif', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/34285202002171340371181.gif', '0', 'image/jpg', 6, 1581918037),
(52, 'd6c57202002171744271971.png', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/d6c57202002171744271971.png', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/d6c57202002171744271971.png', '0', 'image/jpg', 6, 1581932667),
(53, '68244202002171745063469.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/68244202002171745063469.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/68244202002171745063469.jpg', '0', 'image/jpg', 6, 1581932714),
(54, 'f939b202002201114298263.png', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/f939b202002201114298263.png', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/f939b202002201114298263.png', '0', 'image/jpg', 0, 1582168469),
(74, '267f3202002201232144167.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/267f3202002201232144167.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/267f3202002201232144167.jpg', '0', 'image/jpg', 0, 1582173134),
(75, '1b0cb202002201232145135.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/1b0cb202002201232145135.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/1b0cb202002201232145135.jpg', '0', 'image/jpg', 0, 1582173134),
(76, '9f41f202002201232146791.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/9f41f202002201232146791.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/9f41f202002201232146791.jpg', '0', 'image/jpg', 0, 1582173134),
(77, '44910202002201232149124.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/44910202002201232149124.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/44910202002201232149124.jpg', '0', 'image/jpg', 0, 1582173135),
(78, '3e9f4202002201232159295.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/3e9f4202002201232159295.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/3e9f4202002201232159295.jpg', '0', 'image/jpg', 0, 1582173135),
(79, '8ab46202002201232152644.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/8ab46202002201232152644.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/8ab46202002201232152644.jpg', '0', 'image/jpg', 0, 1582173135),
(80, '887d9202002201232157812.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/887d9202002201232157812.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/887d9202002201232157812.jpg', '0', 'image/jpg', 0, 1582173135),
(81, '9547920200220123215506.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/9547920200220123215506.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/9547920200220123215506.jpg', '0', 'image/jpg', 0, 1582173135),
(82, '85d12202002201232152250.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/85d12202002201232152250.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/85d12202002201232152250.jpg', '0', 'image/jpg', 0, 1582173136),
(83, '9a0d1202002201232324402.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/9a0d1202002201232324402.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/9a0d1202002201232324402.jpg', '0', 'image/jpg', 0, 1582173154),
(84, 'd41c7202002201232431520.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/d41c7202002201232431520.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/d41c7202002201232431520.jpg', '0', 'image/jpg', 0, 1582173163),
(85, 'f4313202002201232435004.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/f4313202002201232435004.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/f4313202002201232435004.jpg', '0', 'image/jpg', 0, 1582173163),
(86, 'ce99d202002201232432554.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/ce99d202002201232432554.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/ce99d202002201232432554.jpg', '0', 'image/jpg', 0, 1582173164),
(87, '78cdd20200220123244525.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/78cdd20200220123244525.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/78cdd20200220123244525.jpg', '0', 'image/jpg', 0, 1582173164),
(88, '3ec76202002201232442683.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/3ec76202002201232442683.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/3ec76202002201232442683.jpg', '0', 'image/jpg', 0, 1582173164),
(89, 'e56f5202002201232449146.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/e56f5202002201232449146.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/e56f5202002201232449146.jpg', '0', 'image/jpg', 0, 1582173164),
(90, '0620e202002201232446695.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/0620e202002201232446695.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/0620e202002201232446695.jpg', '0', 'image/jpg', 0, 1582173164),
(91, '32379202002201232449232.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/32379202002201232449232.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/32379202002201232449232.jpg', '0', 'image/jpg', 0, 1582173165),
(92, '744f3202002201232457195.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/744f3202002201232457195.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/744f3202002201232457195.jpg', '0', 'image/jpg', 0, 1582173165),
(94, '20362202002201412303972.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', 'http://cremb-zsff.oss-cn-beijing.aliyuncs.com/20362202002201412303972.jpg', '0', 'image/jpg', 0, 1582179150);

-- --------------------------------------------------------

--
-- 表的结构 `eb_system_attachment_category`
--

CREATE TABLE `eb_system_attachment_category` (
  `id` int(11) NOT NULL,
  `pid` int(11) DEFAULT '0' COMMENT '父级ID',
  `name` varchar(50) NOT NULL COMMENT '分类名称',
  `enname` varchar(50) NOT NULL COMMENT '分类目录'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='附件分类表';

--
-- 转存表中的数据 `eb_system_attachment_category`
--

INSERT INTO `eb_system_attachment_category` (`id`, `pid`, `name`, `enname`) VALUES
(4, 0, '导航图标', ''),
(5, 0, '专题主图', ''),
(6, 0, '公众号图', '');

-- --------------------------------------------------------

--
-- 表的结构 `eb_system_config`
--

CREATE TABLE `eb_system_config` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '配置id',
  `menu_name` varchar(255) NOT NULL COMMENT '字段名称',
  `type` varchar(255) NOT NULL COMMENT '类型(文本框,单选按钮...)',
  `input_type` varchar(20) DEFAULT 'input' COMMENT '表单类型',
  `config_tab_id` int(10) UNSIGNED NOT NULL COMMENT '配置分类id',
  `parameter` varchar(255) DEFAULT NULL COMMENT '规则 单选框和多选框',
  `upload_type` tinyint(1) UNSIGNED DEFAULT NULL COMMENT '上传文件格式1单图2多图3文件',
  `required` varchar(255) DEFAULT NULL COMMENT '规则',
  `width` int(10) UNSIGNED DEFAULT NULL COMMENT '多行文本框的宽度',
  `high` int(10) UNSIGNED DEFAULT NULL COMMENT '多行文框的高度',
  `value` varchar(5000) DEFAULT NULL COMMENT '默认值',
  `info` varchar(255) NOT NULL COMMENT '配置名称',
  `desc` varchar(255) DEFAULT NULL COMMENT '配置简介',
  `sort` int(10) UNSIGNED NOT NULL COMMENT '排序',
  `status` tinyint(1) UNSIGNED NOT NULL COMMENT '是否隐藏'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='配置表';

--
-- 转存表中的数据 `eb_system_config`
--

INSERT INTO `eb_system_config` (`id`, `menu_name`, `type`, `input_type`, `config_tab_id`, `parameter`, `upload_type`, `required`, `width`, `high`, `value`, `info`, `desc`, `sort`, `status`) VALUES
(1, 'site_name', 'text', 'input', 1, '', 0, 'required:true', 100, 0, '\"\\u77e5\\u8bc6\\u4ed8\\u8d39\"', '网站名称', '网站名称', 0, 1),
(2, 'site_url', 'text', 'input', 1, '', 0, 'required:true,url:true', 100, 0, '\"\"', '网站地址', '网站地址', 0, 1),
(3, 'site_logo', 'upload', 'input', 1, '', 1, '', 0, 0, '\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/d6c57202002171744271971.png\"', '后台LOGO', '左上角logo,建议尺寸[170*50]', 0, 1),
(4, 'site_phone', 'text', 'input', 1, '', 0, '', 100, 0, '\"\"', '联系电话', '联系电话', 0, 1),
(5, 'seo_title', 'text', 'input', 1, '', 0, 'required:true', 100, 0, '\"\"', 'SEO标题', 'SEO标题', 0, 1),
(6, 'site_email', 'text', 'input', 1, '', 0, 'email:true', 100, 0, '\"\"', '联系邮箱', '联系邮箱', 0, 1),
(7, 'site_qq', 'text', 'input', 1, '', 0, 'qq:true', 100, 0, '\"\"', '联系QQ', '联系QQ', 0, 1),
(9, 'close_system', 'radio', 'input', 1, '0=开启\n1=关闭', 0, '', 0, 0, '\"0\"', '关闭后台', '关闭后台', 0, 2),
(10, 'wechat_name', 'text', 'input', 2, '', 0, 'required:true', 100, 0, '\"\"', '公众号名称', '公众号的名称', 0, 1),
(11, 'wechat_id', 'text', 'input', 2, '', 0, 'required:true', 100, 0, '\"\"', '微信号', '微信号', 0, 1),
(12, 'wechat_sourceid', 'text', 'input', 2, '', 0, 'required:true', 100, 0, '\"\"', '公众号原始id', '公众号原始id', 0, 1),
(13, 'wechat_appid', 'text', 'input', 2, '', 0, 'required:true', 100, 0, '\"\"', 'AppID', 'AppID', 0, 1),
(14, 'wechat_appsecret', 'text', 'input', 2, '', 0, 'required:true', 100, 0, '\"\"', 'AppSecret', 'AppSecret', 0, 1),
(15, 'wechat_token', 'text', 'input', 2, '', 0, 'required:true', 100, 0, '\"\"', '微信验证TOKEN', '微信验证TOKEN', 0, 1),
(16, 'wechat_encode', 'radio', 'input', 2, '0=明文模式\n1=兼容模式\n2=安全模式', 0, '', 0, 0, '\"0\"', '消息加解密方式', '如需使用安全模式请在管理中心修改，仅限服务号和认证订阅号', 0, 1),
(17, 'wechat_encodingaeskey', 'text', 'input', 2, '', 0, 'required:true', 100, 0, '\"\"', 'EncodingAESKey', '公众号消息加解密Key,在使用安全模式情况下要填写该值，请先在管理中心修改，然后填写该值，仅限服务号和认证订阅号', 0, 1),
(18, 'wechat_share_img', 'upload', 'input', 3, '', 1, '', 0, 0, '\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/68244202002171745063469.jpg\"', '微信分享图片', '若填写此图片地址，则分享网页出去时会分享此图片。可有效防止分享图片变形', 0, 1),
(19, 'wechat_qrcode', 'upload', 'input', 2, '', 1, '', 0, 0, '\"http:\\/\\/testcrmeb.oss-cn-beijing.aliyuncs.com\\/bd2ef202002111519022660.jpg\"', '公众号二维码', '您的公众号二维码', 0, 1),
(20, 'wechat_type', 'radio', 'input', 2, '0=服务号\n1=订阅号', 0, '', 0, 0, '\"0\"', '公众号类型', '公众号的类型', 0, 1),
(21, 'wechat_share_title', 'text', 'input', 3, '', 0, 'required:true', 100, 0, '\"\\u77e5\\u8bc6\\u4ed8\\u8d39\"', '微信分享标题', '微信分享标题', 0, 1),
(22, 'wechat_share_synopsis', 'textarea', 'input', 3, '', 0, '', 100, 5, '\"\\u77e5\\u8bc6\\u4ed8\\u8d39\"', '微信分享简介', '微信分享简介', 0, 1),
(23, 'pay_weixin_appid', 'text', 'input', 4, '', 0, '', 100, 0, '\"\"', 'Appid', '微信公众号身份的唯一标识。审核通过后，在微信发送的邮件中查看。', 0, 1),
(24, 'pay_weixin_appsecret', 'text', 'input', 4, '', 0, '', 100, 0, '\"\"', 'Appsecret', 'JSAPI接口中获取openid，审核后在公众平台开启开发模式后可查看。', 0, 1),
(25, 'pay_weixin_mchid', 'text', 'input', 4, '', 0, '', 100, 0, '\"\"', 'Mchid', '受理商ID，身份标识', 0, 1),
(26, 'pay_weixin_client_cert', 'upload', 'input', 4, '', 3, '', 0, 0, '\"\"', '微信支付证书', '微信支付证书，在微信商家平台中可以下载！文件名一般为apiclient_cert.pem', 0, 1),
(27, 'pay_weixin_client_key', 'upload', 'input', 4, '', 3, '', 0, 0, '\"\"', '微信支付证书密钥', '微信支付证书密钥，在微信商家平台中可以下载！文件名一般为apiclient_key.pem', 0, 1),
(28, 'pay_weixin_key', 'text', 'input', 4, '', 0, '', 100, 0, '\"\"', 'Key', '商户支付密钥Key。审核通过后，在微信发送的邮件中查看。', 0, 1),
(29, 'pay_weixin_open', 'radio', 'input', 4, '1=开启\n0=关闭', NULL, NULL, 0, 0, '1', '开启', '是否启用微信支付', 0, 2),
(31, 'store_postage', 'text', 'input', 10, '', 0, 'number:true,min:0', 100, 0, '\"12\"', '邮费基础价', '商品邮费基础价格,最终金额为(基础价 + 商品1邮费 + 商品2邮费)', 0, 1),
(32, 'store_free_postage', 'text', 'input', 5, '', 0, 'number:true,min:-1', 100, 0, '\"200\"', '满额包邮', '商城商品满多少金额即可包邮', 0, 1),
(33, 'offline_postage', 'radio', 'input', 10, '0=不包邮\n1=包邮', 0, '', 0, 0, '\"1\"', '线下支付是否包邮', '用户选择线下支付时是否包邮', 0, 1),
(34, 'integral_ratio', 'text', 'input', 11, '', 0, 'number:true', 100, 0, '\"0.01\"', '积分抵用比例', '积分抵用比例(1积分抵多少金额)', 0, 1),
(35, 'site_service_phone', 'text', 'input', 1, '', 0, '', 100, 0, '\"\"', '客服电话', '客服联系电话', 0, 1),
(44, 'store_user_min_recharge', 'text', 'input', 5, '', 0, 'required:true,number:true,min:0', 100, 0, '\"0.01\"', '用户最低充值金额', '用户单次最低充值金额', 0, 0),
(45, 'site_store_admin_uids', 'text', 'input', 5, '', 0, '', 100, 0, '\"4\"', '管理员用户ID', '管理员用户ID,用于接收商城订单提醒，到微信用户中查找编号，多个英文‘,’隔开', 0, 1),
(46, 'system_express_app_code', 'text', 'input', 10, '', 0, '', 100, 0, '\"dbc3c1426efe44fdb6c0aa04c52a4ca9\"', '快递查询密钥', '阿里云快递查询接口密钥购买地址：https://market.aliyun.com/products/57126001/cmapi011120.html', 0, 1),
(47, 'main_business', 'text', 'input', 2, '', 0, 'required:true', 100, 0, '\" IT\\u79d1\\u6280 \\u4e92\\u8054\\u7f51|\\u7535\\u5b50\\u5546\\u52a1\"', '微信模板消息_主营行业', '微信公众号模板消息中选择开通的主营行业', 0, 0),
(48, 'vice_business', 'text', 'input', 2, '', 0, 'required:true', 100, 0, '\"IT\\u79d1\\u6280 IT\\u8f6f\\u4ef6\\u4e0e\\u670d\\u52a1 \"', '微信模板消息_副营行业', '微信公众号模板消息中选择开通的副营行业', 0, 0),
(49, 'store_brokerage_ratio', 'text', 'input', 9, NULL, NULL, 'required:true,min:0,max:100,number:true', 100, 0, '\"60\"', '一级推广人返佣比例', '订单交易成功后给上级返佣的比例0 - 100,例:5 = 反订单金额的5%', 9, 1),
(50, 'wechat_first_sub_give_coupon', 'text', 'input', 12, '', 0, 'requred:true,digits:true,min:0', 100, 0, '\"\"', '首次关注赠送优惠券ID', '首次关注赠送优惠券ID,0为不赠送', 0, 1),
(51, 'store_give_con_min_price', 'text', 'input', 12, '', 0, 'requred:true,digits:true,min:0', 100, 0, '\"0.01\"', '消费满多少赠送优惠券', '消费满多少赠送优惠券,0为不赠送', 0, 1),
(52, 'store_order_give_coupon', 'text', 'input', 12, '', 0, 'requred:true,digits:true,min:0', 100, 0, '\"\"', '消费赠送优惠劵ID', '消费赠送优惠劵ID,0为不赠送', 0, 1),
(54, 'sx_sign_min_int', 'text', 'input', 11, '', 0, 'required:true,number:true,min:0', 100, 0, '\"1\"', '签到奖励最低积分', '签到奖励最低积分', 0, 1),
(55, 'sx_sign_max_int', 'text', 'input', 11, '', 0, 'required:true,number:true,min:0', 100, 0, '\"5\"', '签到奖励最高积分', '签到奖励最高积分', 0, 1),
(57, 'about_us', 'upload', 'input', 1, '', 1, '', 0, 0, '\"\"', '关于我们', '系统的标识', 0, 1),
(58, 'replenishment_num', 'text', 'input', 5, '', 0, 'required:true,number:true,min:0', 100, 0, '\"20\"', '待补货数量', '产品待补货数量低于多少时，提示补货', 0, 1),
(59, 'routine_appId', 'text', 'input', 7, '', 0, '', 100, 0, '\"\"', 'appId', '小程序appID', 0, 1),
(60, 'routine_appsecret', 'text', 'input', 7, '', 0, '', 100, 0, '\"\"', 'AppSecret', '小程序AppSecret', 0, 1),
(61, 'api', 'text', 'input', 2, '', 0, '', 100, 0, '\"\\/wap\\/wechat\\/serve\"', '接口地址', '微信接口例如：http://www.abc.com/wap/wechat/serve', 0, 1),
(62, 'paydir', 'textarea', 'input', 4, '', 0, '', 100, 5, '\"\\/wap\\/special\\/details\\n\"', '配置目录', '支付目录配置系统不调用提示作用', 0, 1),
(73, 'routine_logo', 'upload', 'input', 7, '', 1, '', 0, 0, '\"\"', '小程序logo', '小程序logo', 0, 1),
(74, 'routine_name', 'text', 'input', 7, '', 0, '', 100, 0, '\"\\u8f66\\u8054\\u76df\\u65b0\\u80fd\\u6e90\"', '小程序名称', '小程序名称', 0, 1),
(76, 'routine_style', 'text', 'input', 7, '', 0, '', 100, 0, '\"#FFFFFF\"', '小程序风格', '小程序颜色', 0, 1),
(77, 'store_stock', 'text', 'input', 5, '', 0, '', 100, 0, '\"1\"', '警戒库存', '警戒库存提醒值', 0, 1),
(85, 'stor_reason', 'textarea', 'input', 5, '', 0, '', 100, 8, '\"\\u6536\\u8d27\\u5730\\u5740\\u586b\\u9519\\u4e86=\\u4e0e\\u63cf\\u8ff0\\u4e0d\\u7b26=\\u4fe1\\u606f\\u586b\\u9519\\u4e86\\uff0c\\u91cd\\u65b0\\u62cd=\\u6536\\u5230\\u5546\\u54c1\\u635f\\u574f\\u4e86=\\u672a\\u6309\\u9884\\u5b9a\\u65f6\\u95f4\\u53d1\\u8d27=\\u5176\\u5b83\\u539f\\u56e0\"', '退货理由', '配置退货理由，一行一个理由', 0, 1),
(87, 'store_brokerage_two', 'text', 'input', 9, NULL, NULL, 'required:true,min:0,max:100,number:true', 100, 0, '\"30\"', '二级推广人返佣比例', '订单交易成功后给上级返佣的比例0 - 100,例:5 = 反订单金额的5%', 8, 1),
(88, 'store_brokerage_statu', 'radio', 'input', 9, '1=指定分销\n2=人人分销', 0, '', 0, 0, '\"2\"', '分销模式', '人人分销默认每个人都可以分销，制定人分销后台制定人开启分销', 10, 1),
(89, 'pay_routine_appid', 'text', 'input', 14, '', 0, 'required:true', 100, 0, '\"\"', 'Appid', '小程序Appid', 0, 1),
(90, 'pay_routine_appsecret', 'text', 'input', 14, '', 0, 'required:true', 100, 0, '\"\"', 'Appsecret', '小程序Appsecret', 0, 1),
(91, 'pay_routine_mchid', 'text', 'input', 14, '', 0, 'required:true', 100, 0, '\"\"', 'Mchid', '商户号', 0, 1),
(92, 'pay_routine_key', 'text', 'input', 14, '', 0, 'required:true', 100, 0, '\"\"', 'Key', '商户key', 0, 1),
(93, 'pay_routine_client_cert', 'upload', 'input', 14, '', 3, '', 0, 0, '[\"\\/public\\/uploads\\/config\\/file\\/5c12fb7b9ebc5.pem\"]', '小程序支付证书', '小程序支付证书', 0, 1),
(94, 'pay_routine_client_key', 'upload', 'input', 14, '', 3, '', 0, 0, '[\"\\/public\\/uploads\\/config\\/file\\/5c12fb7eb8897.pem\"]', '小程序支付证书密钥', '小程序支付证书密钥', 0, 1),
(95, 'log_cycle', 'text', 'input', 1, '', 0, '', 100, 0, '\"\"', '系统日志', '系统日志保存时间单位天', 0, 1),
(96, 'sign_in_integral', 'radio', 'input', 11, '1=开启\n0=关闭', NULL, NULL, NULL, NULL, '\"0\"', '签到送积分', '签到送积分显示开关', 0, 1),
(97, 'give_integral', 'radio', 'input', 11, '1=开启\n0=关闭', NULL, NULL, NULL, NULL, '\"0\"', '邀请好友赠送积分', '邀请好友赠送积分显示开关', 0, 1),
(98, 'share_integral', 'radio', 'input', 11, '1=开启\n0=关闭', NULL, NULL, NULL, NULL, '\"0\"', '分享商品送积分', '分享商品送积分开关', 0, 1),
(114, 'user_extract_bank', 'textarea', 'input', 5, NULL, NULL, NULL, 100, 6, '\"\\u62db\\u5546\\u94f6\\u884c=\\u5efa\\u8bbe\\u94f6\\u884c=\\u519c\\u4e1a\\u94f6\\u884c\"', '提现银行', '提现银行', 0, 1),
(116, 'index_recommend_url', 'upload', 'input', 15, NULL, 1, NULL, NULL, NULL, '[\"\\/public\\/uploads\\/config\\/image\\/5c1ef9f2594ea.png\"]', '主页推荐图', '主页推荐图', 0, 1),
(117, 'hot_food', 'upload', 'input', 15, NULL, 1, NULL, NULL, NULL, '\"\"', '热销菜品', '热销菜品', 0, 1),
(118, 'welcome_url', 'upload', 'input', 15, NULL, 1, NULL, NULL, NULL, '[\"\\/public\\/uploads\\/config\\/image\\/5c29e37db77e8.jpg\"]', '最受欢迎', '热销菜品', 0, 1),
(119, 'praise_part', 'text', 'input', 7, NULL, NULL, '', 100, NULL, '\"5\"', '用户给商户好评加分', '用户给商户好评加分', 0, 1),
(120, 'praise_bad_part', 'text', 'input', 7, NULL, NULL, '', 100, NULL, '\"8\"', '用户给商户差评减分分', '用户给商户好评加分', 0, 1),
(130, 'extract_min_money', 'text', 'input', 9, NULL, NULL, NULL, 100, NULL, '\"1\"', '提现最低金额', '提现最低金额', 0, 1),
(132, 'smsSignName', 'text', 'input', 17, NULL, NULL, '', 100, NULL, '\"CEMEB\\u77e5\\u8bc6\\u4ed8\\u8d39\"', '阿里云短信签名', '阿里云短信签名', 0, 1),
(133, 'accessKeyId', 'text', 'input', 18, NULL, NULL, NULL, 100, NULL, '\"\"', '阿里云AccessKeyId', '阿里云AccessKeyId', 0, 1),
(134, 'accessKeySecret', 'text', 'input', 18, NULL, NULL, NULL, 100, NULL, '\"\"', '阿里云AccessKeySecret', '阿里云AccessKeySecret', 0, 1),
(135, 'smsTemplateCode', 'text', 'input', 17, NULL, NULL, '', 100, NULL, '\"\"', '阿里云短信模板ID', '阿里云短信模板ID', 0, 1),
(140, 'spread_poster_url', 'upload', 'input', 9, NULL, 1, NULL, NULL, NULL, '\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/20362202002201412303972.jpg\"', '推广人海报', '推广人海报', 0, 1),
(141, 'special_gift_banner', 'upload', 'input', 22, NULL, 1, NULL, NULL, NULL, '\"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/9547920200220123215506.jpg\"', '赠送礼物广告图', '赠送礼物广告图', 0, 1),
(143, 'alipay_app_id', 'text', 'input', 16, NULL, NULL, '', 100, NULL, '\"\"', '蚂蚁金服appid', '蚂蚁金服appid', 0, 1),
(144, 'alipay_private_key', 'text', 'input', 16, NULL, NULL, '', 100, NULL, '\"\"', '蚂蚁金服key', '蚂蚁金服key', 0, 1),
(145, 'alipay_public_key', 'text', 'input', 16, NULL, NULL, '', 100, NULL, '\"\"', '蚂蚁金服公钥', '蚂蚁金服公钥', 0, 1),
(146, 'promoter_content', 'textarea', 'input', 9, NULL, NULL, NULL, 100, 8, '\"\"', '推广细则', '推广细则', 0, 1),
(147, 'promoter_guide', 'textarea', 'input', 9, NULL, NULL, NULL, 100, 8, '\"\"', '推荐指引', '推荐指引', 0, 1),
(154, 'open_barrage', 'radio', 'input', 22, '1=开启\n0=关闭', NULL, NULL, 100, NULL, '\"1\"', '虚拟用户专题弹幕开关', '虚拟用户专题弹幕开关', 0, 1),
(155, 'barrage_show_time', 'text', 'input', 22, NULL, NULL, NULL, 100, NULL, '\"5\"', '专题弹幕停留时间', '专题弹幕停留时间 单位秒计算', 0, 1),
(164, 'uploadUrl', 'text', 'input', 19, NULL, NULL, '', 100, NULL, '\"\"', '空间域名 Domain', '空间域名 Domain', 0, 1),
(165, 'OssBucket', 'text', 'input', 19, NULL, NULL, '', 100, NULL, '\"\"', '存储空间名称', '存储空间名称,又称桶名', 0, 1),
(166, 'end_point', 'text', 'input', 19, NULL, NULL, '', 100, NULL, '\"oss-cn-beijing.aliyuncs.com\"', 'EndPoint（地域节点）', 'EndPoint（地域节点）', 0, 1),
(168, 'home_logo', 'upload', 'input', 22, NULL, 1, NULL, NULL, NULL, '\"http:\\/\\/testcrmeb.oss-cn-beijing.aliyuncs.com\\/a0c4b202002091840112762.png\"', '首页图标', '首页图标', 0, 1),
(169, 'aliyun_live_rtmpLink', 'text', 'input', 21, NULL, NULL, '', 100, NULL, '\"\"', '推流地址', '推流地址', 0, 1),
(170, 'aliyun_live_playLike', 'text', 'input', 21, NULL, NULL, '', 100, NULL, '\"\"', '播放地址', '播放地址', 0, 1),
(171, 'aliyun_live_push_key', 'text', 'input', 21, NULL, NULL, '', 100, NULL, '\"\"', '推流主key', '推流主key', 0, 1),
(172, 'aliyun_live_play_key', 'text', 'input', 21, NULL, NULL, '', 100, NULL, '\"\"', '播放主key', '播放主key', 0, 1),
(173, 'aliyun_live_appName', 'text', 'input', 21, NULL, NULL, '', 100, NULL, '\"\"', '直播应用名', '直播应用名(只能为英文数字组合)', 0, 1),
(174, 'aliyun_live_oss_bucket', 'text', 'input', 21, NULL, NULL, '', 100, NULL, '\"\"', '直播录制OSS桶名', '直播录制OSS桶名', 0, 1),
(175, 'aliyun_live_end_point', 'text', 'input', 21, NULL, NULL, NULL, 100, NULL, '\"oss-cn-shenzhen.aliyuncs.com\"', '直播录制OssEndpoint', '直播录制OssEndpoint地域节点', 0, 1);

-- --------------------------------------------------------

--
-- 表的结构 `eb_system_config_content`
--

CREATE TABLE `eb_system_config_content` (
  `id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '中文标题',
  `config_name` varchar(100) NOT NULL DEFAULT '' COMMENT '配置名',
  `content` text NOT NULL COMMENT '内容',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `is_show` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='配置文章表' ROW_FORMAT=COMPACT;

--
-- 转存表中的数据 `eb_system_config_content`
--

INSERT INTO `eb_system_config_content` (`id`, `title`, `config_name`, `content`, `add_time`, `is_show`, `is_del`) VALUES
(1, '关于我们', 'about_us', '&lt;p&gt;关于公司的信息介绍&lt;/p&gt;', 0, 1, 0),
(2, '用户付费协议', 'user_agreement', '', 0, 1, 0);

-- --------------------------------------------------------

--
-- 表的结构 `eb_system_config_tab`
--

CREATE TABLE `eb_system_config_tab` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '配置分类id',
  `title` varchar(255) NOT NULL COMMENT '配置分类名称',
  `eng_title` varchar(255) NOT NULL COMMENT '配置分类英文名称',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '配置分类状态',
  `info` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '配置分类是否显示',
  `icon` varchar(30) DEFAULT NULL COMMENT '图标',
  `type` int(2) DEFAULT '0' COMMENT '配置类型'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='配置分类表';

--
-- 转存表中的数据 `eb_system_config_tab`
--

INSERT INTO `eb_system_config_tab` (`id`, `title`, `eng_title`, `status`, `info`, `icon`, `type`) VALUES
(1, '基础配置', 'basics', 1, 0, 'cog', 0),
(2, '公众号配置', 'wechat', 1, 0, 'weixin', 1),
(3, '公众号分享配置', 'wechat_share', 1, 0, 'whatsapp', 1),
(4, '公众号支付配置', 'pay', 1, 0, 'jpy', 4),
(5, '商城配置(暂弃)', 'store', 2, 0, 'shopping-cart', 0),
(7, '小程序配置', 'routine', 1, 0, 'weixin', 2),
(9, '分销配置', 'fenxiao', 1, 0, 'sitemap', 3),
(10, '物流配置', 'express', 2, 0, 'motorcycle', 0),
(11, '积分配置', 'point', 1, 0, 'powerpoint-o', 3),
(12, '优惠券配置', 'coupon', 1, 0, 'heartbeat', 3),
(15, '小程序图片配置', 'routine_image_url', 1, 0, 'cc', 2),
(16, '支付宝支付配置', 'pay_system', 1, 0, 'yen', 4),
(17, '短信配置', 'sms_system', 1, 0, 'paper-plane', 5),
(18, '阿里云key配置', 'aliyun_system', 1, 0, 'sun-o', 5),
(19, 'OSS上传配置', 'oss_sytem', 1, 0, 'cloud-upload', 5),
(21, '阿里云直播', 'aliyun_live', 1, 0, 'arrow-circle-o-left', 5),
(22, '其他配置', 'shop_home', 1, 0, '', 6);


-- --------------------------------------------------------

--
-- 表的结构 `eb_system_file`
--

CREATE TABLE `eb_system_file` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '文件对比ID',
  `cthash` char(32) NOT NULL COMMENT '文件内容',
  `filename` varchar(255) NOT NULL COMMENT '文价名称',
  `atime` char(12) NOT NULL COMMENT '上次访问时间',
  `mtime` char(12) NOT NULL COMMENT '上次修改时间',
  `ctime` char(12) NOT NULL COMMENT '上次改变时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='文件对比表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_system_group`
--

CREATE TABLE `eb_system_group` (
  `id` int(11) NOT NULL COMMENT '组合数据ID',
  `name` varchar(50) NOT NULL COMMENT '数据组名称',
  `info` varchar(256) NOT NULL COMMENT '数据提示',
  `config_name` varchar(50) NOT NULL COMMENT '数据字段',
  `fields` text COMMENT '数据组字段以及类型（json数据）'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='组合数据表';

--
-- 转存表中的数据 `eb_system_group`
--

INSERT INTO `eb_system_group` (`id`, `name`, `info`, `config_name`, `fields`) VALUES
(34, '商城首页banner', '商城首页banner设置', 'store_home_banner', '[{\"name\":\"\\u6807\\u9898\",\"title\":\"title\",\"type\":\"input\",\"param\":\"\"},{\"name\":\"\\u94fe\\u63a5\",\"title\":\"url\",\"type\":\"input\",\"param\":\"\"},{\"name\":\"\\u56fe\\u7247\",\"title\":\"pic\",\"type\":\"upload\",\"param\":\"\"}]'),
(52, '提现银行', '提现银行', 'extract_bank', '[{\"name\":\"\\u94f6\\u884c\\u540d\\u79f0\",\"title\":\"bank_name\",\"type\":\"input\",\"param\":\"\"}]'),
(53, '提现规则', '提现规则', 'extract_rule', '[{\"name\":\"\\u89c4\\u5219\",\"title\":\"content\",\"type\":\"textarea\",\"param\":\"\"}]'),
(54, '分享页面背景图', '分享页面背景图', 'share_background', '[{\"name\":\"\\u80cc\\u666f\\u56fe\",\"title\":\"pic\",\"type\":\"upload\",\"param\":\"\"}]'),
(56, '首页活动区域图片', '首页活动区域图片', 'home_activity', '[{\"name\":\"\\u56fe\\u7247(260*260\\/416*214)\",\"title\":\"pic\",\"type\":\"upload\",\"param\":\"\"},{\"name\":\"\\u6807\\u9898\",\"title\":\"title\",\"type\":\"input\",\"param\":\"\"},{\"name\":\"\\u7b80\\u4ecb\",\"title\":\"info\",\"type\":\"input\",\"param\":\"\"},{\"name\":\"\\u516c\\u4f17\\u53f7\\u94fe\\u63a5\",\"title\":\"wap_link\",\"type\":\"select\",\"param\":\"\\/activity\\/goods_seckill=>\\u79d2\\u6740\\u5217\\u8868\\n\\/activity\\/bargain=>\\u780d\\u4ef7\\u5217\\u8868\\n\\/activity\\/group=>\\u62fc\\u56e2\\u5217\\u8868\"}]'),
(57, '会员权益', '会员权益', 'membership_interests', '[{\"name\":\"\\u6743\\u76ca\\u540d\\u79f0\",\"title\":\"name\",\"type\":\"input\",\"param\":\"\"},{\"name\":\"\\u56fe\\u6807\",\"title\":\"pic\",\"type\":\"upload\",\"param\":\"\"},{\"name\":\"\\u8bf4\\u660e\",\"title\":\"explain\",\"type\":\"input\",\"param\":\"\"},{\"name\":\"\\u6392\\u5e8f\",\"title\":\"sort\",\"type\":\"input\",\"param\":\"\"}]'),
(58, '会员说明', '会员说明', 'member_description', '[{\"name\":\"\\u5185\\u5bb9\",\"title\":\"text\",\"type\":\"input\",\"param\":\"\"},{\"name\":\"\\u6392\\u5e8f\",\"title\":\"sort\",\"type\":\"input\",\"param\":\"\"}]');



-- --------------------------------------------------------

--
-- 表的结构 `eb_system_group_data`
--

CREATE TABLE `eb_system_group_data` (
  `id` int(11) NOT NULL COMMENT '组合数据详情ID',
  `gid` int(11) NOT NULL COMMENT '对应的数据组id',
  `value` text NOT NULL COMMENT '数据组对应的数据值（json数据）',
  `add_time` int(10) NOT NULL COMMENT '添加数据时间',
  `sort` int(11) NOT NULL COMMENT '数据排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态（1：开启；2：关闭；）'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='组合数据详情表';

--
-- 转存表中的数据 `eb_system_group_data`
--

INSERT INTO `eb_system_group_data` (`id`, `gid`, `value`, `add_time`, `sort`, `status`) VALUES
(89, 38, '{\"banner\":{\"type\":\"upload\",\"value\":\"http:\\/\\/shop.crmeb.net\\/public\\/uploads\\/editor\\/20180601\\/5b10b2436876e.jpg\"}}', 1527153599, 1, 1),
(125, 52, '{\"bank_name\":{\"type\":\"input\",\"value\":\"\\u62db\\u5546\\u94f6\\u884c\"}}', 1545116190, 1, 1),
(126, 52, '{\"bank_name\":{\"type\":\"input\",\"value\":\"\\u5efa\\u8bbe\\u94f6\\u884c\"}}', 1545116196, 1, 1),
(127, 52, '{\"bank_name\":{\"type\":\"input\",\"value\":\"\\u519c\\u4e1a\\u94f6\\u884c\"}}', 1545116201, 1, 1),
(128, 52, '{\"bank_name\":{\"type\":\"input\",\"value\":\"\\u4e2d\\u56fd\\u94f6\\u884c\"}}', 1545116213, 1, 1),
(130, 52, '{\"bank_name\":{\"type\":\"input\",\"value\":\"\\u5de5\\u5546\\u94f6\\u884c\"}}', 1545116248, 1, 1),
(131, 53, '{\"content\":{\"type\":\"textarea\",\"value\":\"\\u5230\\u8d26\\u65f6\\u95f4T+1\"}}', 1545117378, 0, 1),
(132, 53, '{\"content\":{\"type\":\"textarea\",\"value\":\"\\u63d0\\u73b0\\u624b\\u7eed\\u8d39\\u6263\\u966410%\\uff08\\u542b\\u4e2a\\u4eba\\u6240\\u5f97\\u7a0e\\uff09\"}}', 1545117383, 1, 1),
(138, 54, '{\"pic\":{\"type\":\"upload\",\"value\":\"https:\\/\\/huochemeng.crmeb.net\\/public\\/uploads\\/25\\/20181224\\/s_5c2055fb368ab.jpg\"}}', 1545623151, 1, 1),
(147, 34, '{\"title\":{\"type\":\"input\",\"value\":\"1\"},\"url\":{\"type\":\"input\",\"value\":\"http:\\/\\/zhishifufei.crmeb.net\\/wap\\/special\\/special_cate.html\"},\"pic\":{\"type\":\"upload\",\"value\":\"http:\\/\\/testcrmeb.oss-cn-beijing.aliyuncs.com\\/7d68920200211175742320.png\"}}', 1548224930, 1, 1),
(155, 34, '{\"title\":{\"type\":\"input\",\"value\":\"2\"},\"url\":{\"type\":\"input\",\"value\":\"http:\\/\\/zhishifufei.crmeb.net\\/wap\\/special\\/special_cate.html\"},\"pic\":{\"type\":\"upload\",\"value\":\"http:\\/\\/testcrmeb.oss-cn-beijing.aliyuncs.com\\/9d76920200212180711743.png\"}}', 1581416351, 1, 1),
(156, 56, '{\"pic\":{\"type\":\"upload\",\"value\":\"http:\\/\\/testcrmeb.oss-cn-beijing.aliyuncs.com\\/ccb10202002111757423753.jpg\"},\"title\":{\"type\":\"input\",\"value\":\"\\u96f6\\u5143\\u8bfe\\u7a0b\\u514d\\u8d39\\u9886\"},\"info\":{\"type\":\"input\",\"value\":\"\\u673a\\u4f1a\\u4e0d\\u80fd\\u9519\\u8fc7\"},\"wap_link\":{\"type\":\"select\",\"value\":\"\\/wap\\/special\\/details?id=48\"},\"select_id\":{\"value\":\"48\",\"type\":\"select\"},\"type\":{\"type\":\"radio\",\"value\":\"0\"}}', 1581416634, 0, 1),
(158, 56, '{\"pic\":{\"type\":\"upload\",\"value\":\"http:\\/\\/testcrmeb.oss-cn-beijing.aliyuncs.com\\/7f0bd202002111757435432.jpg\"},\"title\":{\"type\":\"input\",\"value\":\"\\u96c5\\u601d\\u6258\\u798f\\u7ebf\\u4e0a\\u57f9\\u8bad\"},\"info\":{\"type\":\"input\",\"value\":\"\\u51fa\\u56fd\\u6df1\\u9020\\u5fc5\\u5907\\u8bfe\\u7a0b\"},\"wap_link\":{\"type\":\"select\",\"value\":\"\\/wap\\/special\\/details?id=49\"},\"select_id\":{\"value\":\"49\",\"type\":\"select\"},\"type\":{\"type\":\"radio\",\"value\":\"0\"}}', 1581416745, 0, 1),
(159, 56, '{\"pic\":{\"type\":\"upload\",\"value\":\"http:\\/\\/testcrmeb.oss-cn-beijing.aliyuncs.com\\/6b85d202002111757421971.jpg\"},\"title\":{\"type\":\"input\",\"value\":\"\\u8003\\u7814\\u5347\\u5b66\\u6b63\\u5f53\\u65f6\"},\"info\":{\"type\":\"input\",\"value\":\"\\u8003\\u7814\\u5f3a\\u52a9\\u529b\"},\"wap_link\":{\"type\":\"select\",\"value\":\"\\/wap\\/special\\/special_cate?cate_id=8\"},\"select_id\":{\"value\":\"8\",\"type\":\"select\"},\"type\":{\"type\":\"radio\",\"value\":\"1\"}}', 1581416759, 0, 1),
(160, 34, '{\"title\":{\"type\":\"input\",\"value\":\"3\"},\"url\":{\"type\":\"input\",\"value\":\"http:\\/\\/zhishifufei.crmeb.net\\/wap\\/special\\/special_cate.html\"},\"pic\":{\"type\":\"upload\",\"value\":\"http:\\/\\/testcrmeb.oss-cn-beijing.aliyuncs.com\\/9ec16202002121807113099.png\"}}', 1581502059, 1, 1),
(161, 57, '{"name":{"type":"input","value":"\\u4f1a\\u5458\\u4f18\\u60e0\\u4ef7"},"pic":{"type":"upload","value":"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/39472202004291128217988.png"},"explain":{"type":"input","value":"\\u8d2d\\u4e70\\u4e13\\u9898\\u4eab\\u4f1a\\u5458\\u4ef7"},"sort":{"type":"input","value":"1"}}', '1588130969', '1', '1'),
(162, 57, '{"name":{"type":"input","value":"\\u514d\\u8d39\\u8bfe\\u7a0b"},"pic":{"type":"upload","value":"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/59285202004291128212590.png"},"explain":{"type":"input","value":"\\u90e8\\u5206\\u8bfe\\u7a0b\\u4f1a\\u5458\\u514d\\u8d39"},"sort":{"type":"input","value":"2"}}', '1588130996', '2', '1'),
(163, 57, '{"name":{"type":"input","value":"\\u66f4\\u591a\\u6743\\u76ca"},"pic":{"type":"upload","value":"http:\\/\\/cremb-zsff.oss-cn-beijing.aliyuncs.com\\/11009202004291128212348.png"},"explain":{"type":"input","value":"\\u66f4\\u591a\\u6743\\u76ca\\u589e\\u52a0\\u4e2d"},"sort":{"type":"input","value":"3"}}', '1588131020', '3', '1'),
(164, 58, '{"text":{"type":"input","value":"\\u4f1a\\u5458\\u8d2d\\u4e70\\u90e8\\u5206\\u8bfe\\u7a0b\\u53ef\\u4eab\\u53d7\\u4f18\\u60e0\\u4ef7"},"sort":{"type":"input","value":"1"}}', '1588131048', '1', '1'),
(165, 58, '{"text":{"type":"input","value":"\\u4f1a\\u5458\\u5230\\u671f\\u540e\\u6743\\u76ca\\u5373\\u5931\\u6548\\uff0c\\u9700\\u7ee7\\u7eed\\u4eab\\u53d7\\u6743\\u76ca\\u8bf7\\u53ca\\u65f6\\u7eed\\u8d39"},"sort":{"type":"input","value":"2"}}', '1588131059', '2', '1'),
(166, 58, '{"text":{"type":"input","value":"\\u62fc\\u56e2\\u6d3b\\u52a8\\u4ef7\\u65e0\\u4f1a\\u5458\\u4f18\\u60e0"},"sort":{"type":"input","value":"3"}}', '1588131073', '3', '1');

-- --------------------------------------------------------

--
-- 表的结构 `eb_system_log`
--

CREATE TABLE `eb_system_log` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '管理员操作记录ID',
  `admin_id` int(10) UNSIGNED NOT NULL COMMENT '管理员id',
  `admin_name` varchar(64) NOT NULL COMMENT '管理员姓名',
  `path` varchar(128) NOT NULL COMMENT '链接',
  `page` varchar(64) NOT NULL COMMENT '行为',
  `method` varchar(12) NOT NULL COMMENT '访问类型',
  `ip` varchar(16) NOT NULL COMMENT '登录IP',
  `type` varchar(32) NOT NULL COMMENT '类型',
  `add_time` int(10) UNSIGNED NOT NULL COMMENT '操作时间',
  `merchant_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '商户id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='管理员操作记录表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_system_menus`
--

CREATE TABLE `eb_system_menus` (
  `id` smallint(5) UNSIGNED NOT NULL COMMENT '菜单ID',
  `pid` smallint(5) UNSIGNED NOT NULL DEFAULT '0' COMMENT '父级id',
  `icon` varchar(16) NOT NULL COMMENT '图标',
  `menu_name` varchar(32) NOT NULL DEFAULT '' COMMENT '按钮名',
  `module` varchar(32) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT '模块名',
  `controller` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '控制器',
  `action` varchar(32) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT '方法名',
  `params` varchar(128) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '[]' COMMENT '参数',
  `sort` int(5) NOT NULL DEFAULT '1' COMMENT '排序',
  `is_show` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '是否显示',
  `access` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '子管理员是否可用'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='菜单表';

--
-- 转存表中的数据 `eb_system_menus`
--

INSERT INTO `eb_system_menus` (`id`, `pid`, `icon`, `menu_name`, `module`, `controller`, `action`, `params`, `sort`, `is_show`, `access`) VALUES
(1, 289, '', '系统设置', 'admin', 'setting.systemConfig', 'index', '[]', 265, 1, 1),
(2, 153, '', '权限规则', 'admin', 'setting.systemMenus', 'index', '{\"cate\":\"12\"}', 7, 1, 1),
(4, 153, '', '管理员列表', 'admin', 'setting.systemAdmin', 'index', '[]', 9, 1, 1),
(6, 1, '', '基础配置', 'admin', 'setting.systemConfig', 'index', '{\"tab_id\":\"1\"}', 270, 1, 1),
(7, 497, '', '配置分类', 'admin', 'setting.systemConfigTab', 'index', '[]', 277, 1, 1),
(8, 153, '', '身份管理', 'admin', 'setting.systemRole', 'index', '[]', 10, 1, 1),
(9, 497, '', '组合数据', 'admin', 'setting.systemGroup', 'index', '[]', 276, 1, 1),
(11, 0, 'wechat', '公众号', 'admin', 'wechat.wechat', 'index', '[]', 91, 1, 1),
(12, 354, '', '微信关注回复', 'admin', 'wechat.reply', 'index', '{\"key\":\"subscribe\",\"title\":\"\\u7f16\\u8f91\\u65e0\\u914d\\u7f6e\\u9ed8\\u8ba4\\u56de\\u590d\"}', 86, 1, 1),
(17, 360, '', '微信菜单', 'admin', 'wechat.menus', 'index', '[]', 95, 1, 1),
(19, 11, '', '图文管理', 'admin', 'wechat.wechatNewsCategory', 'index', '[]', 60, 1, 1),
(21, 0, 'magic', '维护', 'admin', 'system.system', '', '[]', 1, 1, 1),
(30, 354, '', '关键字回复', 'admin', 'wechat.reply', 'keyword', '[]', 85, 1, 1),
(31, 354, '', '无效关键词回复', 'admin', 'wechat.reply', 'index', '{\"key\":\"default\",\"title\":\"\\u7f16\\u8f91\\u65e0\\u6548\\u5173\\u952e\\u5b57\\u9ed8\\u8ba4\\u56de\\u590d\"}', 84, 1, 1),
(37, 31, '', '附加权限', 'admin', 'wechat.reply', '', '[]', 0, 0, 1),
(42, 19, '', '附加权限', 'admin', 'wechat.wechatNewsCategory', '', '[]', 0, 0, 1),
(43, 42, '', '添加图文消息', 'admin', 'wechat.wechatNewsCategory', 'create', '[]', 0, 0, 1),
(44, 42, '', '编辑图文消息', 'admin', 'wechat.wechatNewsCategory', 'edit', '[]', 0, 0, 1),
(45, 42, '', '删除图文消息', 'admin', 'wechat.wechatNewsCategory', 'delete', '[]', 0, 0, 1),
(46, 7, '', '配置分类附加权限', 'admin', 'setting.systemConfigTab', '', '[]', 0, 0, 1),
(47, 46, '', '添加配置分类', 'admin', 'setting.systemConfigTab', 'create', '[]', 0, 0, 1),
(48, 46, '', '添加配置', 'admin', 'setting.systemConfig', 'create', '[]', 0, 0, 1),
(49, 46, '', '编辑配置分类', 'admin', 'setting.systemConfigTab', 'edit', '[]', 0, 0, 1),
(50, 46, '', '删除配置分类', 'admin', 'setting.systemConfigTab', 'delete', '[]', 0, 0, 1),
(51, 46, '', '查看子字段', 'admin', 'system.systemConfigTab', 'sonConfigTab', '[]', 0, 0, 1),
(52, 9, '', '组合数据附加权限', 'admin', 'system.systemGroup', '', '[]', 0, 0, 1),
(53, 52, '', '添加数据', 'admin', 'system.systemGroupData', 'create', '[]', 0, 0, 1),
(54, 52, '', '编辑数据', 'admin', 'system.systemGroupData', 'edit', '[]', 0, 0, 1),
(55, 52, '', '删除数据', 'admin', 'system.systemGroupData', 'delete', '[]', 0, 0, 1),
(56, 52, '', '数据列表', 'admin', 'system.systemGroupData', 'index', '[]', 0, 0, 1),
(57, 52, '', '添加数据组', 'admin', 'system.systemGroup', 'create', '[]', 0, 0, 1),
(58, 52, '', '删除数据组', 'admin', 'system.systemGroup', 'delete', '[]', 0, 0, 1),
(59, 4, '', '管理员列表附加权限', 'admin', 'system.systemAdmin', '', '[]', 0, 0, 1),
(60, 59, '', '添加管理员', 'admin', 'system.systemAdmin', 'create', '[]', 0, 0, 1),
(61, 59, '', '编辑管理员', 'admin', 'system.systemAdmin', 'edit', '[]', 0, 0, 1),
(62, 59, '', '删除管理员', 'admin', 'system.systemAdmin', 'delete', '[]', 0, 0, 1),
(63, 8, '', '身份管理附加权限', 'admin', 'system.systemRole', '', '[]', 0, 0, 1),
(64, 63, '', '添加身份', 'admin', 'system.systemRole', 'create', '[]', 0, 0, 1),
(65, 63, '', '修改身份', 'admin', 'system.systemRole', 'edit', '[]', 0, 0, 1),
(66, 63, '', '删除身份', 'admin', 'system.systemRole', 'delete', '[]', 0, 0, 1),
(67, 8, '', '身份管理展示页', 'admin', 'system.systemRole', 'index', '[]', 0, 0, 1),
(68, 4, '', '管理员列表展示页', 'admin', 'system.systemAdmin', 'index', '[]', 0, 0, 1),
(69, 7, '', '配置分类展示页', 'admin', 'setting.systemConfigTab', 'index', '[]', 0, 0, 1),
(70, 9, '', '组合数据展示页', 'admin', 'system.systemGroup', 'index', '[]', 0, 0, 1),
(73, 19, '', '图文消息展示页', 'admin', 'wechat.wechatNewsCategory', 'index', '[]', 0, 0, 1),
(74, 2, '', '菜单管理附加权限', 'admin', 'system.systemMenus', '', '[]', 0, 0, 1),
(75, 74, '', '添加菜单', 'admin', 'system.systemMenus', 'create', '[]', 0, 0, 1),
(76, 74, '', '编辑菜单', 'admin', 'system.systemMenus', 'edit', '[]', 0, 0, 1),
(77, 74, '', '删除菜单', 'admin', 'system.systemMenus', 'delete', '[]', 0, 0, 1),
(78, 2, '', '菜单管理展示页', 'admin', 'system.systemMenus', 'index', '[]', 0, 0, 1),
(89, 30, '', '关键字回复附加权限', 'admin', 'wechat.reply', '', '[]', 0, 0, 1),
(90, 89, '', '添加关键字', 'admin', 'wechat.reply', 'add_keyword', '[]', 0, 0, 1),
(91, 89, '', '修改关键字', 'admin', 'wechat.reply', 'info_keyword', '[]', 0, 0, 1),
(92, 89, '', '删除关键字', 'admin', 'wechat.reply', 'delete', '[]', 0, 0, 1),
(93, 30, '', '关键字回复展示页', 'admin', 'wechat.reply', 'keyword', '[]', 0, 0, 1),
(94, 31, '', '无效关键词回复展示页', 'admin', 'wechat.reply', 'index', '[]', 0, 0, 1),
(95, 31, '', '无效关键词回复附加权限', 'admin', 'wechat.reply', '', '[]', 0, 0, 1),
(96, 95, '', '无效关键词回复提交按钮', 'admin', 'wechat.reply', 'save', '{\"key\":\"default\",\"title\":\"编辑无效关键字默认回复\"}', 0, 0, 1),
(97, 12, '', '微信关注回复展示页', 'admin', 'wechat.reply', 'index', '[]', 0, 0, 1),
(98, 12, '', '微信关注回复附加权限', 'admin', 'wechat.reply', '', '[]', 0, 0, 1),
(99, 98, '', '微信关注回复提交按钮', 'admin', 'wechat.reply', 'save', '{\"key\":\"subscribe\",\"title\":\"编辑无配置默认回复\"}', 0, 0, 1),
(100, 74, '', '添加提交菜单', 'admin', 'system.systemMenus', 'save', '[]', 0, 0, 1),
(101, 74, '', '编辑提交菜单', 'admin', 'system.systemMenus', 'update', '[]', 0, 1, 1),
(102, 59, '', '提交添加管理员', 'admin', 'system.systemAdmin', 'save', '[]', 0, 0, 1),
(103, 59, '', '提交修改管理员', 'admin', 'system.systemAdmin', 'update', '[]', 0, 0, 1),
(104, 63, '', '提交添加身份', 'admin', 'system.systemRole', 'save', '[]', 0, 0, 1),
(105, 63, '', '提交修改身份', 'admin', 'system.systemRole', 'update', '[]', 0, 0, 1),
(106, 46, '', '提交添加配置分类', 'admin', 'setting.systemConfigTab', 'save', '[]', 0, 0, 1),
(107, 46, '', '提交修改配置分类', 'admin', 'setting.systemConfigTab', 'update', '[]', 0, 0, 1),
(108, 46, '', '提交添加配置列表', 'admin', 'setting.systemConfig', 'save', '[]', 0, 0, 1),
(109, 52, '', '提交添加数据组', 'admin', 'system.systemGroup', 'save', '[]', 0, 0, 1),
(110, 52, '', '提交修改数据组', 'admin', 'system.systemGroup', 'update', '[]', 0, 0, 1),
(111, 52, '', '提交添加数据', 'admin', 'system.systemGroupData', 'save', '[]', 0, 0, 1),
(112, 52, '', '提交修改数据', 'admin', 'system.systemGroupData', 'update', '[]', 0, 0, 1),
(115, 42, '', '提交添加图文消息', 'admin', 'wechat.wechatNewsCategory', 'save', '[]', 0, 0, 1),
(116, 42, '', '提交编辑图文消息', 'admin', 'wechat.wechatNewsCategory', 'update', '[]', 0, 0, 1),
(117, 6, '', '配置列表附加权限', 'admin', 'setting.systemConfig', '', '[]', 0, 0, 1),
(118, 6, '', '配置列表展示页', 'admin', 'setting.systemConfig', 'index', '[]', 0, 0, 1),
(119, 117, '', '提交保存配置列表', 'admin', 'setting.systemConfig', 'save_basics', '[]', 0, 0, 1),
(123, 89, '', '提交添加关键字', 'admin', 'wechat.reply', 'save_keyword', '{\"dis\":\"1\"}', 0, 0, 1),
(124, 89, '', '提交修改关键字', 'admin', 'wechat.reply', 'save_keyword', '{\"dis\":\"2\"}', 0, 0, 1),
(126, 17, '', '微信菜单展示页', 'admin', 'wechat.menus', 'index', '[]', 0, 0, 1),
(127, 17, '', '微信菜单附加权限', 'admin', 'wechat.menus', '', '[]', 0, 0, 1),
(128, 127, '', '提交微信菜单按钮', 'admin', 'wechat.menus', 'save', '{\"dis\":\"1\"}', 0, 0, 1),
(130, 498, '', '系统日志', 'admin', 'system.systemLog', 'index', '[]', 274, 1, 1),
(131, 130, '', '管理员操作记录展示页', 'admin', 'system.systemLog', 'index', '[]', 0, 0, 1),
(137, 135, '', '添加通知模板', 'admin', 'system.systemNotice', 'create', '[]', 0, 0, 1),
(138, 135, '', '编辑通知模板', 'admin', 'system.systemNotice', 'edit', '[]', 0, 0, 1),
(139, 135, '', '删除辑通知模板', 'admin', 'system.systemNotice', 'delete', '[]', 0, 0, 1),
(140, 135, '', '提交编辑辑通知模板', 'admin', 'system.systemNotice', 'update', '[]', 0, 0, 1),
(141, 135, '', '提交添加辑通知模板', 'admin', 'system.systemNotice', 'save', '[]', 0, 0, 1),
(144, 117, '', '获取配置列表上传文件的名称', 'admin', 'setting.systemConfig', 'getimagename', '[]', 0, 0, 1),
(145, 117, '', '配置列表上传文件', 'admin', 'setting.systemConfig', 'view_upload', '[]', 0, 0, 1),
(148, 286, '', '优惠券', '', '', '', '[]', 10, 0, 1),
(149, 148, '', '优惠券制作', 'admin', 'ump.storeCoupon', 'index', '[]', 5, 1, 1),
(150, 148, '', '会员领取记录', 'admin', 'ump.storeCouponUser', 'index', '[]', 1, 1, 1),
(151, 0, 'user', '用户', 'admin', 'user.userList', 'list', '[]', 286, 1, 1),
(153, 289, '', '权限管理', 'admin', 'setting.systemAdmin', '', '[]', 256, 1, 1),
(155, 154, '', '商户产品展示页', 'admin', 'store.storeMerchant', 'index', '[]', 0, 0, 1),
(156, 154, '', '商户产品附加权限', 'admin', 'store.storeMerchant', '', '[]', 0, 0, 1),
(158, 157, '', '商户文章管理展示页', 'admin', 'wechat.wechatNews', 'merchantIndex', '[]', 0, 0, 1),
(159, 157, '', '商户文章管理附加权限', 'admin', 'wechat.wechatNews', '', '[]', 0, 0, 1),
(173, 498, '', '文件校验', 'admin', 'system.system_file', 'index', '[]', 273, 1, 1),
(174, 360, '', '微信模板消息', 'admin', 'wechat.wechatTemplate', 'index', '[]', 1, 1, 1),
(175, 289, '', '客服管理', 'admin', 'wechat.storeService', 'index', '[]', 257, 1, 1),
(177, 151, '', '用户列表', 'admin', 'user.user', 'index', '[]', 285, 1, 1),
(179, 307, '', '充值记录', 'admin', 'finance.userRecharge', 'index', '[]', 1, 1, 1),
(209, 175, '', '客服管理展示页', 'admin', 'store.storeService', 'index', '[]', 0, 0, 1),
(210, 175, '', '客服管理附加权限', 'admin', 'store.storeService', '', '[]', 0, 0, 1),
(211, 210, '', '客服管理添加', 'admin', 'store.storeService', 'create', '[]', 0, 0, 1),
(212, 210, '', '客服管理添加提交', 'admin', 'store.storeService', 'save', '[]', 0, 0, 1),
(213, 210, '', '客服管理编辑', 'admin', 'store.storeService', 'edit', '[]', 0, 0, 1),
(214, 210, '', '客服管理编辑提交', 'admin', 'store.storeService', 'update', '[]', 0, 0, 1),
(215, 210, '', '客服管理删除', 'admin', 'store.storeService', 'delete', '[]', 0, 0, 1),
(216, 179, '', '用户充值记录展示页', 'admin', 'user.userRecharge', 'index', '[]', 0, 0, 1),
(217, 179, '', '用户充值记录附加权限', 'admin', 'user.userRecharge', '', '[]', 0, 0, 1),
(218, 217, '', '用户充值记录退款', 'admin', 'user.userRecharge', 'edit', '[]', 0, 0, 1),
(219, 217, '', '用户充值记录退款提交', 'admin', 'user.userRecharge', 'updaterefundy', '[]', 0, 0, 1),
(220, 180, '', '预售卡管理批量修改预售卡金额', 'admin', 'presell.presellCard', 'batch_price', '[]', 0, 0, 1),
(221, 180, '', '预售卡管理批量修改预售卡金额提交', 'admin', 'presell.presellCard', 'savebatch', '[]', 0, 0, 1),
(222, 210, '', '客服管理聊天记录查询', 'admin', 'store.storeService', 'chat_user', '[]', 0, 0, 1),
(223, 210, '', '客服管理聊天记录查询详情', 'admin', 'store.storeService', 'chat_list', '[]', 0, 0, 1),
(229, 149, '', '优惠券管理展示页', 'admin', 'store.storeCoupon', 'index', '[]', 0, 0, 1),
(230, 149, '', '优惠券管理附加权限', 'admin', 'store.storeCoupon', '', '[]', 0, 0, 1),
(231, 230, '', '优惠券管理添加', 'admin', 'store.storeCoupon', 'create', '[]', 0, 0, 1),
(232, 230, '', '优惠券管理添加提交', 'admin', 'store.storeCoupon', 'save', '[]', 0, 0, 1),
(233, 230, '', '优惠券管理删除', 'admin', 'store.storeCoupon', 'delete', '[]', 0, 0, 1),
(234, 230, '', '优惠券管理立即失效', 'admin', 'store.storeCoupon', 'status', '[]', 0, 0, 1),
(235, 148, '', '已发布管理', 'admin', 'ump.storeCouponIssue', 'index', '[]', 3, 1, 1),
(237, 21, '', '刷新缓存', 'admin', 'system.clear', 'index', '[]', 0, 1, 1),
(239, 306, '', '提现申请', 'admin', 'finance.user_extract', 'index', '[]', 0, 1, 1),
(241, 273, '', '限时秒杀', 'admin', 'ump.storeSeckill', 'index', '[]', 0, 1, 1),
(244, 294, '', '财务报表', 'admin', 'record.storeStatistics', 'index', '[]', 0, 1, 1),
(245, 293, '', '商品统计', 'admin', 'store.storeProduct', 'statistics', '[]', 0, 0, 1),
(246, 295, '', '用户统计', 'admin', 'user.user', 'user_analysis', '[]', 0, 1, 1),
(247, 153, '', '个人资料', 'admin', 'setting.systemAdmin', 'admininfo', '[]', 0, 0, 1),
(248, 247, '', '个人资料附加权限', 'admin', 'system.systemAdmin', '', '[]', 0, 0, 1),
(249, 248, '', '个人资料提交保存', 'admin', 'system.systemAdmin', 'setAdminInfo', '[]', 0, 0, 1),
(250, 247, '', '个人资料展示页', 'admin', 'system.systemAdmin', 'admininfo', '[]', 0, 0, 1),
(251, 293, '', '订单统计', 'admin', 'order.storeOrder', 'orderchart', '[]', 0, 1, 1),
(252, 21, '', '在线更新', 'admin', 'system.system_upgradeclient', 'index', '[]', 0, 1, 1),
/*(267, 360, '', '公众号接口配置', 'admin', 'setting.systemConfig', 'index', '{\"type\":\"1\",\"tab_id\":\"2\"}', 100, 1, 1),*/
(269, 0, 'cubes', '小程序', 'admin', 'setting.system', '', '[]', 92, 0, 1),
(270, 269, '', '小程序配置', 'admin', 'setting.systemConfig', 'index_alone', '{\"type\":\"2\",\"tab_id\":\"7\"}', 0, 1, 1),
(273, 286, '', '秒杀管理', 'admin', '', '', '[]', 0, 0, 1),
(276, 21, '', '附件管理', 'admin', 'widget.images', 'index', '[]', 0, 0, 1),
(278, 498, '', '清除数据', 'admin', 'system.system_cleardata', 'index', '[]', 271, 1, 1),
(286, 0, 'paper-plane', '营销', 'admin', '', '', '[]', 105, 1, 1),
(287, 0, 'money', '财务', 'admin', '', '', '[]', 103, 1, 1),
(289, 0, 'gear', '设置', 'admin', '', '', '[]', 90, 1, 1),
(306, 287, '', '财务操作', 'admin', '', '', '[]', 100, 1, 1),
(307, 287, '', '财务记录', 'admin', '', '', '[]', 50, 1, 1),
(308, 287, '', '佣金记录', 'admin', '', '', '[]', 0, 1, 1),
(312, 307, '', '资金监控', 'admin', 'finance.finance', 'bill', '[]', 0, 1, 1),
(313, 308, '', '佣金记录', 'admin', 'finance.finance', 'commission_list', '[]', 0, 1, 1),
(337, 0, 'users', '分销', 'admin', 'user', 'user', '[]', 106, 1, 1),
(349, 286, '', '积分', 'admin', 'userPoint', 'index', '[]', 0, 0, 1),
(350, 349, '', '积分配置', 'admin', 'setting.systemConfig', 'index', '{\"type\":\"3\",\"tab_id\":\"11\"}', 0, 1, 1),
(351, 349, '', '积分日志', 'admin', 'ump.userPoint', 'index', '[]', 0, 1, 1),
(352, 148, '', '优惠券配置', 'admin', 'setting.systemConfig', 'index', '{\"type\":\"3\",\"tab_id\":\"12\"}', 0, 1, 1),
(353, 337, '', '分销配置', 'admin', 'setting.systemConfig', 'index', '{\"type\":\"3\",\"tab_id\":\"9\"}', 282, 1, 1),
(354, 11, '', '自动回复', '', '', '', '[]', 80, 1, 1),
/*(355, 11, '', '页面设置', '', '', '', '[]', 90, 1, 1),*/
(357, 507, '', '首页轮播图', 'admin', 'setting.system_group_data', 'index', '{\"gid\":\"34\"}', 463, 1, 1),
(360, 11, '', '公众号配置', '', '', '', '[]', 100, 1, 1),
/*(361, 360, '', '公众号支付配置', 'admin', 'setting.systemConfig', 'index', '{\"type\":\"1\",\"tab_id\":\"4\"}', 0, 1, 1),*/
(362, 276, '', '附加权限', '', '', '', '[]', 0, 1, 1),
(363, 362, '', '上传图片', 'admin', 'widget.images', 'upload', '[]', 0, 1, 1),
(364, 362, '', '删除图片', 'admin', 'widget.images', 'delete', '[]', 0, 1, 1),
(365, 362, '', '附件管理', 'admin', 'widget.images', 'index', '[]', 0, 1, 1),
(372, 269, '', '首页幻灯片', 'admin', 'setting.system_group_data', 'index', '{\"gid\":\"48\"}', 0, 1, 1),
(373, 269, '', '分享背景', 'admin', 'setting.system_group_data', 'index', '{\"gid\":\"54\"}', 0, 1, 1),
(374, 295, '', '分销会员业务', 'admin', 'record.record', 'user_distribution_chart', '[]', 0, 1, 1),
(375, 269, '', '小程序支付配置', 'admin', 'setting.systemConfig', 'index_alone', '{\"type\":\"2\",\"tab_id\":\"14\"}', 0, 1, 1),
(376, 269, '', '小程序模板消息', 'admin', 'routine.routineTemplate', 'index', '[]', 0, 1, 1),
(377, 498, '', '数据库维护', 'admin', 'system.system_databackup', 'index', '[]', 272, 1, 1),
(378, 286, '', '砍价管理', 'admin', '', '', '[]', 0, 0, 1),
(379, 286, '', '拼团列表', 'admin', 'ump.store_combination', 'combina_list', '[]', 279, 1, 1),
(380, 378, '', '砍价产品', 'admin', 'ump.storeBargain', 'index', '[]', 0, 1, 1),
(391, 269, '', '配送时效', 'admin', 'setting.system_group_data', 'index', '{\"gid\":\"49\"}', 0, 1, 1),
(392, 269, '', '小程序图片配置', 'admin', 'setting.system_config', 'index_alone', '{\"type\":\"2\",\"tab_id\":\"15.html\"}', 0, 1, 1),
(399, 0, 'th-list', '订单', 'admin', '', '', '[]', 298, 1, 1),
(400, 399, '', '订单管理', 'admin', 'order.store_order', 'index', '[]', 100, 1, 1),
(409, 507, '', '推荐设置', 'admin', 'setting.system_group_data', 'recommend', '[]', 261, 1, 1),
(411, 0, 'th', '专题', 'admin', '', '', '[]', 297, 1, 1),
(417, 0, 'picture-o', '新闻', 'admin', '', '', '[]', 290, 1, 1),
(418, 417, '', '新闻列表', 'admin', 'article.article_v1', 'index', '[]', 289, 1, 1),
(419, 417, '', '搜索关键词', 'admin', 'article.search', 'index', '[]', 0, 0, 1),
(420, 502, '', '关键词搜索', 'admin', 'article.search', 'index', '[]', 258, 1, 1),
(421, 337, '', '分销员列表', 'admin', 'user.user_spread', 'index', '[]', 287, 1, 1),
(423, 482, '', '课程弹幕', 'admin', 'special.special_type', 'special_barrage', '{\"type\":\"3\"}', 291, 1, 1),
(428, 0, 'leaf', '分类', 'admin', '', '', '[]', 300, 1, 1),
(429, 428, '', '一级分类', 'admin', 'special.grade', 'index', '[]', 299, 1, 1),
(430, 428, '', '二级分类', 'admin', 'special.subject', 'index', '[]', 298, 1, 1),
(431, 507, '', '导航配置', 'admin', 'setting.system_group_data', 'navigation', '[]', 264, 1, 1),
(432, 507, '', '活动区域', 'admin', 'setting.system_group_data', 'index_v1', '{\"gid\":\"56\"}', 262, 1, 1),
(433, 337, '', '提现银行配置', 'admin', 'setting.system_group_data', 'index', '{\"gid\":\"52\"}', 281, 1, 1),
(434, 502, '', '关于我们', 'admin', 'setting.system_config_content', 'index', '{\"id\":\"1\"}', 259, 1, 1),
(435, 502, '', '用户付费协议', 'admin', 'setting.system_config_content', 'index', '{\"id\":\"2\"}', 259, 1, 1),
(454, 429, '', '删除分类', 'admin', 'special.grade', 'delete', '[]', 0, 0, 1),
(455, 429, '', '保存分类', 'admin', 'special.grade', 'save', '[]', 0, 0, 1),
(456, 429, '', '快速编辑分类', 'admin', 'special.grade', 'set_value', '[]', 0, 0, 1),
(457, 429, '', '创建分类', 'admin', 'special.grade', 'create', '[]', 0, 0, 1),
(458, 430, '', '删除分类', 'admin', 'special.subject', 'delete', '[]', 0, 0, 1),
(459, 430, '', '快速编辑分类', 'admin', 'special.subject', 'set_value', '[]', 0, 0, 1),
(460, 430, '', '创建分类页面', 'admin', 'special.subject', 'create', '[]', 0, 0, 1),
(461, 400, '', '订单展示页面', 'admin', 'order.store_order', 'order_list', '[]', 0, 0, 1),
(462, 400, '', '修改订单金额', 'admin', 'order.store_order', 'edit', '[]', 0, 0, 1),
(463, 400, '', '保存订单金额', 'admin', 'order.store_order', 'update', '[]', 0, 0, 1),
(464, 400, '', '送货', 'admin', 'order.store_order', 'delivery', '[]', 0, 0, 1),
(465, 400, '', '发货', 'admin', 'order.store_order', 'deliver_goods', '[]', 0, 0, 1),
(466, 400, '', '发货保存', 'admin', 'order.store_order', 'updateDeliveryGoods', '[]', 0, 0, 1),
(467, 400, '', '确认收货', 'admin', 'order.store_order', 'take_delivery', '[]', 0, 0, 1),
(468, 400, '', '退款页面', 'admin', 'order.store_order', 'refund_y', '[]', 0, 0, 1),
(469, 400, '', '退款处理', 'admin', 'order.store_order', 'updateRefundY', '[]', 0, 0, 1),
(470, 400, '', '订单详情', 'admin', 'order.store_order', 'order_info', '[]', 0, 0, 1),
(471, 400, '', '物流查询', 'admin', 'order.store_order', 'express', '[]', 0, 0, 1),
(472, 400, '', '修改配送信息', 'admin', 'order.store_order', 'distribution', '[]', 0, 0, 1),
(473, 400, '', '保存配送信息', 'admin', 'order.store_order', 'updateDistribution', '[]', 0, 0, 1),
(474, 400, '', '不退款保存页面', 'admin', 'order.store_order', 'refund_n', '[]', 0, 0, 1),
(475, 400, '', '保存不退款信息', 'admin', 'order.store_order', 'updateRefundN', '[]', 0, 0, 1),
(476, 400, '', '立即支付', 'admin', 'order.store_order', 'offline', '[]', 0, 0, 1),
(477, 400, '', '退积分', 'admin', 'order.store_order', 'integral_back', '[]', 0, 0, 1),
(478, 400, '', '退积分保存', 'admin', 'order.store_order', 'updateIntegralBack', '[]', 0, 0, 1),
(482, 0, 'book', '课程', 'admin', '', '', '[]', 299, 1, 1),
(483, 482, '', '图文专题', 'admin', 'special.special_type', 'index', '{\"special_type\":\"1\"}', 294, 1, 1),
(484, 482, '', '音频专题', 'admin', 'special.special_type', 'index', '{\"special_type\":\"2\"}', 295, 1, 1),
(485, 482, '', '视频专题', 'admin', 'special.special_type', 'index', '{\"special_type\":\"3\"}', 296, 1, 1),
(487, 482, '', '直播列表', 'admin', 'live.aliyun_live', 'special_live', '{\"special_type\":\"4\"}', 292, 1, 1),
(488, 482, '', '专栏列表', 'admin', 'special.special_type', 'index', '{\"special_type\":\"5\"}', 293, 1, 1),
(490, 493, '', '卡密会员', 'admin', 'user.member_card', 'batch_index', '[]', 252, 1, 1),
(491, 493, '', '会员等级', 'admin', 'user.member_ship', 'index', '[]', 254, 1, 1),
(492, 493, '', '会员记录', 'admin', 'user.member_record', 'index', '[]', 251, 1, 1),
(493, 151, '', '会员管理', 'admin', '', '', '[]', 283, 1, 1),
(496, 337, '', '提现银行规则', 'admin', 'setting.system_group_data', 'index', '{\"gid\":\"53\"}', 280, 1, 1),
(497, 21, '', '开发配置', 'admin', '', '', '[]', 278, 1, 1),
(498, 21, '', '安全维护', 'admin', '', '', '[]', 275, 1, 1),
(499, 1, '', '公众号配置', 'admin', 'setting.systemConfig', 'index', '{\"type\":\"1\",\"tab_id\":\"2\"}', 269, 1, 1),
(500, 1, '', '支付配置', 'admin', 'setting.systemConfig', 'index', '{\"type\":\"4\",\"tab_id\":\"4\"}', 266, 1, 1),
(501, 1, '', '阿里云配置', 'admin', 'setting.systemConfig', 'index', '{\"tab_id\":\"17\",\"type\":\"5\"}', 265, 1, 1),
(502, 289, '', '商城设置', '', '', '', '[]', 264, 1, 1),
(505, 493, '', '会员权益', 'admin', 'setting.system_group_data', 'index', '{\"gid\":\"57\"}', 249, 1, 1),
(506, 493, '', '会员说明', 'admin', 'setting.system_group_data', 'index', '{\"gid\":\"58\"}', 248, 1, 1),
(507, 502, '', '首页配置', 'admin', '', '', '[]', 261, 1, 1),
(508, 502, '', '其他配置', 'admin', 'setting.systemConfig', 'index', '{\"tab_id\":\"22\"}', 260, 1, 1);


-- --------------------------------------------------------

--
-- 表的结构 `eb_system_notice`
--

CREATE TABLE `eb_system_notice` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '通知模板id',
  `title` varchar(64) NOT NULL COMMENT '通知标题',
  `type` varchar(64) NOT NULL COMMENT '通知类型',
  `icon` varchar(16) NOT NULL COMMENT '图标',
  `url` varchar(64) NOT NULL COMMENT '链接',
  `table_title` varchar(256) NOT NULL COMMENT '通知数据',
  `template` varchar(64) NOT NULL COMMENT '通知模板',
  `push_admin` varchar(128) NOT NULL COMMENT '通知管理员id',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='通知模板表' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `eb_system_notice_admin`
--

CREATE TABLE `eb_system_notice_admin` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '通知记录ID',
  `notice_type` varchar(64) NOT NULL COMMENT '通知类型',
  `admin_id` smallint(5) UNSIGNED NOT NULL COMMENT '通知的管理员',
  `link_id` int(10) UNSIGNED NOT NULL COMMENT '关联ID',
  `table_data` text NOT NULL COMMENT '通知的数据',
  `is_click` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT '点击次数',
  `is_visit` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT '访问次数',
  `visit_time` int(11) NOT NULL COMMENT '访问时间',
  `add_time` int(10) UNSIGNED NOT NULL COMMENT '通知时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='通知记录表' ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- 表的结构 `eb_system_role`
--

CREATE TABLE `eb_system_role` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '身份管理id',
  `role_name` varchar(32) NOT NULL COMMENT '身份管理名称',
  `sign` varchar(50) NOT NULL COMMENT '身份标识',
  `rules` text NOT NULL COMMENT '身份管理权限(menus_id)',
  `level` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='身份管理表';

--
-- 转存表中的数据 `eb_system_role`
--

INSERT INTO `eb_system_role` (`id`, `role_name`, `sign`, `rules`, `level`, `status`) VALUES
(1, '超级管理员','admin', '37,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,73,74,75,76,77,78,89,90,91,92,93,94,95,96,97,98,99,100,102,103,104,105,106,107,108,109,110,111,112,115,116,117,118,119,123,124,126,127,128,131,137,138,139,140,141,144,145,148,155,156,158,159,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,229,230,231,232,233,234,245,247,248,249,250,269,273,276,288,349,378,419,436,437,438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,1,2,4,6,7,8,9,11,12,17,19,21,30,31,101,130,149,150,151,153,173,174,175,177,179,235,237,239,241,244,246,251,252,267,270,278,286,287,289,293,306,307,308,312,313,337,350,351,352,353,354,355,357,360,361,362,363,364,365,372,373,374,375,376,377,379,380,391,392,399,400,409,411,412,415,417,418,420,421,423,428,429,430,431,432,433,434,435,479,480,481', 0, 1),
(2, '主播', 'anchor','', 1, 1);

-- --------------------------------------------------------

--
-- 表的结构 `eb_user`
--

CREATE TABLE `eb_user` (
  `uid` int(10) UNSIGNED NOT NULL COMMENT '用户id',
  `account` varchar(32) NOT NULL COMMENT '用户账号',
  `pwd` varchar(32) NOT NULL COMMENT '用户密码',
  `nickname` varchar(16) NOT NULL COMMENT '用户昵称',
  `avatar` varchar(256) NOT NULL COMMENT '用户头像',
  `name` varchar(255) DEFAULT NULL COMMENT '姓名',
  `phone` char(15) NOT NULL COMMENT '手机号码',
  `grade_id` int(11) NOT NULL COMMENT '年级id',
  `full_name` varchar(35) NOT NULL DEFAULT '' COMMENT '真实姓名',
  `bank_card` varchar(50) NOT NULL DEFAULT '' COMMENT '银行卡号码',
  `add_time` int(11) UNSIGNED NOT NULL COMMENT '添加时间',
  `add_ip` varchar(16) NOT NULL COMMENT '添加ip',
  `last_time` int(11) UNSIGNED NOT NULL COMMENT '最后一次登录时间',
  `last_ip` varchar(16) NOT NULL COMMENT '最后一次登录ip',
  `now_money` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '用户余额',
  `brokerage_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '可提现金额',
  `integral` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '用户剩余积分',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1为正常，0为禁止',
  `level` tinyint(2) UNSIGNED NOT NULL DEFAULT '0' COMMENT '等级',
  `spread_uid` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '推广元id',
  `spread_time` int(11) NOT NULL,
  `valid_time` int(11) NOT NULL DEFAULT '0' COMMENT '客户关系解除时间',
  `user_type` varchar(32) NOT NULL COMMENT '用户类型',
  `is_promoter` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否为推广员',
  `pay_count` int(11) UNSIGNED DEFAULT '0' COMMENT '用户购买次数',
  `is_binding` int(11) NOT NULL,
  `is_senior` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为高级推广人',
  `is_h5user` tinyint(1) DEFAULT '0' COMMENT '是否为H5虚拟用户',
  `is_permanent` tinyint(2) DEFAULT '0' COMMENT '会员是否永久',
  `overdue_time` int(11) UNSIGNED DEFAULT '0' COMMENT '会员过期时间',
  `client_id` varchar(50) NOT NULL COMMENT 'client_id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_user_address`
--

CREATE TABLE `eb_user_address` (
  `id` mediumint(8) UNSIGNED NOT NULL COMMENT '用户地址id',
  `uid` int(10) UNSIGNED NOT NULL COMMENT '用户id',
  `real_name` varchar(32) NOT NULL COMMENT '收货人姓名',
  `phone` varchar(16) NOT NULL COMMENT '收货人电话',
  `province` varchar(64) NOT NULL COMMENT '收货人所在省',
  `city` varchar(64) NOT NULL COMMENT '收货人所在市',
  `district` varchar(64) NOT NULL COMMENT '收货人所在区',
  `detail` varchar(256) NOT NULL COMMENT '收货人详细地址',
  `post_code` int(10) UNSIGNED NOT NULL COMMENT '邮编',
  `longitude` varchar(16) NOT NULL DEFAULT '0' COMMENT '经度',
  `latitude` varchar(16) NOT NULL DEFAULT '0' COMMENT '纬度',
  `is_default` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否默认',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否删除',
  `add_time` int(10) UNSIGNED NOT NULL COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户地址表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_user_bill`
--

CREATE TABLE `eb_user_bill` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '用户账单id',
  `uid` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户uid',
  `get_uid` int(11) NOT NULL DEFAULT '0' COMMENT '由谁获得',
  `link_id` varchar(32) NOT NULL DEFAULT '0' COMMENT '关联id',
  `pm` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0 = 支出 1 = 获得',
  `title` varchar(64) NOT NULL COMMENT '账单标题',
  `category` varchar(64) NOT NULL COMMENT '明细种类',
  `type` varchar(64) NOT NULL DEFAULT '' COMMENT '明细类型',
  `number` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '明细数字',
  `balance` decimal(8,2) UNSIGNED NOT NULL DEFAULT '0.00' COMMENT '剩余',
  `mark` varchar(512) NOT NULL COMMENT '备注',
  `add_time` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '添加时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0 = 带确定 1 = 有效 -1 = 无效'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户账单表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_user_enter`
--

CREATE TABLE `eb_user_enter` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '商户申请ID',
  `uid` int(10) UNSIGNED NOT NULL COMMENT '用户ID',
  `province` varchar(32) NOT NULL COMMENT '商户所在省',
  `city` varchar(32) NOT NULL COMMENT '商户所在市',
  `district` varchar(32) NOT NULL COMMENT '商户所在区',
  `address` varchar(256) NOT NULL COMMENT '商户详细地址',
  `merchant_name` varchar(256) NOT NULL COMMENT '商户名称',
  `link_user` varchar(32) NOT NULL,
  `link_tel` varchar(16) NOT NULL COMMENT '商户电话',
  `charter` varchar(512) NOT NULL COMMENT '商户证书',
  `add_time` int(10) UNSIGNED NOT NULL COMMENT '添加时间',
  `apply_time` int(10) UNSIGNED NOT NULL COMMENT '审核时间',
  `success_time` int(11) NOT NULL COMMENT '通过时间',
  `fail_message` varchar(256) NOT NULL COMMENT '未通过原因',
  `fail_time` int(10) UNSIGNED NOT NULL COMMENT '未通过时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '-1 审核未通过 0未审核 1审核通过',
  `is_lock` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0 = 开启 1= 关闭',
  `is_del` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否删除'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商户申请表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_user_extract`
--

CREATE TABLE `eb_user_extract` (
  `id` int(10) UNSIGNED NOT NULL,
  `uid` int(10) UNSIGNED DEFAULT NULL,
  `mer_id` int(11) NOT NULL COMMENT '商户id',
  `real_name` varchar(64) DEFAULT NULL COMMENT '名称',
  `partner_trade_no` varchar(32) NOT NULL DEFAULT '' COMMENT '商户订单号',
  `extract_type` varchar(32) DEFAULT 'bank' COMMENT 'bank = 银行卡 alipay = 支付宝wx=微信',
  `bank_code` varchar(32) DEFAULT '0' COMMENT '银行卡',
  `bank_address` varchar(256) DEFAULT '' COMMENT '开户地址',
  `alipay_code` varchar(64) DEFAULT '' COMMENT '支付宝账号',
  `extract_price` decimal(8,2) UNSIGNED DEFAULT '0.00' COMMENT '提现金额',
  `mark` varchar(512) DEFAULT NULL,
  `balance` decimal(8,2) UNSIGNED DEFAULT '0.00',
  `fail_msg` varchar(128) DEFAULT NULL COMMENT '无效原因',
  `fail_time` int(10) UNSIGNED DEFAULT NULL,
  `add_time` int(10) UNSIGNED DEFAULT NULL COMMENT '添加时间',
  `status` tinyint(2) DEFAULT '0' COMMENT '-1 未通过 0 审核中 1 已提现',
  `wechat` varchar(15) DEFAULT NULL COMMENT '微信号'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户提现表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_user_group`
--

CREATE TABLE `eb_user_group` (
  `id` smallint(5) UNSIGNED NOT NULL,
  `group_name` varchar(64) DEFAULT NULL COMMENT '用户分组名称'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户分组表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_user_notice`
--

CREATE TABLE `eb_user_notice` (
  `id` int(11) NOT NULL,
  `uid` text NOT NULL COMMENT '接收消息的用户id（类型：json数据）',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '消息通知类型（1：系统消息；2：用户通知）',
  `user` varchar(20) NOT NULL DEFAULT '' COMMENT '发送人',
  `title` varchar(20) NOT NULL COMMENT '通知消息的标题信息',
  `content` varchar(500) NOT NULL COMMENT '通知消息的内容',
  `add_time` int(11) NOT NULL COMMENT '通知消息发送的时间',
  `is_send` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否发送（0：未发送；1：已发送）',
  `send_time` int(11) NOT NULL COMMENT '发送时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户通知表';

--
-- 转存表中的数据 `eb_user_notice`
--

INSERT INTO `eb_user_notice` (`id`, `uid`, `type`, `user`, `title`, `content`, `add_time`, `is_send`, `send_time`) VALUES
(1, ',6,', 2, '系统管理员', '请开通会员但未提供收货地址的会员联系客服', '请开通会员但未提供收货地址的会员联系客服', 1541742986, 1, 1541743080);

-- --------------------------------------------------------

--
-- 表的结构 `eb_user_notice_see`
--

CREATE TABLE `eb_user_notice_see` (
  `id` int(11) NOT NULL,
  `nid` int(11) NOT NULL COMMENT '查看的通知id',
  `uid` int(11) NOT NULL COMMENT '查看通知的用户id',
  `add_time` int(11) NOT NULL COMMENT '查看通知的时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户通知发送记录表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_user_recharge`
--

CREATE TABLE `eb_user_recharge` (
  `id` int(10) UNSIGNED NOT NULL,
  `uid` int(10) DEFAULT NULL COMMENT '充值用户UID',
  `vip_id` int(11) NOT NULL DEFAULT '0' COMMENT '0为充值金额,',
  `order_id` varchar(32) DEFAULT NULL COMMENT '订单号',
  `price` decimal(8,2) DEFAULT NULL COMMENT '充值金额',
  `recharge_type` varchar(32) DEFAULT NULL COMMENT '充值类型',
  `paid` tinyint(1) DEFAULT NULL COMMENT '是否充值',
  `pay_time` int(10) DEFAULT NULL COMMENT '充值支付时间',
  `add_time` int(12) DEFAULT NULL COMMENT '充值时间',
  `refund_price` decimal(10,2) UNSIGNED NOT NULL COMMENT '退款金额'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户充值表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_wechat_media`
--

CREATE TABLE `eb_wechat_media` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '微信视频音频id',
  `type` varchar(16) NOT NULL COMMENT '回复类型',
  `path` varchar(128) NOT NULL COMMENT '文件路径',
  `media_id` varchar(64) NOT NULL COMMENT '微信服务器返回的id',
  `url` varchar(256) NOT NULL COMMENT '地址',
  `temporary` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否永久或者临时 0永久1临时',
  `add_time` int(10) UNSIGNED NOT NULL COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='微信回复表';

--
-- 转存表中的数据 `eb_wechat_media`
--

INSERT INTO `eb_wechat_media` (`id`, `type`, `path`, `media_id`, `url`, `temporary`, `add_time`) VALUES
(12, 'image', '/public/uploads/wechat/image/5b042ca618139.jpg', '6sFx6PzPF2v_Lv4FGOMzzwcwmM2wuoA63ZMSxiN-7DY', 'http://mmbiz.qpic.cn/mmbiz_jpg/xVkDhuiaGm78WOdUXuPE1oYLnU4J0LCEiaSuLhwwSrfdyINspibXsllaj8rOMSs5estAv0qhGuGniaqhb6HftecPuw/0?wx_fmt=jpeg', 0, 1527000231);

-- --------------------------------------------------------

--
-- 表的结构 `eb_wechat_message`
--

CREATE TABLE `eb_wechat_message` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '用户行为记录id',
  `openid` varchar(32) NOT NULL COMMENT '用户openid',
  `type` varchar(32) NOT NULL COMMENT '操作类型',
  `result` varchar(512) NOT NULL COMMENT '操作详细记录',
  `add_time` int(10) UNSIGNED NOT NULL COMMENT '操作时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户行为记录表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_wechat_news_category`
--

CREATE TABLE `eb_wechat_news_category` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '图文消息管理ID',
  `cate_name` varchar(255) NOT NULL COMMENT '图文名称',
  `sort` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '状态',
  `new_id` varchar(255) NOT NULL COMMENT '文章id',
  `add_time` varchar(255) NOT NULL COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='图文消息管理表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_wechat_qrcode`
--

CREATE TABLE `eb_wechat_qrcode` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '微信二维码ID',
  `third_type` varchar(32) NOT NULL COMMENT '二维码类型',
  `third_id` int(11) UNSIGNED NOT NULL COMMENT '用户id',
  `scan_id` int(10) NOT NULL COMMENT '扫描用户uid',
  `ticket` varchar(255) NOT NULL COMMENT '二维码参数',
  `expire_seconds` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '二维码有效时间',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '状态',
  `add_time` varchar(255) NOT NULL COMMENT '添加时间',
  `url` varchar(255) NOT NULL COMMENT '微信访问url',
  `qrcode_url` varchar(255) NOT NULL COMMENT '微信二维码url',
  `scan` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT '被扫的次数'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='微信二维码管理表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_wechat_reply`
--

CREATE TABLE `eb_wechat_reply` (
  `id` mediumint(8) UNSIGNED NOT NULL COMMENT '微信关键字回复id',
  `key` varchar(64) NOT NULL COMMENT '关键字',
  `type` varchar(32) NOT NULL COMMENT '回复类型',
  `data` text NOT NULL COMMENT '回复数据',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1' COMMENT '0=不可用  1 =可用',
  `hide` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '是否隐藏'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='微信关键字回复表';

-- --------------------------------------------------------

--
-- 表的结构 `eb_wechat_template`
--

CREATE TABLE `eb_wechat_template` (
  `id` int(10) UNSIGNED NOT NULL COMMENT '模板id',
  `tempkey` char(50) NOT NULL COMMENT '模板编号',
  `name` char(100) NOT NULL COMMENT '模板名',
  `content` varchar(1000) NOT NULL COMMENT '回复内容',
  `tempid` char(100) DEFAULT NULL COMMENT '模板ID',
  `add_time` varchar(15) NOT NULL COMMENT '添加时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='微信模板';

--
-- 转存表中的数据 `eb_wechat_template`
--

INSERT INTO `eb_wechat_template` (`id`, `tempkey`, `name`, `content`, `tempid`, `add_time`, `status`) VALUES
(3, 'OPENTM200565259', '订单发货提醒', '{{first.DATA}}\n订单编号：{{keyword1.DATA}}\n物流公司：{{keyword2.DATA}}\n物流单号：{{keyword3.DATA}}\n{{remark.DATA}}', 'RRsyuuWpCo81xCtfG-5qYnXXoeSQHY4mTVav0zzaZsM', '1515052638', 1),
(4, 'OPENTM413386489', '订单收货通知', '{{first.DATA}}\n订单编号：{{keyword1.DATA}}\n订单状态：{{keyword2.DATA}}\n收货时间：{{keyword3.DATA}}\n商品详情：{{keyword4.DATA}}\n{{remark.DATA}}', 'caAhoWioDb2A8Ew1bTr4GTe6mdsDoM4kjp9XV5BC8hg', '1515052765', 1),
(5, 'OPENTM410119152', '退款进度通知', '{{first.DATA}}\n订单编号：{{keyword1.DATA}}\n订单金额：{{keyword2.DATA}}\n下单时间：{{keyword3.DATA}}\n{{remark.DATA}}', '-WH6gUzezKnX9OTam9VrQEVyNWfr1bUhT6FRuBMotZw', '1515053049', 1),
(6, 'OPENTM405847076', '帐户资金变动提醒', '{{first.DATA}}\n变动类型：{{keyword1.DATA}}\n变动时间：{{keyword2.DATA}}\n变动金额：{{keyword3.DATA}}\n{{remark.DATA}}', 'qYMdIRYj3EoNYjFljxxgcEnzWP5TCN8yRb553HeX-yE', '1515053127', 1),
(7, 'OPENTM207707249', '订单发货提醒', '\n{{first.DATA}}\n商品明细：{{keyword1.DATA}}\n下单时间：{{keyword2.DATA}}\n配送地址：{{keyword3.DATA}}\n配送人：{{keyword4.DATA}}\n联系电话：{{keyword5.DATA}}\n{{remark.DATA}}', 'hC9PFuxOKq6u5kNZyl6VdHGgAuA6h5I3ztpuDk1ioAk', '1515053313', 1),
(10, 'OPENTM407456411', '拼团成功通知', '{{first.DATA}}\n订单编号：{{keyword1.DATA}}\n团购商品：{{keyword2.DATA}}\n{{remark.DATA}}', '0vOEi8iBqKXYsqvVep9Nn-CDaqPfqG8ajDpib2eY1S0', '1520063823', 1),
(11, 'OPENTM401113750', '拼团失败通知', '{{first.DATA}}\n拼团商品：{{keyword1.DATA}}\n商品金额：{{keyword2.DATA}}\n退款金额：{{keyword3.DATA}}\n{{remark.DATA}}', 'zFFr8ENLdKvVqA7Clo5ZB0WC6eARlYClCVDck-RIoSM', '1520064059', 1),
(12, 'OPENTM205213550', '订单生成通知', '{{first.DATA}}\n时间：{{keyword1.DATA}}\n商品名称：{{keyword2.DATA}}\n订单号：{{keyword3.DATA}}\n{{remark.DATA}}', 'pUMM82fuyNAeomd4mpzNz9_FdIxEehGTPR2l6q8GuCQ', '1528966701', 1),
(13, 'OPENTM207791277', '订单支付成功通知', '{{first.DATA}}\n订单编号：{{keyword1.DATA}}\n支付金额：{{keyword2.DATA}}\n{{remark.DATA}}', 'zQ0HVGaYM_zZoCiUG9E8IZiOD4X54G9e9ldUWkyuPvo', '1528966759', 1),
(15, 'OPENTM406772650', '拼团成功通知', '{first.DATA}}\n订单编号：{{keyword1.DATA}}\n团购商品：{{keyword2.DATA}}\n{{remark.DATA}}', '0vOEi8iBqKXYsqvVep9Nn-CDaqPfqG8ajDpib2eY1S0', '1551749779', 1),
(16, 'OPENTM411478702', '开团成功通知', '{{first.DATA}}\n商品名称：{{keyword1.DATA}}\n商品价格：{{keyword2.DATA}}\n组团人数：{{keyword3.DATA}}\n组团时间：{{keyword4.DATA}}\n{{remark.DATA}}', 'PDLbtKYeoWFjqwmvEb49s3zaqe1ufdXGEfZ5rt1XQLk', '1552034788', 1),
(17, 'OPENTM415198906', '拼单进度提醒', '\n{{first.DATA}}\n商品名称：{{keyword1.DATA}}\n拼单进度：{{keyword2.DATA}}\n{{remark.DATA}}', 'USG9thsiUOjyT9UISNiThdBgkq2Tl29cE6J39_vWdTo', '1562752076', 1);
(18, 'OPENTM405456204', '开播提醒', '{{first.DATA}}\r\n课程名称：{{keyword1.DATA}}\r\n开始时间：{{keyword2.DATA}}\r\n{{remark.DATA}}', 'MCfo_7rP8vFGssGE78JdgXycghSwCqmeFmFnYYIbPb8', '1585197241', '1');
-- --------------------------------------------------------

--
-- 表的结构 `eb_wechat_user`
--

CREATE TABLE `eb_wechat_user` (
  `id` int(10) UNSIGNED NOT NULL,
  `uid` int(10) UNSIGNED NOT NULL COMMENT '微信用户id',
  `unionid` varchar(30) DEFAULT NULL COMMENT '只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段',
  `openid` varchar(30) DEFAULT NULL COMMENT '用户的标识，对当前公众号唯一',
  `routine_openid` varchar(32) DEFAULT NULL COMMENT '小程序唯一身份ID',
  `nickname` varchar(64) NOT NULL COMMENT '用户的昵称',
  `headimgurl` varchar(256) NOT NULL COMMENT '用户头像',
  `sex` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '用户的性别，值为1时是男性，值为2时是女性，值为0时是未知',
  `city` varchar(64) NOT NULL COMMENT '用户所在城市',
  `language` varchar(64) NOT NULL COMMENT '用户的语言，简体中文为zh_CN',
  `province` varchar(64) NOT NULL COMMENT '用户所在省份',
  `country` varchar(64) NOT NULL COMMENT '用户所在国家',
  `remark` varchar(256) DEFAULT NULL COMMENT '公众号运营者对粉丝的备注，公众号运营者可在微信公众平台用户管理界面对粉丝添加备注',
  `groupid` smallint(5) UNSIGNED DEFAULT '0' COMMENT '用户所在的分组ID（兼容旧的用户分组接口）',
  `tagid_list` varchar(256) DEFAULT NULL COMMENT '用户被打上的标签ID列表',
  `subscribe` tinyint(3) UNSIGNED DEFAULT '1' COMMENT '用户是否订阅该公众号标识',
  `subscribe_time` int(10) UNSIGNED DEFAULT NULL COMMENT '关注公众号时间',
  `add_time` int(10) UNSIGNED DEFAULT NULL COMMENT '添加时间',
  `stair` int(11) UNSIGNED DEFAULT NULL COMMENT '一级推荐人',
  `second` int(11) UNSIGNED DEFAULT NULL COMMENT '二级推荐人',
  `order_stair` int(11) DEFAULT NULL COMMENT '一级推荐人订单',
  `order_second` int(11) UNSIGNED DEFAULT NULL COMMENT '二级推荐人订单',
  `now_money` int(11) UNSIGNED DEFAULT NULL COMMENT '佣金',
  `session_key` varchar(32) DEFAULT NULL COMMENT '小程序用户会话密匙',
  `user_type` varchar(32) DEFAULT 'wechat' COMMENT '用户类型'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='微信用户表';
-- --------------------------------------------------------

--
-- 表的结构 `eb_member_ship`
--
CREATE TABLE `eb_member_ship` (
  `id` int(10) NOT NULL,
  `type` int(2) NOT NULL DEFAULT '1' COMMENT '会员类别(1:普通会员)',
  `title` varchar(200) NOT NULL COMMENT '会员名称',
  `vip_day` int(10) NOT NULL COMMENT '会员时间(天)',
  `original_price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '原价',
  `price` decimal(8,2) NOT NULL DEFAULT '0.00' COMMENT '优惠后价格',
  `is_permanent` int(2) NOT NULL DEFAULT '0' COMMENT '是否永久',
  `is_publish` int(2) NOT NULL COMMENT '是否发布',
  `is_free` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '是否免费',
  `sort` int(10) NOT NULL COMMENT '排序倒序',
  `is_del` int(2) NOT NULL COMMENT '删除',
  `add_time` int(50) NOT NULL COMMENT '添加时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='会员管理表';
-- --------------------------------------------------------

--
-- 表数据 `eb_member_ship`
--
INSERT INTO `eb_member_ship` (`id`, `type`, `title`, `vip_day`, `original_price`, `price`, `is_permanent`, `is_publish`, `is_free`, `sort`, `is_del`, `add_time`) VALUES
 (NULL, '1', '月卡', '30', '30.00', '20.00', '0', '1', '0', '4', '0', '1588129765'),
 (NULL, '1', '季卡', '90', '90.00', '80.00', '0', '1', '0', '3', '0', '1588129794'),
 (NULL, '1', '年卡', '365', '360.00', '300.00', '0', '1', '0', '2', '0', '1588129818'),
 (NULL, '1', '永久', '-1', '1200.00', '1000.00', '1', '1', '0', '1', '0', '1588129856'),
 (NULL, '1', '免费', '7', '0.00', '0.00', '0', '1', '1', '0', '0', '1588130680');



--
-- 表的结构 `eb_member_record`
--
CREATE TABLE `eb_member_record` (
  `id` int(10) NOT NULL,
  `oid` int(10) unsigned NOT NULL COMMENT '订单ID',
  `uid` int(10) unsigned NOT NULL COMMENT '用户uid',
  `type` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '区别 0:购买 1:会员卡',
  `code` varchar(255) DEFAULT NULL COMMENT '卡号',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '支付金额',
  `purchase_time` int(50) unsigned NOT NULL DEFAULT '0' COMMENT '会员购买时间',
  `is_free` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '是否免费',
  `is_permanent` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '是否永久',
  `overdue_time` int(50) unsigned NOT NULL COMMENT '会员过期时间',
  `validity` varchar(10) DEFAULT '0' COMMENT '有效期',
  `add_time` int(50) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='会员购买记录表';
--
-- 转储表的索引
--

--
-- 表的索引 `eb_article`
--
ALTER TABLE `eb_article`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_article_category`
--
ALTER TABLE `eb_article_category`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_article_content`
--
ALTER TABLE `eb_article_content`
  ADD UNIQUE KEY `nid` (`nid`) USING BTREE;

--
-- 表的索引 `eb_cache`
--
ALTER TABLE `eb_cache`
  ADD PRIMARY KEY (`key`);

--
-- 表的索引 `eb_express`
--
ALTER TABLE `eb_express`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`) USING BTREE,
  ADD KEY `is_show` (`is_show`) USING BTREE;

--
-- 表的索引 `eb_grade`
--
ALTER TABLE `eb_grade`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_live_barrage`
--
ALTER TABLE `eb_live_barrage`
  ADD PRIMARY KEY (`id`) USING BTREE,
  ADD KEY `uid` (`uid`) USING BTREE,
  ADD KEY `live_id` (`live_id`) USING BTREE,
  ADD KEY `to_uid` (`to_uid`) USING BTREE;

--
-- 表的索引 `eb_live_honoured_guest`
--
ALTER TABLE `eb_live_honoured_guest`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `live_id` (`live_id`);

--
-- 表的索引 `eb_live_studio`
--
ALTER TABLE `eb_live_studio`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `special_id` (`special_id`),
  ADD KEY `stream_name` (`stream_name`);

--
-- 表的索引 `eb_live_user`
--
ALTER TABLE `eb_live_user`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`),
  ADD KEY `live_id` (`live_id`);

--
-- 表的索引 `eb_phone_user`
--
ALTER TABLE `eb_phone_user`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_recommend`
--
ALTER TABLE `eb_recommend`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_recommend_banner`
--
ALTER TABLE `eb_recommend_banner`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_recommend_relation`
--
ALTER TABLE `eb_recommend_relation`
  ADD UNIQUE KEY `id` (`id`),
  ADD KEY `id_2` (`id`);

--
-- 表的索引 `eb_routine_access_token`
--
ALTER TABLE `eb_routine_access_token`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_routine_form_id`
--
ALTER TABLE `eb_routine_form_id`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_routine_template`
--
ALTER TABLE `eb_routine_template`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tempkey` (`tempkey`) USING BTREE;

--
-- 表的索引 `eb_search`
--
ALTER TABLE `eb_search`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_sms_code`
--
ALTER TABLE `eb_sms_code`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `id` (`id`),
  ADD KEY `id_2` (`id`);

--
-- 表的索引 `eb_special`
--
ALTER TABLE `eb_special`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_special_barrage`
--
ALTER TABLE `eb_special_barrage`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_special_buy`
--
ALTER TABLE `eb_special_buy`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_special_content`
--
ALTER TABLE `eb_special_content`
  ADD UNIQUE KEY `id` (`id`);

--
-- 表的索引 `eb_special_course`
--
ALTER TABLE `eb_special_course`
  ADD PRIMARY KEY (`id`);
--
-- 表的索引 `eb_special_source`
--
ALTER TABLE `eb_special_source`
  ADD PRIMARY KEY (`id`),
  ADD KEY `special_ids` (`special_id`) USING BTREE,
  ADD KEY `source_ids` (`source_id`) USING BTREE;

--
-- 表的索引 `eb_special_record`
--
ALTER TABLE `eb_special_record`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_special_relation`
--
ALTER TABLE `eb_special_relation`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_special_subject`
--
ALTER TABLE `eb_special_subject`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_special_task`
--
ALTER TABLE `eb_special_task`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `id` (`id`);

--
-- 表的索引 `eb_store_bargain`
--
ALTER TABLE `eb_store_bargain`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_store_bargain_user`
--
ALTER TABLE `eb_store_bargain_user`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_store_bargain_user_help`
--
ALTER TABLE `eb_store_bargain_user_help`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_store_cart`
--
ALTER TABLE `eb_store_cart`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`uid`) USING BTREE,
  ADD KEY `goods_id` (`product_id`) USING BTREE,
  ADD KEY `uid` (`uid`,`is_pay`) USING BTREE,
  ADD KEY `uid_2` (`uid`,`is_del`) USING BTREE,
  ADD KEY `uid_3` (`uid`,`is_new`) USING BTREE,
  ADD KEY `type` (`type`) USING BTREE;

--
-- 表的索引 `eb_store_category`
--
ALTER TABLE `eb_store_category`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`) USING BTREE,
  ADD KEY `is_base` (`is_show`) USING BTREE,
  ADD KEY `sort` (`sort`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE;

--
-- 表的索引 `eb_store_combination`
--
ALTER TABLE `eb_store_combination`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_store_combination_attr`
--
ALTER TABLE `eb_store_combination_attr`
  ADD KEY `store_id` (`product_id`) USING BTREE;

--
-- 表的索引 `eb_store_combination_attr_result`
--
ALTER TABLE `eb_store_combination_attr_result`
  ADD UNIQUE KEY `product_id` (`product_id`) USING BTREE;

--
-- 表的索引 `eb_store_combination_attr_value`
--
ALTER TABLE `eb_store_combination_attr_value`
  ADD UNIQUE KEY `unique` (`unique`,`suk`) USING BTREE,
  ADD KEY `store_id` (`product_id`,`suk`) USING BTREE;

--
-- 表的索引 `eb_store_coupon`
--
ALTER TABLE `eb_store_coupon`
  ADD PRIMARY KEY (`id`),
  ADD KEY `state` (`status`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE,
  ADD KEY `coupon_time` (`coupon_time`) USING BTREE,
  ADD KEY `is_del` (`is_del`) USING BTREE;

--
-- 表的索引 `eb_store_coupon_issue`
--
ALTER TABLE `eb_store_coupon_issue`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cid` (`cid`) USING BTREE,
  ADD KEY `start_time` (`start_time`,`end_time`) USING BTREE,
  ADD KEY `remain_count` (`remain_count`) USING BTREE,
  ADD KEY `status` (`status`) USING BTREE,
  ADD KEY `is_del` (`is_del`) USING BTREE;

--
-- 表的索引 `eb_store_coupon_issue_user`
--
ALTER TABLE `eb_store_coupon_issue_user`
  ADD UNIQUE KEY `uid` (`uid`,`issue_coupon_id`) USING BTREE;

--
-- 表的索引 `eb_store_coupon_user`
--
ALTER TABLE `eb_store_coupon_user`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cid` (`cid`) USING BTREE,
  ADD KEY `uid` (`uid`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE,
  ADD KEY `end_time` (`end_time`) USING BTREE,
  ADD KEY `status` (`status`) USING BTREE,
  ADD KEY `is_fail` (`is_fail`) USING BTREE;

--
-- 表的索引 `eb_store_order`
--
ALTER TABLE `eb_store_order`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `order_id_2` (`order_id`,`uid`) USING BTREE,
  ADD UNIQUE KEY `unique` (`unique`) USING BTREE,
  ADD KEY `uid` (`uid`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE,
  ADD KEY `pay_price` (`pay_price`) USING BTREE,
  ADD KEY `paid` (`paid`) USING BTREE,
  ADD KEY `pay_time` (`pay_time`) USING BTREE,
  ADD KEY `pay_type` (`pay_type`) USING BTREE,
  ADD KEY `status` (`status`) USING BTREE,
  ADD KEY `is_del` (`is_del`) USING BTREE,
  ADD KEY `coupon_id` (`coupon_id`) USING BTREE;

--
-- 表的索引 `eb_store_order_cart_info`
--
ALTER TABLE `eb_store_order_cart_info`
  ADD UNIQUE KEY `oid` (`oid`,`unique`) USING BTREE,
  ADD KEY `cart_id` (`cart_id`) USING BTREE,
  ADD KEY `product_id` (`product_id`) USING BTREE;

--
-- 表的索引 `eb_store_order_status`
--
ALTER TABLE `eb_store_order_status`
  ADD KEY `oid` (`oid`) USING BTREE,
  ADD KEY `change_type` (`change_type`) USING BTREE;

--
-- 表的索引 `eb_store_pink`
--
ALTER TABLE `eb_store_pink`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_store_pink_false`
--
ALTER TABLE `eb_store_pink_false`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_store_product`
--
ALTER TABLE `eb_store_product`
  ADD PRIMARY KEY (`id`),
  ADD KEY `cate_id` (`cate_id`) USING BTREE,
  ADD KEY `is_hot` (`is_hot`) USING BTREE,
  ADD KEY `is_benefit` (`is_benefit`) USING BTREE,
  ADD KEY `is_best` (`is_best`) USING BTREE,
  ADD KEY `is_new` (`is_new`) USING BTREE,
  ADD KEY `toggle_on_sale, is_del` (`is_del`) USING BTREE,
  ADD KEY `price` (`price`) USING BTREE,
  ADD KEY `is_show` (`is_show`) USING BTREE,
  ADD KEY `sort` (`sort`) USING BTREE,
  ADD KEY `sales` (`sales`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE,
  ADD KEY `is_postage` (`is_postage`) USING BTREE;

--
-- 表的索引 `eb_store_product_attr`
--
ALTER TABLE `eb_store_product_attr`
  ADD KEY `store_id` (`product_id`) USING BTREE;

--
-- 表的索引 `eb_store_product_attr_result`
--
ALTER TABLE `eb_store_product_attr_result`
  ADD UNIQUE KEY `product_id` (`product_id`) USING BTREE;

--
-- 表的索引 `eb_store_product_attr_value`
--
ALTER TABLE `eb_store_product_attr_value`
  ADD UNIQUE KEY `unique` (`unique`,`suk`) USING BTREE,
  ADD KEY `store_id` (`product_id`,`suk`) USING BTREE;

--
-- 表的索引 `eb_store_product_relation`
--
ALTER TABLE `eb_store_product_relation`
  ADD UNIQUE KEY `uid` (`uid`,`product_id`,`type`) USING BTREE,
  ADD KEY `type` (`type`) USING BTREE,
  ADD KEY `category` (`category`) USING BTREE;

--
-- 表的索引 `eb_store_product_reply`
--
ALTER TABLE `eb_store_product_reply`
  ADD PRIMARY KEY (`id`) USING BTREE,
  ADD UNIQUE KEY `order_id_2` (`oid`,`unique`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE,
  ADD KEY `parent_id` (`reply_type`) USING BTREE,
  ADD KEY `is_del` (`is_del`) USING BTREE,
  ADD KEY `product_score` (`product_score`) USING BTREE,
  ADD KEY `service_score` (`service_score`) USING BTREE;

--
-- 表的索引 `eb_store_seckill`
--
ALTER TABLE `eb_store_seckill`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `start_time` (`start_time`,`stop_time`),
  ADD KEY `is_del` (`is_del`),
  ADD KEY `is_hot` (`is_hot`),
  ADD KEY `is_show` (`status`),
  ADD KEY `add_time` (`add_time`),
  ADD KEY `sort` (`sort`),
  ADD KEY `is_postage` (`is_postage`);

--
-- 表的索引 `eb_store_seckill_attr`
--
ALTER TABLE `eb_store_seckill_attr`
  ADD KEY `store_id` (`product_id`) USING BTREE;

--
-- 表的索引 `eb_store_seckill_attr_result`
--
ALTER TABLE `eb_store_seckill_attr_result`
  ADD UNIQUE KEY `product_id` (`product_id`) USING BTREE;

--
-- 表的索引 `eb_store_seckill_attr_value`
--
ALTER TABLE `eb_store_seckill_attr_value`
  ADD UNIQUE KEY `unique` (`unique`,`suk`) USING BTREE,
  ADD KEY `store_id` (`product_id`,`suk`) USING BTREE;

--
-- 表的索引 `eb_store_service`
--
ALTER TABLE `eb_store_service`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_store_service_log`
--
ALTER TABLE `eb_store_service_log`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_store_visit`
--
ALTER TABLE `eb_store_visit`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_system_admin`
--
ALTER TABLE `eb_system_admin`
  ADD PRIMARY KEY (`id`),
  ADD KEY `account` (`account`) USING BTREE,
  ADD KEY `status` (`status`) USING BTREE;

--
-- 表的索引 `eb_system_attachment`
--
ALTER TABLE `eb_system_attachment`
  ADD PRIMARY KEY (`att_id`);

--
-- 表的索引 `eb_system_attachment_category`
--
ALTER TABLE `eb_system_attachment_category`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `id` (`id`);

--
-- 表的索引 `eb_system_config`
--
ALTER TABLE `eb_system_config`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_system_config_content`
--
ALTER TABLE `eb_system_config_content`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_system_config_tab`
--
ALTER TABLE `eb_system_config_tab`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_system_file`
--
ALTER TABLE `eb_system_file`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_system_group`
--
ALTER TABLE `eb_system_group`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `config_name` (`config_name`) USING BTREE;

--
-- 表的索引 `eb_system_group_data`
--
ALTER TABLE `eb_system_group_data`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_system_log`
--
ALTER TABLE `eb_system_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `admin_id` (`admin_id`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE,
  ADD KEY `type` (`type`) USING BTREE;

--
-- 表的索引 `eb_system_menus`
--
ALTER TABLE `eb_system_menus`
  ADD PRIMARY KEY (`id`),
  ADD KEY `pid` (`pid`) USING BTREE,
  ADD KEY `is_show` (`is_show`) USING BTREE,
  ADD KEY `access` (`access`) USING BTREE;

--
-- 表的索引 `eb_system_notice`
--
ALTER TABLE `eb_system_notice`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `type` (`type`) USING BTREE,
  ADD KEY `status` (`status`) USING BTREE;

--
-- 表的索引 `eb_system_notice_admin`
--
ALTER TABLE `eb_system_notice_admin`
  ADD PRIMARY KEY (`id`),
  ADD KEY `admin_id` (`admin_id`,`notice_type`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE,
  ADD KEY `is_visit` (`is_visit`) USING BTREE,
  ADD KEY `is_click` (`is_click`) USING BTREE;

--
-- 表的索引 `eb_system_role`
--
ALTER TABLE `eb_system_role`
  ADD PRIMARY KEY (`id`),
  ADD KEY `status` (`status`) USING BTREE,
  ADD UNIQUE KEY `sign` (`sign`) USING BTREE;

--
-- 表的索引 `eb_user`
--
ALTER TABLE `eb_user`
  ADD PRIMARY KEY (`uid`),
  ADD KEY `account` (`account`) USING BTREE,
  ADD KEY `spreaduid` (`spread_uid`) USING BTREE,
  ADD KEY `level` (`level`) USING BTREE,
  ADD KEY `status` (`status`) USING BTREE,
  ADD KEY `is_promoter` (`is_promoter`) USING BTREE;

--
-- 表的索引 `eb_user_address`
--
ALTER TABLE `eb_user_address`
  ADD PRIMARY KEY (`id`),
  ADD KEY `uid` (`uid`) USING BTREE,
  ADD KEY `is_default` (`is_default`) USING BTREE,
  ADD KEY `is_del` (`is_del`) USING BTREE;

--
-- 表的索引 `eb_user_bill`
--
ALTER TABLE `eb_user_bill`
  ADD PRIMARY KEY (`id`),
  ADD KEY `openid` (`uid`) USING BTREE,
  ADD KEY `status` (`status`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE,
  ADD KEY `pm` (`pm`) USING BTREE,
  ADD KEY `type` (`category`,`type`,`link_id`) USING BTREE;

--
-- 表的索引 `eb_user_enter`
--
ALTER TABLE `eb_user_enter`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uid` (`uid`) USING BTREE,
  ADD KEY `province` (`province`,`city`,`district`) USING BTREE,
  ADD KEY `is_lock` (`is_lock`) USING BTREE,
  ADD KEY `is_del` (`is_del`) USING BTREE,
  ADD KEY `status` (`status`) USING BTREE;

--
-- 表的索引 `eb_user_extract`
--
ALTER TABLE `eb_user_extract`
  ADD PRIMARY KEY (`id`),
  ADD KEY `extract_type` (`extract_type`) USING BTREE,
  ADD KEY `status` (`status`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE,
  ADD KEY `openid` (`uid`) USING BTREE,
  ADD KEY `fail_time` (`fail_time`);

--
-- 表的索引 `eb_user_group`
--
ALTER TABLE `eb_user_group`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_user_notice`
--
ALTER TABLE `eb_user_notice`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_user_notice_see`
--
ALTER TABLE `eb_user_notice_see`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_user_recharge`
--
ALTER TABLE `eb_user_recharge`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `order_id` (`order_id`) USING BTREE,
  ADD KEY `uid` (`uid`) USING BTREE,
  ADD KEY `recharge_type` (`recharge_type`) USING BTREE,
  ADD KEY `paid` (`paid`) USING BTREE;

--
-- 表的索引 `eb_wechat_media`
--
ALTER TABLE `eb_wechat_media`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `type` (`type`,`media_id`) USING BTREE,
  ADD KEY `type_2` (`type`) USING BTREE;

--
-- 表的索引 `eb_wechat_message`
--
ALTER TABLE `eb_wechat_message`
  ADD PRIMARY KEY (`id`),
  ADD KEY `openid` (`openid`) USING BTREE,
  ADD KEY `type` (`type`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE;

--
-- 表的索引 `eb_wechat_news_category`
--
ALTER TABLE `eb_wechat_news_category`
  ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_wechat_qrcode`
--
ALTER TABLE `eb_wechat_qrcode`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `third_type` (`third_type`,`third_id`) USING BTREE,
  ADD KEY `ticket` (`ticket`) USING BTREE;

--
-- 表的索引 `eb_wechat_reply`
--
ALTER TABLE `eb_wechat_reply`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `key` (`key`) USING BTREE,
  ADD KEY `type` (`type`) USING BTREE,
  ADD KEY `status` (`status`) USING BTREE,
  ADD KEY `hide` (`hide`) USING BTREE;

--
-- 表的索引 `eb_wechat_template`
--
ALTER TABLE `eb_wechat_template`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tempkey` (`tempkey`) USING BTREE;

--
-- 表的索引 `eb_wechat_user`
--
ALTER TABLE `eb_wechat_user`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `openid` (`openid`) USING BTREE,
  ADD KEY `groupid` (`groupid`) USING BTREE,
  ADD KEY `subscribe_time` (`subscribe_time`) USING BTREE,
  ADD KEY `add_time` (`add_time`) USING BTREE,
  ADD KEY `subscribe` (`subscribe`) USING BTREE,
  ADD KEY `unionid` (`unionid`) USING BTREE,
  ADD KEY `uid` (`uid`);

--
-- 表的索引 `eb_member_card_batch`
--
ALTER TABLE `eb_member_card_batch`
 ADD PRIMARY KEY (`id`);

--
-- 表的索引 `eb_member_card`
--
ALTER TABLE `eb_member_card`
 ADD PRIMARY KEY (`id`),
 ADD KEY `card_batch_id` (`card_batch_id`) USING BTREE;
--
-- 表的索引 `eb_member_ship`
--
ALTER TABLE `eb_member_ship`
MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
 ADD PRIMARY KEY (`id`);
--
-- 表的索引 `eb_member_record`
--
ALTER TABLE `eb_member_record`
 ADD PRIMARY KEY (`id`);
--
-- 在导出的表使用AUTO_INCREMENT
--

--
-- 使用表AUTO_INCREMENT `eb_article`
--
ALTER TABLE `eb_article`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '文章管理ID', AUTO_INCREMENT=15;

--
-- 使用表AUTO_INCREMENT `eb_article_category`
--
ALTER TABLE `eb_article_category`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '文章分类id', AUTO_INCREMENT=2;

--
-- 使用表AUTO_INCREMENT `eb_express`
--
ALTER TABLE `eb_express`
  MODIFY `id` mediumint(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '快递公司id', AUTO_INCREMENT=426;

--
-- 使用表AUTO_INCREMENT `eb_grade`
--
ALTER TABLE `eb_grade`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- 使用表AUTO_INCREMENT `eb_live_barrage`
--
ALTER TABLE `eb_live_barrage`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=67;

--
-- 使用表AUTO_INCREMENT `eb_live_honoured_guest`
--
ALTER TABLE `eb_live_honoured_guest`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;

--
-- 使用表AUTO_INCREMENT `eb_live_studio`
--
ALTER TABLE `eb_live_studio`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- 使用表AUTO_INCREMENT `eb_live_user`
--
ALTER TABLE `eb_live_user`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=167;

--
-- 使用表AUTO_INCREMENT `eb_phone_user`
--
ALTER TABLE `eb_phone_user`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=31;

--
-- 使用表AUTO_INCREMENT `eb_recommend`
--
ALTER TABLE `eb_recommend`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;

--
-- 使用表AUTO_INCREMENT `eb_recommend_banner`
--
ALTER TABLE `eb_recommend_banner`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- 使用表AUTO_INCREMENT `eb_recommend_relation`
--
ALTER TABLE `eb_recommend_relation`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=111;

--
-- 使用表AUTO_INCREMENT `eb_routine_access_token`
--
ALTER TABLE `eb_routine_access_token`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '小程序access_token表ID', AUTO_INCREMENT=2;

--
-- 使用表AUTO_INCREMENT `eb_routine_form_id`
--
ALTER TABLE `eb_routine_form_id`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '表单ID表ID';

--
-- 使用表AUTO_INCREMENT `eb_routine_template`
--
ALTER TABLE `eb_routine_template`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '模板id', AUTO_INCREMENT=20;

--
-- 使用表AUTO_INCREMENT `eb_search`
--
ALTER TABLE `eb_search`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;

--
-- 使用表AUTO_INCREMENT `eb_sms_code`
--
ALTER TABLE `eb_sms_code`
  MODIFY `id` int(5) NOT NULL AUTO_INCREMENT COMMENT 'id', AUTO_INCREMENT=256;

--
-- 使用表AUTO_INCREMENT `eb_special`
--
ALTER TABLE `eb_special`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT/*, AUTO_INCREMENT=56*/;
--
-- 使用表AUTO_INCREMENT `eb_special_source`
--
ALTER TABLE `eb_special_source`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;
--
-- 使用表AUTO_INCREMENT `eb_special_barrage`
--
ALTER TABLE `eb_special_barrage`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=27;

--
-- 使用表AUTO_INCREMENT `eb_special_buy`
--
ALTER TABLE `eb_special_buy`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=162;

--
-- 使用表AUTO_INCREMENT `eb_special_content`
--
ALTER TABLE `eb_special_content`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_special_course`
--
ALTER TABLE `eb_special_course`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- 使用表AUTO_INCREMENT `eb_special_record`
--
ALTER TABLE `eb_special_record`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1670;

--
-- 使用表AUTO_INCREMENT `eb_special_relation`
--
ALTER TABLE `eb_special_relation`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=84;

--
-- 使用表AUTO_INCREMENT `eb_special_subject`
--
ALTER TABLE `eb_special_subject`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=31;

--
-- 使用表AUTO_INCREMENT `eb_special_task`
--
ALTER TABLE `eb_special_task`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT/*, AUTO_INCREMENT=22*/;

--
-- 使用表AUTO_INCREMENT `eb_store_bargain`
--
ALTER TABLE `eb_store_bargain`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '砍价产品ID', AUTO_INCREMENT=5;

--
-- 使用表AUTO_INCREMENT `eb_store_bargain_user`
--
ALTER TABLE `eb_store_bargain_user`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '用户参与砍价表ID', AUTO_INCREMENT=34;

--
-- 使用表AUTO_INCREMENT `eb_store_bargain_user_help`
--
ALTER TABLE `eb_store_bargain_user_help`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '砍价用户帮助表ID', AUTO_INCREMENT=46;

--
-- 使用表AUTO_INCREMENT `eb_store_cart`
--
ALTER TABLE `eb_store_cart`
  MODIFY `id` bigint(8) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '购物车表ID';

--
-- 使用表AUTO_INCREMENT `eb_store_category`
--
ALTER TABLE `eb_store_category`
  MODIFY `id` mediumint(11) NOT NULL AUTO_INCREMENT COMMENT '商品分类表ID', AUTO_INCREMENT=71;

--
-- 使用表AUTO_INCREMENT `eb_store_combination`
--
ALTER TABLE `eb_store_combination`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_store_coupon`
--
ALTER TABLE `eb_store_coupon`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '优惠券表ID', AUTO_INCREMENT=2;

--
-- 使用表AUTO_INCREMENT `eb_store_coupon_issue`
--
ALTER TABLE `eb_store_coupon_issue`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_store_coupon_user`
--
ALTER TABLE `eb_store_coupon_user`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '优惠券发放记录id', AUTO_INCREMENT=6;

--
-- 使用表AUTO_INCREMENT `eb_store_order`
--
ALTER TABLE `eb_store_order`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '订单ID';

--
-- 使用表AUTO_INCREMENT `eb_store_pink`
--
ALTER TABLE `eb_store_pink`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_store_pink_false`
--
ALTER TABLE `eb_store_pink_false`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_store_product`
--
ALTER TABLE `eb_store_product`
  MODIFY `id` mediumint(11) NOT NULL AUTO_INCREMENT COMMENT '商品id', AUTO_INCREMENT=170;

--
-- 使用表AUTO_INCREMENT `eb_store_product_reply`
--
ALTER TABLE `eb_store_product_reply`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '评论ID', AUTO_INCREMENT=2;

--
-- 使用表AUTO_INCREMENT `eb_store_seckill`
--
ALTER TABLE `eb_store_seckill`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '商品秒杀产品表id';

--
-- 使用表AUTO_INCREMENT `eb_store_service`
--
ALTER TABLE `eb_store_service`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '客服id';

--
-- 使用表AUTO_INCREMENT `eb_store_service_log`
--
ALTER TABLE `eb_store_service_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '客服用户对话记录表ID';

--
-- 使用表AUTO_INCREMENT `eb_store_visit`
--
ALTER TABLE `eb_store_visit`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=971;

--
-- 使用表AUTO_INCREMENT `eb_system_admin`
--
ALTER TABLE `eb_system_admin`
  MODIFY `id` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '后台管理员表ID', AUTO_INCREMENT=3;

--
-- 使用表AUTO_INCREMENT `eb_system_attachment`
--
ALTER TABLE `eb_system_attachment`
  MODIFY `att_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=95;

--
-- 使用表AUTO_INCREMENT `eb_system_attachment_category`
--
ALTER TABLE `eb_system_attachment_category`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- 使用表AUTO_INCREMENT `eb_system_config`
--
ALTER TABLE `eb_system_config`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '配置id', AUTO_INCREMENT=176;

--
-- 使用表AUTO_INCREMENT `eb_system_config_content`
--
ALTER TABLE `eb_system_config_content`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- 使用表AUTO_INCREMENT `eb_system_config_tab`
--
ALTER TABLE `eb_system_config_tab`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '配置分类id', AUTO_INCREMENT=22;

--
-- 使用表AUTO_INCREMENT `eb_system_file`
--
ALTER TABLE `eb_system_file`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '文件对比ID', AUTO_INCREMENT=2696;

--
-- 使用表AUTO_INCREMENT `eb_system_group`
--
ALTER TABLE `eb_system_group`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '组合数据ID', AUTO_INCREMENT=57;

--
-- 使用表AUTO_INCREMENT `eb_system_group_data`
--
ALTER TABLE `eb_system_group_data`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '组合数据详情ID', AUTO_INCREMENT=161;

--
-- 使用表AUTO_INCREMENT `eb_system_log`
--
ALTER TABLE `eb_system_log`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '管理员操作记录ID';

--
-- 使用表AUTO_INCREMENT `eb_system_menus`
--
ALTER TABLE `eb_system_menus`
  MODIFY `id` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '菜单ID', AUTO_INCREMENT=482;

--
-- 使用表AUTO_INCREMENT `eb_system_notice`
--
ALTER TABLE `eb_system_notice`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '通知模板id', AUTO_INCREMENT=10;

--
-- 使用表AUTO_INCREMENT `eb_system_notice_admin`
--
ALTER TABLE `eb_system_notice_admin`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '通知记录ID', AUTO_INCREMENT=11;

--
-- 使用表AUTO_INCREMENT `eb_system_role`
--
ALTER TABLE `eb_system_role`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '身份管理id', AUTO_INCREMENT=24;

--
-- 使用表AUTO_INCREMENT `eb_user`
--
ALTER TABLE `eb_user`
  MODIFY `uid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '用户id';

--
-- 使用表AUTO_INCREMENT `eb_user_address`
--
ALTER TABLE `eb_user_address`
  MODIFY `id` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '用户地址id', AUTO_INCREMENT=37;

--
-- 使用表AUTO_INCREMENT `eb_user_bill`
--
ALTER TABLE `eb_user_bill`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '用户账单id';

--
-- 使用表AUTO_INCREMENT `eb_user_enter`
--
ALTER TABLE `eb_user_enter`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '商户申请ID';

--
-- 使用表AUTO_INCREMENT `eb_user_extract`
--
ALTER TABLE `eb_user_extract`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_user_group`
--
ALTER TABLE `eb_user_group`
  MODIFY `id` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_user_notice`
--
ALTER TABLE `eb_user_notice`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- 使用表AUTO_INCREMENT `eb_user_notice_see`
--
ALTER TABLE `eb_user_notice_see`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_user_recharge`
--
ALTER TABLE `eb_user_recharge`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_wechat_media`
--
ALTER TABLE `eb_wechat_media`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '微信视频音频id', AUTO_INCREMENT=13;

--
-- 使用表AUTO_INCREMENT `eb_wechat_message`
--
ALTER TABLE `eb_wechat_message`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '用户行为记录id';

--
-- 使用表AUTO_INCREMENT `eb_wechat_news_category`
--
ALTER TABLE `eb_wechat_news_category`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '图文消息管理ID';

--
-- 使用表AUTO_INCREMENT `eb_wechat_qrcode`
--
ALTER TABLE `eb_wechat_qrcode`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '微信二维码ID';

--
-- 使用表AUTO_INCREMENT `eb_wechat_reply`
--
ALTER TABLE `eb_wechat_reply`
  MODIFY `id` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '微信关键字回复id';

--
-- 使用表AUTO_INCREMENT `eb_wechat_template`
--
ALTER TABLE `eb_wechat_template`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '模板id', AUTO_INCREMENT=18;

--
-- 使用表AUTO_INCREMENT `eb_member_card_batch`
--
ALTER TABLE `eb_member_card_batch`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_member_card`
--
ALTER TABLE `eb_member_card`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_member_ship`
--
ALTER TABLE `eb_member_ship`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- 使用表AUTO_INCREMENT `eb_member_record`
--
ALTER TABLE `eb_member_record`
  MODIFY `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- 使用表AUTO_INCREMENT `eb_wechat_user`
--
ALTER TABLE `eb_wechat_user`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
