<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：程序安装控制器
 * +------------------------------------------------------------------------ 
**/  

class indexControl extends mydecmsClass {
	public $db;//数据库链接
	public $conf;//配置信息
	public $config;//程序设置对象
	public $template = "template/";//模板目录
	public $control="index";
	public $action = "index";//默认调用方法
	
	/**
	 * 程序安装首页
	**/
	public function index()
	{
		if(!is_writable(MYDECMS_PATH)){
			$this -> errlog("程序根目录没有写入文件权限，程序因此无法安装，请手动增加权限后再刷新本页");
		}

		if(!file_exists(MYDECMS_PATH.$this->template."/index.php")){
			exit("没有找到对应的模板文件");
		}
		include MYDECMS_PATH.$this->template."/index.php";
		exit();
	}
	
	/**
	 * 删除安装包文件
	**/
	public function del(){
		$this -> delDir(MYDECMS_PATH);
		exit('安装包文件删除完毕');
	}
	
	/**
	 * 第一步
	**/
	public function first(){
		$yes = isset($_GET['yes']) ? $_GET['yes'] : "";
		if($yes==''){
			header("HTTP/1.1 301 Moved Permanently");
			header("Location: ./index.php?c=index&a=index");
			exit();
		}
		if(!file_exists(MYDECMS_PATH.$this->template."/first.php")){
			exit("没有找到对应的模板文件");
		}
		include MYDECMS_PATH.$this->template."/first.php";
	}
	
	/**
	 * 第二步
	**/
	public function second(){
		$mysqlhost    = $this -> p("mysqlhost","localhost","2");
		$mysqluser    = $this -> p("mysqluser","root","2");
		$mysqlpass    = $this -> p("mysqlpass","","2");
		$mysqldb      = $this -> p("mysqldb","","2");
		$mysqldbqz    = $this -> p("mysqldbqz","mydecms_","2");
		$admindir     = $this -> p("admindir","","2");
		$webadmin     = $this -> p("webadmin","","2");
		$webpass      = $this -> p("webpass","","2");
		$webname      = $this -> p("webname","","2");
		
		if($mysqldb == ""){
			$this -> errlog("数据库表不能为空");
		}
		
		if($webadmin == ""){
			$this -> errlog("网站管理员账号不能为空");
		}
		
		if($webpass == ""){
			$this -> errlog("网站管理员密码不能为空");
		}
		
		if($webname == ""){
			$this -> errlog("网站名称不能为空");
		}
		
		$conf = array(
					"dbtype" => "mysql",         //数据库类型
					"host"   => $mysqlhost,      //数据库访问地址
					"user"   => $mysqluser,      //数据库访问用户名
					"pass"   => $mysqlpass,      //数据库访问密码
					"dbname" => $mysqldb,        //数据库名
					"prefix" => $mysqldbqz,      //表前缀
					"charset"=> "utf8",          //编码
					"port"   => "3306"           //数据库连接端口
		);
		
		$url = 'http://'.$_SERVER['SERVER_NAME'].$_SERVER["REQUEST_URI"]; 
		$url = dirname($url);
		if($url !='') $url = substr($url,0,strpos($url,"/install"));
		
		$this -> db = new mydecmsMysql($conf);
		
		$this -> db -> query("drop table if exists {$conf['prefix']}adminmenu");
		$this -> db -> query("drop table if exists {$conf['prefix']}article");
		$this -> db -> query("drop table if exists {$conf['prefix']}cachearticle");
		$this -> db -> query("drop table if exists {$conf['prefix']}category");
		$this -> db -> query("drop table if exists {$conf['prefix']}control");
		$this -> db -> query("drop table if exists {$conf['prefix']}friendlink");
		$this -> db -> query("drop table if exists {$conf['prefix']}glspider");
		$this -> db -> query("drop table if exists {$conf['prefix']}group");
		$this -> db -> query("drop table if exists {$conf['prefix']}menu");
		$this -> db -> query("drop table if exists {$conf['prefix']}method");
		$this -> db -> query("drop table if exists {$conf['prefix']}role");
		$this -> db -> query("drop table if exists {$conf['prefix']}spiderlogs");
		$this -> db -> query("drop table if exists {$conf['prefix']}system");
		$this -> db -> query("drop table if exists {$conf['prefix']}tag");
		$this -> db -> query("drop table if exists {$conf['prefix']}tplfile");
		$this -> db -> query("drop table if exists {$conf['prefix']}tplsubject");
		$this -> db -> query("drop table if exists {$conf['prefix']}user");
		$this -> db -> query("drop table if exists {$conf['prefix']}user_action_logs");
		$this -> db -> query("drop table if exists {$conf['prefix']}user_login_logs");

		
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}adminmenu` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `cid` int(10) NOT NULL,  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `url` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,  `img` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,  `type` int(10) NOT NULL DEFAULT '1',  `sort` int(10) NOT NULL DEFAULT '11',PRIMARY KEY (`id`),  KEY `name` (`name`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='后台权限菜单'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}article` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `cid` int(10) NOT NULL,  `title` varchar(160) COLLATE utf8_unicode_ci NOT NULL,  `keyword` varchar(160) COLLATE utf8_unicode_ci DEFAULT NULL,  `desc` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,  `img` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,  `content` longtext COLLATE utf8_unicode_ci NOT NULL,  `tpl` varchar(1600) COLLATE utf8_unicode_ci DEFAULT NULL,  `userid` int(10) NOT NULL,  `date` int(11) NOT NULL,  `type` int(10) NOT NULL DEFAULT '1',  `tags` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,PRIMARY KEY (`id`), UNIQUE KEY `title` (`title`), KEY `cid` (`cid`), KEY `type` (`type`), KEY `date` (`date`), KEY `userid` (`userid`), KEY `tags` (`tags`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='文章表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}cachearticle` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `aid` int(10) NOT NULL,  `ids` text COLLATE utf8_unicode_ci,  `date` int(11) NOT NULL,  `views` int(10) NOT NULL DEFAULT '0',PRIMARY KEY (`id`), UNIQUE KEY `aid` (`aid`), KEY `views` (`views`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='相关文章缓存表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}category` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `urlname` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `cid` int(10) NOT NULL DEFAULT '0',  `fids` text COLLATE utf8_unicode_ci,  `zids` text COLLATE utf8_unicode_ci,  `tpl` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,  `title` text COLLATE utf8_unicode_ci,  `keyword` varchar(160) COLLATE utf8_unicode_ci DEFAULT NULL,  `desc` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,  `type` int(10) NOT NULL DEFAULT '1',  `sort` int(10) NOT NULL DEFAULT '1000',PRIMARY KEY (`id`),UNIQUE KEY `urlname` (`urlname`),KEY `name` (`name`),KEY `cid` (`cid`),KEY `type` (`type`),KEY `sort` (`sort`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='文章分类'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}control` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,  `control` varchar(250) COLLATE utf8_unicode_ci NOT NULL,  `logstype` int(10) NOT NULL DEFAULT '1',  `sharetype` int(10) NOT NULL,  `sort` int(10) NOT NULL DEFAULT '100',PRIMARY KEY (`id`),UNIQUE KEY `control` (`control`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='权限文件表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}friendlink` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,  `url` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,  `type` int(5) DEFAULT '1',  `target` varchar(20) COLLATE utf8_unicode_ci DEFAULT '_blank',  `sort` int(10) DEFAULT '500',  `qq` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,  `email` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,PRIMARY KEY (`id`),UNIQUE KEY `flink` (`name`,`url`),KEY `name` (`name`),KEY `url` (`url`),KEY `type` (`type`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='友情链接表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}glspider` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `name` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,  `ip` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,PRIMARY KEY (`id`),UNIQUE KEY `ip` (`ip`),KEY `name` (`name`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci  AUTO_INCREMENT=1 COMMENT='要过滤的蜘蛛IP表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}group` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `fid` varchar(250) COLLATE utf8_unicode_ci NOT NULL,  `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,  `authoritys` text COLLATE utf8_unicode_ci,  `actionlog` int(10) NOT NULL DEFAULT '1',  `sortid` int(10) NOT NULL DEFAULT '100',PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='用户组表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}menu` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `cid` int(10) NOT NULL,  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `url` varchar(250) COLLATE utf8_unicode_ci NOT NULL,  `target` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',  `type` int(10) NOT NULL DEFAULT '1',  `sort` int(10) NOT NULL DEFAULT '11',PRIMARY KEY (`id`),UNIQUE KEY `url` (`url`),KEY `name` (`name`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='前台导航菜单'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}method` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `control` varchar(100) COLLATE utf8_unicode_ci NOT NULL,  `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,  `method` varchar(100) COLLATE utf8_unicode_ci NOT NULL,  `logstype` int(10) NOT NULL DEFAULT '1',  `sharetype` int(10) NOT NULL,  `sort` int(10) NOT NULL DEFAULT '100',PRIMARY KEY (`id`),UNIQUE KEY `control_method` (`control`,`method`),KEY `control` (`control`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='权限文件功能表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}role` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `cid` varchar(250) COLLATE utf8_unicode_ci NOT NULL,  `name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,  `menuqx` text COLLATE utf8_unicode_ci NOT NULL,  `qx` text COLLATE utf8_unicode_ci,  `actionlog` int(10) NOT NULL DEFAULT '1',  `sort` int(10) NOT NULL DEFAULT '100',PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='职务表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}spiderlogs` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,  `url` text COLLATE utf8_unicode_ci,  `date` bigint(20) NOT NULL,  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,PRIMARY KEY (`id`),KEY `name` (`name`),KEY `date` (`date`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='蜘蛛爬行记录表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}system` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `webname` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `weburl` varchar(250) COLLATE utf8_unicode_ci NOT NULL,  `webtitle` varchar(250) COLLATE utf8_unicode_ci NOT NULL,  `weblogo` varchar(250) COLLATE utf8_unicode_ci NOT NULL,  `webkey` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,  `webdesc` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,  `softdir` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `softtpl` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `mobiletype` int(10) NOT NULL DEFAULT '2',  `mobileurl` varchar(100) COLLATE utf8_unicode_ci NOT NULL,  `spider` int(10) NOT NULL DEFAULT '1',  `webwjt` int(10) NOT NULL DEFAULT '2',  `wjt` text COLLATE utf8_unicode_ci NOT NULL,  `watertype` int(10) DEFAULT '2',  `water` text COLLATE utf8_unicode_ci,  `loginlog` int(10) NOT NULL DEFAULT '1',  `actionlog` int(10) NOT NULL DEFAULT '1',  `adminyzm` int(10) NOT NULL DEFAULT '1',  `webicp` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,  `webtj` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,PRIMARY KEY (`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='网站配置表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}tag` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `ids` text COLLATE utf8_unicode_ci,  `title` varchar(180) COLLATE utf8_unicode_ci DEFAULT NULL,  `keyword` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,  `desc` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,  `tpl` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,  `userid` int(11) NOT NULL,  `date` int(11) NOT NULL,  `views` int(11) NOT NULL DEFAULT '0',  `type` int(11) NOT NULL DEFAULT '1',PRIMARY KEY (`id`),UNIQUE KEY `name` (`name`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='tag标签表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}tplfile` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `filename` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `word` varchar(100) COLLATE utf8_unicode_ci NOT NULL,  `subjectid` int(10) NOT NULL,  `type` int(10) NOT NULL DEFAULT '1',  `content` longtext COLLATE utf8_unicode_ci NOT NULL,PRIMARY KEY (`id`), UNIQUE KEY `filename` (`filename`,`subjectid`,`type`),KEY `subjectid` (`subjectid`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='模板文件表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}tplsubject` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `folder` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `tplfolder` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `cssfolder` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `jsfolder` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `imgfolder` varchar(50) COLLATE utf8_unicode_ci NOT NULL,PRIMARY KEY (`id`),UNIQUE KEY `folder` (`folder`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='模板主题表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}user` (`id` int(10) NOT NULL AUTO_INCREMENT,  `rid` int(10) NOT NULL,  `username` varchar(50) COLLATE utf8_unicode_ci NOT NULL,  `password` varchar(100) COLLATE utf8_unicode_ci NOT NULL,  `regdate` int(11) NOT NULL,  `type` int(10) NOT NULL DEFAULT '1',  `count` int(10) NOT NULL DEFAULT '0',  `actiontime` int(11) NOT NULL,  `enddate` int(11) NOT NULL,  `endip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,  `actionlog` int(10) NOT NULL DEFAULT '1',PRIMARY KEY (`id`),UNIQUE KEY `username` (`username`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='用户表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}user_action_logs` (  `id` int(10) NOT NULL AUTO_INCREMENT,  `userid` int(10) NOT NULL,  `content` text COLLATE utf8_unicode_ci NOT NULL,  `date` int(10) NOT NULL,PRIMARY KEY (`id`),KEY `userid` (`userid`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='用户操作日志表'");
		
		$this -> db -> query("CREATE TABLE IF NOT EXISTS `{$conf['prefix']}user_login_logs` (  `id` int(11) NOT NULL AUTO_INCREMENT,  `userid` int(10) NOT NULL,  `date` int(11) NOT NULL,  `ip` varchar(50) COLLATE utf8_unicode_ci NOT NULL,PRIMARY KEY (`id`),KEY `userid` (`userid`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 COMMENT='用户登录日志表'");
		
		$this -> db -> query("INSERT INTO `mydecms_menu` (`cid`, `name`, `url`, `target`, `type`, `sort`) VALUES (0, '首页', '/', '', 1, 100)");
		
		$this -> db -> query("INSERT INTO `{$conf['prefix']}adminmenu` (`id`, `cid`, `name`, `url`, `img`, `type`, `sort`) VALUES (1, 0, '综合管理', '', './style/ico/zh.png', 2, 1),(2, 0, '权限管理', '', './style/ico/quanxianguanli.png', 2, 2),(3, 0, '菜单与友链', '', './style/ico/link.png', 2, 3),(4, 0, '分类与文章', '', './style/ico/quanxian.png', 2, 4),(5, 1, '网站设置', './index.php?c=system&a=edit', NULL, 1, 1),(6, 1, '蜘蛛爬行记录', './index.php?c=spiderlogs&a=index', NULL, 1, 2),(7, 2, '权限文件', './index.php?c=control&a=index', NULL, 1, 1),(8, 2, '角色管理', './index.php?c=role&a=index', NULL, 1, 2),(9, 2, '用户管理', './index.php?c=user&a=index', NULL, 1, 3),(10, 3, '后台菜单', './index.php?c=adminmenu&a=index', NULL, 1, 1),(11, 3, '前台菜单', './index.php?c=menu&a=index', NULL, 1, 2),(12, 3, '友情链接', './index.php?c=friendlink&a=index', NULL, 1, 3),(13, 4, '文章分类', './index.php?c=category&a=index', NULL, 1, 1),(14, 4, '文章列表', './index.php?c=article&a=index', NULL, 1, 2),(15, 0, '模板与附件', '', './style/ico/tpl.png', 2, 5),(16, 15, '模板管理', './index.php?c=tplfile&a=index', NULL, 1, 2),(17, 15, '附件管理', './index.php?c=fileadmin&a=index', NULL, 1, 3),(18, 15, '批量远程下载图片', './index.php?c=fileadmin&a=pldownimg&folder=images', NULL, 1, 4),(19, 15, '模板主题', './index.php?c=tplsubject&a=index', NULL, 1, 1),(20, 1, '用户登录日志', './index.php?c=userloginlogs&a=index', NULL, 1, 4),(21, 1, '用户操作日志', './index.php?c=useractionlogs&a=index', NULL, 1, 5),(22, 4, 'tag标签', './index.php?c=tag&a=index', NULL, 1, 3)");
		
		$this -> db -> query("INSERT INTO `{$conf['prefix']}control` (`id`, `name`, `control`, `logstype`, `sharetype`, `sort`) VALUES (1, '后台菜单管理', 'adminmenu', 1, 2, 1),(2, '文章管理', 'article', 1, 2, 9),(3, '编辑器上传附件管理', 'bdedit', 1, 2, 10),(4, '文章分类管理', 'category', 1, 2, 7),(5, '附件管理', 'fileadmin', 1, 2, 6),(6, '友情链接管理', 'friendlink', 1, 2, 13),(7, '前台导航菜单管理', 'menu', 1, 2, 12),(8, '用户角色管理', 'role', 1, 2, 2),(9, '蜘蛛爬行日志管理', 'spiderlogs', 1, 2, 11),(10, 'tag标签管理', 'tag', 1, 2, 8),(11, '模板文件管理', 'tplfile', 1, 2, 4),(12, '模板主题管理', 'tplsubject', 1, 2, 5),(13, '用户管理', 'user', 1, 2, 3)");
		
		$this -> db -> query("INSERT INTO `{$conf['prefix']}method` (`id`, `control`, `name`, `method`, `logstype`, `sharetype`, `sort`) VALUES (1, 'adminmenu', '查看后台菜单分栏', 'index', 1, 2, 100),(2, 'adminmenu', '查看后台菜单', 'menu', 1, 2, 100),(3, 'adminmenu', '添加后台菜单分栏', 'addfl', 1, 2, 100),(4, 'adminmenu', '修改后台菜单分栏', 'editfl', 1, 2, 100),(5, 'adminmenu', '删除后台菜单分栏', 'delfl', 1, 2, 100),(6, 'adminmenu', '批量修改后台菜单分栏', 'pleditfl', 1, 2, 100),(7, 'adminmenu', '添加后台菜单', 'add', 1, 2, 100),(8, 'adminmenu', '修改后台菜单', 'edit', 1, 2, 100),(9, 'adminmenu', '删除后台菜单', 'del', 1, 2, 100),(10, 'adminmenu', '批量修改后台菜单', 'pledit', 1, 2, 100),(11, 'adminmenu', '批量修改后台菜单所属分栏', 'pleditcid', 1, 2, 100),(12, 'article', '查看文章列表', 'index', 1, 2, 100),(13, 'article', '搜索文章', 'search', 1, 2, 100),(14, 'article', '添加文章', 'add', 1, 2, 100),(15, 'article', '修改文章', 'edit', 1, 2, 100),(16, 'article', '删除文章', 'del', 1, 2, 100),(17, 'article', '批量修改文章', 'pledit', 1, 2, 100),(18, 'article', '批量修改文章属性', 'pledittype', 1, 2, 100),(19, 'article', '批量修改文章所属分类', 'pleditcid', 1, 2, 100),(20, 'bdedit', '编辑器上传图片、视频、文件', 'index', 1, 2, 100),(21, 'category', '查看文章分类', 'index', 1, 2, 100),(22, 'category', '搜索文章分类', 'search', 1, 2, 100),(23, 'category', '添加文章分类', 'add', 1, 2, 100),(24, 'category', '修改文章分类', 'edit', 1, 2, 100),(25, 'category', '删除文章分类', 'del', 1, 2, 100),(26, 'category', '批量修改文章分类', 'pledit', 1, 2, 100),(27, 'category', '批量修改显示属性', 'pledittype', 1, 2, 100),(28, 'category', '批量修改所属父分类', 'pleditcid', 1, 2, 100),(29, 'fileadmin', '查看附件', 'index', 1, 2, 100),(30, 'fileadmin', '上传附件', 'upfile', 1, 2, 100),(31, 'fileadmin', '远程下载文件', 'downimg', 1, 2, 100),(32, 'fileadmin', '批量远程下载附件', 'pldownimg', 1, 2, 100),(33, 'fileadmin', '新建文件夹', 'addfolder', 1, 2, 100),(34, 'fileadmin', '重命名文件夹或者文件', 'rname', 1, 2, 100),(35, 'fileadmin', '移动文件夹或者文件', 'move', 1, 2, 100),(36, 'fileadmin', '复制文件夹或者文件', 'copyfile', 1, 2, 100),(37, 'fileadmin', '删除附件', 'del', 1, 2, 100),(38, 'friendlink', '查看友情链接', 'index', 1, 2, 100),(39, 'friendlink', '搜索友情链接', 'search', 1, 2, 100),(40, 'friendlink', '添加友情链接', 'add', 1, 2, 100),(41, 'friendlink', '修改友情链接', 'edit', 1, 2, 100),(42, 'friendlink', '删除友情链接', 'del', 1, 2, 100),(43, 'friendlink', '批量修改友情链接', 'pledit', 1, 2, 100),(44, 'friendlink', '批量修改显示属性', 'pledittype', 1, 2, 100),(45, 'friendlink', '批量修改打开方式', 'pledittarget', 1, 2, 100),(46, 'menu', '查看前台导航菜单', 'index', 1, 2, 100),(47, 'menu', '搜索前台导航菜单', 'search', 1, 2, 100),(48, 'menu', '添加前台导航菜单', 'add', 1, 2, 100),(49, 'menu', '修改前台导航菜单', 'edit', 1, 2, 100),(50, 'menu', '删除前台导航菜单', 'del', 1, 2, 100),(51, 'menu', '批量修改前台导航菜单', 'pledit', 1, 2, 100),(52, 'menu', '批量修改显示属性', 'pledittype', 1, 2, 100),(53, 'menu', '批量修改打开方式', 'pledittarget', 1, 2, 100),(54, 'role', '查看自己权限所能看到的角色', 'index', 1, 2, 100),(55, 'role', '搜索自己权限所能看到的角色', 'search', 1, 2, 100),(56, 'role', '添加角色', 'add', 1, 2, 100),(57, 'role', '修改角色', 'edit', 1, 2, 100),(58, 'role', '删除角色', 'del', 1, 2, 100),(59, 'role', '批量修改角色', 'pledit', 1, 2, 100),(60, 'role', '批量修改所属父角色', 'pleditcid', 1, 2, 100),(61, 'spiderlogs', '查看蜘蛛爬行日志', 'index', 1, 2, 100),(62, 'spiderlogs', '搜索蜘蛛爬行日志', 'search', 1, 2, 100),(63, 'spiderlogs', '删除蜘蛛爬行日志', 'del', 1, 2, 100),(64, 'spiderlogs', '查看已过滤的蜘蛛IP列表', 'glspider', 1, 2, 100),(65, 'spiderlogs', '添加过滤蜘蛛IP', 'add', 1, 2, 100),(66, 'spiderlogs', '修改过滤蜘蛛IP', 'edit', 1, 2, 100),(67, 'spiderlogs', '批量加入过滤蜘蛛IP', 'pladdgl', 1, 2, 100),(68, 'spiderlogs', '删除选中的过滤蜘蛛IP', 'delglspider', 1, 2, 100),(69, 'tag', '查看tag标签', 'index', 1, 2, 100),(70, 'tag', '搜索tag标签', 'search', 1, 2, 100),(71, 'tag', '添加tag标签', 'add', 1, 2, 100),(72, 'tag', '修改tag标签', 'edit', 1, 2, 100),(73, 'tag', '删除tag标签', 'del', 1, 2, 100),(74, 'tag', '批量修改tag标签', 'pledit', 1, 2, 100),(75, 'tag', '批量修改显示属性', 'pledittype', 1, 2, 100),(76, 'tplfile', '查看模板', 'index', 1, 2, 100),(77, 'tplfile', '添加模板', 'add', 1, 2, 100),(78, 'tplfile', '修改模板', 'edit', 1, 2, 100),(79, 'tplfile', '删除模板', 'del', 1, 2, 100),(80, 'tplsubject', '查看模板主题', 'index', 1, 2, 100),(81, 'tplsubject', '添加模板主题', 'add', 1, 2, 100),(82, 'tplsubject', '修改模板主题', 'edit', 1, 2, 100),(83, 'tplsubject', '删除模板主题', 'del', 1, 2, 100),(84, 'tplsubject', '查看CSS样式文件', 'css', 1, 2, 100),(85, 'tplsubject', '添加CSS样式文件', 'addcss', 1, 2, 100),(86, 'tplsubject', '修改CSS样式文件', 'editcss', 1, 2, 100),(87, 'tplsubject', '删除CSS样式文件', 'delcss', 1, 2, 100),(88, 'tplsubject', '查看JS脚本文件', 'js', 1, 2, 100),(89, 'tplsubject', '添加JS脚本文件', 'addjs', 1, 2, 100),(90, 'tplsubject', '修改JS脚本文件', 'editjs', 1, 2, 100),(91, 'tplsubject', '删除JS脚本文件', 'deljs', 1, 2, 100),(92, 'tplsubject', '查看模板图片库', 'img', 1, 2, 100),(93, 'tplsubject', '上传模板用的图片', 'upimg', 1, 2, 100),(94, 'tplsubject', '删除模板图片', 'delimg', 1, 2, 100),(95, 'user', '查看用户', 'index', 1, 2, 100),(96, 'user', '搜索用户', 'search', 1, 2, 100),(97, 'user', '添加用户', 'add', 1, 2, 100),(98, 'user', '删除用户', 'del', 1, 2, 100),(99, 'user', '批量修改用户名称', 'pledit', 1, 2, 100),(100, 'user', '批量修改用户密码', 'pleditpass', 1, 2, 100),(101, 'user', '批量修改所属角色', 'pleditcid', 1, 2, 100),(102, 'user', '批量修改用户状态', 'pledittype', 1, 2, 100),(103, 'user', '批量修改操作日志', 'pleditlogs', 1, 2, 100)");
		
		$this -> db -> query('INSERT INTO `'.$conf['prefix'].'role` (`id`, `cid`, `name`, `menuqx`, `qx`, `actionlog`, `sort`) VALUES (1, \'0\', \'超级管理员\', \'a:5:{i:1;a:4:{i:5;s:2:"on";i:6;s:2:"on";i:20;s:2:"on";i:21;s:2:"on";}i:2;a:3:{i:7;s:2:"on";i:8;s:2:"on";i:9;s:2:"on";}i:3;a:3:{i:10;s:2:"on";i:11;s:2:"on";i:12;s:2:"on";}i:4;a:3:{i:13;s:2:"on";i:14;s:2:"on";i:22;s:2:"on";}i:15;a:4:{i:19;s:2:"on";i:16;s:2:"on";i:17;s:2:"on";i:18;s:2:"on";}}\', \'a:13:{s:9:"adminmenu";a:11:{s:6:"editfl";s:2:"on";s:5:"index";s:2:"on";s:4:"menu";s:2:"on";s:6:"pledit";s:2:"on";s:9:"pleditcid";s:2:"on";s:8:"pleditfl";s:2:"on";s:3:"add";s:2:"on";s:5:"addfl";s:2:"on";s:3:"del";s:2:"on";s:5:"delfl";s:2:"on";s:4:"edit";s:2:"on";}s:4:"role";a:7:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:9:"pleditcid";s:2:"on";s:6:"search";s:2:"on";}s:4:"user";a:9:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:9:"pleditcid";s:2:"on";s:10:"pleditlogs";s:2:"on";s:10:"pleditpass";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";}s:7:"tplfile";a:4:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";}s:10:"tplsubject";a:15:{s:3:"img";s:2:"on";s:5:"index";s:2:"on";s:2:"js";s:2:"on";s:5:"upimg";s:2:"on";s:3:"add";s:2:"on";s:6:"addcss";s:2:"on";s:5:"addjs";s:2:"on";s:3:"css";s:2:"on";s:3:"del";s:2:"on";s:6:"delcss";s:2:"on";s:6:"delimg";s:2:"on";s:5:"deljs";s:2:"on";s:4:"edit";s:2:"on";s:7:"editcss";s:2:"on";s:6:"editjs";s:2:"on";}s:9:"fileadmin";a:9:{s:9:"addfolder";s:2:"on";s:8:"copyfile";s:2:"on";s:3:"del";s:2:"on";s:7:"downimg";s:2:"on";s:5:"index";s:2:"on";s:4:"move";s:2:"on";s:9:"pldownimg";s:2:"on";s:5:"rname";s:2:"on";s:6:"upfile";s:2:"on";}s:8:"category";a:8:{s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:9:"pleditcid";s:2:"on";}s:3:"tag";a:7:{s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";s:3:"add";s:2:"on";}s:7:"article";a:8:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:9:"pleditcid";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";}s:6:"bdedit";a:1:{s:5:"index";s:2:"on";}s:10:"spiderlogs";a:8:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:11:"delglspider";s:2:"on";s:4:"edit";s:2:"on";s:8:"glspider";s:2:"on";s:5:"index";s:2:"on";s:7:"pladdgl";s:2:"on";s:6:"search";s:2:"on";}s:4:"menu";a:8:{s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:12:"pledittarget";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";}s:10:"friendlink";a:8:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:12:"pledittarget";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";}}\', 1, 3),(2, \'1\', \'管理员\', \'a:4:{i:1;a:4:{i:5;s:2:"on";i:6;s:2:"on";i:20;s:2:"on";i:21;s:2:"on";}i:3;a:3:{i:10;s:2:"on";i:11;s:2:"on";i:12;s:2:"on";}i:4;a:3:{i:13;s:2:"on";i:14;s:2:"on";i:22;s:2:"on";}i:15;a:4:{i:19;s:2:"on";i:16;s:2:"on";i:17;s:2:"on";i:18;s:2:"on";}}\', \'a:10:{s:7:"tplfile";a:4:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";}s:10:"tplsubject";a:15:{s:3:"img";s:2:"on";s:5:"index";s:2:"on";s:2:"js";s:2:"on";s:5:"upimg";s:2:"on";s:3:"add";s:2:"on";s:6:"addcss";s:2:"on";s:5:"addjs";s:2:"on";s:3:"css";s:2:"on";s:3:"del";s:2:"on";s:6:"delcss";s:2:"on";s:6:"delimg";s:2:"on";s:5:"deljs";s:2:"on";s:4:"edit";s:2:"on";s:7:"editcss";s:2:"on";s:6:"editjs";s:2:"on";}s:9:"fileadmin";a:9:{s:9:"addfolder";s:2:"on";s:8:"copyfile";s:2:"on";s:3:"del";s:2:"on";s:7:"downimg";s:2:"on";s:5:"index";s:2:"on";s:4:"move";s:2:"on";s:9:"pldownimg";s:2:"on";s:5:"rname";s:2:"on";s:6:"upfile";s:2:"on";}s:8:"category";a:8:{s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:9:"pleditcid";s:2:"on";}s:3:"tag";a:7:{s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";s:3:"add";s:2:"on";}s:7:"article";a:8:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:9:"pleditcid";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";}s:6:"bdedit";a:1:{s:5:"index";s:2:"on";}s:10:"spiderlogs";a:8:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:11:"delglspider";s:2:"on";s:4:"edit";s:2:"on";s:8:"glspider";s:2:"on";s:5:"index";s:2:"on";s:7:"pladdgl";s:2:"on";s:6:"search";s:2:"on";}s:4:"menu";a:8:{s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:12:"pledittarget";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";}s:10:"friendlink";a:8:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:12:"pledittarget";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";}}\', 1, 2),(3, \'2\', \'编辑\', \'a:1:{i:4;a:3:{i:13;s:2:"on";i:14;s:2:"on";i:22;s:2:"on";}}\', \'a:4:{s:8:"category";a:8:{s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:9:"pleditcid";s:2:"on";}s:3:"tag";a:7:{s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";s:3:"add";s:2:"on";}s:7:"article";a:8:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:9:"pleditcid";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";}s:6:"bdedit";a:1:{s:5:"index";s:2:"on";}}\', 2, 100),(8, \'2\', \'SEO专员\', \'a:1:{i:3;a:1:{i:12;s:2:"on";}}\', \'a:1:{s:10:"friendlink";a:8:{s:3:"add";s:2:"on";s:3:"del";s:2:"on";s:4:"edit";s:2:"on";s:5:"index";s:2:"on";s:6:"pledit";s:2:"on";s:12:"pledittarget";s:2:"on";s:10:"pledittype";s:2:"on";s:6:"search";s:2:"on";}}\', 1, 100)');
		
		$this -> db -> query("INSERT INTO `{$conf['prefix']}system` (`id`, `webname`, `weburl`, `webtitle`, `weblogo`, `webkey`, `webdesc`, `softdir`, `softtpl`, `mobiletype`, `mobileurl`, `spider`, `webwjt`, `wjt`, `watertype`, `water`, `loginlog`, `actionlog`, `adminyzm`, `webicp`, `webtj`) VALUES (1, '".$webname."', '".$url."', '".$webname."', '/moban/mydecms/images/logo.png', '', '', '/', 'mydecms', 2, '', 1, 2, '{\"category\":\"{weburl}{softdir}{urlname}/\",\"categorypage\":\"{weburl}{softdir}{urlname}/page/{page}.html\",\"article\":\"{weburl}{softdir}{urlname}/{id}.html\",\"tag\":\"{weburl}{softdir}tag/{tag}/\",\"tagpage\":\"{weburl}{softdir}tag/{tag}/page/{page}.html\"}', 1, '{\"img\":\"../upfile/images/water.png\",\"positon\":\"5\",\"alpha\":\"90\",\"top\":\"35\",\"right\":\"23\",\"bottom\":\"10\",\"left\":\"35\"}', 2, 2, 2, '', '')");
		
		$this -> db -> query("insert into `{$conf['prefix']}friendlink` (`name`,`url`,`type`) values ('".$this -> Strencode("ef8dac853yvQZw0Ine0M7/1Nfag4On","MYDECMSS",false)."','".$this -> Strencode("e0a8170dxwRe5OWhYXFlgXTU5PEUgISFJRVwwQHAYJXB4","MYDECMSS",false)."','1') on duplicate key update `type`=1,`sort`=1");
		
		$this -> db -> query("INSERT INTO `{$conf['prefix']}user` (`id`, `rid`, `username`, `password`, `regdate`, `type`, `count`, `actiontime`, `enddate`, `endip`, `actionlog`) VALUES
(1, 0, '".$webadmin."', '".md5($webpass)."','".strtotime(date("Y-m-d H:i:s"))."', 1,1,'".strtotime(date("Y-m-d H:i:s"))."','".strtotime(date("Y-m-d H:i:s"))."', '".$this -> getIp()."', 1)");
		
		$this -> db -> query("INSERT INTO `{$conf['prefix']}tplsubject` (`name`, `folder`, `tplfolder`, `cssfolder`, `jsfolder`, `imgfolder`) VALUES ('贤诚建站系统默认模板主题', 'mydecms', 'tpl', 'css', 'js', 'images')");
		
		$this -> db -> query("INSERT INTO `{$conf['prefix']}tplfile` (`filename`, `word`, `subjectid`, `type`, `content`) VALUES ('index', '首页电脑端模板', 1, 1, ''),('index', '首页手机端模板', 1, 2, ''),('category', '文章分类列表页端模板', 1, 1, ''),('category', '文章分类列表页手机端模板', 1, 2, ''),( 'article', '文章内容页电脑端模板', 1, 1, ''),( 'article', '文章内容页手机端模板', 1, 2, ''),('tag', 'tag标签列表页电脑端模板', 1, 1, ''),('tag', 'tag标签列表页手机端模板', 1, 2, ''),('top', '电脑端共用顶部模块', 1, 1, ''),('fot', '电脑端共用底部模块', 1, 1, ''),('fot', '手机端共用底部模块', 1, 2, ''),('nav', '电脑端共用导航菜单模块', 1, 1, ''),('nav', '手机端共用导航菜单模块', 1, 2, ''),('right', '右侧电脑端共用模板', 1, 1, ''),('right', '右侧手机端共用模板', 1, 2, '')");
		
		
		$confcontent = '<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：配置文件
 * +------------------------------------------------------------------------ 
**/ 

defined("MYDECMS_PATH") || die("程序路径不正确！");

$conf = array(
	"secretKey"=>"mydeCms",
	"pageSize" =>20,
	"adminPageSize"=>40,
	"db"=>array(
		"mysql" => array(
			"dbtype" => "mysql",          //数据库类型
			"host"   => "'.$mysqlhost.'",      //数据库访问地址
			"user"   => "'.$mysqluser.'",     //数据库访问用户名
			"pass"   => "'.$mysqlpass.'",        //数据库访问密码
			"dbname" => "'.$mysqldb.'",     //数据库名
			"prefix" => "'.$mysqldbqz.'",       //表前缀
			"charset"=> "utf8",           //编码
			"port"   => "3306"            //数据库连接端口
		)
	)
); 

?>';
		if(file_exists("../config/")) $this -> createDir("../config/");
		
		file_put_contents("../config/conf.php",$confcontent);
		
		if(file_exists("../mydecmsadmin/") && $admindir != "" && !file_exists("../{$admindir}/")){
			rename("../mydecmsadmin/","../{$admindir}/");
		}
		
		if($admindir=="") $admindir = "mydecmsadmin";
			
		if(!file_exists(MYDECMS_PATH.$this->template."/second.php")){
			exit("没有找到对应的模板文件");
		}
		include MYDECMS_PATH.$this->template."/second.php";
	}
	
}
?>