<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：后台菜单分栏管理控制器
 * +------------------------------------------------------------------------ 
**/  

class adminmenuControl extends adminControl {
	public $ControlName = "后台菜单管理";
	private $cid;//父菜单ID
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			
		),
		//用户权限功能
		"user"  => array(
			"index"       => "查看后台菜单分栏",
			"menu"        => "查看后台菜单",
			"addfl"       => "添加后台菜单分栏",
			"editfl"      => "修改后台菜单分栏",
			"delfl"       => "删除后台菜单分栏",
			"pleditfl"    => "批量修改后台菜单分栏",
			"add"         => "添加后台菜单",
			"edit"        => "修改后台菜单",
			"del"         => "删除后台菜单",
			"pledit"      => "批量修改后台菜单",
			"pleditcid"   => "批量修改后台菜单所属分栏"
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
		$this -> cid = $this -> p("cid","0","1");
	}
	
	/**
	 * 查看后台菜单分栏
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."adminmenu/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$where = $this -> cid != "0" ? " where `cid`=0  and `type`!=1" : " where `type`!=1";
		
		$list = $this -> db -> keyList("select *,(select count(id) from {$this->conf['prefix']}adminmenu as m2 where m2.cid=m1.id) as cids from {$this->conf['prefix']}adminmenu as m1 {$where} order by `cid` asc,`sort` asc,`id` asc");
		
		include MYDECMS_PATH.$this->template."adminmenu/index.php";
		exit();
	}
	
	/**
	 * 查看后台菜单
	**/
	public function menu(){
		if(!file_exists(MYDECMS_PATH.$this->template."adminmenu/menu.php")){
			exit("没有找到对应的模板文件");
		}
		
		$where = $this -> cid != "0" ? " where `cid`='".$this -> cid."' and `type`=1 " : " where `type`=1 ";
		
		$list = $this -> db -> keyList("select *,(select count(id) from {$this->conf['prefix']}adminmenu as m2 where m2.cid=m1.id) as cids from {$this->conf['prefix']}adminmenu as m1 {$where} order by `cid` asc,`sort` asc,`id` asc");
		
		$where = $this -> cid != "0" ? " where `cid`=0  and `type`!=1" : " where `type`!=1";
		
		$clist = $this -> db -> keyList("select *,(select count(id) from {$this->conf['prefix']}adminmenu as m2 where m2.cid=m1.id) as cids from {$this->conf['prefix']}adminmenu as m1 {$where} order by `cid` asc,`sort` asc,`id` asc");
		
		include MYDECMS_PATH.$this->template."adminmenu/menu.php";
		exit();
	}
	
	/**
	 * 添加后台菜单分栏
	**/
	public function addfl(){
		if(!file_exists(MYDECMS_PATH.$this->template."adminmenu/addfl.php")){
			exit("没有找到对应的模板文件");
		}
		
		$v = array("id"=>"","cid"=>"","name"=>"","img"=>"","url"=>"","type"=>"1","sort"=>"100");
		include MYDECMS_PATH.$this->template."adminmenu/addfl.php";
		exit();
	}
	public function addflAction(){
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("菜单分栏不能为空","",false,3);
		}
		
		$img     = $this -> p("img","","2");
		if($img == ""){
			$this -> msg("分栏小图标不能为空","",false,3);
		}
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}

		$this -> db -> query("insert ignore into `{$this->conf['prefix']}adminmenu` (`cid`,`name`,`url`,`img`,`type`,`sort`) value ('0','".$name."','','".$img."','2','".$this->glstr($sort,1)."')");
     	$this -> addlog("添加后台菜单分栏【".$this -> readContent($name)."】");
		$this -> msg("添加新后台菜单分栏成功","./index.php?c=adminmenu&a=index",true);
	}
	
	/**
	 * 添加后台菜单
	**/
	public function add(){
		if(!file_exists(MYDECMS_PATH.$this->template."adminmenu/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$v = array("id"=>"","cid"=>"","name"=>"","url"=>"","type"=>"1","sort"=>"100");
		include MYDECMS_PATH.$this->template."adminmenu/add.php";
		exit();
	}
	public function addAction(){
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("菜单名称不能为空","",false,3);
		}
		$url     = $this -> p("url","","2");
		if($url == ""){
			$this -> msg("菜单链接地址不能为空","",false,3);
		}
		
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}
		
		$this -> db -> query("insert ignore into `{$this->conf['prefix']}adminmenu` (`cid`,`name`,`url`,`type`,`sort`) value ('".$this ->cid."','".$name."','".$url."','1','".$sort."')");
     	$this -> addlog("添加后台菜单【".$this -> readContent($name)."】");
		$this -> msg("添加后台菜单成功","./index.php?c=adminmenu&a=menu&cid=".$this->cid,true);
	}
	
	/**
	 * 修改后台菜单分栏
	**/
	public function editfl(){
		if(!file_exists(MYDECMS_PATH.$this->template."adminmenu/addfl.php")){
			exit("没有找到对应的模板文件");
		}
		
		$id = $this -> p("id","","1");
		if($id=="") $this -> errlog("记录参数错误");

		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}adminmenu where `id`='{$id}' limit 0,1");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		include MYDECMS_PATH.$this->template."adminmenu/addfl.php";
		exit();
	}
	public function editflAction(){
		$id = $this -> p("id","","2");
		if($id=="") $this -> errlog("记录参数错误");
		
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("菜单分栏不能为空","",false,3);
		}
		
		$img     = $this -> p("img","","2");
		if($img == ""){
			$this -> msg("分栏小图标不能为空","",false,3);
		}
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}
		
		$this -> db -> query("update `{$this->conf['prefix']}adminmenu` set `name`='".$name."',`img`='".$img."',`sort`='".$sort."' where `id`='{$id}'");
		$this -> addlog("修改后台菜单分栏【{$id}=>".$this -> readContent($name)."】");
		$this -> msg("修改后台菜单分栏成功","./index.php?c=adminmenu&a=index",true);
	}
	
	/**
	 * 修改后台菜单
	**/
	public function edit(){
		if(!file_exists(MYDECMS_PATH.$this->template."adminmenu/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$id = $this -> p("id","","1");
		if($id=="") $this -> errlog("记录参数错误");
		
		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}adminmenu where `id`='{$id}' limit 0,1");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		include MYDECMS_PATH.$this->template."adminmenu/add.php";
		exit();
	}
	public function editAction(){
		$id = $this -> p("id","","2");
		if($id=="") $this -> errlog("记录参数错误");
		
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("菜单名称不能为空","",false,3);
		}
		$url     = $this -> p("url","","2");
		if($url == ""){
			$this -> msg("菜单链接地址不能为空","",false,3);
		}
		
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}
		
		
		$this -> db -> query("update `{$this->conf['prefix']}adminmenu` set `cid`='".$this -> cid."',`name`='".$name."',`url`='".$url."',`sort`='".$this->glstr($sort,1)."' where `id`='{$id}'");
		$this -> addlog("修改后台菜单【{$id}=>".$this -> readContent($name)."】");
		$this -> msg("修改后台菜单成功","./index.php?c=adminmenu&a=menu&cid=".$this->cid,true);
	}
	
	/**
	 * 删除后台菜单分栏
	**/
	public function delfl(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}adminmenu where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("delete from {$this->conf['prefix']}adminmenu where `id`='".$id."'");
		}
		$this -> addlog("批量删除后台菜单分栏【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除后台菜单分栏成功","./index.php?c=adminmenu&a=index",true);
	}
	
	
	/**
	 * 删除后台菜单
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}adminmenu where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("delete from {$this->conf['prefix']}adminmenu where `id`='".$id."'");
		}
		$this -> addlog("批量删除后台菜单【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除后台菜单成功","./index.php?c=adminmenu&a=menu&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改后台菜单分栏
	**/
	public function pleditfl(){
		$id      = $this -> p("id","","2");
		$ids     = $this -> p("ids","","2");
		$name    = $this -> p("name","","2");
		$sort    = $this -> p("sort","100","2");
		
		if($id == "" || $ids =="" || $name == "" || $sort == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$idarr = array();
		
		foreach ($ids as $k => $v){
			if(in_array($v, $id)) $idarr[] = $k ;
		}
		
		try{
			foreach($idarr as $v){
				if($name[$v]=="" || $name[$v] == NULL) continue;
				$this -> db -> query("update {$this->conf['prefix']}adminmenu set `name`='".$name[$v]."',`sort`='".$sort[$v]."' where `id`='".$ids[$v]."'");
			}
			$this -> addlog("批量修改后台菜单分栏【".(is_array($id) ? implode(",",$id):$id)."】");
			$this -> msg("批量修改数据成功","./index.php?c=adminmenu&a=index",true,5);
		}catch (Exception $err) {
			$this -> errlog("批量修改数据出错<br><p>".$err->getMessage()."</p>");
		}
	}
	
	/**
	 * 批量修改后台菜单所属分栏
	**/
	public function pleditcid(){
		$id          = $this -> p("id","","2");
		$newcid     = $this -> p("newcid","1");
		if($id == "" || $newcid == ""){
			$this -> msg("提交的数据错误","");
		}
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}adminmenu set `cid`='".$this->glstr($newcid)."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}adminmenu set `cid`='".$this->glstr($newcid)."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改后台菜单所属分栏【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改所属分栏成功","./index.php?c=adminmenu&a=menu&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改后台菜单
	**/
	public function pledit(){
		$id      = $this -> p("id","","2");
		$ids     = $this -> p("ids","","2");
		$name    = $this -> p("name","","2");
		$url     = $this -> p("url","","2");
		$sort    = $this -> p("sort","100","2");
		
		if($id == "" || $ids =="" || $name == "" || $url == "" || $sort == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$idarr = array();
		$cgs = $sbs = $cws = 0;
		
		foreach ($ids as $k => $v){
			if(in_array($v, $id)) $idarr[] = $k ;
		}
		
		try{
			foreach($idarr as $v){
				if($name[$v]=="" || $name[$v] == NULL) continue;
				$this -> db -> query("update {$this->conf['prefix']}adminmenu set `name`='".$this->glstr($name[$v],"6")."',`url`='".$url[$v]."',`sort`='".$this->glstr($sort[$v])."',`cid`='".$this-> cid."' where `id`='".$this->glstr($ids[$v])."'");
			}
			$this -> addlog("批量修改后台菜单【".(is_array($id) ? implode(",",$id):$id)."】");
			$this -> msg("批量修改数据成功","./index.php?c=adminmenu&a=menu&cid=".$this->cid,true,5);
		}catch (Exception $err) {
			$this -> errlog("批量修改数据出错<br><p>".$err->getMessage()."</p>");
		}
	}
	
	/**
	 * 清空后台菜单分栏
	**/
	public function clearfl(){
		$this -> db -> truncate("{$this->conf['prefix']}adminmenu");
		$this -> addlog("清空后台菜单分栏");
		$this -> msg("清空表数据成功","./index.php?c=adminmenu&a=index",true);
	}
	
}
?>