<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：文章管理控制器
 * +------------------------------------------------------------------------ 
**/  

class articleControl extends adminControl {
	public $ControlName = "文章管理";
	private $pageCode;//分页源代码
	private $type = "";//属性
	private $cid;//父分类
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			
		),
		//用户权限功能
		"user"  => array(
			"index"       => "查看文章列表",
			"search"      => "搜索文章",
			"add"         => "添加文章",
			"edit"        => "修改文章",
			"del"         => "删除文章",
			"pledit"      => "批量修改文章",
			"pledittype"  => "批量修改文章属性",
			"pleditcid"   => "批量修改文章所属分类"
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
		$this -> type = $this -> p("type","","1");
		$this -> cid = $this -> p("cid","0","1");
	}
	
	/**
	 * 文章url
	 * $v => 文章记录信息数组
	**/
	public function wzurl($v){
		$url = $this -> config['webwjt'] == "2" ? '{weburl}{softdir}index.php?c=article&a=index&id={id}' : $this -> config['wjt']['article'];
		$url = str_replace(array('{weburl}','{softdir}','{cid}','{urlname}','{id}'),array($this->config['weburl'],$this->config['softdir'],isset($v['cid']) ? $v['cid'] : '',isset($v['urlname']) ? $v['urlname'] : '',isset($v['id']) ? $v['id'] : ''),$url);
		return $url;
	}
	
	/**
	 * 查看文章
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."article/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$c = $this-> cid == "0" ? array() : $this -> db -> fetch_first("select `id`,`fids`,`zids` from {$this->conf['prefix']}category where id={$this -> cid} order by `id` asc");
		
		
		$where = isset($c['zids']) && $c['zids'] != "" ? " where c1.cid in(".$c['zids'].")": "";	
		
		if($this -> type != ""){
			$where = $where != "" ? $where." and " : $where." where ";
			$where .= " c1.type='".$this -> type."'";
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select c1.*,c3.views,c2.name as cname,c2.urlname as urlname,u.username as username from {$this->conf['prefix']}article as c1 left join {$this->conf['prefix']}category as c2 on c2.id=c1.cid left join {$this->conf['prefix']}cachearticle as c3 on c3.aid=c1.id left join {$this->conf['prefix']}user as u on u.id=c1.userid {$where} order by c1.id desc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}article as c1 ","*",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=article&a=index&page={page}&type=".$this->type."&cid=".$this->cid,"./index.php?c=article&a=index&type=".$this->type."&cid=".$this->cid);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=article&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."article/index.php";
		exit();
	}
	
	/**
	 * 搜索文章
	**/
	public function search(){
		if(!file_exists(MYDECMS_PATH.$this->template."article/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$searchtype = isset($_GET['searchtype']) ? $this->glstr($_GET['searchtype']) : "1";
		
		$searchkey = isset($_GET['searchkey']) ? $this->glstr($_GET['searchkey'],6) : "";
		if(empty($searchkey)){
			header("Location: ./index.php?c=article&a=index");
		}
		
		$where = "";
		
		switch($searchtype){
			case "1":
				$where = " where c1.content like '%".$searchkey."%'";
				break;
			default:
				$where = " where c1.title like '%".$searchkey."%'";
				break;
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select c1.*,c3.views,c2.name as cname,c2.urlname as urlname,u.username as username from {$this->conf['prefix']}article as c1 left join {$this->conf['prefix']}category as c2 on c2.id=c1.cid left join {$this->conf['prefix']}cachearticle as c3 on c3.aid=c1.id left join {$this->conf['prefix']}user as u on u.id=c1.userid {$where} order by c1.id desc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}article as c1 ","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=article&a=search&page={page}&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype."&cid=".$this->cid,"./index.php?c=article&a=search&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype."&cid=".$this->cid);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=article&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."article/index.php";
		exit();
	}
	
	/**
	 * 添加文章
	**/
	public function add(){
		if(!file_exists(MYDECMS_PATH.$this->template."article/add.php")){
			exit("没有找到对应的模板文件");
		}
		$c = $this-> cid == "0" ? array() :$this -> db -> fetch_first("select `id`,`name` from {$this->conf['prefix']}category where id={$this -> cid} limit 0,1");
		$v = array("id"=>"","img"=>"","tags"=>"","cname"=>(isset($c['name']) ? $c['name'] : "根分类"),"views"=>"0","cid"=>(isset($c['id']) ? $c['id'] : "0"),"type"=>"1","tpl"=>"","title"=>"","keyword"=>"","desc"=>"","sort"=>"100","content"=>"","date"=>date("Y-m-d H:i:s"));

		
		include MYDECMS_PATH.$this->template."article/add.php";
		exit();
	}
	public function addAction(){
		$title     = $this -> p("title","","2");
		if($title == ""){
			$this -> msg("文章标题不能为空","",false,3);
		}
		$content     = $this -> p("content","","2");
		if($content == ""){
			$this -> msg("文章内容不能为空","",false,3);
		}	
		
		$type    = $this -> p("type","1","2");
		$cid     = $this -> p("cid","0","2");
		$tpl     = $this -> p("tpl","","2");
		$title   = $this -> p("title","","2");
		$keyword = $this -> p("keyword","","2");
		$desc    = $this -> p("desc","","2");
		$img     = $this -> p("img","","2");
		$views   = $this -> p("views","0","2");
		$tags    = $this -> p("tags","","2");
		$date    = strtotime($this -> p("date",date("Y-m-d H:i:s"),"2"));
		
		$this -> db -> query("insert ignore into `{$this->conf['prefix']}article` (`cid`,`title`,`keyword`,`desc`,`img`,`content`,`tpl`,`userid`,`date`,`type`,`tags`) value ('".$cid."','".$title."','".$keyword."','".$desc."','".$img."','".$content."','".$tpl."','".$this->user["id"]."','".$date."','".$type."','".$tags."')");
		
		$newdate = strtotime(date("Y-m-d H:i:s"));
		
		if($tags!=''){
			$taglist = explode(",",$tags);
			$sql   = "";
			$inser = "insert ignore into `{$this->conf['prefix']}tag` (`name`,`userid`,`date`,`views`) value ";
			foreach($taglist as $v){
				$sql .= ",('".$v."','".$this->user["id"]."','".$newdate."','0')";
			}
			if($sql!=""){
				$sql = substr($sql,1);
				$this -> db -> query($inser.$sql);
			}
			$this -> db -> query("update `{$this->conf['prefix']}tag` as t set t.date='".$newdate."',t.ids=(select GROUP_CONCAT(a.id) AS ids from {$this->conf['prefix']}article as a where a.tags like concat('%' ,t.name,'%') order by id desc limit 0,100) where `name` in('".str_replace(",","','",$tags)."')");
		}
		
		$this -> addlog("添加新文章【".$this -> readContent($title)."】");
		$this -> msg("添加新文章成功","./index.php?c=article&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	
	/**
	 * 修改文章
	**/
	public function edit(){
		if(!file_exists(MYDECMS_PATH.$this->template."article/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$id = $this -> p("id","","1");
		if($id=="") $this -> errlog("记录参数错误");

		$v = $this -> db -> fetch_first("select c1.*,c2.name as cname,c3.views from {$this->conf['prefix']}article as c1 left join {$this->conf['prefix']}category as c2 on c2.id=c1.cid left join {$this->conf['prefix']}cachearticle as c3 on c3.aid=c1.id where c1.id='{$id}' limit 0,1");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		if($v['cname']=="") $v['cname'] = "根分类";
		
		$v["date"] = date("Y-m-d H:i:s",$v["date"]);
		
		
		include MYDECMS_PATH.$this->template."article/add.php";
		exit();
	}
	public function editAction(){
		$id = $this -> p("id","","2");
		$title     = $this -> p("title","","2");
		if($title == ""){
			$this -> msg("文章标题不能为空","",false,3);
		}
		$content     = $this -> p("content","","2");
		if($content == ""){
			$this -> msg("文章内容不能为空","",false,3);
		}	
		
		$v = $this -> db -> fetch_first("select `tags` from {$this->conf['prefix']}article where `id`='{$id}' limit 0,1");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		$type    = $this -> p("type","1","2");
		$cid     = $this -> p("cid","0","2");
		$tpl     = $this -> p("tpl","","2");
		$title   = $this -> p("title","","2");
		$keyword = $this -> p("keyword","","2");
		$desc    = $this -> p("desc","","2");
		$img     = $this -> p("img","","2");
		$views   = $this -> p("views","0","2");
		$tags    = $this -> p("tags","","2");
		$date    = strtotime($this -> p("date",date("Y-m-d H:i:s"),"2"));
		
		$this -> db -> query("update {$this->conf['prefix']}article as c1 left join {$this->conf['prefix']}cachearticle as c3 on c3.aid=c1.id set c1.cid='".$cid."',c1.title='".$title."',c1.keyword='".$keyword."',c1.desc='".$desc."',c1.img='".$img."',c1.content='".$content."',c1.tpl='".$tpl."',c1.date='".$date."',c1.type='".$type."',c1.tags='".$tags."',c3.views='".$views."' where c1.id='{$id}'");

		$this -> addlog("修改文章【{$id}=>".$this -> readContent($title)."】");
		
		if($v['tags']!='') $tags .= ",".$v['tags'];
		
		if(substr($tags,0,1)==",") $tags = substr($tags,1);
		
		$oldtaglist = $newtaglist = $taglist = array();
		if($v['tags']!=''){
			$oldtaglist = explode(",",$v['tags']);
		}
		
		if($tags!=''){
			$newtaglist = explode(",",$tags);
		}
		
		foreach($newtaglist as $vv){
			if(!in_array($vv,$oldtaglist) && !in_array($vv,$taglist)) $taglist[] = $vv;
		}
		
		foreach($oldtaglist as $vv){
			if(!in_array($vv,$newtaglist) && !in_array($vv,$taglist)) $taglist[] = $vv;
		}
		
		$newdate = strtotime(date("Y-m-d H:i:s"));
		
		if(count($taglist)>0){
			if(count($taglist)>0) $taglist = array_filter($taglist);
			if(count($taglist)>0) $taglist = array_unique($taglist);
			$sql   = "";
			$inser = "insert ignore into `{$this->conf['prefix']}tag` (`name`,`userid`,`date`,`views`) value ";
			foreach($taglist as $v){
				$sql .= ",('".$v."','".$this->user["id"]."','".$newdate."','0')";
			}
			if($sql!=""){
				$sql = substr($sql,1);
				$this -> db -> query($inser.$sql);
			}
			$tags = implode(",",$taglist);
			$this -> db -> query("update `{$this->conf['prefix']}tag` as t set t.date='".$newdate."',t.ids=(select GROUP_CONCAT(a.id) AS ids from {$this->conf['prefix']}article as a where a.tags like concat('%' ,t.name,'%') order by id desc limit 0,100) where `name` in('".str_replace(",","','",$tags)."')");
		}
		
		$this -> msg("修改文章成功","./index.php?c=article&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	
	/**
	 * 删除文章
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$v = $this -> db -> fetch_first("select GROUP_CONCAT(tags) tags from {$this->conf['prefix']}article {$this->conf['prefix']}article where `id` in(".implode(",",$id).")");
		
		$date = strtotime(date("Y-m-d H:i:s"));
		
		if($v['tags']!=''){
			$taglist = explode(",",$v['tags']);
			if(count($taglist)>0) $taglist = array_filter($taglist);
			if(count($taglist)>0) $taglist = array_unique($taglist);
			if(count($taglist)>0){
				//$this -> db -> query("update `{$this->conf['prefix']}tag` as t set t.date='".$date."',t.ids=(select GROUP_CONCAT(a.id) AS ids from {$this->conf['prefix']}article as a where a.tags like concat('%' ,t.name,'%') order by id desc limit 0,100) where `name` in('".implode("','",$taglist)."')");
			}
		}
		
		
		$this -> db -> query("delete c1,c3 from {$this->conf['prefix']}article as c1 left join {$this->conf['prefix']}cachearticle as c3 on c3.aid=c1.id where c1.id in(".implode(",",$id).")");

		$this -> addlog("批量删除文章【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除文章成功","./index.php?c=article&a=index&page=".$this->page."&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改文章
	**/
	public function pledit(){
		$id      = $this -> p("id","","2");
		$ids     = $this -> p("ids","","2");
		$title    = $this -> p("title","","2");
		$tpl     = $this -> p("tpl","","2");
		$views    = $this -> p("views","0","2");
		$tags      = $this -> p("tags","","2");
		
		$date = strtotime(date("Y-m-d H:i:s"));

		if($id == "" || $ids =="" || $title == "" || $tpl == "" || $views == "" || $tags == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$idarr = array();
		$cgs = $sbs = $cws = 0;
		
		foreach ($ids as $k => $v){
			if(in_array($v, $id)) $idarr[] = $k ;
		}
		
		$v = $this -> db -> fetch_first("select GROUP_CONCAT(tags) tags from {$this->conf['prefix']}article {$this->conf['prefix']}article where `id` in(".implode(",",$id).")");
		
		$oldtaglist = $newtaglist = array();
		if($v['tags']!=''){
			$oldtaglist = explode(",",$v['tags']);
			if(count($oldtaglist)>0) $oldtaglist = array_filter($oldtaglist);
			if(count($oldtaglist)>0) $oldtaglist = array_unique($oldtaglist);
		}
		
		$taglist = array();
		try{
			$newtags = "";
			foreach($idarr as $v){
				if($title[$v]=="" || $title[$v] == NULL) continue;
				$this -> db -> query("update {$this->conf['prefix']}article as c1 left join {$this->conf['prefix']}cachearticle as c3 on c3.aid=c1.id set c1.title='".$title[$v]."',c1.tpl='".$tpl[$v]."',c3.views='".$views[$v]."',c1.tags='".$tags[$v]."' where c1.id='".$ids[$v]."'");
				if($tags[$v]!=""){
					$temtags = explode(",",$tags[$v]);
					foreach($temtags as $vv){
						if(!in_array($vv,$newtaglist)) $newtaglist[] = $vv;
						if(!in_array($vv,$oldtaglist) && !in_array($vv,$taglist)) $taglist[] = $vv;
					}
				}
			}
			$this -> addlog("批量修改文章【".(is_array($id) ? implode(",",$id):$id)."】");
			
			foreach($oldtaglist as $v){
				if(!in_array($v,$newtaglist) && !in_array($v,$taglist)) $taglist[] = $v;
			}
			
			if(count($taglist)>0){
				$sql   = "";
				$inser = "insert ignore into `{$this->conf['prefix']}tag` (`name`,`userid`,`date`,`views`) value ";
				foreach($taglist as $v){
					$sql .= ",('".$v."','".$this->user["id"]."','".$date."','0')";
				}
				if($sql!=""){
					$sql = substr($sql,1);
					$this -> db -> query($inser.$sql);
				}
				
				$this -> db -> query("update `{$this->conf['prefix']}tag` as t set t.date='".$date."',t.ids=(select GROUP_CONCAT(a.id) AS ids from {$this->conf['prefix']}article as a where a.tags like concat('%' ,t.name,'%') order by id desc limit 0,100) where `name` in('".implode("','",$taglist)."')");
			}
			
			$this -> msg("批量修改数据成功","./index.php?c=article&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true,5);
		}catch (Exception $err) {
			$this -> errlog("批量修改数据出错<br><p>".$err->getMessage()."</p>");
		}
	}


	/**
	 * 批量修改显示属性
	**/
	public function pledittype(){
		$id          = $this -> p("id","","2");
		$newtype     = $this -> p("newtype","1");
		if($id == "" || $newtype == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}article set `type`='".$this->glstr($newtype)."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}article set `type`='".$this->glstr($newtype)."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改文章属性【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改显示属性成功","./index.php?c=article&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改文章所属分类
	**/
	public function pleditcid(){
		$newcid = $this -> p("newcid","0");
		$id     = $this -> p("id","","2");
		if($id == "" || $newcid == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}article set `cid`='".$newcid."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}article set `cid`='".$newcid."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改文章所属分类【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改所属父分类","./index.php?c=article&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	/**
	 * 清空文章
	**/
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}article");
		$this -> db -> truncate("{$this->conf['prefix']}cachearticle");
		$this -> addlog("清空文章表数据");
		$this -> msg("清空表数据成功","./index.php?c=article&a=index",true);
	}
}
?>