<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：文章分类管理控制器
 * +------------------------------------------------------------------------ 
**/  

class categoryControl extends adminControl {
	public $ControlName = "文章分类管理";
	private $pageCode;//分页源代码
	private $type = "";//属性
	private $cid;//父分类
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			"show"=>"选择分类",
			"exist"=>"检测urlname是否存在"
		),
		//用户权限功能
		"user"  => array(
			"index"       => "查看文章分类",
			"search"      => "搜索文章分类",
			"add"         => "添加文章分类",
			"edit"        => "修改文章分类",
			"del"         => "删除文章分类",
			"pledit"      => "批量修改文章分类",
			"pledittype"  => "批量修改显示属性",
			"pleditcid"   => "批量修改所属父分类"
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
		$this -> type = $this -> p("type","","1");
		$this -> cid = $this -> p("cid","0","1");
	}
	
	/**
	 * 检测urlname是否存在
	**/
	public function exist(){
		$id        = $this -> p("id","","1");
		$urlname   = $this -> glstr($this -> p("urlname","","1"),3);
		if($urlname == ""){
			return ;
		}
		$v = $this -> db -> fetch_first("select `id`,`urlname` from {$this->conf['prefix']}category where `urlname`='".$urlname."'".($id !="" ? " and `id`!={$id}":""));
		if($v){
			exit("【{$urlname}】已经存在!");
		}
	}
	
	
	/**
	 * 选择分类
	**/
	public function show(){
		$v = $this -> cid == "0" ? array("id"=>0,"name"=>"根分类","cid"=>"0") : $this -> db -> fetch_first("select `id`,`cid`,`name`,`fids`,`zids` from {$this->conf['prefix']}category where id={$this -> cid}");
		$plist = isset($v['fids']) && $v['fids'] != "" ? $this -> db -> keyList("select * from {$this->conf['prefix']}category where id in({$v['fids']}) order by find_in_set(id,'".$v['fids']."')"): array();
		
		
		$zlist = $this -> db -> keyList("select *,(select count(id) from {$this->conf['prefix']}category where `cid`=c.id) as zcount from {$this->conf['prefix']}category as c where cid={$this -> cid} order by `type` asc,id asc");
		
		include MYDECMS_PATH.$this->template."category/show.php";
		exit();
	}
	
	/**
	 * 获取分类数据
	 * $tid => 当前分类ID
	**/
	private function getfl($tid){
		$data = array();
		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}category where id={$tid}");
		if($v){
			$data['data'] = $v;
			if($v['fids']!=""){
				if(strlen($v['fids'])>0) $v['fids'] = str_replace(",,",",",$v['fids']);
				if(strlen($v['fids'])>0 && substr($v['fids'],0,1) == ",") $v['fids'] = substr($v['fids'],1);
				if(strlen($v['fids'])>0 && substr($v['fids'],-1) == ",") $v['fids'] = substr($v['fids'],0,-1);
				$data['ffl'] = $this -> db -> keyList("select * from {$this->conf['prefix']}category where id in ({$v['fids']}) order by find_in_set(id,'{$v['fids']}')");
			}
			
			if($v['zids']!=""){
				if(strlen($v['zids'])>0) $v['zids'] = str_replace(",,",",",$v['zids']);
				if(strlen($v['zids'])>0 && substr($v['zids'],0,1) == ",") $v['zids'] = substr($v['zids'],1);
				if(strlen($v['zids'])>0 && substr($v['zids'],-1) == ",") $v['zids'] = substr($v['zids'],0,-1);
				$data['zfl'] = $this -> db -> keyList("select * from {$this->conf['prefix']}category where id in ({$v['zids']}) order by find_in_set(id,'{$v['zids']}')");
			}
		}
		echo json_encode($data);
	}
	
	/**
	 * 获取父分类ID集合
	 * $tid => 当前分类ID
	**/
	private function getffl($tid){
		$fid = "";
		if($tid=="0") return $fid;
		$v = $this -> db -> fetch_first("select `cid` from {$this->conf['prefix']}category where id={$tid}");
		if(isset($v['cid']) && $v['cid']!=''){
			$fid = $v['cid'];
			$newid = $this -> getffl($v['cid']);
			$fid = $newid != "" ? $newid.($fid != "" ? ",".$fid : "") : $fid;
		}
		return $fid;
	}
	
	/**
	 * 获取子分类ID集合
	 * $tid => 当前分类ID
	**/
	private function getzfl($tid){
		$zid = "";
		$v = $this -> db -> fetch_first("select group_concat(id) as zids from {$this->conf['prefix']}category where cid={$tid}");
		if(isset($v['zids']) && $v['zids'] != ''){
			$zid = $v['zids'];
		}

		$list = $zid != "" ? explode(",",$zid) : array();
		foreach($list as $v){
			$newid = $this -> getzfl($v);
			if($newid != "") $zid .= ",".$newid;
		}
		
		if(strlen($zid)>0 && substr($zid,0,1) == ",") $zid = substr($zid,1);
		
		return $zid;
	}
	
	/**
	 * 更新文章分类的父分类ID集合及子分类ID集合
	 * $ids => 要更新的ID分类数组
	**/
	private function updateIds($ids){
		$v = $this -> db -> fetch_first("select group_concat(id) as ids from {$this->conf['prefix']}category where id in ({$ids}) order by `id` asc");
		if(!isset($v['ids']) || $v['ids']=="") return;
		$list = explode(",",$v['ids']);
		$list = array_filter($list);
		$list = array_unique($list);

		foreach($list as $v){
			$newfids = $this -> getffl($v);
			$newzids = $this -> getzfl($v);
			$newzids = $newzids != "" ? $newzids = $v.",".$newzids : $v ;
			$this -> db -> query("update `{$this->conf['prefix']}category` set `fids`='".$newfids."',`zids`='".$newzids."' where `id`={$v}");
		}
	}
	
	/**
	 * 文章分类url
	 * $v => 文章分类记录信息数组
	**/
	public function flurl($v){
		$url = $this -> config['webwjt'] == "2" ? '{weburl}{softdir}index.php?c=category&a=index&id={cid}' :$this -> config['wjt']['category'];
		$url = str_replace(array('{weburl}','{softdir}','{cid}','{urlname}'),array($this->config['weburl'],$this->config['softdir'],isset($v['id']) ? $v['id']:'',isset($v['urlname']) ? $v['urlname'] : ''),$url);
		return $url;
	}
	
	/**
	 * 查看文章分类
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."category/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$where = $this -> cid != "" ? " where `cid`='".$this -> cid."'": "";	
		
		if($this -> type != ""){
			$where = $where != "" ? $where." and " : $where." where ";
			$where .= " `type`='".$this -> type."'";
		}
		
		$p = $this -> cid == "0" ? array() : $this -> db -> fetch_first("select `id`,`fids` from {$this->conf['prefix']}category where id={$this -> cid} and `type`='1' limit 0,1");
				
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select *,(select count(id) from {$this->conf['prefix']}category as c2 where c2.cid=c1.id) as zidcount,(select `name` from {$this->conf['prefix']}category as c3 where c3.id=c1.cid) as cname from {$this->conf['prefix']}category as c1 {$where} order by `type` asc,`sort` asc,`id` asc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}category","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=category&a=index&page={page}&type=".$this->type."&cid=".$this->cid,"./index.php?c=category&a=index&type=".$this->type."&cid=".$this->cid);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=category&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");

		if(isset($p['fids']) && strlen($p['fids'])>0){
			if(substr($p['fids'],0,1)==",") $p['fids'] = substr($p['fids'],1);
			if(strlen($p['fids'])>0 && substr($p['fids'],-1)==",") $p['fids'] = substr($p['fids'],0,-1);
			if($p['fids']!="") $p['fids'] .= ",".$p['id'];
		}
		$plist = isset($p['fids']) && $p['fids'] != "" ? $this -> db -> keyList("select * from {$this->conf['prefix']}category where id in({$p['fids']}) order by find_in_set(id,'".$p['fids']."')"): array();

		
		include MYDECMS_PATH.$this->template."category/index.php";
		exit();
	}
	
	/**
	 * 搜索文章分类
	**/
	public function search(){
		if(!file_exists(MYDECMS_PATH.$this->template."category/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$searchtype = isset($_GET['searchtype']) ? $this->glstr($_GET['searchtype']) : "1";
		
		$searchkey = isset($_GET['searchkey']) ? $this->glstr($_GET['searchkey'],6) : "";
		if(empty($searchkey)){
			header("Location: ./index.php?c=category&a=index");
		}
		
		$where = "";
		
		switch($searchtype){
			case "1":
				$where = " where `urlname` like '%".$searchkey."%'";
				break;
			default:
				$where = " where `name` like '%".$searchkey."%'";
				break;
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select *,(select count(id) from {$this->conf['prefix']}category as c2 where c2.cid=c1.id) as zidcount,(select `name` from {$this->conf['prefix']}category as c3 where c3.id=c1.cid) as cname from {$this->conf['prefix']}category as c1 {$where} order by `type` asc,`sort` asc,`id` asc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}category","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=category&a=search&page={page}&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype."&cid=".$this->cid,"./index.php?c=category&a=search&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype."&cid=".$this->cid);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=category&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		$plist = array();
		
		include MYDECMS_PATH.$this->template."category/index.php";
		exit();
	}
	
	/**
	 * 添加文章分类
	**/
	public function add(){
		if(!file_exists(MYDECMS_PATH.$this->template."category/add.php")){
			exit("没有找到对应的模板文件");
		}
		$c = $this-> cid == "0" ? array() :$this -> db -> fetch_first("select `name` from {$this->conf['prefix']}category where id={$this -> cid} limit 0,1");
		$v = array("id"=>"","name"=>"","urlname"=>"","cname"=>(isset($c['name']) ? $c['name'] : "根分类"),"cid"=>$this -> cid,"type"=>"1","tpl"=>"","title"=>"","keyword"=>"","desc"=>"","sort"=>"100");

		
		include MYDECMS_PATH.$this->template."category/add.php";
		exit();
	}
	public function addAction(){
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("分类名称不能为空","",false,3);
		}
		$urlname     = $this -> p("urlname","","2");
		if($urlname == ""){
			$this -> msg("urlname不能为空","",false,3);
		}
		
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}
		
		
		$type    = $this -> p("type","1","2");
		$cid  = $this -> p("cid","0","2");
		$sort    = $this -> p("sort","100","2");
		$tpl      = $this -> p("tpl","","2");
		$title   = $this -> p("title","","2");
		$keyword   = $this -> p("keyword","","2");
		$desc   = $this -> p("desc","","2");

		$nid = $this -> db -> insert("insert ignore into `{$this->conf['prefix']}category` (`name`,`urlname`,`cid`,`fids`,`zids`,`tpl`,`title`,`keyword`,`desc`,`type`,`sort`) value ('".$name."','".$urlname."','".$cid."','".(isset($c['fids']) ? $c['fids'] : "0")."','".(isset($c['zids']) ? $c['zids'] : "")."','".$tpl."','".$title."','".$keyword."','".$desc."','".$type."','".$sort."')");
		
		$this -> addlog("添加文章分类【".$this -> readContent($name)."】");
		if($nid>0) $cid .= ','.$nid;
		
		$c = $this -> db -> fetch_first("select GROUP_CONCAT(fids) AS fids from {$this->conf['prefix']}category where `id`='{$cid}'");
		if(isset($c['fids']) && $c['fids'] != ''){
			$cid .= ','.$c['fids'];
		}
		if($cid!="0")$this -> updateIds($cid);
		
		$this -> msg("添加新文章分类成功","./index.php?c=category&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	
	/**
	 * 修改文章分类
	**/
	public function edit(){
		if(!file_exists(MYDECMS_PATH.$this->template."category/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$id = $this -> p("id","","1");
		if($id=="") $this -> errlog("记录参数错误");
		
		
		$v = $this -> db -> fetch_first("select *,(select `name` from {$this->conf['prefix']}category where id=c.cid) as cname from {$this->conf['prefix']}category as c where `id`='{$id}' limit 0,1");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		if($v['cname']=="") $v['cname'] = "根分类";
		
		include MYDECMS_PATH.$this->template."category/add.php";
		exit();
	}
	public function editAction(){
		$id = $this -> p("id","","2");
		if($id=="") $this -> errlog("记录参数错误");
		
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("分类名称不能为空","",false,3);
		}
		$urlname     = $this -> p("urlname","","2");
		if($urlname == ""){
			$this -> msg("urlname不能为空","",false,3);
		}
		
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}
		
		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}category where `id`='{$id}'");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		
		$type    = $this -> p("type","1","2");
		$cid  = $this -> p("cid","0","2");
		$sort    = $this -> p("sort","100","2");
		$tpl      = $this -> p("tpl","","2");
		$title   = $this -> p("title","","2");
		$keyword   = $this -> p("keyword","","2");
		$desc   = $this -> p("desc","","2");
		
		if($id==$cid)$this -> msg("修改失败，不能自己是自己的父分类","",false,3);
		
		$this -> db -> query("update `{$this->conf['prefix']}category` set `name`='".$name."',`urlname`='".$urlname."',`type`='".$type."',`cid`='".$cid."',`sort`='".$this->glstr($sort,1)."',`tpl`='".$tpl."',`title`='".$title."',`keyword`='".$keyword."',`desc`='".$desc."' where `id`='{$id}'");
		
		$ids = array($cid);
		if(!in_array($v['cid'],$ids)) $ids[] = $v['cid'];
		if(!in_array($v['id'],$ids)) $ids[] = $v['id'];
		
		
		if($v['zids']!=''){
			$zids = explode(",",$v['zids']);
			$ids = array_merge($zids,$ids);
		}	
		if($v['fids']!=''){
			$fids = explode(",",$v['fids']);
			$ids = array_merge($fids,$ids);
		}

		
		$ids = array_unique($ids);
		if(count($ids)>0)$this -> updateIds(implode(",",$ids));
		
		$this -> addlog("修改文章分类【{$id}=>".$this -> readContent($name)."】");
		$this -> msg("修改文章分类成功","./index.php?c=category&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	
	/**
	 * 删除文章分类
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$v = $this -> db -> fetch_first("select GROUP_CONCAT(fids) AS fids,GROUP_CONCAT(zids) AS zids from {$this->conf['prefix']}category where `id` in(".implode(",",$id).")");
		$fids = $zids = array();
		if($v['zids']!=''){
			$zids = explode(",",$v['zids']);
			$zids = array_unique($zids);
		}	
		if($v['fids']!=''){
			$fids = explode(",",$v['fids']);
			$fids = array_unique($fids);
		}

		$id = array_merge($zids,$id);
		$id = array_unique($id);

		if(count($id)>0) $this -> db -> query("delete c2,c1,c3 from {$this->conf['prefix']}category as c2 left JOIN {$this->conf['prefix']}article as c1 on c1.cid=c2.id left JOIN {$this->conf['prefix']}cachearticle as c3 on c3.aid=c1.id where c2.id in(".implode(",",$id).")");
		if(count($fids)>0) $this -> updateIds(implode(",",$fids));
		$this -> addlog("批量删除文章分类【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除文章分类成功","./index.php?c=category&a=index&page=".$this->page."&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改文章分类
	**/
	public function pledit(){
		$id      = $this -> p("id","","2");
		$ids     = $this -> p("ids","","2");
		$name    = $this -> p("name","","2");
		$urlname     = $this -> p("urlname","","2");
		$sort    = $this -> p("sort","100","2");
		$tpl      = $this -> p("tpl","","2");

		if($id == "" || $ids =="" || $name == "" || $urlname == "" || $sort == "" || $tpl == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$idarr = array();
		$cgs = $sbs = $cws = 0;
		
		foreach ($ids as $k => $v){
			if(in_array($v, $id)) $idarr[] = $k ;
		}
		
		try{
			foreach($idarr as $v){
				if($name[$v]=="" || $name[$v] == NULL) continue;
				$this -> db -> query("update {$this->conf['prefix']}category set `name`='".$this->glstr($name[$v],"6")."',`urlname`='".$urlname[$v]."',`sort`='".$this->glstr($sort[$v])."',`tpl`='".$tpl[$v]."' where `id`='".$this->glstr($ids[$v])."'");
			}
			$this -> addlog("批量修改文章分类【".(is_array($id) ? implode(",",$id):$id)."】");
			$this -> msg("批量修改数据成功","./index.php?c=category&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true,5);
		}catch (Exception $err) {
			$this -> errlog("批量修改数据出错<br><p>".$err->getMessage()."</p>");
		}
	}


	/**
	 * 批量修改显示属性
	**/
	public function pledittype(){
		$id          = $this -> p("id","","2");
		$newtype     = $this -> p("newtype","1");
		if($id == "" || $newtype == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(count($id)>0) $this -> db -> query("update {$this->conf['prefix']}category set `type`='".$this->glstr($newtype)."' where `id` in(".implode(",",$id).")");

		$this -> addlog("批量文章分类属性【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改显示属性成功","./index.php?c=category&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改所属父分类
	**/
	public function pleditcid(){
		$newcid = $this -> p("newcid","0");
		$id     = $this -> p("id","","2");
		if($id == "" || $newcid == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$v = $this -> db -> fetch_first("select GROUP_CONCAT(fids) AS fids,GROUP_CONCAT(zids) AS zids from {$this->conf['prefix']}category where `id` in(".implode(",",$id).")");
		$ids =  array();
	
		if($v['zids']!=''){
			$zids = explode(",",$v['zids']);
			$ids = array_merge($zids,$ids);
		}	
		if($v['fids']!=''){
			$fids = explode(",",$v['fids']);
			$ids = array_merge($fids,$ids);
		}
		
		$ids[] = $newcid;

		$ids = array_merge($ids,$id);
		$ids = array_unique($ids);
		
		if(count($id)>0) $this -> db -> query("update {$this->conf['prefix']}category set `cid`='".$newcid."' where `id` in(".implode(",",$id).")");
		
		if(count($ids)>0) $this -> updateIds(implode(",",$ids));
		
		$this -> addlog("批量修改文章分类的所属父分类【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改所属父分类","./index.php?c=category&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	/**
	 * 清空文章分类
	**/
	private $clearName = "清空文章分类";
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}category");
		$this -> addlog("清空文章分类");
		$this -> msg("清空表数据成功","./index.php?c=category&a=index",true);
	}
}
?>