<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：后台控制器管理控制器
 * +------------------------------------------------------------------------ 
**/  

class controlControl extends adminControl {
	public $ControlName = "后台控制器管理控制器";
	
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
		),
		//用户权限功能
		"user"  => array(
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
	}
	
	/**
	 * 默认方法
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."control/control.php")){
			exit("没有找到对应的模板文件");
		}
		$list = $this -> db -> keyList("select *,(select count(id) from {$this->conf['prefix']}method as m where m.control=c.control) as methods from {$this->conf['prefix']}control as c order by `sort` asc,id asc");
		include MYDECMS_PATH.$this->template."control/control.php";
		exit();
	}
	
	
	/**
	 * 批量修改数据
	**/
	public function pledit(){
		$id     = $this -> p("id","","2");
		$ids    = $this -> p("ids","","2");
		$name   = $this -> p("name","","2");
		$sort   = $this -> p("sort","","2");

		if($id == "" || $ids =="" || $name == "" || $sort == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$idarr = array();
		$cgs = $sbs = $cws = 0;
		
		foreach ($ids as $k => $v){
			if(in_array($v, $id)) $idarr[] = $k ;
		}
		
		try{
			foreach($idarr as $v){
				if($name[$v]=="" || $name[$v] == NULL) continue;
				$this -> db -> query("update {$this->conf['prefix']}control set `name`='".$this->glstr($name[$v],"6")."',`sort`='".$this->glstr($sort[$v])."' where `id`='".$this->glstr($ids[$v])."'");
			}
			$this -> addlog("批量后台控制器【".(is_array($id) ? implode(",",$id):$id)."】");
			$this -> msg("批量修改数据成功","./index.php?c=control&a=index",true,5);
		}catch (Exception $err) {
			$this -> errlog("批量修改数据出错<br><p>".$err->getMessage()."</p>");
		}
	}
	
	/**
	 * 批量修改通用权限
	**/
	public function pleditshare(){
		$sharetype = $this -> p("sharetype","");
		$id     = $this -> p("id","","2");
		if($id == "" || $sharetype == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}control set `sharetype`='".$this->glstr($sharetype)."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}control set `sharetype`='".$this->glstr($sharetype)."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改通用权限【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改通用权限成功","./index.php?c=control&a=index",true);
	}
	
	/**
	 * 批量修改操作日志
	**/
	public function pleditlogs(){
		$logstype = $this -> p("logstype","");
		$id     = $this -> p("id","","2");
		if($id == "" || $logstype == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}control set `logstype`='".$this->glstr($logstype)."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}control set `logstype`='".$this->glstr($logstype)."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改操作日志状态【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改操作日志状态成功","./index.php?c=control&a=index",true);
	}
	
	/**
	 * 删除选中记录
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("delete m,c from {$this->conf['prefix']}method as m,{$this->conf['prefix']}control as c where m.control=c.control and c.id in(".implode(",",$id).")");
		}else{
			$this -> db -> query("delete m,c from {$this->conf['prefix']}method as m,{$this->conf['prefix']}control as c where m.control=c.control and c.id='".$id."'");
		}
		$this -> addlog("批量删除控制器数据【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除数据成功","./index.php?c=control&a=index",true);
	}
	
	/**
	 * 更新权限文件
	**/
	public function refresh()
	{
		$dir = "./control/";
		if(is_dir($dir))
		{
			if ($dh = opendir($dir)) 
			{
				while (($file = readdir($dh)) !== false)
				{
					if((!is_dir($dir."/".$file)) && $file!="." && $file!="..")
					{
						$c = substr($file,0,strpos($file,"."));
						if(in_array($c,array("control","method"))) continue;
						include_once $dir."/".$file;
						$vars = get_class_vars(str_replace(".control.mydecms.php","",$file)."Control");
						if(!isset($vars['ControlName']) || !isset($vars['quanxian']['user']) || count($vars['quanxian']['user'])<1) continue;
						$this -> db -> query("insert ignore into `{$this->conf['prefix']}control` (`name`,`control`,`logstype`,`sharetype`) value ('".$vars['ControlName']."','".$c."','".$this->config["actionlog"]."','2')");
						
						$inser = "insert ignore into `{$this->conf['prefix']}method` (`control`,`name`,`method`,`logstype`,`sharetype`) value ";
						$sql = "";
						foreach($vars['quanxian']['user'] as $k=>$v){
							$sql .= ",('".$c."','".$v."','".$k."','".$this->config["actionlog"]."','2')";
						}
						if($sql != ""){
							$sql = substr($sql,1);
							$this->db->query($inser.$sql);
						}
					}
				}
				closedir($dh);
			}
		}
		$this -> addlog("更新权限文件数据");
		$this -> msg("更新权限文件数据成功","./index.php?c=control&a=index",true,3);
	}
	
	/**
	 * 清空表数据
	**/
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}control");
		$this -> db -> truncate("{$this->conf['prefix']}method");
		$this -> addlog("清空控制器数据");
		$this -> msg("清空表数据成功","./index.php?c=control&a=index",true);
	}
	
}
?>