<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：附件管理控制器
 * +------------------------------------------------------------------------ 
**/  

class fileadminControl extends adminControl {
	public $ControlName = "附件管理";
	
		//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			
		),
		//用户权限功能
		"user"  => array(
			"index"       => "查看附件",
			"upfile"      => "上传附件",
			"downimg"     => "远程下载文件",
			"pldownimg"   => "批量远程下载附件",
			"addfolder"   => "新建文件夹",
			"rname"       => "重命名文件夹或者文件",
			"move"        => "移动文件夹或者文件",
			"copyfile"    => "复制文件夹或者文件",
			"del"         => "删除附件"
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
		if(!file_exists("../upfile/")){
			$this -> createDir("../upfile/");
		}
	}
	
	/**
	 * 查看附件
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."fileadmin/index.php")){
			exit("没有找到对应的模板文件");
		}
		$folder = $this -> p("folder","","1");
		$dirarr = array();
		$dir = "";
		if($folder!=""){
			while(strpos($folder,"../")){
				$folder = str_replace("../","",$folder);
			}
			
			if(strpos($folder,"/")){
				$dirarr = explode("/",$folder);
				foreach($dirarr as $k => $v){
					if(trim($v)=="") {unset($dirarr[$k]); continue;}
					$dir .= $v."/";
				}
			}else{
				$dir = $folder."/";
				$dirarr[] = $folder;
			}
		}
		
		$list = array();
		
		if(!file_exists("../upfile/{$dir}")){
			$dir = "";
			$dirarr = array();
		}

		$handle=opendir("../upfile/{$dir}"); 
		while (false !== ($file = readdir($handle))){//遍历文件夹下所有文件
			if ($file != "." && $file != "..") {
				if(is_dir("../upfile/{$dir}".$file."/")){
					$list['folder'][] = array("dir"=>"{$dir}","foldername"=>$file);
				}else{
					$zfwz = strrpos($file,".");
					$filename = substr($file,0,$zfwz);
					$kzm = substr($file,$zfwz,strlen($file)-$zfwz);
					if(in_array(strtolower($kzm), array(".jpg",".png",".gif",".bmp",".jpeg"))){
						$list['img'][] = array("dir"=>"{$dir}","filename"=>$filename,"hz"=>$kzm,"date"=>date("Y-m-d H:i:s",filemtime("../upfile/{$dir}".$file))); //输出文件名
					}else{
						$list['file'][] = array("dir"=>"{$dir}","filename"=>$filename,"hz"=>$kzm,"date"=>date("Y-m-d H:i:s",filemtime("../upfile/{$dir}".$file))); //输出文件名
					}
				}
			}
			
		}
		closedir($handle);
		
		$zfolderArr = $this -> readDir("");
		
		include MYDECMS_PATH.$this->template."fileadmin/index.php";
		exit();
	}
	
	/**
	 * 上传附件
	**/
	public function upfile(){
		if(!isset($_FILES['uploadimg'])) exit("参数错误");

		$folder = $this -> p("folder","","2");
		
		include_once MYDECMSPHP_PATH.'upfile.mydecms.php'; 
		
		$upfile = new UpFileClass($_FILES["uploadimg"],"../upfile/{$folder}/",array(".gif",".jpeg",".jpg",".png",".bmp",".ico",".rar",".zip",".rmvb",".mp3",".wav",".txt",".doc",".xls",".ppt",".mdb",".xml"),"../upfile/{$folder}/");
		
		$upfile -> Up();
		
		if($upfile->msg == "上传成功！"){
			if($this -> config['watertype']=="1"){
				$sy = new mydecmsWater($this -> config['water']);
				$sy -> imgWater($upfile->NewFileUrl);
			}
			$this -> addlog("上传附件【".$upfile->NewFileUrl."】");
			exit("上传成功！");
		}else{
			exit($upfile->msg);
		}
	}
	
	/**
	 * 远程下载文件
	**/
	public function downimg(){
		$folder = $this -> p("folder","","2");
		include_once MYDECMSPHP_PATH.'downimg.mydecms.php';
		$imgurl = isset($_POST["imgurl"]) ? $this -> readContent($_POST["imgurl"]) : "";
		if($imgurl=="") exit("图片地址不能为空");
		$dimg = new downImg($imgurl,"../upfile/{$folder}/");
		if($this -> config['watertype']=="1"){
			$sy = new mydecmsWater($this -> config['water']);
			$sy -> imgWater($dimg->saveImgUrl);
		}
		$this -> addlog("远程下载附件【".$dimg->saveImgUrl."】");
		exit("远程下载成功");
	}
	
	/**
	 * 批量远程下载附件
	**/
	public function pldownimg(){
		if(!file_exists(MYDECMS_PATH.$this->template."downimg/index.php")){
			exit("没有找到对应的模板文件");
		}	
		$folder = $this -> p("folder","","1");	
		include MYDECMS_PATH.$this->template."downimg/index.php";
	}
	public function pldownimgAction(){
		$folder = $this -> p("folder","","1");
		include_once MYDECMSPHP_PATH.'downimg.mydecms.php';
		$imgurl = isset($_POST["imgurl"]) ? $this -> readContent($_POST["imgurl"]) : "";
		if($imgurl=="") exit("图片地址不能为空");
		$dimg = new downImg($imgurl,"../upfile/{$folder}/");
		if($this -> config['watertype']=="1"){
			$sy = new mydecmsWater($this -> config['water']);
			$sy -> imgWater($dimg->saveImgUrl);
		}
		exit($dimg -> reText);
	}
	
	/**
	 * 遍历文件夹函数
	**/
	public function readDir($dir){
		$arr = array();
		try{
			if(is_dir("../upfile/{$dir}")){
				$handle=opendir("../upfile/{$dir}"); 
				while (false !== ($file = readdir($handle))){//遍历文件夹下所有文件
					if ($file != "." && $file != "..") {
						if(is_dir("../upfile/{$dir}".$file."/")){
							$arr["{$dir}{$file}"] = "{$dir}{$file}";
							$newArr = $this -> readDir("{$dir}".$file."/");
							$arr = array_merge($arr,$newArr);
						}
					}
				}
				closedir($handle);
			}
		}catch(Exception $err){
			$this -> errlog("创建目录【".$dir."】失败，请检查是否有写入权限");
		}
		return $arr;
	}
	
	/**
	 * 新建文件夹
	**/
	public function addfolder(){
		$folder = $this -> p("folder","","2");
		$addfoldername = $this -> p("addfoldername","","2");
		if(file_exists("../upfile/{$folder}/{$addfoldername}")){
			exit("【{$addfoldername}】文件夹已经存在，请改用其他名称");
		}else{
			$this -> createDir("../upfile/{$folder}/{$addfoldername}");
		}
		$this -> addlog("新建文件夹【".$addfoldername."】");
		exit("创建文件夹成功");
	}
	
	/**
	 * 重命名文件夹或者文件
	**/
	public function rname(){
		$folder = $this -> p("folder","","2");
		if($folder!="") $folder .="/";
		$folderid = $this -> p("folderid","","2");
		$fileid = $this -> p("fileid","","2");
		$imgid = $this -> p("imgid","","2");
		//重命名文件
		if(is_array($fileid) && count($fileid)>0){
			foreach($fileid as $v){
				if(file_exists("../upfile/{$folder}{$v[0]}{$v[2]}") && !file_exists("../upfile/{$folder}{$v[1]}{$v[2]}")){
					@rename("../upfile/{$folder}{$v[0]}{$v[2]}","../upfile/{$folder}{$v[1]}{$v[2]}");
				}
			}
		}
		
		//重命名图片文件
		if(is_array($imgid) && count($imgid)>0){
			foreach($imgid as $v){
				if(file_exists("../upfile/{$folder}{$v[0]}{$v[2]}") && !file_exists("../upfile/{$folder}{$v[1]}{$v[2]}")){
					@rename("../upfile/{$folder}{$v[0]}{$v[2]}","../upfile/{$folder}{$v[1]}{$v[2]}");
				}
			}
		}
		
		//重命名文件夹
		if(is_array($folderid) && count($folderid)>0){
			foreach($folderid as $v){
				if(file_exists("../upfile/{$folder}{$v[0]}") && !file_exists("../upfile/{$folder}{$v[1]}")){
					@rename("../upfile/{$folder}{$v[0]}","../upfile/{$folder}{$v[1]}");
				}
			}
		}
		$this -> addlog("批量重命名文件夹或者文件");
		exit('重命名成功');
	}
	
	/**
	 * 移动文件夹或者文件
	**/
	public function move(){
		$folder = $this -> p("folder","","2");
		if($folder!="") $folder .="/";
		$movedir = $this -> p("movedir","/","2");
		$folderid = $this -> p("folderid","","2");
		$fileid = $this -> p("fileid","","2");
		$imgid = $this -> p("imgid","","2");
		
		//移动文件
		if(is_array($fileid) && count($fileid)>0){
			foreach($fileid as $v){
				if(file_exists("../upfile/{$folder}{$v}") && file_exists("../upfile/{$movedir}") && !file_exists("../upfile/{$movedir}{$v}")){
					if(copy("../upfile/{$folder}{$v}","../upfile/{$movedir}{$v}")){
						unlink("../upfile/{$folder}{$v}");
					}
				}
			}
		}
		
		//移动图片文件
		if(is_array($imgid) && count($imgid)>0){
			foreach($imgid as $v){
				if(file_exists("../upfile/{$folder}{$v}") && file_exists("../upfile/{$movedir}") && !file_exists("../upfile/{$movedir}{$v}")){
					if(copy("../upfile/{$folder}{$v}","../upfile/{$movedir}{$v}")){
						unlink("../upfile/{$folder}{$v}");
					}
				}
			}
		}
		
		//移动文件夹
		if(is_array($folderid) && count($folderid)>0){
			foreach($folderid as $v){
				if(strpos("../upfile/{$movedir}{$v}","../upfile/{$folder}{$v}")!==false) continue;
				$this -> createDir("../upfile/{$movedir}{$v}");
				if(file_exists("../upfile/{$folder}{$v}") && file_exists("../upfile/{$movedir}{$v}")){
					$this -> copyAllFolder("{$folder}{$v}","/{$movedir}{$v}",true);
				}
			}
		}
		$this -> addlog("批量移动文件夹或者文件");
		exit("移动成功");
	}
	
	
	/**
	 * 遍历复制文件夹及其下文件
	 * $oldfolder => 要复制的源文件夹目录
	 * $newfolder => 要复制到的目标文件夹目录
	 * $type      => 复制完成后是否删除旧文件夹目录(true为删除，false为不删除)
	**/
	public function copyAllFolder($oldfolder,$newfolder,$type=false){
		if(!file_exists("../upfile/{$oldfolder}")) return false;
		if(is_dir("../upfile/{$oldfolder}")){
			$handle=opendir("../upfile/{$oldfolder}"); 
			while (false !== ($file = readdir($handle))){//遍历文件夹下所有文件
				if ($file != "." && $file != "..") {
					if(is_dir("../upfile/{$oldfolder}/".$file."/")){
						if(!file_exists("../upfile/{$oldfolder}/".$file."/")) $this -> createDir("../upfile//{$newfolder}/".$file."/");
						return $this -> copyAllFolder("{$oldfolder}/{$file}","{$newfolder}/{$file}",$type);
					}else{
						echo "../upfile/{$oldfolder}/{$file}\r\n../upfile/{$newfolder}/{$oldfolder}/{$file}";
						if(@copy("../upfile/{$oldfolder}/{$file}","../upfile/{$newfolder}/{$file}") && $type){
							@unlink("../upfile/{$oldfolder}/{$file}");
						}
					}
				}
			}
			closedir($handle);
			if($type) @rmdir("../upfile/{$oldfolder}");
		}else{
			if(@copy("../upfile/{$oldfolder}","../upfile/{$newfolder}/{$oldfolder}") && $type){
				@unlink("../upfile/{$oldfolder}");
			}
		}
		return true;
	}
	
	/**
	 * 复制文件夹或者文件
	**/
	public function copyfile(){
		$folder = $this -> p("folder","","2");
		if($folder!="") $folder .="/";
		$copyfiledir = $this -> p("copyfiledir","/","2");
		$folderid = $this -> p("folderid","","2");
		$fileid = $this -> p("fileid","","2");
		$imgid = $this -> p("imgid","","2");
		
		//移动文件
		if(is_array($fileid) && count($fileid)>0){
			foreach($fileid as $v){
				if(file_exists("../upfile/{$folder}{$v}") && file_exists("../upfile/{$copyfiledir}") && !file_exists("../upfile/{$copyfiledir}{$v}")){
					@copy("../upfile/{$folder}{$v}","../upfile/{$copyfiledir}{$v}");
				}
			}
		}
		
		//移动图片文件
		if(is_array($imgid) && count($imgid)>0){
			foreach($imgid as $v){
				if(file_exists("../upfile/{$folder}{$v}") && file_exists("../upfile/{$copyfiledir}") && !file_exists("../upfile/{$copyfiledir}{$v}")){
					@copy("../upfile/{$folder}{$v}","../upfile/{$copyfiledir}{$v}");
				}
			}
		}
		
		//移动文件夹
		if(is_array($folderid) && count($folderid)>0){
			foreach($folderid as $v){
				if(strpos("../upfile/{$copyfiledir}{$v}","../upfile/{$folder}{$v}")!==false) continue;
				$this -> createDir("../upfile/{$copyfiledir}{$v}");
				if(file_exists("../upfile/{$folder}{$v}") && file_exists("../upfile/{$copyfiledir}{$v}")){
					$this -> copyAllFolder("{$folder}{$v}","/{$copyfiledir}{$v}",false);
				}
			}
		}
		$this -> addlog("批量复制文件夹或者文件");
		exit("复制成功");
	}
	
	/**
	 * 删除附件
	**/
	public function del(){
		$folder = $this -> p("folder","","2");
		if($folder!="") $folder .="/";
		$folderid = $this -> p("folderid","","2");
		$fileid = $this -> p("fileid","","2");
		$imgid = $this -> p("imgid","","2");
		if(is_array($folderid) && count($folderid)>0){
			foreach($folderid as $v){
				if(file_exists("../upfile/{$folder}{$v}")) $this -> delDir("../upfile/{$folder}{$v}");
			}
		}
		
		if(is_array($fileid) && count($fileid)>0){
			foreach($fileid as $v){
				if(file_exists("../upfile/{$folder}{$v}")) $this -> delDir("../upfile/{$folder}{$v}");
			}
		}
		
		if(is_array($imgid) && count($imgid)>0){
			foreach($imgid as $v){
				if(file_exists("../upfile/{$folder}{$v}")) $this -> delDir("../upfile/{$folder}{$v}");
			}
		}
		$this -> addlog("批量删除文件夹或者文件");
		exit('删除成功');
	}
	
}
?>