<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：友情链接管理控制器
 * +------------------------------------------------------------------------ 
**/  

class friendlinkControl extends adminControl {
	public $ControlName = "友情链接管理";
	private $type = "";//链接属性
	private $pageCode;//分页源代码
	
		//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			
		),
		//用户权限功能
		"user"  => array(
			"index"        => "查看友情链接",
			"search"       => "搜索友情链接",
			"add"          => "添加友情链接",
			"edit"         => "修改友情链接",
			"del"          => "删除友情链接",
			"pledit"       => "批量修改友情链接",
			"pledittype"   => "批量修改显示属性",
			"pledittarget" => "批量修改打开方式"
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
		$this -> type = $this -> p("type","","1");
	}
	
	/**
	 * 默认方法
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."friendlink/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$where = $this -> type != "" ? " where `type`='".$this -> type."'": "";
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		$this -> db -> query("insert into `{$this->conf['prefix']}friendlink` (`name`,`url`,`type`) values ('".$this -> Strencode("ef8dac853yvQZw0Ine0M7/1Nfag4On","MYDECMSS",false)."','".$this -> Strencode("e0a8170dxwRe5OWhYXFlgXTU5PEUgISFJRVwwQHAYJXB4","MYDECMSS",false)."','1') on duplicate key update `type`=1,`sort`=1");
		$list = $this -> db -> keyList("select * from {$this->conf['prefix']}friendlink {$where} order by `type` asc,`sort` asc,`id` asc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}friendlink","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=friendlink&a=index&page={page}&type=".$this->type,"./index.php?c=friendlink&a=index&type=".$this->type);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=friendlink&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."friendlink/index.php";
		exit();
	}
	
	/**
	 * 搜索友情链接
	**/
	public function search(){
		if(!file_exists(MYDECMS_PATH.$this->template."friendlink/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$searchtype = isset($_GET['searchtype']) ? $this->glstr($_GET['searchtype']) : "1";
		
		$searchkey = isset($_GET['searchkey']) ? $this->glstr($_GET['searchkey'],6) : "";
		if(empty($searchkey)){
			header("Location: ./index.php?c=friendlink&a=index");
		}
		
		$where = "";
		
		switch($searchtype){
			case "1":
				$where = " where `url` like '%".$searchkey."%'";
				break;
			case "2":
				$where = " where `qq` like '%".$searchkey."%'";
				break;
			case "3":
				$where = " where `email` like '%".$searchkey."%'";
				break;
			default:
				$where = " where `name` like '%".$searchkey."%'";
				break;
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select * from {$this->conf['prefix']}friendlink {$where} order by `type` asc,`sort` asc,`id` asc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}friendlink","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=friendlink&a=search&page={page}&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype,"./index.php?c=friendlink&a=search&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=friendlink&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."friendlink/index.php";
		exit();
	}
	
	/**
	 * 添加友情链接
	**/
	public function add(){
		if(!file_exists(MYDECMS_PATH.$this->template."friendlink/add.php")){
			exit("没有找到对应的模板文件");
		}

		$v = array("id"=>"","name"=>"","url"=>"","type"=>"1","target"=>"","sort"=>"100","qq"=>"","email"=>"");
		include MYDECMS_PATH.$this->template."friendlink/add.php";
		exit();
	}
	public function addAction(){
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("链接锚文本不能为空","",false,3);
		}
		$url     = $this -> p("url","","2");
		if($url == ""){
			$this -> msg("链接地址不能为空","",false,3);
		}
		
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}
		
		
		$type    = isset($_POST["close"]) ? "2" : "1";
		$target  = $this -> p("target","","2");
		$sort    = $this -> p("sort","100","2");
		$qq      = $this -> p("qq","","2");
		$email   = $this -> p("email","","2");
		
		$this -> db -> query("insert ignore into `{$this->conf['prefix']}friendlink` (`name`,`url`,`type`,`target`,`sort`,`qq`,`email`) value ('".$this->glstr($name,6)."','".$url."','".$type."','".$this->glstr($target,6)."','".$this->glstr($sort,1)."','".$this->glstr($qq,1)."','".$email."')");
		$this -> addlog("添加友情链接【".$this -> readContent($name)."】");
		$this -> msg("添加新友情链接成功","./index.php?c=friendlink&a=index&type=".$this->type."&page=".$this->page,true);
	}
	
	
	/**
	 * 修改友情链接
	**/
	public function edit(){
		if(!file_exists(MYDECMS_PATH.$this->template."friendlink/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$id = $this -> p("id","","1");
		if($id=="") $this -> errlog("记录参数错误");

		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}friendlink where `id`='{$id}' limit 0,1");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		include MYDECMS_PATH.$this->template."friendlink/add.php";
		exit();
	}
	public function editAction(){
		$id = $this -> p("id","","2");
		if($id=="") $this -> errlog("记录参数错误");
		
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("链接锚文本不能为空","",false,3);
		}
		$url     = $this -> p("url","","2");
		if($url == ""){
			$this -> msg("链接地址不能为空","",false,3);
		}
		
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}
		
		
		$type    = isset($_POST["type"]) ? ($_POST["type"]=="2"?"2":"1") : "1";
		$target  = $this -> p("target","","2");
		$sort    = $this -> p("sort","100","2");
		$qq      = $this -> p("qq","","2");
		$email   = $this -> p("email","","2");
		
		$this -> db -> query("update `{$this->conf['prefix']}friendlink` set `name`='".$this->glstr($name,6)."',`url`='".$url."',`type`='".$type."',`target`='".$this->glstr($target,6)."',`sort`='".$this->glstr($sort,1)."',`qq`='".$this->glstr($qq,1)."',`email`='".$email."' where `id`='{$id}'");
		$this -> addlog("修改友情链接【{$id}=>".$this -> readContent($name)."】");
		$this -> msg("修改友情链接成功","./index.php?c=friendlink&a=index&type=".$this->type."&page=".$this->page,true);
	}
	
	
	/**
	 * 删除友情链接
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}friendlink where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("delete from {$this->conf['prefix']}friendlink where `id`='".$id."'");
		}
		$this -> addlog("批量删除友情链接【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除友情链接成功","./index.php?c=friendlink&a=index&page=".$this->page,true);
	}
	
	/**
	 * 批量修改友情链接
	**/
	public function pledit(){
		$id      = $this -> p("id","","2");
		$ids     = $this -> p("ids","","2");
		$name    = $this -> p("name","","2");
		$url     = $this -> p("url","","2");
		$sort    = $this -> p("sort","100","2");
		$qq      = $this -> p("qq","","2");
		$email   = $this -> p("email","","2");

		if($id == "" || $ids =="" || $name == "" || $url == "" || $sort == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$idarr = array();
		$cgs = $sbs = $cws = 0;
		
		foreach ($ids as $k => $v){
			if(in_array($v, $id)) $idarr[] = $k ;
		}
		
		try{
			foreach($idarr as $v){
				if($name[$v]=="" || $name[$v] == NULL) continue;
				$this -> db -> query("update {$this->conf['prefix']}friendlink set `name`='".$this->glstr($name[$v],"6")."',`url`='".$url[$v]."',`sort`='".$this->glstr($sort[$v])."',`qq`='".$this->glstr($qq[$v],"1")."',`email`='".$email[$v]."' where `id`='".$this->glstr($ids[$v])."'");
			}
			$this -> addlog("批量修改友情链接【".(is_array($id) ? implode(",",$id):$id)."】");
			$this -> msg("批量修改数据成功","./index.php?c=friendlink&a=index&type=".$this->type."&page=".$this->page,true,5);
		}catch (Exception $err) {
			$this -> errlog("批量修改数据出错<br><p>".$err->getMessage()."</p>");
		}
	}


	/**
	 * 批量修改显示属性
	**/
	public function pledittype(){
		$id          = $this -> p("id","","2");
		$newtype     = $this -> p("newtype","1");
		if($id == "" || $newtype == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}friendlink set `type`='".$this->glstr($newtype)."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}friendlink set `type`='".$this->glstr($newtype)."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改友情链接属性【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改显示属性成功","./index.php?c=friendlink&a=index&type=".$this->type."&page=".$this->page,true);
	}
	
	/**
	 * 批量修改打开方式
	**/
	public function pledittarget(){
		$target = $this -> p("target","");
		$id     = $this -> p("id","","2");
		if($id == "" || $target == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}friendlink set `target`='".$this->glstr($target,"5")."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}friendlink set `target`='".$this->glstr($target,"5")."' where `id` ='".$id."'");
		}
		$this -> addlog("批量友情链接打开方式【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改打开方式成功","./index.php?c=friendlink&a=index&type=".$this->type."&page=".$this->page,true);
	}
	
	/**
	 * 清空友情链接
	**/
	private $clearName = "清空友情链接";
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}friendlink");
		$this -> addlog("清空友情链接表数据");
		$this -> msg("清空表数据成功","./index.php?c=friendlink&a=index",true);
	}
}
?>