<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：后台登录控制器
 * +------------------------------------------------------------------------ 
**/  

class loginControl extends adminControl {
	public $ControlName = "登录后台";
	
		//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			"login" => "用户登录",
			"loginout"=> "用户退出后台登录状态",
			"yzm"=>"验证码"
		),
		//用户权限功能
		"user"  => array(
			
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
	}
	
	/**
	 * 默认方法
	**/
	public function index(){
		$this -> login();
	}
	
	/**
	 * 登录页面
	**/
	public function login()
	{
		if(!file_exists(MYDECMS_PATH.$this->template."system/login.php")){
			exit("没有找到对应的模板文件");
		}
		
		$username = $password = $cookielogin = "";
		
		if(isset($_COOKIE["mydeCmsUser"]) && strlen($_COOKIE["mydeCmsUser"])>0){
			$mydeCmsUser = $this -> Strencode($this -> readContent($_COOKIE["mydeCmsUser"]),$this->conf["secretKey"],false);
			preg_match("/\[username=(?<username>[^\]]{1,26})\]\[password=(?<password>[^\]]+)\]/u",$mydeCmsUser,$thisUser);
			if(isset($thisUser["username"]) && isset($thisUser["password"])){
				$username = $thisUser["username"];
				$password = $thisUser["password"];
				$cookielogin = "1";
			}
		}
		
		include MYDECMS_PATH.$this->template."system/login.php";
		exit();
	}
	
	/**
	 * 提交登录
	**/
	public function loginAction()
	{
	
		if(isset($this -> config["adminyzm"]) && $this -> config["adminyzm"]=="1"){
			$yzm = isset($_POST["yzm"]) && strlen(trim($_POST["yzm"])) > 0 ? $_POST["yzm"] : "";
			if($yzm==""){
				$_SESSION["MyDeCmsYzm"] = "";
				$this -> msg("验证码不能为空","./index.php?c=login",false,10);
			}
			if($_SESSION["MyDeCmsYzm"] == "" || $yzm != $this -> Strencode($_SESSION["MyDeCmsYzm"],$this->conf["secretKey"],false)){
				$_SESSION["MyDeCmsYzm"] = "";
				$this -> msg("验证码错误","./index.php?c=login",false,10);
			}
			$_SESSION["MyDeCmsYzm"] = "";
		}
		
		if(!isset($_POST["username"]) || !isset($_POST["password"])){
			$this -> msg("登录帐号和登录密码不能为空","",false,3);
		}
		
		$username = $this -> glstr($_POST['username'],6);
		$password =$_POST['password'];
		
		$row = $this-> db -> fetch_first("select * from {$this->conf['prefix']}user where `username`='".$username."' and `password`='". md5($password)."' limit 0,1");
	
		if(!$row){
			$this -> msg("登录帐号或者登录密码错误","",false,3);
		}else{
			if($row["type"]=="2"){
				setcookie("mydeCmsUser", "", time() - 3600);
				setcookie("mydeCmsAdmin", "", time() - 3600);
				$this -> errlog("您的账号【".$row["username"]."】已被管理员设置为禁止登录");
			}
			$logindate = strtotime(date("Y-m-d H:i:s"));
			$ip = $this -> getIp();
			setcookie("mydeCmsAdmin",$this -> Strencode("[userid=".$row["id"]."][username=".$row["username"]."][ip={$ip}][time={$logindate}][actiontime={$logindate}]",$this->conf["secretKey"]),time()+3600*24);
			$this-> db -> query("update {$this->conf['prefix']}user set `count`=`count`+1,`endip`='{$ip}',`actiontime`='{$logindate}',`enddate`='{$logindate}' where `id`=".$row["id"]);
			if(isset($_POST["cookielogin"])){
				setcookie("mydeCmsUser",$this -> Strencode("[username=".$row["username"]."][password=".$password."]",$this->conf["secretKey"]),time()+ 10 * 365 * 24 * 60 * 60);
				if($this -> config['loginlog'] == "1")$this -> db -> query("insert ignore into `{$this->conf['prefix']}user_login_logs` (`userid`,`date`,`ip`) value ('".$row['id']."','".strtotime(date("Y-m-d H:i:s"))."','".$this->getIp()."')");
			}else{
				setcookie("mydeCmsUser", "", time() - 3600);
			}
			header("Location: index.php");
		}
		exit();
	}
	
	
	/**
	 * 生成验证码
	 * @param $num => 位数
	 * @param $size => 高度
	 * @param $width  => 验证码图片宽度
	 * @param $height  => 验证码图片高度
	**/
	public function yzm($num = 4, $size = 18, $width = 0, $height = 0) {
		!$width && $width = $num * $size * 4 / 5 + 5;
		!$height && $height = $size + 10; 
		// 去掉了 0 1 O l 等
		$str = "23456789abcdefghijkmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVW";
		$code = '';
		for ($i = 0; $i < $num; $i++) {
			$code .= $str[mt_rand(0, strlen($str)-1)];
		}
		
		$_SESSION["MyDeCmsYzm"] = $this -> Strencode(strtolower($code),$this->conf["secretKey"]);
		
		// 画图像
		$im = imagecreatetruecolor($width, $height); 
		// 定义要用到的颜色
		$back_color = imagecolorallocate($im, 235, 236, 237);
		$boer_color = imagecolorallocate($im, 118, 151, 199);
		$text_color = imagecolorallocate($im, mt_rand(0, 200), mt_rand(0, 120), mt_rand(0, 120)); 
		// 画背景
		imagefilledrectangle($im, 0, 0, $width, $height, $back_color); 
		// 画边框
		imagerectangle($im, 0, 0, $width-1, $height-1, $boer_color); 
		// 画干扰线
		for($i = 0;$i < 5;$i++) {
			$font_color = imagecolorallocate($im, mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255));
			imagearc($im, mt_rand(- $width, $width), mt_rand(- $height, $height), mt_rand(30, $width * 2), mt_rand(20, $height * 2), mt_rand(0, 360), mt_rand(0, 360), $font_color);
		} 
		// 画干扰点
		for($i = 0;$i < 50;$i++) {
			$font_color = imagecolorallocate($im, mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255));
			imagesetpixel($im, mt_rand(0, $width), mt_rand(0, $height), $font_color);
		} 
		// 画验证码
		@imagefttext($im, $size , 0, 5, $size + 3, $text_color, 'c:\\WINDOWS\\Fonts\\simsun.ttc', $code);
		header("Cache-Control: max-age=1, s-maxage=1, no-cache, must-revalidate");
		header("Content-type: image/png;charset=gb2312");
		imagepng($im);
		imagedestroy($im);
	}
	
	/**
	 * 检查验证码是否正确
	**/
	public function yzmAction()
	{
		$yzm = isset($_GET["yzm"]) && strlen($_GET["yzm"]) > 0 ? $_GET["yzm"] : "";
		if($yzm==""){
			$_SESSION["MyDeCmsYzm"] = "";
			exit("X");
		}
		
		if(!isset($_SESSION["MyDeCmsYzm"])){
			$_SESSION["MyDeCmsYzm"] = "";
			exit("X");
		}
		
		if($_SESSION["MyDeCmsYzm"] != "" && $yzm == $this -> Strencode($_SESSION["MyDeCmsYzm"],$this->conf["secretKey"],false)){
			exit("√");
		}else{
			$_SESSION["MyDeCmsYzm"] = "";
			exit("X");
		}
	}
}
?>