<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：前台导航菜单管理控制器
 * +------------------------------------------------------------------------ 
**/  

class menuControl extends adminControl {
	public $ControlName = "前台导航菜单管理";
	private $type = "";//链接属性
	private $pageCode;//分页源代码
	private $cid;//父菜单ID
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			
		),
		//用户权限功能
		"user"  => array(
			"index"        => "查看前台导航菜单",
			"search"       => "搜索前台导航菜单",
			"add"          => "添加前台导航菜单",
			"edit"         => "修改前台导航菜单",
			"del"          => "删除前台导航菜单",
			"pledit"       => "批量修改前台导航菜单",
			"pledittype"   => "批量修改显示属性",
			"pledittarget" => "批量修改打开方式"
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
		$this -> type = $this -> p("type","","1");
		$this -> cid = $this -> p("cid","0","1");
	}
	
	/**
	 * 查看前台导航菜单
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."menu/".($this->cid!="0"?"zimenu":"index").".php")){
			exit("没有找到对应的模板文件");
		}
		
		$where = $this -> cid != "0" ? " where `cid`='".$this -> cid."'" : "";
		if($where!=""){
			$where .= $this -> type != "" ? " and `type`='".$this -> type."'": "";
		}else{
			$where .= $this -> type != "" ? " where `type`='".$this -> type."'": "";
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$clist = $this -> db -> keyList("select `id`,`name` from {$this->conf['prefix']}menu where `cid`=0 order by `type` asc,`sort` asc,`id` asc");
		
		$list = $this -> db -> keyList("select *,(select count(id) from {$this->conf['prefix']}menu as m2 where m2.cid=m1.id) as cids from {$this->conf['prefix']}menu as m1 {$where} order by `type` asc,`cid` asc,`sort` asc,`id` asc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}menu","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=menu&a=index&page={page}&type=".$this->type."&cid=".$this->cid,"./index.php?c=menu&a=index&type=".$this->type."&cid=".$this->cid);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=menu&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."menu/".($this->cid!="0"?"zimenu":"index").".php";
		exit();
	}
	
	/**
	 * 搜索前台导航菜单
	**/
	public function search(){
		if(!file_exists(MYDECMS_PATH.$this->template."menu/".($this->cid!="0"?"zimenu":"index").".php")){
			exit("没有找到对应的模板文件");
		}
		
		$searchtype = isset($_GET['searchtype']) ? $this->glstr($_GET['searchtype']) : "1";
		
		$searchkey = isset($_GET['searchkey']) ? $this->glstr($_GET['searchkey'],6) : "";
		if(empty($searchkey)){
			header("Location: ./index.php?c=menu&a=index");
		}
		
		$where = "";
		
		switch($searchtype){
			case "1":
				$where = " where `url` like '%".$searchkey."%'";
				break;
			default:
				$where = " where `name` like '%".$searchkey."%'";
				break;
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select * from {$this->conf['prefix']}menu {$where} order by `type` asc,`sort` asc,`id` asc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}menu","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=menu&a=search&page={page}&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype."&cid=".$this->cid,"./index.php?c=menu&a=search&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype."&cid=".$this->cid);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=menu&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."menu/".($this->cid!="0"?"zimenu":"index").".php";
		exit();
	}
	
	/**
	 * 添加前台导航菜单
	**/
	public function add(){
		if(!file_exists(MYDECMS_PATH.$this->template."menu/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$clist = $this -> db -> keyList("select `id`,`name` from {$this->conf['prefix']}menu where `cid`=0 order by `type` asc,`sort` asc,`id` asc");

		$v = array("id"=>"","cid"=>"","name"=>"","url"=>"","type"=>"1","target"=>"","sort"=>"100");
		include MYDECMS_PATH.$this->template."menu/add.php";
		exit();
	}
	public function addAction(){
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("菜单文本不能为空","",false,3);
		}
		$url     = $this -> p("url","","2");
		if($url == ""){
			$this -> msg("菜单链接地址不能为空","",false,3);
		}
		
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}
		
		
		$type    = $this -> p("type","1","2");
		$target  = $this -> p("target","","2");
		$cid     = $this -> p("cid","0","2");

		$this -> db -> query("insert ignore into `{$this->conf['prefix']}menu` (`cid`,`name`,`url`,`type`,`target`,`sort`) value ('".$this->glstr($cid,1)."','".$this->glstr($name,6)."','".$url."','".$type."','".$this->glstr($target,6)."','".$this->glstr($sort,1)."')");
		$this -> addlog("添加前台导航菜单【".$this -> readContent($name)."】");
     	$this -> msg("添加新前台导航菜单成功","./index.php?c=menu&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	
	/**
	 * 修改前台导航菜单
	**/
	public function edit(){
		if(!file_exists(MYDECMS_PATH.$this->template."menu/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$id = $this -> p("id","","1");
		if($id=="") $this -> errlog("记录参数错误");
		
		$clist = $this -> db -> keyList("select `id`,`name` from {$this->conf['prefix']}menu where `cid`=0 order by `type` asc,`sort` asc,`id` asc");

		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}menu where `id`='{$id}' limit 0,1");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		include MYDECMS_PATH.$this->template."menu/add.php";
		exit();
	}
	public function editAction(){
		$id = $this -> p("id","","2");
		if($id=="") $this -> errlog("记录参数错误");
		
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("菜单文本不能为空","",false,3);
		}
		$url     = $this -> p("url","","2");
		if($url == ""){
			$this -> msg("菜单链接地址不能为空","",false,3);
		}
		
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}
		
		
		$type    = isset($_POST["type"]) ? ($_POST["type"]=="2"?"2":"1") : "1";
		$target  = $this -> p("target","","2");
		$cid      = $this -> p("cid","0","2");
		
		$this -> db -> query("update `{$this->conf['prefix']}menu` set `cid`='".$this->glstr($cid,6)."',`name`='".$this->glstr($name,6)."',`url`='".$url."',`type`='".$type."',`target`='".$this->glstr($target,6)."',`sort`='".$this->glstr($sort,1)."' where `id`='{$id}'");
		$this -> addlog("修改前台导航菜单【{$id}=>".$this -> readContent($name)."】");
		$this -> msg("修改前台导航菜单成功","./index.php?c=menu&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	
	/**
	 * 删除前台导航菜单
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}menu where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("delete from {$this->conf['prefix']}menu where `id`='".$id."'");
		}
		$this -> addlog("批量删除前台导航菜单【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除前台导航菜单成功","./index.php?c=menu&a=index&page=".$this->page."&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改前台导航菜单
	**/
	public function pledit(){
		$id      = $this -> p("id","","2");
		$ids     = $this -> p("ids","","2");
		$name    = $this -> p("name","","2");
		$url     = $this -> p("url","","2");
		$cid     = $this -> p("cid","0","2");
		$sort    = $this -> p("sort","100","2");
		
		if($id==$cid) $cid = 0;

		if($id == "" || $ids =="" || $name == "" || $url == "" || $sort == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$idarr = array();
		$cgs = $sbs = $cws = 0;
		
		foreach ($ids as $k => $v){
			if(in_array($v, $id)) $idarr[] = $k ;
		}
		
		try{
			foreach($idarr as $v){
				if($name[$v]=="" || $name[$v] == NULL) continue;
				$this -> db -> query("update {$this->conf['prefix']}menu set `name`='".$this->glstr($name[$v],"6")."',`url`='".$url[$v]."',`sort`='".$this->glstr($sort[$v])."'".($this->glstr($cid[$v])!=$ids[$v]?",`cid`='".$this->glstr($cid[$v])."'":"")." where `id`='".$this->glstr($ids[$v])."'");
			}
			$this -> addlog("批量修改前台导航菜单【".(is_array($id) ? implode(",",$id):$id)."】");
			$this -> msg("批量修改数据成功","./index.php?c=menu&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true,5);
		}catch (Exception $err) {
			$this -> errlog("批量修改数据出错<br><p>".$err->getMessage()."</p>");
		}
	}


	/**
	 * 批量修改显示属性
	**/
	public function pledittype(){
		$id          = $this -> p("id","","2");
		$newtype     = $this -> p("newtype","1");
		if($id == "" || $newtype == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}menu set `type`='".$this->glstr($newtype)."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}menu set `type`='".$this->glstr($newtype)."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改前台导航菜单属性【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改显示属性成功","./index.php?c=menu&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改打开方式
	**/
	public function pledittarget(){
		$target = $this -> p("target","");
		$id     = $this -> p("id","","2");
		if($id == "" || $target == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}menu set `target`='".$this->glstr($target,"5")."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}menu set `target`='".$this->glstr($target,"5")."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改前台导航菜单打开方式【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改打开方式成功","./index.php?c=menu&a=index&type=".$this->type."&page=".$this->page."&cid=".$this->cid,true);
	}
	
	/**
	 * 清空前台导航菜单
	**/
	private $clearName = "清空前台导航菜单";
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}menu");
		$this -> addlog("清空前台导航菜单");
		$this -> msg("清空表数据成功","./index.php?c=menu&a=index",true);
	}
}
?>