<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：后台控制器对应的功能管理控制器
 * +------------------------------------------------------------------------ 
**/  

class methodControl extends adminControl {
	public $ControlName = "权限文件对应的功能管理";
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
		),
		//用户权限功能
		"user"  => array(
		)
	);	
	
	public function __construct($conf){
		parent::__construct($conf);
	}
	
	/**
	 * 查看控制器的功能列表
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."control/method.php")){
			exit("没有找到对应的模板文件");
		}
		$control = $this -> p("control","","1");
		$where = $control == "" ? "" : " where `control`='".$this->glstr($control,"5")."' ";
		$list = $this -> db -> keyList("select *,(select name from {$this->conf['prefix']}control as c where c.control=m.control) as controlname from {$this->conf['prefix']}method as m {$where} order by `sort` asc,id asc");
		$selectlist = $this -> db -> keyList("select `id`,`name`,`control` from {$this->conf['prefix']}control order by `sort` asc,id asc");
		include MYDECMS_PATH.$this->template."control/method.php";
		exit();
	}
	
	
	/**
	 * 批量修改数据
	**/
	public function pledit(){
		$id     = $this -> p("id","","2");
		$ids    = $this -> p("ids","","2");
		$name   = $this -> p("name","","2");
		$sort   = $this -> p("sort","","2");

		if($id == "" || $ids =="" || $name == "" || $sort == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$idarr = array();
		$cgs = $sbs = $cws = 0;
		
		foreach ($ids as $k => $v){
			if(in_array($v, $id)) $idarr[] = $k ;
		}
		
		$control = $this -> p("control","","1");
		
		try{
			foreach($idarr as $v){
				if($name[$v]=="" || $name[$v] == NULL) continue;
				$this -> db -> query("update {$this->conf['prefix']}method set `name`='".$this->glstr($name[$v],"6")."',`sort`='".$this->glstr($sort[$v])."' where `id`='".$this->glstr($ids[$v])."'");
			}
			$this -> addlog("批量批量修改控制器的功能【".(is_array($id) ? implode(",",$id):$id)."】");
			$this -> msg("批量修改数据成功","./index.php?c=method&a=index&control=".$control,true,5);
		}catch (Exception $err) {
			$this -> errlog("批量修改数据出错<br><p>".$err->getMessage()."</p>");
		}
	}
	
	/**
	 * 批量修改通用权限
	**/
	public function pleditshare(){
		$sharetype = $this -> p("sharetype","");
		$id     = $this -> p("id","","2");
		if($id == "" || $sharetype == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$control = $this -> p("control","","1");
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}method set `sharetype`='".$this->glstr($sharetype)."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}method set `sharetype`='".$this->glstr($sharetype)."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改控制器的功能通用权限【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改通用权限成功","./index.php?c=method&a=index&control=".$control,true);
		
	}
	
	/**
	 * 批量修改操作日志
	**/
	public function pleditlogs(){
		$logstype = $this -> p("logstype","");
		$id     = $this -> p("id","","2");
		if($id == "" || $logstype == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$control = $this -> p("control","","1");
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}method set `logstype`='".$this->glstr($logstype)."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}method set `logstype`='".$this->glstr($logstype)."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改控制器功能的操作日志【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改操作日志状态成功","./index.php?c=method&a=index&control=".$control,true);
	}
	
	/**
	 * 删除选中记录
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$control = $this -> p("control","","1");
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}method where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("delete from {$this->conf['prefix']}method where `id`='".$id."'");
		}
		$this -> addlog("批量删除控制器的功能【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除数据成功","./index.php?c=method&a=index&control=".$control,true);
	}
	
	
	/**
	 * 清空表数据
	**/
	public function clear(){
		$control = $this -> p("control","","1");
		$this -> db -> truncate("{$this->conf['prefix']}method");
		$this -> addlog("清空控制器的功能表数据");
		$this -> msg("清空表数据成功","./index.php?c=method&a=index&control=".$control,true);
		
	}
	
}
?>