<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：角色控制器
 * +------------------------------------------------------------------------ 
**/  

class roleControl extends adminControl {
	public $ControlName = "用户角色管理";
	private $rid;//父分类
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			
		),
		//用户权限功能
		"user"  => array(
			"index"        => "查看自己权限所能看到的角色",
			"search"       => "搜索自己权限所能看到的角色",
			"add"          => "添加角色",
			"edit"         => "修改角色",
			"del"          => "删除角色",
			"pledit"       => "批量修改角色",
			"pleditcid"   => "批量修改所属父角色"
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
		$this -> cid = $this -> p("cid",$this -> user["rid"],"1");
	}
	
	/**
	 * 查看自己权限所能看到的角色
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."role/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}role order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		$upids = $wxfl -> getParentId($this -> user["rid"]);
		$zids = $wxfl -> getParentId($this -> cid);
		
		if($this -> user["rid"] == "0"){
			$where = " where `cid`='".$this->cid."'";
		}else{
			if(in_array($this->cid,$uzids)){
				$where = " where `cid`='".$this->cid."'";
			}else{
				$where = " where `cid`='".$this -> user["rid"]."'";
			}
		}
		
		$list = $this -> db -> keyList("select *,(select count(id) from {$this->conf['prefix']}role as c2 where c2.cid=c1.id) as zidcount from {$this->conf['prefix']}role as c1 {$where} order by `sort` asc,`id` asc");
		
		include MYDECMS_PATH.$this->template."role/index.php";
		exit();
	}
	
	/**
	 * 搜索角色
	**/
	public function search(){
		if(!file_exists(MYDECMS_PATH.$this->template."role/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$searchkey = isset($_GET['searchkey']) ? $this->glstr($_GET['searchkey'],6) : "";
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}role order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		$upids = $wxfl -> getParentId($this -> user["rid"]);
		$zids = $wxfl -> getParentId($this -> cid);
		
		if(count($uzids)>0) unset($uzids[0]);
		
		if($this -> user["rid"] == "0"){
			$where = " where `name` like '%".$searchkey."%'";
		}else{
			if(count($uzids)>0){
				$where = " where `cid` in(".implode(",",$uzids).") and `name` like '%".$searchkey."%'";
			}else{
				$where = " where `cid`='".$this -> user["rid"]."' and `name` like '%".$searchkey."%'";
			}
		}
		
		$list = $this -> db -> keyList("select *,(select count(id) from {$this->conf['prefix']}role as c2 where c2.cid=c1.id) as zidcount from {$this->conf['prefix']}role as c1 {$where} order by `sort` asc,`id` asc");
		
		include MYDECMS_PATH.$this->template."role/index.php";
		exit();
	}
	
	/**
	 * 添加角色
	**/
	public function add(){
		if(!file_exists(MYDECMS_PATH.$this->template."role/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$v = array("id"=>"","name"=>"","menuqx"=>"","qx"=>"","actionlog"=>"","sort"=>"100");	
		
		$list = $this -> db -> keyList("SELECT c.id,c.name,c.control,m.name as mname,m.method FROM {$this->conf['prefix']}control AS c, {$this->conf['prefix']}method AS m WHERE m.control = c.control order by c.sort asc,m.sort asc");
		
		$menu = $this -> db -> keyList("SELECT a.id,a.cid,a.name,b.id as bid,b.name as bname,b.url as burl FROM {$this->conf['prefix']}adminmenu AS a,{$this->conf['prefix']}adminmenu AS b where a.cid=0 and b.cid=a.id order by a.sort asc,b.sort asc");
		
		$qx = $menuqx = array();
		foreach($list as $t){
			$qx[$t['control']][$t["method"]] = $t;
			$qx[$t['control']]["name"] = $t["name"];
		}
		
		foreach($menu as $t){
			$menuqx[$t['id']][$t["bid"]] = $t;
			$menuqx[$t['id']]["name"] = $t["name"];
		}
		
		if($this->user["rid"]=="0"){
			$fqx = array("menuqx"=>$menuqx,"qx"=>$qx);
		}else{
			$pqx = $this -> db -> fetch_first("select `cid`,`menuqx`,`qx` from {$this->conf['prefix']}role where `id`=".$this->user["rid"]." limit 0,1");
			if(!$pqx){
				$this -> errlog("当前用户角色所属的角色权限不存在，请联系管理解决");
			}	
			$fqx = array("menuqx"=>unserialize($pqx["menuqx"]),"qx"=>unserialize($pqx["qx"]));
		}
				
		include MYDECMS_PATH.$this->template."role/add.php";
		exit();
	}
	public function addAction(){
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("角色不能为空","",false,3);
		}
		$actionlog     = $this -> p("actionlog","1","2");
		if($actionlog == ""){
			$this -> msg("日志开关不能为空","",false,3);
		}
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}role order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		if($this->user["rid"]!="0" && !in_array($this->cid,$uzids)){
			$this -> msg("您账号所属当前角色权限不能给非它下属角色添加新角色","",false,5);
		}
		
		$menuqx    = $this -> readContent($this -> p("menuqx",array(),"2"));
		$qx      = $this -> readContent($this -> p("qx",array(),"2"));
		
		if($this -> user["rid"] !=="0"){
			foreach($menuqx as $kk=>$vv){
				if(is_array($vv) && count($vv)>0){
					foreach($vv as $kkk=>$vvv){
						if(!isset($this->qx["menuqx"][$kk][$kkk])) unset($menuqx["menuqx"][$kk][$kkk]);
					}
				}
				if(!isset($this->qx["menuqx"][$kk])) unset($menuqx["menuqx"][$kk]);
			}
			
			foreach($qx as $kk=>$vv){
				if(is_array($vv) && count($vv)>0){
					foreach($vv as $kkk=>$vvv){
						if(!isset($this->qx["qx"][$kk][$kkk])) unset($qx["qx"][$kk][$kkk]);
					}
				}
				if(!isset($this->qx["qx"][$kk])) unset($qx["qx"][$kk]);
			}
		}
		
		$this -> db -> query("insert ignore into `{$this->conf['prefix']}role` (`cid`,`name`,`menuqx`,`qx`,`actionlog`,`sort`) value ('".$this->cid."','".$name."','".serialize($menuqx)."','".serialize($qx)."','".$actionlog."','".$sort."')");
		$this -> addlog("添加角色【".$this -> readContent($name)."】");
		$this -> msg("添加角色成功","./index.php?c=role&a=index&cid=".$this->cid,true);
	}
	
	
	/**
	 * 修改角色
	**/
	public function edit(){
		if(!file_exists(MYDECMS_PATH.$this->template."role/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$id = $this -> p("id","","1");
		if($id=="") $this -> errlog("记录参数错误");

		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}role where `id`='{$id}' limit 0,1");
		
		if(!$v && $this->user["rid"]!="0"){
			$this -> errlog("记录存在");
		}
		$v["menuqx"]=unserialize($v["menuqx"]);
		$v["qx"]=unserialize($v["qx"]);
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}role order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		if($this->user["rid"]!="0" && !in_array($id,$uzids)){
			$this -> msg("您账号所属当前角色权限不能修改非它下属角色信息","",false,5);
		}
		
		$list = $this -> db -> keyList("SELECT c.id,c.name,c.control,m.name as mname,m.method FROM {$this->conf['prefix']}control AS c, {$this->conf['prefix']}method AS m WHERE m.control = c.control order by c.sort asc,m.sort asc");
		
		$menu = $this -> db -> keyList("SELECT a.id,a.cid,a.name,b.id as bid,b.name as bname,b.url as burl FROM {$this->conf['prefix']}adminmenu AS a,{$this->conf['prefix']}adminmenu AS b where a.cid=0 and b.cid=a.id order by a.sort asc,b.sort asc");
		
		$qx = $menuqx = array();
		foreach($list as $t){
			$qx[$t['control']][$t["method"]] = $t;
			$qx[$t['control']]["name"] = $t["name"];
		}
		
		foreach($menu as $t){
			$menuqx[$t['id']][$t["bid"]] = $t;
			$menuqx[$t['id']]["name"] = $t["name"];
		}
		
		if($this->user["rid"]=="0"){
			$fqx = array("menuqx"=>$menuqx,"qx"=>$qx);
		}else{
			$pqx = $this -> db -> fetch_first("select `cid`,`menuqx`,`qx` from {$this->conf['prefix']}role where `id`=".$this->user["rid"]);
			if(!$pqx){
				$this -> errlog("当前角色所属的角色权限不存在，请联系管理解决");
			}	
			$fqx = array("menuqx"=>unserialize($pqx["menuqx"]),"qx"=>unserialize($pqx["qx"]));
		}
		
		
		include MYDECMS_PATH.$this->template."role/add.php";
		exit();
	}
	public function editAction(){
		$id = $this -> p("id","","2");
		if($id=="") $this -> errlog("记录参数错误");
		
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("角色不能为空","",false,3);
		}
		$actionlog     = $this -> p("actionlog","1","2");
		if($actionlog == ""){
			$this -> msg("日志开关不能为空","",false,3);
		}
		
		
		$sort     = $this -> p("sort","100","2");
		if($sort == ""){
			$this -> msg("排序ID不能为空","",false,3);
		}
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}role order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		if($this->user["rid"]!="0" && !in_array($id,$uzids)){
			$this -> msg("您账号所属当前角色权限不能修改非它下属角色信息","",false,5);
		}
		
		$menuqx    = $this -> readContent($this -> p("menuqx",array(),"2"));
		$qx      = $this -> readContent($this -> p("qx",array(),"2"));
		
		if($this -> user["rid"] !=="0"){
			foreach($menuqx as $kk=>$vv){
				if(is_array($vv) && count($vv)>0){
					foreach($vv as $kkk=>$vvv){
						if(!isset($this->qx["menuqx"][$kk][$kkk])) unset($menuqx["menuqx"][$kk][$kkk]);
					}
				}
				if(!isset($this->qx["menuqx"][$kk])) unset($menuqx["menuqx"][$kk]);
			}
			
			foreach($qx as $kk=>$vv){
				if(is_array($vv) && count($vv)>0){
					foreach($vv as $kkk=>$vvv){
						if(!isset($this->qx["qx"][$kk][$kkk])) unset($qx["qx"][$kk][$kkk]);
					}
				}
				if(!isset($this->qx["qx"][$kk])) unset($qx["qx"][$kk]);
			}
		}
		
		$this -> db -> query("update `{$this->conf['prefix']}role` set `name`='".$name."',`menuqx`='".serialize($menuqx)."',`qx`='".serialize($qx)."',`actionlog`='".$actionlog."',`sort`='".$sort."' where `id`='{$id}'");
		$this -> addlog("修改角色成功【{$id}=>".$this -> readContent($name)."】");
		$this -> msg("修改角色成功","./index.php?c=role&a=index&cid=".$this->cid,true);
	}
	
	
	/**
	 * 删除角色
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}role order by `id` asc");
		$wxfl = new mydecmsWuXianClass($clist);
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
			
		if($this -> user["rid"]!="0" && is_array($id)){
			foreach($id as $k=>$v){
				if(!in_array($v,$uzids))unset($id[$k]);
			}
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}role where `id` in(".implode(",",$id).")");
		}else{
			if($id != "" && in_array($id,$uzids)) $this -> db -> query("delete from {$this->conf['prefix']}role where `id`='".$id."'");
		}
		$this -> addlog("批量删除角色【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除角色完毕","./index.php?c=role&a=index&cid=".$this->cid,true);
	}
	
	/**
	 * 批量修改角色
	**/
	public function pleidt(){
		$id      = $this -> p("id","","2");
		$ids     = $this -> p("ids","","2");
		$name    = $this -> p("name","","2");
		$sort     = $this -> p("sort","100","2");

		if($id == "" || $ids =="" || $name == "" || $sort == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$idarr = array();
		
		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}role order by `id` asc");
		$wxfl = new mydecmsWuXianClass($clist);
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
			
		if($this -> user["rid"]!="0" && is_array($ids)){
			foreach($ids as $k=>$v){
				if(!in_array($v,$uzids))unset($ids[$k]);
			}
		}
		
		foreach ($ids as $k => $v){
			if(in_array($v, $id)) $idarr[] = $k ;
		}
		
		try{
			foreach($idarr as $v){
				if($name[$v]=="" || $name[$v] == NULL) continue;
				$this -> db -> query("update {$this->conf['prefix']}role set `name`='".$name[$v]."',`sort`='".$sort[$v]."' where `id`='".$ids[$v]."'");
			}
			$this -> addlog("批量修改角色【".(is_array($id) ? implode(",",$id):$id)."】");
			$this -> msg("批量修改数据成功","./index.php?c=role&a=index&cid=".$this->cid,true,5);
		}catch (Exception $err) {
			$this -> errlog("批量修改数据出错<br><p>".$err->getMessage()."</p>");
		}
	}
	
	/**
	 * 批量修改所属父角色
	**/
	public function pleditcid(){
		$id          = $this -> p("id","","2");
		$newcid     = $this -> p("newcid","1");
		if($id == "" || $newcid == ""){
			$this -> msg("提交的数据错误","");
		}

		include_once MYDECMSPHP_PATH."wuxian.mydecms.php";
		
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}role order by `id` asc");
		
		$wxfl = new mydecmsWuXianClass($clist);
		
		$uzids = $wxfl -> getChildId($this -> user["rid"]);
		if($this -> user["rid"]!="0" && is_array($id)){
			foreach($id as $k=>$v){
				if(!in_array($v,$uzids))unset($id[$k]);
			}
		}
		
		if($this->user["rid"]!="0" && !in_array($newcid,$uzids)){
			$this -> msg("您账号所属当前角色无权限修改选中角色修改到目标所属父角色","",false,5);
		}
		
		if(is_array($id)){
			$this -> db -> query("update {$this->conf['prefix']}role set `cid`='".$this->glstr($newcid)."' where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("update {$this->conf['prefix']}role set `cid`='".$this->glstr($newcid)."' where `id` ='".$id."'");
		}
		$this -> addlog("批量修改所属父角色【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量修改所属父角色成功","./index.php?c=role&a=index&cid=".$this->cid,true);
	}

	/**
	 * 清空角色
	**/
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}article");
		$this -> addlog("清空角色表数据");
		$this -> msg("清空表数据成功","./index.php?c=role&a=index",true);
	}
}
?>