<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：蜘蛛爬行日志管理控制器
 * +------------------------------------------------------------------------ 
**/  

class spiderlogsControl extends adminControl {
	public $ControlName = "蜘蛛爬行日志管理";
	private $pageCode;//分页源代码
	private $spider = "未知";
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			
		),
		//用户权限功能
		"user"  => array(
			"index"        => "查看蜘蛛爬行日志",
			"search"       => "搜索蜘蛛爬行日志",
			"del"          => "删除蜘蛛爬行日志",
			"glspider"     => "查看已过滤的蜘蛛IP列表",
			"add"          => "添加过滤蜘蛛IP",
			"edit"         => "修改过滤蜘蛛IP",
			"pladdgl"      => "批量加入过滤蜘蛛IP",
			"delglspider"  => "删除选中的过滤蜘蛛IP"
		)
	);	
	
	public function __construct($conf){
		parent::__construct($conf);
	}
	
	/**
	 * 查看蜘蛛爬行日志
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."spiderlogs/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$this -> spider = $this -> glstr($this->p("spider","未知"),"5");
		
		$where = $this -> spider != ""? " where `name`='".$this -> spider."'": "";
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select * from {$this->conf['prefix']}spiderlogs {$where} order by `id` desc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}spiderlogs","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=spiderlogs&a=index&page={page}","./index.php?c=spiderlogs&a=index");
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=spiderlogs&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."spiderlogs/index.php";
		exit();
	}
	
	/**
	 * 搜索蜘蛛爬行日志
	**/
	public function search(){
		if(!file_exists(MYDECMS_PATH.$this->template."spiderlogs/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$searchtype = isset($_GET['searchtype']) ? $this->glstr($_GET['searchtype']) : "1";
		
		$searchkey = isset($_GET['searchkey']) ? $_GET['searchkey'] : "";
		if(empty($searchkey)){
			header("Location: ./index.php?c=spiderlogs&a=index");
		}
		
		$where = "";
		
		switch($searchtype){
			case "1":
				$where = " where `url` like '%".$searchkey."%'";
				break;
			case "2":
				$where = " where `ip` like '%".$searchkey."%'";
				break;
			default:
				$where = " where `name` like '%".$searchkey."%'";
				break;
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select * from {$this->conf['prefix']}spiderlogs {$where} order by `id` desc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}spiderlogs","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=spiderlogs&a=search&page={page}&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype,"./index.php?c=spiderlogs&a=search&searchkey=".urlencode($searchkey)."&searchtype=".$searchtype);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=spiderlogs&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."spiderlogs/index.php";
		exit();
	}
	
	/**
	 * 删除蜘蛛爬行日志
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}spiderlogs where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("delete from {$this->conf['prefix']}spiderlogs where `id`='".$id."'");
		}
		$this -> addlog("批量删除蜘蛛爬行日志【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除蜘蛛爬行日志成功","./index.php?c=spiderlogs&a=index&page=".$this->page,true);
	}
	
	/**
	 * 查看已过滤的蜘蛛IP列表
	**/
	public function glspider(){
		if(!file_exists(MYDECMS_PATH.$this->template."spiderlogs/glspider.php")){
			exit("没有找到对应的模板文件");
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select * from {$this->conf['prefix']}glspider order by `id` desc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}glspider","id","");
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=spiderlogs&a=glspider&page={page}","./index.php?c=spiderlogs&a=glspider");
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=spiderlogs&a=glspider&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."spiderlogs/glspider.php";
		exit();
	}
	
	/**
	 * 添加过滤蜘蛛IP
	**/
	public function add(){
		if(!file_exists(MYDECMS_PATH.$this->template."spiderlogs/add.php")){
			exit("没有找到对应的模板文件");
		}

		$v = array("id"=>"","name"=>"","ip"=>"");
		include MYDECMS_PATH.$this->template."spiderlogs/add.php";
		exit();
	}
	public function addAction(){
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("蜘蛛名称不能为空","",false,3);
		}
		$ip     = $this -> p("ip","","2");
		if($ip == ""){
			$this -> msg("蜘蛛IP地址不能为空","",false,3);
		}
		
		$this -> db -> query("insert ignore into `{$this->conf['prefix']}glspider` (`name`,`ip`) value ('".$this->glstr($name,6)."','".$ip."')");
		$this -> addlog("添加过滤蜘蛛IP【".$this -> readContent($name)."】");
		$this -> msg("添加过滤蜘蛛IP成功","./index.php?c=spiderlogs&a=glspider",true);
	}
	
	
	/**
	 * 修改过滤蜘蛛IP
	**/
	public function edit(){
		if(!file_exists(MYDECMS_PATH.$this->template."spiderlogs/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$id = $this -> p("id","","1");
		if($id=="") $this -> errlog("记录参数错误");

		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}glspider where `id`='{$id}' limit 0,1");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		include MYDECMS_PATH.$this->template."spiderlogs/add.php";
		exit();
	}
	public function editAction(){
		$id = $this -> p("id","","2");
		if($id=="") $this -> errlog("记录参数错误");
		
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("蜘蛛名称不能为空","",false,3);
		}
		$ip     = $this -> p("ip","","2");
		if($ip == ""){
			$this -> msg("蜘蛛ip地址不能为空","",false,3);
		}
		
		$this -> db -> query("update `{$this->conf['prefix']}glspider` set `name`='".$this->glstr($name,6)."',`ip`='".$ip."' where `id`='{$id}'");
		$this -> addlog("修改过滤蜘蛛IP【{$id}=>".$this -> readContent($name)."】");
		$this -> msg("修改过滤蜘蛛ip成功","./index.php?c=spiderlogs&a=glspider&page=".$this->page,true);
	}
	
	/**
	 * 删除选中的过滤蜘蛛IP
	**/
	public function delglspider(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}glspider where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("delete from {$this->conf['prefix']}glspider where `id`='".$id."'");
		}
		$this -> addlog("批量删除过滤蜘蛛IP【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("删除选中的过滤蜘蛛IP成功","./index.php?c=spiderlogs&a=glspider&page=".$this->page,true);
	}
	

	/**
	 * 批量加入过滤蜘蛛IP
	**/
	public function pladdgl(){
		$id          = $this -> p("id","","2");
		$newtype     = $this -> p("newtype","1");
		if($id == "" || $newtype == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("insert ignore into `{$this->conf['prefix']}glspider` (`name`,`ip`) select `name`,`ip` from {$this->conf['prefix']}spiderlogs where `id` in(".implode(",",$id).")");
			$this -> db -> query("delete from {$this->conf['prefix']}spiderlogs where `ip` in(select `ip` from `{$this->conf['prefix']}glspider`)");
		}else{
			$this -> db -> query("insert ignore into `{$this->conf['prefix']}glspider` (`name`,`ip`) select `name`,`ip` from {$this->conf['prefix']}spiderlogs where `id` ='".$id."')");
			$this -> db -> query("delete from {$this->conf['prefix']}spiderlogs where `ip` in(select `ip` from `{$this->conf['prefix']}glspider`)");
		}
		$this -> addlog("批量将选中记录IP加入到过滤蜘蛛IP【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量将选中记录IP加入到过滤蜘蛛IP成功","./index.php?c=spiderlogs&a=index&page=".$this->page,true);
	}
	
	/**
	 * 清空蜘蛛爬行日志
	**/
	public function glspiderclear(){
		$this -> db -> truncate("{$this->conf['prefix']}glspider");
		$this -> addlog("清空已过滤蜘蛛IP数据");
		$this -> msg("清空已过滤蜘蛛IP数据成功","./index.php?c=spiderlogs&a=glspider",true);
	}
	
	
	/**
	 * 清空蜘蛛爬行日志
	**/
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}spiderlogs");
		$this -> addlog("清空蜘蛛爬行日志数据");
		$this -> msg("清空蜘蛛爬行日志数据成功","./index.php?c=spiderlogs&a=index",true);
	}
}
?>