<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：后台首页控制器
 * +------------------------------------------------------------------------ 
**/  

class systemControl extends adminControl {
	
	public $ControlName = "后台首页控制器";
	
	public $SpiderArr = array
	(
		'baidu'    => '百度蜘蛛',
		'360spider'      => '360蜘蛛',
		'sogou'          => '搜狗蜘蛛',
		'google'      => '谷歌蜘蛛',
		'bing'        => "必应蜘蛛"
	);
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			"webinfo"=>"网站信息概括"
		),
		//用户权限功能
		"user"  => array(
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
	}
	
	/**
	 * 删除安装包文件
	**/
	public function delinstall(){
		if(!file_exists("../install/")){
			exit("安装包文件已经被删除");
		}
		$this -> delDir("../install/");
		exit('安装包文件删除完毕');
	}
	
	/**
	 * 网站信息概括
	**/
	public function webinfo(){
		if(!file_exists(MYDECMS_PATH.$this->template."system/webinfo.php")){
			exit("没有找到对应的模板文件");
		}
		
		$data['webdata'][] = array("用户",$this -> db -> count("{$this->conf['prefix']}user"));
		$data['webdata'][] = array("文章分类",$this -> db -> count("{$this->conf['prefix']}category"));
		$data['webdata'][] = array("文章",$this -> db -> count("{$this->conf['prefix']}article"));
		$data['webdata'][] = array("tags标签",$this -> db -> count("{$this->conf['prefix']}tag"));
		$data['webdata'][] = array("友情链接",$this -> db -> count("{$this->conf['prefix']}friendlink"));
		
		
		$date[0][0] = date("Y-m-d");                                                 //今天开始
		$date[0][1] = $date[0][0];                                                   //今天结束
		$date[1][0] = date("Y-m-d",strtotime("{$date[0][0]} -1 days"));              //昨天开始
		$date[1][1] = $date[1][0];                                                   //昨天结束
		$date[2][0] = date('Y-m-d', strtotime('this week'));                         //本周第一天
		$date[2][1] = date("Y-m-d", strtotime("{$date[2][0]} +6 days"));                //本周最后一天
		$date[3][0] = date('Y-m-d',strtotime("{$date[2][0]} -7 days"));              //上周第一天
		$date[3][1] = date('Y-m-d',strtotime("{$date[2][0]} -1 days"));              //上周最后一天
		$date[4][0] = date('Y-m-01', strtotime(date("Y-m-d")));                      //本月第一天
		$date[4][1] = date('Y-m-d', strtotime("{$date[4][0]} +1 month -1 day"));     //本月最后一天
		$date[5][0] = date('Y-m-01', strtotime('-1 month'));                         //上月第一天
		$date[5][1] = date('Y-m-t', strtotime('-1 month'));                          //上月最后一天
		$date[6][0] = "2008-08-08";                                                  //全部开始
		$date[6][1] = $date[0][0];                                                   //全部结束

		$data['spider'] = array();
		foreach($date as $v){
			$field = "";
			foreach($this -> SpiderArr as $kk => $vv){
				$field .= "count(`name`='{$kk}' or null) as {$kk},";
			}
			$sql = "select {$field}count(id) as count from {$this->conf['prefix']}spiderlogs as s where `date`>='".strtotime($v[0]." 00:00:00")."' and `date`<='".strtotime($v[1]." 23:59:59")."'";
			$sdata = $this -> db -> keyList($sql);
			foreach($sdata[0] as $kkk=>$vvv){
				$data['spider'][$kkk][] = $sdata[0][$kkk];
			}
			
		}
		//print_r($data['spider']);
		include MYDECMS_PATH.$this->template."system/webinfo.php";
		exit();
	}
	
	/**
	 * 修改网站设置
	**/
	public function edit()
	{
		$v = $this -> config;
		if(!file_exists(MYDECMS_PATH.$this->template."system/system.php")){
			exit("没有找到对应的模板文件");
		}
		if(!file_exists("../moban/")) $this -> createDir("../moban/");
		$tpllist = array();
		if(file_exists("../moban/")){
			$handle=opendir("../moban/"); 
			while (false !== ($file = readdir($handle))){//遍历文件夹下所有文件
				if ($file != "." && $file != "..") {
					if(is_dir("../moban/".$file."/")){
						$tpllist[] = $file;
					}
				}
			}
			closedir($handle);
		}
		include MYDECMS_PATH.$this->template."system/system.php";
		exit();
	}
	
	/**
	 * 修改网站设置
	**/
	public function editAction(){
		$id = $this -> p("id","","2");
		$webname     = $this -> p("webname","","2");
		if($webname == ""){
			$this -> msg("网站名称不能为空","",false,3);
		}
		$weburl     = $this -> p("weburl","","2");
		if($weburl == ""){
			$this -> msg("网站首页地址不能为空","",false,3);
		}
		
		if(substr($weburl,-1)=="/") $weburl = substr($weburl,0,-1);
		
		$webtitle     = $this -> p("webtitle","","2");
		if($webtitle == ""){
			$this -> msg("网站标题不能为空","",false,3);
		}
		
		$weblogo     = $this -> p("weblogo","","2");
		if($weblogo == ""){
			$this -> msg("网站logo不能为空","",false,3);
		}
		
		$softdir     = $this -> p("softdir","","2");
		if($softdir == ""){
			$softdir = "/";
		}	
		
		$softtpl     = $this -> p("softtpl","","2");
		if($softtpl == ""){
			$this -> msg("网站模板不能为空","",false,3);
		}
		
		$webkey     = $this -> p("webkey","","2");
		$webdesc     = $this -> p("webdesc","","2");
		$spider     = $this -> p("spider","2","2");
		$webwjt     = $this -> p("webwjt","2","2");
		$watertype     = $this -> p("watertype","2","2");
		$loginlog  = $this -> p("loginlog","2","2");
		$actionlog  = $this -> p("actionlog","2","2");
		$adminyzm   = $this -> p("adminyzm","2","2");
		$webicp     = $this -> p("webicp","","2");
		$webtj      = $this -> p("webtj","","2");
		$mobiletype = $this -> p("mobiletype","2","2");
		$mobileurl  = $this -> p("mobileurl","","2");

		
		$this -> db -> query("update `{$this->conf['prefix']}system` set `webname`='".$webname."',`weburl`='".$weburl."',`webtitle`='".$webtitle."',`weblogo`='".$weblogo."',`webkey`='".$webkey."',`webdesc`='".$webdesc."',`softdir`='".$softdir."',`softtpl`='".$softtpl."',`mobiletype`='".$mobiletype."',`mobileurl`='".$mobileurl."',`spider`='".$spider."',`webwjt`='".$webwjt."',`watertype`='".$watertype."',`loginlog`='".$loginlog."',`actionlog`='".$actionlog."',`adminyzm`='".$adminyzm."',`webicp`='".$webicp."',`webtj`='".$webtj."' where `id`='{$id}'");
		$this -> addlog("修改网站设置");
		$this -> msg("修改网站设置成功","./index.php?c=system&a=edit",true);
	}
	
	/**
	 * 修改伪静态规则
	**/
	public function wjt(){
		$v = $this -> config;
		if(!file_exists(MYDECMS_PATH.$this->template."system/wjt.php")){
			exit("没有找到对应的模板文件");
		}
		include MYDECMS_PATH.$this->template."system/wjt.php";
		exit();
	}
	public function wjtAction(){
		$id = $this -> p("id","","2");
		$this -> config['wjt']['category']     = $this -> p("category","","2");
		if($this -> config['wjt']['category'] == ""){
			$this -> msg("文章列表首页规则不能为空","",false,3);
		}
		$this -> config['wjt']['categorypage']     = $this -> p("categorypage","","2");
		if($this -> config['wjt']['categorypage'] == ""){
			$this -> msg("文章列表分页规则不能为空","",false,3);
		}
				
		$this -> config['wjt']['article']     = $this -> p("article","","2");
		if($this -> config['wjt']['article'] == ""){
			$this -> msg("文章URL规则不能为空","",false,3);
		}
		
		$this -> config['wjt']['tag']     = $this -> p("tag","","2");
		if($this -> config['wjt']['tag'] == ""){
			$this -> msg("TAG标签列表首页URL规则不能为空","",false,3);
		}
		$this -> config['wjt']['tagpage']     = $this -> p("tagpage","","2");
		if($this -> config['wjt']['tagpage'] == ""){
			$this -> msg("TAG标签列表分页URL规则不能为空","",false,3);
		}
		
		$this -> db -> query("update `{$this->conf['prefix']}system` set `wjt`='".json_encode($this -> config['wjt'])."' where `id`='{$id}'");
		$this -> addlog("修改伪静态规则");
		$this -> msg("修改伪静态规则成功","./index.php?c=system&a=wjt",true);
	} 
	
	/**
	 * 修改图片水印配置
	**/
	public function water(){
		$v = $this -> config;
		if(!file_exists(MYDECMS_PATH.$this->template."system/water.php")){
			exit("没有找到对应的模板文件");
		}
		include MYDECMS_PATH.$this->template."system/water.php";
		exit();
	}
	public function waterAction(){
		$id = $this -> p("id","","2");
		$this -> config['water']['img']     = $this -> p("img","","2");
		if($this -> config['water']['img'] == ""){
			$this -> msg("水印图片地址不能为空","",false,3);
		}
		$this -> config['water']['positon']     = $this -> p("positon","3","2");
		if($this -> config['water']['positon'] == ""){
			$this -> msg("水印位置不能为空","",false,3);
		}
				
		$this -> config['water']['alpha']     = $this -> p("alpha","100","2");
		if($this -> config['water']['alpha'] == ""){
			$this -> msg("水印透明度不能为空","",false,3);
		}
		
		$this -> config['water']['top']     = $this -> p("top","0","2");
		if($this -> config['water']['top'] == ""){
			$this -> msg("水印顶部间距不能为空","",false,3);
		}
		
		$this -> config['water']['right']     = $this -> p("right","0","2");
		if($this -> config['water']['right'] == ""){
			$this -> msg("水印右边间距不能为空","",false,3);
		}
		
		$this -> config['water']['bottom']     = $this -> p("bottom","0","2");
		if($this -> config['water']['bottom'] == ""){
			$this -> msg("水印底部间距不能为空","",false,3);
		}
		
		$this -> config['water']['left']     = $this -> p("left","0","2");
		if($this -> config['water']['left'] == ""){
			$this -> msg("水印左边间距不能为空","",false,3);
		}

		$this -> db -> query("update `{$this->conf['prefix']}system` set `water`='".json_encode($this -> config['water'])."' where `id`='{$id}'");
		$this -> addlog("修改上传图片水印设置");
		$this -> msg("修改上传图片水印设置成功","./index.php?c=system&a=water",true);
	} 
	
}
?>