<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：tag标签管理控制器
 * +------------------------------------------------------------------------ 
**/  

class tagControl extends adminControl {
	public $ControlName = "tag标签管理";
	private $pageCode;//分页源代码
	private $type = "";//属性
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			
		),
		//用户权限功能
		"user"  => array(
			"index"        => "查看tag标签",
			"search"       => "搜索tag标签",
			"add"          => "添加tag标签",
			"edit"         => "修改tag标签",
			"del"          => "删除tag标签",
			"pledit"       => "批量修改tag标签",
			"pledittype"   => "批量修改显示属性"
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
		$this -> type = $this -> p("type","","1");
	}
	
	/**
	 * 查看tag标签
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."tag/index.php")){
			exit("没有找到对应的模板文件");
		}
						
		$where = "";	
		
		if($this -> type != ""){
			$where = $where != "" ? $where." and " : $where." where ";
			$where .= " `type`='".$this -> type."'";
		}
		
		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select *,(select `username` from {$this->conf['prefix']}user as u where u.id=c1.userid limit 0,1) as username from {$this->conf['prefix']}tag as c1 {$where} order by `id` desc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}tag","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=tag&a=index&page={page}&type=".$this->type,"./index.php?c=tag&a=index&type=".$this->type);
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=tag&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."tag/index.php";
		exit();
	}
	
	/**
	 * 搜索tag标签
	**/
	public function search(){
		if(!file_exists(MYDECMS_PATH.$this->template."tag/index.php")){
			exit("没有找到对应的模板文件");
		}
		
		$searchtype = isset($_GET['searchtype']) ? $this->glstr($_GET['searchtype']) : "1";
		
		$searchkey = isset($_GET['searchkey']) ? $this->glstr($_GET['searchkey'],6) : "";
		if(empty($searchkey)){
			header("Location: ./index.php?c=tag&a=index");
		}
		
		$where = " where `name` like '%".$searchkey."%'";

		$limit = "limit ".($this -> page * $this -> conf["adminPageSize"] - $this -> conf["adminPageSize"]).",".$this -> conf["adminPageSize"];
		
		$list = $this -> db -> keyList("select *,(select `username` from {$this->conf['prefix']}user as u where u.id=c1.userid limit 0,1) as username from {$this->conf['prefix']}tag as c1 {$where} order by `id` desc {$limit}");
		
		$records = $this -> db -> count("{$this->conf['prefix']}tag","id",$where);
		
		$mydePage = new PageMydecms($records,$this -> conf["adminPageSize"],$this -> page,"./index.php?c=tag&a=search&page={page}&searchkey=".urlencode($searchkey),"./index.php?c=tag&a=search&searchkey=".urlencode($searchkey));
		
		if($this -> page > $mydePage -> mydeCmsPageCount && $this -> page >1 && $mydePage -> mydeCmsPageCount > 1){
			header("Location: ./index.php?c=tag&a=index&page={$mydePage->mydeCmsPageCount}");
		}
		
		$this -> pageCode = $mydePage -> mydeCmsShow("mydePage");
		
		include MYDECMS_PATH.$this->template."tag/index.php";
		exit();
	}
	
	/**
	 * 添加tag标签
	**/
	public function add(){
		if(!file_exists(MYDECMS_PATH.$this->template."tag/add.php")){
			exit("没有找到对应的模板文件");
		}

		$v = array("id"=>"","name"=>"","views"=>"0","type"=>"1","date"=>date("Y-m-d H:i:s"));
		
		include MYDECMS_PATH.$this->template."tag/add.php";
		exit();
	}
	public function addAction(){
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("tag标签名不能为空","",false,3);
		}
		
		$views   = $this -> p("views","0","2");
		$date    = strtotime($this -> p("date",date("Y-m-d H:i:s"),"2"));
		
		$ids = '';
		$v = $this -> db -> fetch_first("select GROUP_CONCAT(a.id) AS ids from {$this->conf['prefix']}article as a where a.tags like '%{$name}%' order by id desc limit 0,100");
		if($v['ids']!='') $ids = $v['ids'];
		$this -> db -> query("insert ignore into `{$this->conf['prefix']}tag` (`name`,`userid`,`date`,`views`,`ids`) value ('".$name."','".$this->user["id"]."','".$date."','".$views."','".$ids."')");
		$this -> addlog("添加新tag标签成功");
		$this -> msg("添加新tag标签成功","./index.php?c=tag&a=index&type=".$this->type."&page=".$this->page,true);
	}
	
	
	/**
	 * 修改tag标签
	**/
	public function edit(){
		if(!file_exists(MYDECMS_PATH.$this->template."tag/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$id = $this -> p("id","","1");
		if($id=="") $this -> errlog("记录参数错误");

		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tag where `id`='{$id}' limit 0,1");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		$v["date"] = date("Y-m-d H:i:s",$v["date"]);

		include MYDECMS_PATH.$this->template."tag/add.php";
		exit();
	}
	public function editAction(){
		$id = $this -> p("id","","2");
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("tag标签名不能为空","",false,3);
		}
		
		$views   = $this -> p("views","0","2");
		$date    = strtotime($this -> p("date",date("Y-m-d H:i:s"),"2"));
		
		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tag where `id`='{$id}' limit 0,1");
		
		$sql = "";
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		if($v['name']!=$name){
			$sql = ",t.ids=(select GROUP_CONCAT(a.id) AS ids from {$this->conf['prefix']}article as a where a.tags like '%{$name}%' order by id desc limit 0,100)";
		}
		
		$this -> db -> query("update `{$this->conf['prefix']}tag` as t set `name`='".$name."',`date`='".$date."',`views`='".$views."'{$sql} where `id`='{$id}'");
		$this -> addlog("修改tag标签【{$id}=>".$this -> readContent($name)."】");
		$this -> msg("修改tag标签成功","./index.php?c=tag&a=index&page=".$this->page,true);
	}
	
	
	/**
	 * 删除tag标签
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}tag where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("delete from {$this->conf['prefix']}tag where `id`='".$id."'");
		}
		$this -> addlog("批量删除tag标签【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除tag标签成功","./index.php?c=tag&a=index&page=".$this->page,true);
	}
	
	/**
	 * 批量修改tag标签
	**/
	public function pledit(){
		$id      = $this -> p("id","","2");
		$ids     = $this -> p("ids","","2");
		$name    = $this -> p("name","","2");
		$views    = $this -> p("views","0","2");

		if($id == "" || $ids =="" || $name == "" || $views == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$idarr = array();
		$cgs = $sbs = $cws = 0;
		
		foreach ($ids as $k => $v){
			if(in_array($v, $id)) $idarr[] = $k ;
		}
		
		try{
			$date    = strtotime(date("Y-m-d H:i:s"));
			foreach($idarr as $v){
				if($name[$v]=="" || $name[$v] == NULL) continue;
				$this -> db -> query("update {$this->conf['prefix']}tag as t set `name`='".$name[$v]."',`views`='".$views[$v]."',t.ids=(select GROUP_CONCAT(a.id) AS ids from {$this->conf['prefix']}article as a where a.tags like '%".$name[$v]."%' order by id desc limit 0,100),t.date='{$date}' where `id`='".$ids[$v]."'");
			}
			$this -> addlog("批量修改tag标签【".(is_array($id) ? implode(",",$id):$id)."】");
			$this -> msg("批量修改tag标签数据成功","./index.php?c=tag&a=index&page=".$this->page,true,5);
		}catch (Exception $err) {
			$this -> errlog("批量修改tag标签数据出错<br><p>".$err->getMessage()."</p>");
		}
	}
	
	/**
	 * 批量更新tag标签文章
	**/
	public function plupdate(){
		$id      = $this -> p("id","","2");

		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		$date    = strtotime(date("Y-m-d H:i:s"));
		
		$sql = "update {$this->conf['prefix']}tag as t set t.date='{$date}',t.ids=(select GROUP_CONCAT(a.id) AS ids from {$this->conf['prefix']}article as a where a.tags like concat('%' ,t.name,'%') order by id desc limit 0,100) where t.id in(".implode(",",$id).")";
		try{
			$this -> db -> query($sql);
			$this -> addlog("批量更新tag标签文章【".(is_array($id) ? implode(",",$id):$id)."】");
			$this -> msg("批量更新tag标签文章成功","./index.php?c=tag&a=index&page=".$this->page,true,5);
		}catch (Exception $err) {
			$this -> errlog("批量更新tag标签文章时出错<br><p>".$err->getMessage()."</p>");
		}
	}

		
	/**
	 * 清空tag标签
	**/
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}tag");
		$this -> addlog("清空tag标签表数据");
		$this -> msg("清空tag标签表数据成功","./index.php?c=tag&a=index",true);
	}
}
?>