<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：模板文件管理控制器
 * +------------------------------------------------------------------------ 
**/  

class tplfileControl extends adminControl {
	public $ControlName = "模板文件管理";
	private $tplsubject;//模板目录
	private $type = "";//模板所属类型
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
			"selecttpl" => "选择专用模板"
		),
		//用户权限功能
		"user"  => array(
			"index"        => "查看模板",
			"add"          => "添加模板",
			"edit"         => "修改模板",
			"del"          => "删除模板"
		)
	);
	
	public function __construct($conf){
		parent::__construct($conf);
		$this -> type = $this -> p("type","","1");
		$tsid = $this -> p("tsid","","1");
		if($tsid!=""){
			$this -> tplsubject = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplsubject where `id`='{$tsid}' limit 0,1");
		}
		if(!isset($this -> tplsubject["id"])){
			$this -> tplsubject = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplsubject order by id asc limit 0,1");
		}

		if(!isset($this -> tplsubject["id"])){
			$this -> errlog("没有找到对应的模板主题记录");
		}
		
	}
	
	/**
	 * 选择专用模板
	**/
	public function selecttpl(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplfile/selecttpl.php")){
			exit("没有找到对应的模板文件");
		}
		$list = $this -> db -> keyList("select * from {$this->conf['prefix']}tplfile where `type`=1 and `subjectid`=(select `subjectid` from {$this->conf['prefix']}tplsubject where `folder`='".$this->config['softtpl']."' limit 0,1) order by `id` asc");
		include MYDECMS_PATH.$this->template."tplfile/selecttpl.php";
		exit();
	}
	
	/**
	 * 查看模板
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplfile/index.php")){
			exit("没有找到对应的模板文件");
		}
				
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}tplsubject order by `id` asc");
		
		$where = $this -> type != "" ? " and `type`='".$this -> type."'": "";
		
		$list = $this -> db -> keyList("select * from {$this->conf['prefix']}tplfile where `subjectid`='".$this -> tplsubject["id"]."' {$where} order by `id` asc");
	
		include MYDECMS_PATH.$this->template."tplfile/index.php";
		exit();
	}
	
	
	/**
	 * 添加模板文件
	**/
	public function add(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplfile/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		if(!file_exists("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["tplfolder"]."/")){
			$this -> createDir("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["tplfolder"]."/");
		}
		
		$v = array("id"=>"","filename"=>"","word"=>"","type"=>"1","content"=>"");
		
		$id = $this -> p("id","","1");
		if($id!=""){
			$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplfile where `id`='{$id}' limit 0,1");
			if($v){
				$v["type"] = $this -> p("newtype","1","1");
			}
		}
		
		include MYDECMS_PATH.$this->template."tplfile/add.php";
		exit();
	}
	public function addAction(){
		$filename     = $this -> p("filename","","2");
		if($filename == ""){
			$this -> msg("模板文件名不能为空","",false,3);
		}
		$word     = $this -> p("word","","2");
		if($word == ""){
			$this -> msg("模板说明不能为空","",false,3);
		}
		$type     = $this -> p("type","","2");
		if($type == ""){
			$this -> msg("模板类型能为空","",false,3);
		}
		$content  = trim($this -> p("content","","2"));
		if($content == ""){
			$this -> msg("模板内容不能为空","",false,3);
		}
		
		$content = $this->readContent($content);
		
		if(strpos($content,'<?php if(!defined(\'WWW.MYDECMS.COM\')) exit(\'请不要非法操作\'); ?>')!==0){
			$content = '<?php if(!defined(\'WWW.MYDECMS.COM\')) exit(\'请不要非法操作\'); ?>'.$content;
		}
		
		$this -> db -> query("insert ignore into `{$this->conf['prefix']}tplfile` (`filename`,`word`,`subjectid`,`type`,`content`) value ('".$filename."','".$word."','".$this -> tplsubject["id"]."','".$type."','".$this->writeContent($content)."')");

		file_put_contents("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["tplfolder"]."/".$filename.($type=="2" ? ".m":"").".php",$content);
		$this -> addlog("添加新模板文件【{$filename}】");
		$this -> msg("添加新模板文件成功","./index.php?c=tplfile&a=index&tsid=".$this -> tplsubject["id"]."&type=".$this -> type,true);
	}
	
	
	/**
	 * 修改模板文件
	**/
	public function edit(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplfile/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$id = $this -> p("id","","1");
		if($id=="") $this -> errlog("记录参数错误");

		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplfile where `id`='{$id}' limit 0,1");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		include MYDECMS_PATH.$this->template."tplfile/add.php";
		exit();
	}
	public function editAction(){
		$id = $this -> p("id","","2");
		if($id=="") $this -> errlog("记录参数错误");
		
		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplfile where `id`='{$id}' limit 0,1");
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		
		$filename     = $this -> p("filename","","2");
		if($filename == ""){
			$this -> msg("模板文件名不能为空","",false,3);
		}
		$word     = $this -> p("word","","2");
		if($word == ""){
			$this -> msg("模板说明不能为空","",false,3);
		}
		$type     = $this -> p("type","","2");
		if($type == ""){
			$this -> msg("模板类型能为空","",false,3);
		}
		$content     = trim($this -> p("content","","2"));
		if($content == ""){
			$this -> msg("模板内容不能为空","",false,3);
		}
		
		$content = $this->readContent($content);
		
		if($v["filename"] != $filename && file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["tplfolder"]."/".$filename.($type=="2" ? ".m":"").".php")){
			$this -> msg("模板文件【".$filename."】已经存在，请改用其他样式文件名","",false,3);
		}else if($v["filename"] != $filename && file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["tplfolder"]."/".$v["filename"].($type=="2" ? ".m":"").".php")){
			$this -> renamedir("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["tplfolder"]."/".$v["filename"].".php","../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["tplfolder"]."/".$filename.".php");
		}
		
		if(strpos($content,'<?php if(!defined(\'WWW.MYDECMS.COM\')) exit(\'请不要非法操作\'); ?>')!==0){
			$content = '<?php if(!defined(\'WWW.MYDECMS.COM\')) exit(\'请不要非法操作\'); ?>'.$content;
		}
		
		$this -> db -> query("update `{$this->conf['prefix']}tplfile` set `filename`='".$filename."',`word`='".$word."',`type`='".$type."',`content`='".$this->writeContent($content)."' where `id`='{$id}'");
			
		file_put_contents("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["tplfolder"]."/".$filename.($type=="2" ? ".m":"").".php",$content);
		$this -> addlog("修改模板文件【{$id}=>".$this -> readContent($filename)."】");
		$this -> msg("修改模板文件成功","./index.php?c=tplfile&a=index&tsid=".$this -> tplsubject["id"]."&type=".$this -> type,true);
	}
	
	/**
	 * 从目录更新模板
	**/
	public function update(){
		$this -> getTplSubject();
		
		if(!file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["tplfolder"]."/")){
			$this -> createDir("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["tplfolder"]."/");
		}
		
		$handle=opendir("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["tplfolder"]."/"); 
		while (false !== ($file = readdir($handle))){//遍历文件夹下所有文件
			if ($file != "." && $file != "..") {
				$zfwz = strrpos($file,".");
				$filename = substr($file,0,$zfwz);
				$kzm = substr($file,$zfwz,strlen($file)-$zfwz);
				if(in_array(strtolower($kzm), array(".php"))){
					$list[] = array("file"=>$filename,"date"=>date("Y-m-d H:i:s",filemtime("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["tplfolder"]."/".$file))); //输出文件名
					$type = strpos($file,".m.php") !== false ? "2" : "1";
					$filename = str_replace(".m","",$filename);
					$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplfile where `subjectid`='{$this -> tplsubject['id']}' and `type`='{$type}' and `filename`='{$filename}' limit 0,1");
					$content = $this -> writeContent(file_get_contents("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["tplfolder"]."/".$file));
					
					if($v){
						$this -> db -> query("update {$this->conf['prefix']}tplfile set `content`='{$content}' where `subjectid`='{$this -> tplsubject['id']}' and `type`='{$type}' and `filename`='{$filename}'");
					}else{
						$this -> db -> query("insert ignore into `{$this->conf['prefix']}tplfile` (`filename`,`subjectid`,`type`,`content`) value ('".$filename."','".$this -> tplsubject['id']."','".$type."','".$content."')");
					}
				}
			}
			
		}
		closedir($handle);
		$this -> msg("从目录更新模板成功","./index.php?c=tplfile&a=index&tsid=".$this -> tplsubject["id"]."&type=".$this -> type,true);
	}
	
	/**
	 * 读取模板主题
	**/
	private function getTplSubject(){
		$tsid = $this -> p("tsid","","1");
		if($tsid==""){$this -> errlog("URL参数错误");}
		$this -> tplsubject = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplsubject where `id`='{$tsid}' limit 0,1");
		if(!isset($this -> tplsubject["id"])){
			$this -> tplsubject = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplsubject order by id asc limit 0,1");
		}

		if(!isset($this -> tplsubject["id"])){
			$this -> errlog("没有找到对应的模板主题记录");
		}
	}
	
	
	/**
	 * 删除模板文件
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$list = $this -> db -> keyList("select `filename`,`type` from {$this->conf['prefix']}tplfile where `id` in(".implode(",",$id).")");
			$this -> db -> query("delete from {$this->conf['prefix']}tplfile where `id` in(".implode(",",$id).")");
		}else{
			$list = $this -> db -> keyList("select `filename`,`type` from {$this->conf['prefix']}tplfile where `id`='".$id."'");
			$this -> db -> query("delete from {$this->conf['prefix']}tplfile where `id`='".$id."'");
		}

		foreach($list as $v){
			if(file_exists("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["tplfolder"]."/".$v["filename"].($v["type"]!="1"?".m":"").".php"))unlink("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["tplfolder"]."/".$v["filename"].($v["type"]!="1"?".m":"").".php");
		}
		$this -> addlog("批量删除模板文件【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除模板文件成功","./index.php?c=tplfile&a=index&tsid=".$this -> tplsubject["id"]."&type=".$this -> type,true);
	}
	
	/**
	 * 修改文件夹名称
	**/
	private function renamedir($old,$new){
		if(file_exists("{$old}")){
			rename("{$old}","{$new}");
		}
	}

	
	/**
	 * 清空模板文件
	**/
	private $clearName = "清空模板文件";
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}tplfile");
		$this -> addlog("清空模板文件数据");
		$this -> msg("清空表数据成功","./index.php?c=tplfile&a=index&tsid=".$this -> tplsubject["id"],true);
	}
}
?>