<?php
/** 
 * +------------------------------------------------------------------------ 
 * | 程序名称：贤诚建站系统
 * +------------------------------------------------------------------------ 
 * | Copyright www.mydecms.com All rights reserved. 
 * +------------------------------------------------------------------------ 
 * | Author: 小贤 <e-mail:admin@mydecms.com> <QQ:306282268> 
 * +------------------------------------------------------------------------ 
 * | 声明:本程序禁止未经作者商业授权之前用于商业用途，违者追究法律责任
 * | 如需要用于商业用途，请联系程序作者小贤<QQ:306282268>购买程序商业授权
 * +------------------------------------------------------------------------ 
 * | 文件说明：模板主题管理控制器
 * +------------------------------------------------------------------------ 
**/  

class tplsubjectControl extends adminControl {
	public $ControlName = "模板主题管理";
	
	//功能权限
	public $quanxian = array(
		//对所有用户公开功能
		"open"  => array(
		),
		//用户权限功能
		"user"  => array(
			"index"        => "查看模板主题",
			"add"          => "添加模板主题",
			"edit"         => "修改模板主题",
			"del"          => "删除模板主题",
			"css"          => "查看CSS样式文件",
			"addcss"       => "添加CSS样式文件",
			"editcss"      => "修改CSS样式文件",
			"delcss"       => "删除CSS样式文件",
			"js"           => "查看JS脚本文件",
			"addjs"        => "添加JS脚本文件",
			"editjs"       => "修改JS脚本文件",
			"deljs"        => "删除JS脚本文件",
			"img"          => "查看模板图片库",
			"upimg"        => "上传模板用的图片",
			"update"       => "从目录更新模板主题",
			"delimg"       => "删除模板图片"
		)
	);	
	
	public function __construct($conf){
		parent::__construct($conf);
		if(!file_exists("../moban/")){
			$this -> createDir("../moban/");
		}
	}
	
	/**
	 * 查看模板主题
	**/
	public function index(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplsubject/index.php")){
			exit("没有找到对应的模板文件");
		}

		if(!file_exists("../moban/") || !is_writable("../moban/")){
			$this -> errlog("程序根目录下的moban文件夹没有写入权限，无法创建新的模板主题<br>请通过FTP软件登录网站空间将moban文件夹增加写入权限");
		}
		
		$list = $this -> db -> keyList("select * from {$this->conf['prefix']}tplsubject order by `id` asc");
	
		include MYDECMS_PATH.$this->template."tplsubject/index.php";
		exit();
	}	
	
	/**
	 * 添加模板主题
	**/
	public function add(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplsubject/add.php")){
			exit("没有找到对应的模板文件");
		}
		

		
		if(!file_exists("../moban/") || !is_writable("../moban/")){
			$this -> errlog("程序根目录下的moban文件夹没有写入权限，无法创建新的模板主题<br>请通过FTP软件登录网站空间将moban文件夹增加写入权限");
		}
		
		$v = array("id"=>"","name"=>"","folder"=>"","tplfolder"=>"","cssfolder"=>"","jsfolder"=>"","imgfolder"=>"");
		include MYDECMS_PATH.$this->template."tplsubject/add.php";
		exit();
	}
	public function addAction(){
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("主题名称不能为空","",false,3);
		}
		$folder     = $this -> p("folder","","2");
		if($folder == ""){
			$this -> msg("主题目录不能为空","",false,3);
		}
		$tplfolder     = $this -> p("tplfolder","","2");
		if($tplfolder == ""){
			$this -> msg("模板目录不能为空","",false,3);
		}
		$cssfolder     = $this -> p("cssfolder","","2");
		if($cssfolder == ""){
			$this -> msg("CSS样式目录不能为空","",false,3);
		}
		$jsfolder     = $this -> p("jsfolder","","2");
		if($jsfolder == ""){
			$this -> msg("JS脚本目录不能为空","",false,3);
		}
		$imgfolder     = $this -> p("imgfolder","","2");
		if($imgfolder == ""){
			$this -> msg("图片目录不能为空","",false,3);
		}
		
		$this -> db -> query("insert ignore into `{$this->conf['prefix']}tplsubject` (`name`,`folder`,`tplfolder`,`cssfolder`,`jsfolder`,`imgfolder`) value ('".$name."','".$folder."','".$tplfolder."','".$cssfolder."','".$jsfolder."','".$imgfolder."')");
		
		if(!file_exists("../moban/".$folder."/")){
				$this -> createDir("../moban/".$folder."/");
		}
		
		$dirarr = array("tplfolder","cssfolder","jsfolder","imgfolder");
		foreach($dirarr as $v){
			if(!file_exists("../moban/{$folder}/".$$v."/")){
				$this -> createDir("../moban/{$folder}/".$$v."/");
			}
		}
		$this -> addlog("添加新模板主题");
		$this -> msg("添加新模板主题成功","./index.php?c=tplsubject&a=index",true);
	}
	
	/**
	 * 修改文件夹名称
	**/
	private function renamedir($old,$new){
		if(file_exists("../moban/{$old}")){
			rename("../moban/{$old}","../moban/{$new}");
		}
	}
	
	
	/**
	 * 修改模板主题
	**/
	public function edit(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplsubject/add.php")){
			exit("没有找到对应的模板文件");
		}
		
		$id = $this -> p("id","","1");
		if($id=="") $this -> errlog("记录参数错误");
		
		if(!file_exists("../moban/")){
			$this -> createDir("../moban/");
		}
		
		if(!file_exists("../moban/") || !is_writable("../moban/")){
			$this -> errlog("程序根目录下的moban文件夹没有写入权限，无法创建新的模板主题<br>请通过FTP软件登录网站空间将moban文件夹增加写入权限");
		}

		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplsubject where `id`='{$id}' limit 0,1");
		
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		include MYDECMS_PATH.$this->template."tplsubject/add.php";
		exit();
	}
	public function editAction(){
		$id = $this -> p("id","","2");
		if($id=="") $this -> errlog("记录参数错误");
		
		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplsubject where `id`='{$id}' limit 0,1");
		if(!$v) $this -> msg("没有找到对应的记录","",false,3);
		
		
		$name     = $this -> p("name","","2");
		if($name == ""){
			$this -> msg("主题名称不能为空","",false,3);
		}
		$folder     = $this -> p("folder","","2");
		if($folder == ""){
			$this -> msg("主题目录不能为空","",false,3);
		}
		$tplfolder     = $this -> p("tplfolder","","2");
		if($tplfolder == ""){
			$this -> msg("模板目录不能为空","",false,3);
		}
		$cssfolder     = $this -> p("cssfolder","","2");
		if($cssfolder == ""){
			$this -> msg("CSS样式目录不能为空","",false,3);
		}
		$jsfolder     = $this -> p("jsfolder","","2");
		if($jsfolder == ""){
			$this -> msg("JS脚本目录不能为空","",false,3);
		}
		$imgfolder     = $this -> p("imgfolder","","2");
		if($imgfolder == ""){
			$this -> msg("图片目录不能为空","",false,3);
		}
		
		$this -> db -> query("update `{$this->conf['prefix']}tplsubject` set `name`='".$name."',`folder`='".$folder."',`tplfolder`='".$tplfolder."',`cssfolder`='".$cssfolder."',`jsfolder`='".$jsfolder."',`imgfolder`='".$imgfolder."' where `id`='{$id}'");
		
		if(!file_exists("../moban/".$folder."/")){
			if(file_exists("../moban/".$v["folder"]."/")){
				$this -> renamedir("../moban/".$v["folder"]."/","../moban/".$folder."/");
			}else{
				$this -> createDir("../moban/".$folder."/");
			}
		}
		
		$dirarr = array("tplfolder","cssfolder","jsfolder","imgfolder");
		foreach($dirarr as $vv){
			if(!file_exists("../moban/{$folder}/".$$vv."/")){
				if(file_exists("../moban/".$folder."/".$v[$vv]."/")){
					$this -> renamedir("../moban/{$folder}/".$v[$vv]."/","../moban/{$folder}/".$$vv."/");
				}else{
					$this -> createDir("../moban/{$folder}/".$$vv."/");
				}
			}
		}
		$this -> addlog("修改模板主题【{$id}=>".$this -> readContent($name)."】");
		$this -> msg("修改模板主题成功","./index.php?c=tplsubject&a=index",true);
	}
	
	/**
	 * 从目录更新模板主题
	**/
	public function update(){
		
		if(!file_exists("../moban/")){
			$this -> createDir("../moban/");
		}

		$handle=opendir("../moban/"); 
		while (false !== ($file = readdir($handle))){//遍历文件夹下所有文件
			if($file != "." && $file != ".." && is_dir("../moban/{$file}/")){
				$data = file_exists("../moban/{$file}/data.json") ? json_encode(file_get_contents("../moban/{$file}/data.json"),true) : array();
				if(!isset($data['name']))     $data['name'] = $file;
				if(!isset($data['folder'])) $data['folder'] = $file;
				if(!isset($data['tpl']))       $data['tpl'] = "tpl";
				if(!isset($data['css']))       $data['css'] = "css";
				if(!isset($data['js']))         $data['js'] = "js";
				if(!isset($data['images'])) $data['images'] = "images";
				$this -> db -> query("insert ignore into `{$this->conf['prefix']}tplsubject` (`name`,`folder`,`tplfolder`,`cssfolder`,`jsfolder`,`imgfolder`) value ('".$data['name']."','".$data['folder']."','".$data['tpl']."','".$data['css']."','".$data['js']."','".$data['images']."')");
				$this -> updatetpl($data['folder']);
			}
		}
		closedir($handle);
		$this -> msg("从目录更新模板主题成功","./index.php?c=tplsubject&a=index",true);
	}
	
	
	/**
	 * 从目录更新模板
	**/
	public function updatetpl($folder){
		$v = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplsubject where `folder`='{$folder}' limit 0,1");
		
		if(!$v) return;
		
		if(!file_exists("../moban/".$v["folder"]."/".$v["tplfolder"]."/")){
			$this -> createDir("../moban/".$v["folder"]."/".$v["tplfolder"]."/");
		}
		
		$data = file_exists("../moban/{$folder}/data.json") ? json_encode(file_get_contents("../moban/{$folder}/data.json"),true) : array();
		
		$handle=opendir("../moban/".$v["folder"]."/".$v["tplfolder"]."/"); 
		while (false !== ($file = readdir($handle))){//遍历文件夹下所有文件
			if ($file != "." && $file != "..") {
				$zfwz = strrpos($file,".");
				$filename = substr($file,0,$zfwz);
				$kzm = substr($file,$zfwz,strlen($file)-$zfwz);
				if(in_array(strtolower($kzm), array(".php"))){
					echo "../moban/".$v["folder"]."/".$v["tplfolder"]."/".$file."<br>";
					$list[] = array("file"=>$filename,"date"=>date("Y-m-d H:i:s",filemtime("../moban/".$v["folder"]."/".$v["tplfolder"]."/".$file))); //输出文件名
					$type = strpos($file,".m.php") !== false ? "2" : "1";
					$filename = str_replace(".m","",$filename);
					$vv = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplfile where `subjectid`='{$v['id']}' and `type`='{$type}' and `filename`='{$filename}' limit 0,1");
					$content = file_exists("../moban/".$v["folder"]."/".$v["tplfolder"]."/".$file) ?  $this -> writeContent(file_get_contents("../moban/".$v["folder"]."/".$v["tplfolder"]."/".$file)) : "";
					if($vv){
						$this -> db -> query("update {$this->conf['prefix']}tplfile set `content`='{$content}' where `subjectid`='{$v['id']}' and `type`='{$type}' and `filename`='{$filename}'");
					}else{
						$this -> db -> query("insert ignore into `{$this->conf['prefix']}tplfile` (`filename`,`subjectid`,`type`,`word`,`content`) value ('".$filename."','".$v['id']."','".$type."','".(isset($data['tpllist'][$file]) ? $data['tpllist'][$file] : "")."','".$content."')");
					}
				}
			}
		}
		closedir($handle);
	}
	
	
	/**
	 * 删除模板主题
	**/
	public function del(){
		$id     = $this -> p("id","","2");
		if($id == ""){
			$this -> msg("提交的数据错误","");
		}
		
		if(is_array($id)){
			$this -> db -> query("delete from {$this->conf['prefix']}tplfile where `subjectid` in(".implode(",",$id).")");
			$this -> db -> query("delete from {$this->conf['prefix']}tplsubject where `id` in(".implode(",",$id).")");
		}else{
			$this -> db -> query("delete from {$this->conf['prefix']}tplfile where `subjectid`='".$id."'");
			$this -> db -> query("delete from {$this->conf['prefix']}tplsubject where `id`='".$id."'");
		}
		$this -> addlog("批量删除模板主题【".(is_array($id) ? implode(",",$id):$id)."】");
		$this -> msg("批量删除模板主题记录成功<br>模板文件得手动去删除","./index.php?c=tplsubject&a=index",true);
	}

	
	/**
	 * 清空模板主题
	**/
	public function clear(){
		$this -> db -> truncate("{$this->conf['prefix']}tplsubject");
		$this -> addlog("清空模板主题数据");
		$this -> msg("清空表数据成功","./index.php?c=tplsubject&a=index",true);
	}
	
	/**
	 * 读取模板主题
	**/
	private function getTplSubject(){
		$tsid = $this -> p("tsid","","1");
		if($tsid==""){$this -> errlog("URL参数错误");}
		$this -> tplsubject = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplsubject where `id`='{$tsid}' limit 0,1");
		if(!isset($this -> tplsubject["id"])){
			$this -> tplsubject = $this -> db -> fetch_first("select * from {$this->conf['prefix']}tplsubject order by id asc limit 0,1");
		}

		if(!isset($this -> tplsubject["id"])){
			$this -> errlog("没有找到对应的模板主题记录");
		}
	}
	
	
	/**
	 * 查看CSS样式文件
	**/
	public function css(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplsubject/css.php")){
			exit("没有找到对应的模板文件");
		}
		$this -> getTplSubject();
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}tplsubject order by `id` asc");
		
		$list = array();
		
		if(!file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/")){
			$this -> createDir("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/");
		}
		
		$handle=opendir("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/"); 
		while (false !== ($file = readdir($handle))){//遍历文件夹下所有文件
			if ($file != "." && $file != "..") {
				$zfwz = strrpos($file,".");
				$filename = substr($file,0,$zfwz);
				$kzm = substr($file,$zfwz,strlen($file)-$zfwz);
				if(in_array(strtolower($kzm), array(".css"))){
					$list[] = array("file"=>$filename,"hz"=>$kzm,"date"=>date("Y-m-d H:i:s",filemtime("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/".$file))); //输出文件名
				}
			}
			
		}
		closedir($handle);
		
		include MYDECMS_PATH.$this->template."tplsubject/css.php";
		exit();
	}
	
	/**
	 * 添加CSS样式文件
	**/
	public function addcss(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplsubject/addcss.php")){
			exit("没有找到对应的模板文件");
		}
		
		$this -> getTplSubject();
		

		
		if(!file_exists("../moban/") || !is_writable("../moban/")){
			$this -> errlog("程序根目录下的moban文件夹没有写入权限，无法创建新的模板主题<br>请通过FTP软件登录网站空间将moban文件夹增加写入权限");
		}
		
		$v = array("filename"=>"","content"=>"");
		include MYDECMS_PATH.$this->template."tplsubject/addcss.php";
		exit();
	}
	public function addcssAction(){
		$filename     = $this -> p("filename","","2");
		if($filename == ""){
			$this -> msg("CSS文件不能为空","",false,3);
		}
		$content     = $this -> p("content","","2");
		if($content == ""){
			$this -> msg("CSS样式文件内容不能为空","",false,3);
		}
		
		$this -> getTplSubject();
		
		$content = $this->readContent($content);
		
		if(file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/".$filename.".css")){
				$this -> msg("CSS样式文件【".$filename."】已经存在，请改用其他样式文件名","",false,3);
		}

		file_put_contents("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/".$filename.".css",$content);
		$this -> addlog("添加新CSS样式文件");
		$this -> msg("添加新CSS样式文件成功","./index.php?c=tplsubject&a=css&tsid=".$this -> tplsubject["id"],true);
	}
	
	
	/**
	 * 修改CSS样式文件
	**/
	public function editcss(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplsubject/addcss.php")){
			exit("没有找到对应的模板文件");
		}
		
		$filename     = $this -> p("filename","","1");
		if($filename == ""){
			$this -> msg("CSS文件不能为空","",false,3);
		}
		
		$this -> getTplSubject();
		
		if(!file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/".$filename.".css")){
				$this -> msg("没有找到【".$filename."】CSS样式文件，无法编辑","",false,3);
		}
		
		$v = array("filename"=>$filename,"content"=>file_get_contents("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/".$filename.".css"));
		
		
		if(!file_exists("../moban/") || !is_writable("../moban/")){
			$this -> errlog("程序根目录下的moban文件夹没有写入权限，无法创建新的模板主题<br>请通过FTP软件登录网站空间将moban文件夹增加写入权限");
		}

		include MYDECMS_PATH.$this->template."tplsubject/addcss.php";
		exit();
	}
	public function editcssAction(){
		$oldfilename = $this -> p("oldfilename","","2");
		if($oldfilename=="") $this -> errlog("参数错误");
		
		$filename     = $this -> p("filename","","2");
		if($filename == ""){
			$this -> msg("CSS文件不能为空","",false,3);
		}
		$content     = $this -> p("content","","2");
		if($content == ""){
			$this -> msg("CSS样式文件内容不能为空","",false,3);
		}
		
		$this -> getTplSubject();
		
		$content = $this->readContent($content);
		
		if($oldfilename != $filename && file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/".$filename.".css")){
			$this -> msg("CSS样式文件【".$filename."】已经存在，请改用其他样式文件名","",false,3);
		}else if($oldfilename != $filename && file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/".$oldfilename.".css")){
			$this -> renamedir("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/".$oldfilename.".css","../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/".$filename.".css");
		}

		file_put_contents("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["cssfolder"]."/".$filename.".css",$content);
		$this -> addlog("修改CSS样式文件【{$oldfilename}】");
		$this -> msg("修改CSS样式文件成功","./index.php?c=tplsubject&a=css&tsid=".$this -> tplsubject["id"],true);
	}
	
	
	/**
	 * 删除CSS样式文件
	**/
	public function delcss(){
		$filename = $this -> p("filename","","2");
		if($filename=="") $this -> errlog("参数错误");
		
		$this -> getTplSubject();
		
		if(is_array($filename)){
			foreach($filename as $v){
				if(file_exists("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["cssfolder"]."/".$v.".css"))unlink("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["cssfolder"]."/".$v.".css");
			}
		}else{
			if(file_exists("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["cssfolder"]."/".$filename.".css"))unlink("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["cssfolder"]."/".$filename.".css");
		}
		$this -> addlog("批量删除CSS样式【".$filename."】");
		$this -> msg("批量删除CSS样式成功","./index.php?c=tplsubject&a=css&tsid=".$this -> tplsubject["id"],true);
	}
	
	
	/**
	 * 查看JS脚本文件
	**/
	public function js(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplsubject/js.php")){
			exit("没有找到对应的模板文件");
		}
		$this -> getTplSubject();
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}tplsubject order by `id` asc");
		
		$list = array();
		
		$handle=opendir("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["jsfolder"]); 
		while (false !== ($file = readdir($handle))){//遍历文件夹下所有文件
			if ($file != "." && $file != "..") {
				$zfwz = strrpos($file,".");
				$filename = substr($file,0,$zfwz);
				$kzm = substr($file,$zfwz,strlen($file)-$zfwz);
				if(in_array(strtolower($kzm), array(".js"))){
					$list[] = array("file"=>$filename,"hz"=>$kzm,"date"=>date("Y-m-d H:i:s",filemtime("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["jsfolder"]."/".$file))); //输出文件名
				}
			}
			
		}
		closedir($handle);
		
		include MYDECMS_PATH.$this->template."tplsubject/js.php";
		exit();
	}
	
	/**
	 * 添加JS脚本文件
	**/
	public function addjs(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplsubject/addjs.php")){
			exit("没有找到对应的模板文件");
		}
		
		$this -> getTplSubject();
		
		
		
		if(!file_exists("../moban/") || !is_writable("../moban/")){
			$this -> errlog("程序根目录下的moban文件夹没有写入权限，无法创建新的模板主题<br>请通过FTP软件登录网站空间将moban文件夹增加写入权限");
		}
		
		$v = array("filename"=>"","content"=>"");
		include MYDECMS_PATH.$this->template."tplsubject/addjs.php";
		exit();
	}
	public function addjsAction(){
		$filename     = $this -> p("filename","","2");
		if($filename == ""){
			$this -> msg("JS脚本文件不能为空","",false,3);
		}
		$content     = $this -> p("content","","2");
		if($content == ""){
			$this -> msg("JS脚本文件内容不能为空","",false,3);
		}
		
		$this -> getTplSubject();
		
		$content = $this->readContent($content);
		
		if(file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["jsfolder"]."/".$filename.".js")){
				$this -> msg("JS脚本文件【".$filename."】已经存在，请改用其他样式文件名","",false,3);
		}

		file_put_contents("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["jsfolder"]."/".$filename.".js",$content);
		$this -> addlog("添加JS脚本文件【".$this -> readContent($filename)."】");
		$this -> msg("添加JS脚本文件成功","./index.php?c=tplsubject&a=js&tsid=".$this -> tplsubject["id"],true);
	}
	
	
	/**
	 * 修改JS脚本文件
	**/
	public function editjs(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplsubject/addjs.php")){
			exit("没有找到对应的模板文件");
		}
		
		$filename     = $this -> p("filename","","1");
		if($filename == ""){
			$this -> msg("JS脚本文件不能为空","",false,3);
		}
		
		$this -> getTplSubject();
		
		if(!file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["jsfolder"]."/".$filename.".js")){
				$this -> msg("没有找到【".$filename."】JS脚本文件，无法编辑","",false,3);
		}
		
		$v = array("filename"=>$filename,"content"=>file_get_contents("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["jsfolder"]."/".$filename.".js"));
		
		
		if(!file_exists("../moban/") || !is_writable("../moban/")){
			$this -> errlog("程序根目录下的moban文件夹没有写入权限，无法创建新的模板主题<br>请通过FTP软件登录网站空间将moban文件夹增加写入权限");
		}

		include MYDECMS_PATH.$this->template."tplsubject/addjs.php";
		exit();
	}
	public function editjsAction(){
		$oldfilename = $this -> p("oldfilename","","2");
		if($oldfilename=="") $this -> errlog("参数错误");
		
		$filename     = $this -> p("filename","","2");
		if($filename == ""){
			$this -> msg("JS脚本文件不能为空","",false,3);
		}
		$content     = $this -> p("content","","2");
		if($content == ""){
			$this -> msg("JS脚本文件内容不能为空","",false,3);
		}
		
		$this -> getTplSubject();
		
		$content = $this->readContent($content);
		
		if($oldfilename != $filename && file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["jsfolder"]."/".$filename.".js")){
			$this -> msg("JS脚本文件【".$filename."】已经存在，请改用其他样式文件名","",false,3);
		}else if($oldfilename != $filename && file_exists("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["jsfolder"]."/".$oldfilename.".js")){
			$this -> renamedir("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["jsfolder"]."/".$oldfilename.".js","../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["jsfolder"]."/".$filename.".js");
		}

		file_put_contents("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["jsfolder"]."/".$filename.".js",$content);
		$this -> addlog("修改JS脚本文件【{$id}=>".$this -> readContent($filename)."】");
		$this -> msg("修改JS脚本文件成功","./index.php?c=tplsubject&a=js&tsid=".$this -> tplsubject["id"],true);
	}
	
	
	/**
	 * 删除JS脚本文件
	**/
	public function deljs(){
		$filename = $this -> p("filename","","2");
		if($filename=="") $this -> errlog("参数错误");
		
		$this -> getTplSubject();
		
		if(is_array($filename)){
			foreach($filename as $v){
				if(file_exists("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["jsfolder"]."/".$v.".js"))unlink("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["jsfolder"]."/".$v.".js");
			}
		}else{
			if(file_exists("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["jsfolder"]."/".$filename.".js"))unlink("../moban/".$this -> tplsubject["folder"]."/".$this -> tplsubject["jsfolder"]."/".$filename.".js");
		}
		$this -> addlog("批量删除JS脚本【".$filename."】");
		$this -> msg("批量删除JS脚本成功","./index.php?c=tplsubject&a=js&tsid=".$this -> tplsubject["id"],true);
	}
	
	/**
	 * 查看模板图片库
	**/
	public function img(){
		if(!file_exists(MYDECMS_PATH.$this->template."tplsubject/img.php")){
			exit("没有找到对应的模板文件");
		}
		$this -> getTplSubject();
		$clist = $this -> db -> keyList("select * from {$this->conf['prefix']}tplsubject order by `id` asc");
		
		$list = array();
		
		$handle=opendir("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["imgfolder"]); 
		$folder = $this->tplsubject["folder"]."/".$this->tplsubject["imgfolder"];
		while (false !== ($file = readdir($handle))){//遍历文件夹下所有文件
			if ($file != "." && $file != "..") {
				$zfwz = strrpos($file,".");
				$filename = substr($file,0,$zfwz);
				$kzm = substr($file,$zfwz,strlen($file)-$zfwz);
				if(in_array(strtolower($kzm), array(".jpg",".gif",".png",".bmp"))){
					$list[] = array("file"=>$filename,"hz"=>$kzm,"date"=>date("Y-m-d H:i:s",filemtime("../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["imgfolder"]."/".$file))); //输出文件名
				}
			}
			
		}
		closedir($handle);
		
		include MYDECMS_PATH.$this->template."tplsubject/img.php";
		exit();
	}
	
	/**
	 * 上传模板用的图片
	**/
	public function upimg(){
		if(!isset($_FILES['uploadimg'])) exit("参数错误");
		
		$this -> getTplSubject();
		
		
		
		include_once MYDECMSPHP_PATH.'upfile.mydecms.php'; 
		
		$upfile = new UpFileClass($_FILES["uploadimg"],"./",array(".gif",".jpg",".png",".bmp",".ico",".rar",".zip",".rmvb",".mp3",".wav",".txt",".doc",".xls",".ppt",".mdb",".xml"),"../moban/".$this->tplsubject["folder"]."/".$this->tplsubject["imgfolder"]."/");
		
		$upfile -> Up();
		
		if($upfile->msg == "上传成功！"){
			if($this -> config['watertype']=="1"){
				$sy = new mydecmsWater($this -> config['water']);
				$sy -> imgWater($upfile->NewFileUrl);
			}
			$this -> addlog("上传模板用的图片【".$this -> readContent($upfile->NewFileUrl)."】");
			exit("上传成功！");
		}else{
			exit("上传失败！<br>".$upfile->msg);
		}
	}
	
	/**
	 * 删除模板图片
	**/
	public function delimg(){
		$imgurl = isset($_POST["imgurl"]) ? $_POST["imgurl"] : array();
		if(!is_array($imgurl)) $imgurl = array($imgurl);
		foreach($imgurl as $img){
			$img = $this -> readContent($img);
			if(file_exists($img)){
				$this -> addlog("删除模板用的图片【{$img}】");
				unlink($img);
			}
		}
		$this -> msg("批量删除模板图片成功","./index.php?c=tplsubject&a=img&tsid=".$this -> tplsubject["id"],true);
	}
}
?>